/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.ide.TypePresentationService;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.url.references.UrlPathReferenceUnifiedPomTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.model.SpringMvcUrlTargetInfo;
import com.intellij.spring.mvc.model.jam.MVCPathVariable;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.jam.SpringMVCModelAttribute;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public class SpringMvcRequestMappingDocumentationProvider
extends AbstractDocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        UDeclaration containing;
        PsiElement refPsi = (PsiElement)ObjectUtils.doIfNotNull((Object)UrlPathReference.getFromPomTargetPsiElement((PsiElement)element), PsiReferenceBase::getElement);
        if (refPsi != null) {
            element = refPsi;
        }
        if ((containing = (UDeclaration)UastUtils.findContaining((PsiElement)element, UDeclaration.class)) == null) {
            return null;
        }
        RequestMapping requestMapping = null;
        if (containing instanceof UMethod) {
            requestMapping = (RequestMapping)ObjectUtils.doIfNotNull((Object)containing.getJavaPsi(), javaPsi -> (RequestMapping.Method)JamService.getJamService((Project)javaPsi.getProject()).getJamElement(RequestMapping.METHOD_JAM_KEY, javaPsi));
        } else if (containing instanceof UClass) {
            requestMapping = (RequestMapping)ObjectUtils.doIfNotNull((Object)containing.getJavaPsi(), javaPsi -> (RequestMapping)JamService.getJamService((Project)javaPsi.getProject()).getJamElement(RequestMapping.CLASS_JAM_KEY, javaPsi));
        }
        if (requestMapping == null) {
            return null;
        }
        return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement, (String)SpringMvcRequestMappingDocumentationProvider.getQuickNavigateInfoForRequestMapping(requestMapping));
    }

    @Nullable
    @NlsSafe
    private static String getQuickNavigateInfoInner(PsiElement element) {
        RequestMapping<?> requestMapping = SpringMvcRequestMappingDocumentationProvider.getRequestMapping(element);
        if (requestMapping == null) {
            return null;
        }
        return SpringMvcRequestMappingDocumentationProvider.getQuickNavigateInfoForRequestMapping(requestMapping);
    }

    @NotNull
    @NlsSafe
    private static String getQuickNavigateInfoForRequestMapping(RequestMapping<?> requestMapping) {
        PsiClass containingClass;
        StringBuilder sb = new StringBuilder("<html>");
        SpringMvcRequestMappingDocumentationProvider.appendElementTypeURLs(sb, requestMapping);
        RequestMethod[] requestMethods = requestMapping.getMethods();
        if (requestMethods.length != 0) {
            sb.append(" ");
            sb.append(RequestMethod.getDisplay(requestMethods));
        }
        if ((containingClass = requestMapping.getPsiElement().getContainingClass()) != null) {
            sb.append("<br/>");
            sb.append(containingClass.getQualifiedName());
        }
        sb.append("</html>");
        String string = sb.toString();
        if (string == null) {
            SpringMvcRequestMappingDocumentationProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        RequestMapping<?> requestMapping = SpringMvcRequestMappingDocumentationProvider.getRequestMapping(element);
        if (requestMapping == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
        SpringMvcRequestMappingDocumentationProvider.appendElementTypeURLs(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addMethodLink(sb, requestMapping);
        sb.append("</pre></div>");
        sb.append("<table class='sections'>");
        SpringMvcRequestMappingDocumentationProvider.addHeadersParams(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addConsumesProduces(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addRequestMethod(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addModelAttributes(sb, requestMapping);
        SpringMvcRequestMappingDocumentationProvider.addPathVariables(sb, requestMapping);
        sb.append("</table>");
        return sb.toString();
    }

    @Nullable
    private static RequestMapping<?> getRequestMapping(PsiElement element) {
        Object modelObject;
        UrlPathReferenceUnifiedPomTarget urlPomTarget = UrlPathReferenceUnifiedPomTarget.getFromPomTargetPsiElement((PsiElement)element);
        if (urlPomTarget != null) {
            for (UrlTargetInfo target : urlPomTarget.getResolvedTargets()) {
                JamElement jamElement;
                PomNamedTarget pomTarget;
                if (!(target instanceof SpringMvcUrlTargetInfo) || !((pomTarget = ((SpringMvcUrlTargetInfo)target).getUrlMapping().getPomTarget()) instanceof JamPomTarget) || !((jamElement = ((JamPomTarget)pomTarget).getJamElement()) instanceof RequestMapping)) continue;
                return (RequestMapping)jamElement;
            }
        }
        if (!((modelObject = JamCommonUtil.getModelObject((PsiElement)element)) instanceof RequestMapping)) {
            return null;
        }
        return (RequestMapping)modelObject;
    }

    private static void appendElementTypeURLs(StringBuilder sb, RequestMapping<?> requestMapping) {
        sb.append(TypePresentationService.getService().getTypeName(requestMapping));
        sb.append(" <b>");
        StringUtil.join(requestMapping.getUrls(), (String)", ", (StringBuilder)sb);
        sb.append("</b>");
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append(":").append("</td><td valign='top'>");
        sb.append(sectionContent);
        sb.append("</td>");
    }

    private static void addHeadersParams(StringBuilder sb, RequestMapping<?> mapping) {
        List<String> params;
        List<String> headers = mapping.getHeaders();
        if (!headers.isEmpty()) {
            SpringMvcRequestMappingDocumentationProvider.appendSection(sb, "Headers", StringUtil.join(headers, (String)", "));
        }
        if (!(params = mapping.getParams()).isEmpty()) {
            SpringMvcRequestMappingDocumentationProvider.appendSection(sb, "Params", StringUtil.join(params, (String)", "));
        }
    }

    private static void addConsumesProduces(StringBuilder sb, RequestMapping<?> mapping) {
        List<String> produces;
        List<String> consumes = mapping.getConsumes();
        if (!consumes.isEmpty()) {
            StringBuilder consumesSb = new StringBuilder();
            Iterator<String> it = consumes.iterator();
            while (it.hasNext()) {
                String consume = it.next();
                if (StringUtil.startsWithChar((CharSequence)consume, (char)'!')) {
                    consumesSb.append("<strike>").append(consume).append("</strike>");
                } else {
                    consumesSb.append(consume);
                }
                if (!it.hasNext()) continue;
                consumesSb.append(", ");
            }
            SpringMvcRequestMappingDocumentationProvider.appendSection(sb, "Consumes", consumesSb.toString());
        }
        if (!(produces = mapping.getProduces()).isEmpty()) {
            SpringMvcRequestMappingDocumentationProvider.appendSection(sb, "Produces", StringUtil.join(produces, (String)", "));
        }
    }

    private static void addRequestMethod(StringBuilder sb, RequestMapping<?> requestMapping) {
        RequestMethod[] requestMethods = requestMapping.getMethods();
        if (requestMethods.length != 0) {
            SpringMvcRequestMappingDocumentationProvider.appendSection(sb, "Methods", RequestMethod.getDisplay(requestMethods));
        }
    }

    private static void addModelAttributes(StringBuilder sb, RequestMapping<?> requestMapping) {
        List<SpringMVCModelAttribute> modelAttributes = requestMapping.getModelAttributes();
        if (!modelAttributes.isEmpty()) {
            StringBuilder modelSb = new StringBuilder();
            Iterator<SpringMVCModelAttribute> it = modelAttributes.iterator();
            while (it.hasNext()) {
                SpringMVCModelAttribute attribute = it.next();
                modelSb.append(attribute.getName());
                modelSb.append(":");
                JavaDocInfoGenerator.generateType((StringBuilder)modelSb, (PsiType)attribute.getType(), requestMapping.getPsiElement(), (boolean)true);
                if (!it.hasNext()) continue;
                modelSb.append(", ");
            }
            SpringMvcRequestMappingDocumentationProvider.appendSection(sb, "Model attributes", modelSb.toString());
        }
    }

    private static void addPathVariables(StringBuilder sb, RequestMapping<?> mapping) {
        if (!(mapping instanceof RequestMapping.Method)) {
            return;
        }
        RequestMapping.Method methodMapping = (RequestMapping.Method)mapping;
        List<MVCPathVariable> pathVariables = methodMapping.getPathVariables();
        if (!pathVariables.isEmpty()) {
            StringBuilder varSb = new StringBuilder();
            Iterator<MVCPathVariable> it = pathVariables.iterator();
            while (it.hasNext()) {
                MVCPathVariable pathVariable = it.next();
                varSb.append(pathVariable.getName());
                varSb.append(":");
                JavaDocInfoGenerator.generateType((StringBuilder)varSb, (PsiType)pathVariable.getType(), methodMapping.getPsiElement(), (boolean)true);
                if (!it.hasNext()) continue;
                varSb.append(", ");
            }
            SpringMvcRequestMappingDocumentationProvider.appendSection(sb, "Path variables", varSb.toString());
        }
    }

    private static void addMethodLink(StringBuilder sb, RequestMapping<?> requestMapping) {
        if (requestMapping instanceof RequestMapping.Method) {
            Object requestMappingPsiElement = requestMapping.getPsiElement();
            String methodName = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)requestMappingPsiElement), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4103, (int)2);
            sb.append("<br><a href=\"psi_element://");
            sb.append(JavaDocUtil.getReferenceText((Project)requestMappingPsiElement.getProject(), requestMappingPsiElement));
            sb.append("\">");
            sb.append(methodName);
            sb.append("</a>");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/mvc/SpringMvcRequestMappingDocumentationProvider", "getQuickNavigateInfoForRequestMapping"));
    }
}

