/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.jam.SpringMvcUrlPathSpecification;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCReference
extends PsiReferenceBase.Poly<PsiElement>
implements EmptyResolveMessageProvider,
HighlightedReference {
    private final ServletMappingInfo myMappingInfo;

    public SpringMVCReference(PsiElement element, int offset, String text, @Nullable ServletMappingInfo mappingInfo, boolean soft) {
        super(element, new TextRange(offset, offset + text.length()), soft);
        TextRange range;
        this.myMappingInfo = mappingInfo;
        if (mappingInfo != null && (range = mappingInfo.getNameRange(text)) != null) {
            this.setRangeInElement(range.shiftRight(offset));
        }
    }

    private String getUrl() {
        String url = this.getValue();
        if (StringUtil.startsWithChar((CharSequence)url, (char)'/')) {
            url = url.substring(1);
        }
        return url;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            SpringMVCReference.$$$reportNull$$$0(0);
        }
        if (this.myMappingInfo == null) {
            return super.handleElementRename(newElementName);
        }
        String s = this.myMappingInfo.stripMapping(newElementName);
        return super.handleElementRename(s);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (this.myMappingInfo == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringMVCReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringMVCReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Set elements = StreamEx.of(SpringMvcUtils.getBestMatchingUrlMappings(module, SpringMvcUrlPathSpecification.INSTANCE.parsePath(this.getUrl()))).map(UrlMappingElement::getPomTarget).nonNull().map(pomTarget -> PomService.convertToPsi((Project)module.getProject(), (PomTarget)pomTarget)).toImmutableSet();
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)elements);
        if (resolveResultArray == null) {
            SpringMVCReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    public Object @NotNull [] getVariants() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (EMPTY_ARRAY == null) {
                SpringMVCReference.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        Set<ServletMappingInfo> mappingInfos = this.myMappingInfo == null ? SpringMvcUtils.getServletMappingInfos(module) : null;
        Object[] objectArray = ContainerUtil.map2Array(SpringMvcUtils.getUrlMappings(module), LookupElement.class, variant -> {
            PsiElement resolveElement;
            Object lookupString = "/" + ((StreamEx)StreamEx.of((Collection)variant.getUrlPath().getSegments()).map(e -> e.getValueIfExact()).takeWhileInclusive(Objects::nonNull)).map(StringUtil::notNullize).joining((CharSequence)"/");
            if (mappingInfos != null) {
                for (ServletMappingInfo mappingInfo : mappingInfos) {
                    if (mappingInfo.matches((String)lookupString)) continue;
                    lookupString = mappingInfo.addMapping((String)lookupString);
                    break;
                }
            }
            LookupElementBuilder builder2 = (resolveElement = variant.getNavigationTarget()) != null ? LookupElementBuilder.create((Object)resolveElement, (String)lookupString).withTypeText(FileUtilRt.getNameWithoutExtension((String)resolveElement.getContainingFile().getName())) : LookupElementBuilder.create((String)lookupString);
            builder2 = builder2.withIcon(SpringApiIcons.RequestMapping);
            if (variant.getMethod().length > 0) {
                builder2 = builder2.withTailText(" " + RequestMethod.getDisplay(variant.getMethod()), true);
            }
            return builder2.withPresentableText("/" + variant.getPresentation());
        });
        if (objectArray == null) {
            SpringMVCReference.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = SpringMvcBundle.message("cannot.resolve.controller.url", new Object[0]);
        if (string == null) {
            SpringMVCReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String toString() {
        return "SpringMVCReference{myElement=" + this.myElement.getText() + "range=" + this.getRangeInElement() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/SpringMVCReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/SpringMVCReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

