/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringControllerUtils {
    public static boolean isController(@NotNull PsiClass psiClass) {
        SpringController controller;
        if (psiClass == null) {
            SpringControllerUtils.$$$reportNull$$$0(0);
        }
        return (controller = (SpringController)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringController.META})) != null || SpringControllerUtils.isInheritedController(psiClass);
    }

    static boolean isInheritedController(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringControllerUtils.$$$reportNull$$$0(1);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.createSingleDependency((Object)InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.mvc.Controller"), (Object)PsiModificationTracker.MODIFICATION_COUNT));
    }

    public static boolean hasClassLevelResponseBody(@NotNull PsiClass aClass) {
        SpringController controller;
        if (aClass == null) {
            SpringControllerUtils.$$$reportNull$$$0(2);
        }
        if ((controller = (SpringController)JamService.getJamService((Project)aClass.getProject()).getJamElement((PsiElement)aClass, new JamMemberMeta[]{SpringController.META})) == null) {
            return false;
        }
        String definingAnnotation = controller.getDefiningAnnotation();
        assert (definingAnnotation != null) : aClass;
        if ("org.springframework.stereotype.Controller".equals(definingAnnotation)) {
            return false;
        }
        PsiClass metaControllerAnnoClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(definingAnnotation, controller.getPsiElement().getResolveScope());
        return metaControllerAnnoClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)metaControllerAnnoClass, (String)"org.springframework.web.bind.annotation.ResponseBody", (int)0);
    }

    public static boolean isRequestHandler(PsiMethod method) {
        return SpringControllerUtils.isRequestHandler(method.getContainingClass(), method);
    }

    static boolean isRequestHandler(PsiClass controller, PsiMethod method) {
        if (controller == null || method == null) {
            return false;
        }
        if (!SpringControllerUtils.isRequestHandlerCandidate(method)) {
            return false;
        }
        if (SpringControllerUtils.isInheritedController(controller)) {
            return "handleRequest".equals(method.getName()) || "handleRequestInternal".equals(method.getName());
        }
        return SpringControllerUtils.hasRequestMappingJam(method);
    }

    public static boolean isRequestHandlerCandidate(PsiMethod method) {
        return !method.hasModifierProperty("static") && !method.isConstructor();
    }

    public static boolean isJamRequestHandler(PsiMethod method) {
        return SpringControllerUtils.isRequestHandlerCandidate(method) && SpringControllerUtils.hasRequestMappingJam(method);
    }

    private static boolean hasRequestMappingJam(PsiMethod method) {
        return JamService.getJamService((Project)method.getProject()).getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)method) != null;
    }

    public static boolean isModelAttributeProvider(PsiMethod method) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.web.bind.annotation.ModelAttribute", (int)0);
    }

    @Nullable
    public static String getVariableName(@Nullable PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            PsiClass psiClass = psiClassType.resolve();
            if (psiClass == null) {
                return null;
            }
            if (psiClassType.getParameterCount() == 1 && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.List") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Set")) {
                PsiType collectionElementType = psiClassType.getParameters()[0];
                return SpringControllerUtils.pluralize(SpringControllerUtils.getComponentName(collectionElementType));
            }
            return StringUtil.decapitalize((String)StringUtil.notNullize((String)psiClass.getName()));
        }
        if (psiType instanceof PsiArrayType) {
            PsiArrayType psiArrayType = (PsiArrayType)psiType;
            PsiType arrayElementType = psiArrayType.getComponentType();
            return SpringControllerUtils.pluralize(SpringControllerUtils.getComponentName(arrayElementType));
        }
        return null;
    }

    @Nullable
    private static String getComponentName(PsiType psiType) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
        return psiClass != null ? StringUtil.decapitalize((String)StringUtil.notNullize((String)psiClass.getName())) : null;
    }

    @Nullable
    private static String pluralize(@Nullable String componentName) {
        return componentName == null ? null : componentName + "List";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/mvc/SpringControllerUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isController";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritedController";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasClassLevelResponseBody";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

