/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnitConfigurationModel {
    public static final int ALL_IN_PACKAGE = 0;
    public static final int CLASS = 1;
    public static final int METHOD = 2;
    public static final int PATTERN = 3;
    public static final int DIR = 4;
    public static final int CATEGORY = 5;
    public static final int UNIQUE_ID = 6;
    public static final int TAGS = 7;
    public static final int BY_SOURCE_POSITION = 8;
    public static final int BY_SOURCE_CHANGES = 9;
    private static final List<String> ourTestObjects = Arrays.asList("package", "class", "method", "pattern", "directory", "category", "uniqueId", "tags", "source location", "changes");
    private BiConsumer<Integer, Integer> myListener;
    private int myType = -1;
    private final Object[] myJUnitDocuments = new Object[6];
    private final Project myProject;

    public JUnitConfigurationModel(Project project) {
        this.myProject = project;
    }

    public boolean setType(int type) {
        if (type == this.myType) {
            return false;
        }
        int oldType = this.myType;
        if (type < 0 || type >= ourTestObjects.size()) {
            type = 1;
        }
        this.myType = type;
        this.fireTypeChanged(oldType, type);
        return true;
    }

    private void fireTypeChanged(int oldType, int newType) {
        this.myListener.accept(oldType, newType);
    }

    public void setListener(BiConsumer<Integer, Integer> listener) {
        this.myListener = listener;
    }

    public Object getJUnitDocument(int i) {
        return this.myJUnitDocuments[i];
    }

    public void setJUnitDocument(int i, Object doc) {
        this.myJUnitDocuments[i] = doc;
    }

    public void apply(Module module, JUnitConfiguration configuration) {
        boolean shouldUpdateName = configuration.isGeneratedName();
        this.applyTo(configuration.getPersistentData(), module);
        if (shouldUpdateName && !JavaExecutionUtil.isNewName((String)configuration.getName())) {
            configuration.setGeneratedName();
        }
    }

    private void applyTo(JUnitConfiguration.Data data, Module module) {
        block13: {
            String testObject = this.getTestObject();
            String className = this.getJUnitTextValue(1);
            data.TEST_OBJECT = testObject;
            if (testObject != "package" && testObject != "pattern" && testObject != "directory" && testObject != "category" && testObject != "changes") {
                try {
                    PsiClass testClass;
                    data.METHOD_NAME = this.getJUnitTextValue(2);
                    PsiClass psiClass = testClass = !this.myProject.isDefault() && !StringUtil.isEmptyOrSpaces((String)className) ? JUnitUtil.findPsiClass((String)className, (Module)module, (Project)this.myProject) : null;
                    if (testClass != null && testClass.isValid()) {
                        data.setMainClass(testClass);
                        break block13;
                    }
                    data.MAIN_CLASS_NAME = className;
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    data.MAIN_CLASS_NAME = className;
                }
            } else if (testObject != "changes") {
                if (testObject == "package") {
                    data.PACKAGE_NAME = this.getJUnitTextValue(0);
                } else if (testObject == "directory") {
                    data.setDirName(this.getJUnitTextValue(4));
                } else if (testObject == "category") {
                    data.setCategoryName(this.getJUnitTextValue(5));
                } else {
                    String[] patterns;
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (String pattern : patterns = this.getJUnitTextValue(3).split("\\|\\|")) {
                        if (pattern.length() <= 0) continue;
                        set.add(pattern);
                    }
                    data.setPatterns(set);
                }
                data.MAIN_CLASS_NAME = "";
                data.METHOD_NAME = "";
            }
        }
    }

    private String getTestObject() {
        return ourTestObjects.get(this.myType);
    }

    private String getJUnitTextValue(int index) {
        return JUnitConfigurationModel.getDocumentText(index, this.myJUnitDocuments);
    }

    private static String getDocumentText(int index, Object[] documents) {
        Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                return ((PlainDocument)document).getText(0, ((PlainDocument)document).getLength());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return ((Document)document).getText();
    }

    public void reset(JUnitConfiguration configuration) {
        JUnitConfiguration.Data data = configuration.getPersistentData();
        this.setTestType(data.TEST_OBJECT);
        this.setJUnitTextValue(0, data.getPackageName());
        this.setJUnitTextValue(1, data.getMainClassName() != null ? data.getMainClassName().replaceAll("\\$", "\\.") : "");
        this.setJUnitTextValue(2, data.getMethodNameWithSignature());
        this.setJUnitTextValue(3, data.getPatternPresentation());
        this.setJUnitTextValue(4, data.getDirName());
        this.setJUnitTextValue(5, data.getCategory());
    }

    private void setJUnitTextValue(int index, String text) {
        this.setDocumentText(index, text, this.myJUnitDocuments);
    }

    private void setDocumentText(int index, String text, Object[] documents) {
        Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                ((PlainDocument)document).remove(0, ((PlainDocument)document).getLength());
                ((PlainDocument)document).insertString(0, text, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> ((Document)document).replaceString(0, ((Document)document).getTextLength(), (CharSequence)text));
        }
    }

    private void setTestType(String testObject) {
        this.setType(ourTestObjects.indexOf(testObject));
    }

    @NotNull
    @NlsContexts.Label
    public static String getKindName(int value) {
        switch (value) {
            case 0: {
                String string = JUnitBundle.message("junit.configuration.kind.all.in.package", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(0);
                }
                return string;
            }
            case 4: {
                String string = JUnitBundle.message("junit.configuration.kind.all.in.directory", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(1);
                }
                return string;
            }
            case 3: {
                String string = JUnitBundle.message("junit.configuration.kind.by.pattern", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(2);
                }
                return string;
            }
            case 1: {
                String string = JUnitBundle.message("junit.configuration.kind.class", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(3);
                }
                return string;
            }
            case 2: {
                String string = JUnitBundle.message("junit.configuration.kind.method", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(4);
                }
                return string;
            }
            case 5: {
                String string = JUnitBundle.message("junit.configuration.kind.category", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(5);
                }
                return string;
            }
            case 6: {
                String string = JUnitBundle.message("junit.configuration.kind.by.unique.id", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(6);
                }
                return string;
            }
            case 7: {
                String string = JUnitBundle.message("junit.configuration.kind.by.tags", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(7);
                }
                return string;
            }
            case 8: {
                String string = JUnitBundle.message("junit.configuration.kind.by.source.position", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(8);
                }
                return string;
            }
            case 9: {
                String string = JUnitBundle.message("junit.configuration.kind.by.source.changes", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    @NotNull
    @NlsContexts.Label
    public static String getRepeatModeName(@NotNull @NonNls String value) {
        if (value == null) {
            JUnitConfigurationModel.$$$reportNull$$$0(10);
        }
        switch (value) {
            case "Once": {
                String string = JUnitBundle.message("junit.configuration.repeat.mode.once", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(11);
                }
                return string;
            }
            case "N Times": {
                String string = JUnitBundle.message("junit.configuration.repeat.mode.n.times", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(12);
                }
                return string;
            }
            case "Until Failure": {
                String string = JUnitBundle.message("junit.configuration.repeat.mode.until.failure", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(13);
                }
                return string;
            }
            case "Until Stopped": {
                String string = JUnitBundle.message("junit.configuration.repeat.mode.until.stopped", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(14);
                }
                return string;
            }
        }
        throw new IllegalArgumentException(value);
    }

    @NotNull
    @NlsContexts.Label
    public static String getForkModeName(@NotNull @NonNls String value) {
        if (value == null) {
            JUnitConfigurationModel.$$$reportNull$$$0(15);
        }
        switch (value) {
            case "none": {
                String string = JUnitBundle.message("junit.configuration.fork.mode.none", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(16);
                }
                return string;
            }
            case "method": {
                String string = JUnitBundle.message("junit.configuration.fork.mode.method", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(17);
                }
                return string;
            }
            case "class": {
                String string = JUnitBundle.message("junit.configuration.fork.mode.class", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(18);
                }
                return string;
            }
            case "repeat": {
                String string = JUnitBundle.message("junit.configuration.fork.mode.repeat", new Object[0]);
                if (string == null) {
                    JUnitConfigurationModel.$$$reportNull$$$0(19);
                }
                return string;
            }
        }
        throw new IllegalArgumentException(value);
    }

    public void reloadTestKindModel(JComboBox<Integer> comboBox, Module module) {
        GlobalSearchScope searchScope;
        int selectedIndex = comboBox.getSelectedIndex();
        DefaultComboBoxModel<Integer> aModel = new DefaultComboBoxModel<Integer>();
        aModel.addElement(0);
        aModel.addElement(4);
        aModel.addElement(3);
        aModel.addElement(1);
        aModel.addElement(2);
        GlobalSearchScope globalSearchScope = searchScope = module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)this.myProject);
        if (this.myProject.isDefault() || JavaPsiFacade.getInstance((Project)this.myProject).findPackage("org.junit") != null) {
            aModel.addElement(5);
        }
        if (this.myProject.isDefault() || JUnitUtil.isJUnit5((GlobalSearchScope)searchScope, (Project)this.myProject) || TestObject.hasJUnit5EnginesAPI(searchScope, JavaPsiFacade.getInstance((Project)this.myProject))) {
            aModel.addElement(6);
            aModel.addElement(7);
        }
        if (Registry.is((String)"testDiscovery.enabled")) {
            aModel.addElement(8);
            aModel.addElement(9);
        }
        comboBox.setModel(aModel);
        comboBox.setSelectedIndex(selectedIndex);
    }

    public boolean disableModuleClasspath(boolean wholeProjectSelected) {
        return wholeProjectSelected && (this.myType == 0 || this.myType == 3 || this.myType == 5 || this.myType == 7 || this.myType == 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 10: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit2/configuration/JUnitConfigurationModel";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindName";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit2/configuration/JUnitConfigurationModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepeatModeName";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getForkModeName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRepeatModeName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getForkModeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 10: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

