/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedRepeatedTestInspection;", "Lcom/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Annotations", "intellij.junit"})
public final class JUnit5MalformedRepeatedTestInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.file");
        PsiFile file = psiFile;
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)holder.getProject());
        PsiClass repetitionInfo = psiFacade.findClass("org.junit.jupiter.api.RepetitionInfo", file.getResolveScope());
        if (repetitionInfo == null || psiFacade.findClass("org.junit.jupiter.api.RepeatedTest", file.getResolveScope()) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new JavaElementVisitor(holder, repetitionInfo){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PsiClass $repetitionInfo;

            public void visitMethod(@NotNull PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                PsiModifierList psiModifierList = method.getModifierList();
                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"method.modifierList");
                PsiModifierList modifierList = psiModifierList;
                PsiAnnotation repeatedAnno = modifierList.findAnnotation("org.junit.jupiter.api.RepeatedTest");
                if (repeatedAnno != null) {
                    Object constant;
                    PsiAnnotationMemberValue repeatedNumber;
                    PsiAnnotation[] testAnno = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_JUPITER_ANNOTATIONS);
                    Intrinsics.checkNotNullExpressionValue((Object)testAnno, (String)"testAnno");
                    PsiAnnotation[] psiAnnotationArray = testAnno;
                    boolean bl = false;
                    PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
                    boolean bl2 = false;
                    if (!(psiAnnotationArray2.length == 0)) {
                        this.$holder.registerProblem((PsiElement)testAnno[0], JUnitBundle.message("junit5.malformed.repetition.description.suspicious.combination", new Object[0]), new LocalQuickFix[]{(LocalQuickFix)new DeleteElementFix((PsiElement)testAnno[0])});
                    }
                    if ((repeatedNumber = repeatedAnno.findDeclaredAttributeValue("value")) instanceof PsiExpression && (constant = ExpressionUtils.computeConstantExpression((PsiExpression)((PsiExpression)repeatedNumber))) instanceof Integer && ((Number)constant).intValue() <= 0) {
                        this.$holder.registerProblem((PsiElement)repeatedNumber, JUnitBundle.message("junit5.malformed.repetition.description.positive.number", new Object[0]), new LocalQuickFix[0]);
                    }
                } else {
                    PsiParameter repetitionInfoParam;
                    int n;
                    block15: {
                        PsiParameter psiParameter;
                        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)this.$holder.getProject()).createType(this.$repetitionInfo);
                        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"JavaPsiFacade.getElement\u2026reateType(repetitionInfo)");
                        PsiClassType repetitionType = psiClassType;
                        PsiParameterList psiParameterList = method.getParameterList();
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
                        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList.parameters");
                        PsiParameter[] constant = psiParameterArray;
                        boolean bl = false;
                        PsiParameter[] psiParameterArray2 = constant;
                        boolean bl3 = false;
                        PsiParameter[] psiParameterArray3 = psiParameterArray2;
                        int n2 = psiParameterArray3.length;
                        for (n = 0; n < n2; ++n) {
                            PsiParameter psiParameter2;
                            PsiParameter it = psiParameter2 = psiParameterArray3[n];
                            boolean bl4 = false;
                            PsiParameter psiParameter3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)psiParameter3, (String)"it");
                            if (!Intrinsics.areEqual((Object)psiParameter3.getType(), (Object)repetitionType)) continue;
                            psiParameter = psiParameter2;
                            break block15;
                        }
                        psiParameter = repetitionInfoParam = null;
                    }
                    if (repetitionInfoParam != null) {
                        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Annotations.INSTANCE.getNON_REPEATED_ANNOTATIONS())) {
                            PsiIdentifier psiIdentifier = repetitionInfoParam.getNameIdentifier();
                            this.$holder.registerProblem(psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)repetitionInfoParam, JUnitBundle.message("junit5.malformed.repetition.description.injected.for.repeatedtest", new Object[0]), new LocalQuickFix[0]);
                        } else {
                            PsiAnnotation anno = MetaAnnotationUtil.findMetaAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_STATIC_CONFIG_METHODS).findFirst().orElse(null);
                            if (anno != null) {
                                String qName = anno.getQualifiedName();
                                PsiIdentifier psiIdentifier = repetitionInfoParam.getNameIdentifier();
                                PsiElement psiElement = psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)repetitionInfoParam;
                                Object[] objectArray = new Object[1];
                                String string = qName;
                                Intrinsics.checkNotNull((Object)string);
                                objectArray[0] = StringUtil.getShortName((String)string);
                                this.$holder.registerProblem(psiElement, JUnitBundle.message("junit5.malformed.repetition.description.injected.for.each", objectArray), new LocalQuickFix[0]);
                            } else if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_CONFIG_METHODS)) {
                                PsiMethod psiMethod;
                                block16: {
                                    PsiMethod[] psiMethodArray = method.getContainingClass();
                                    if (psiMethodArray != null && (psiMethodArray = psiMethodArray.getMethods()) != null) {
                                        PsiMethod[] psiMethodArray2 = psiMethodArray;
                                        boolean bl = false;
                                        PsiMethod[] psiMethodArray3 = psiMethodArray2;
                                        boolean bl5 = false;
                                        PsiMethod[] psiMethodArray4 = psiMethodArray3;
                                        n = psiMethodArray4.length;
                                        for (int i = 0; i < n; ++i) {
                                            PsiMethod psiMethod2;
                                            PsiMethod it = psiMethod2 = psiMethodArray4[i];
                                            boolean bl6 = false;
                                            if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)it), (Collection)Annotations.INSTANCE.getNON_REPEATED_ANNOTATIONS())) continue;
                                            psiMethod = psiMethod2;
                                            break block16;
                                        }
                                        psiMethod = null;
                                    } else {
                                        psiMethod = null;
                                    }
                                }
                                if (psiMethod != null) {
                                    PsiIdentifier psiIdentifier = repetitionInfoParam.getNameIdentifier();
                                    this.$holder.registerProblem(psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)repetitionInfoParam, JUnitBundle.message("junit5.malformed.repetition.description.injected.for.test", new Object[0]), new LocalQuickFix[0]);
                                }
                            }
                        }
                    }
                }
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$repetitionInfo = $captured_local_variable$1;
            }
        };
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedRepeatedTestInspection$Annotations;", "", "()V", "NON_REPEATED_ANNOTATIONS", "", "", "getNON_REPEATED_ANNOTATIONS", "()Ljava/util/List;", "intellij.junit"})
    public static final class Annotations {
        @NotNull
        private static final List<String> NON_REPEATED_ANNOTATIONS;
        @NotNull
        public static final Annotations INSTANCE;

        @NotNull
        public final List<String> getNON_REPEATED_ANNOTATIONS() {
            return NON_REPEATED_ANNOTATIONS;
        }

        private Annotations() {
        }

        static {
            Annotations annotations;
            INSTANCE = annotations = new Annotations();
            NON_REPEATED_ANNOTATIONS = CollectionsKt.listOf((Object[])new String[]{"org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.params.ParameterizedTest"});
        }
    }
}

