/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ConfigurationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentUtil;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.junit.JUnitStarter;
import com.intellij.util.Function;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TestPackage
extends TestObject {
    protected static final Function<Location<?>, String> CLASS_NAME_FUNCTION = location -> {
        if (location instanceof MethodLocation) {
            PsiClass containingClass = ((MethodLocation)location).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return ClassUtil.getJVMClassName((PsiClass)containingClass) + "," + ((MethodLocation)location).getPsiElement().getName();
        }
        PsiElement psiElement = location.getPsiElement();
        return psiElement instanceof PsiClass ? ClassUtil.getJVMClassName((PsiClass)((PsiClass)psiElement)) : null;
    };

    public TestPackage(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
    }

    @Nullable
    public SearchForTestsTask createSearchingForTestsTask() throws ExecutionException {
        return this.createSearchingForTestsTask((TargetEnvironment)new LocalTargetEnvironment(new LocalTargetEnvironmentRequest()));
    }

    @Nullable
    public SearchForTestsTask createSearchingForTestsTask(final @NotNull TargetEnvironment remoteEnvironment) throws ExecutionException {
        if (remoteEnvironment == null) {
            TestPackage.$$$reportNull$$$0(0);
        }
        final JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        final Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        final TestClassFilter classFilter = this.computeFilter(data);
        return new SearchForTestsTask(this.getConfiguration().getProject(), this.getServerSocket()){
            private boolean myShouldExecuteFinishMethod;
            private final Set<Location<?>> myClasses;
            {
                super(arg0, arg1);
                this.myShouldExecuteFinishMethod = true;
                this.myClasses = new LinkedHashSet();
            }

            protected void search() {
                this.myClasses.clear();
                SourceScope sourceScope = TestPackage.this.getSourceScope();
                if (sourceScope != null) {
                    try {
                        if ("-junit5".equals(TestPackage.this.getRunner())) {
                            TestPackage.this.searchTests5(module, classFilter, this.myClasses);
                        } else {
                            TestPackage.this.searchTests(module, classFilter, this.myClasses);
                        }
                    }
                    catch (CantRunException cantRunException) {
                        // empty catch block
                    }
                }
            }

            protected void onFound() {
                try {
                    String packageName = TestPackage.this.getPackageName(data);
                    String filters = TestPackage.this.getFilters(this.myClasses, packageName);
                    if ("-junit5".equals(TestPackage.this.getRunner()) && module != null && TestPackage.this.filterOutputByDirectoryForJunit5(this.myClasses)) {
                        JUnitStarter.printClassesList(TestObject.composeDirectoryFilter(TestPackage.this.getModuleWithTestsToFilter(module)), (String)packageName, (String)"", (String)filters, (File)TestPackage.this.myTempFile);
                    } else {
                        TestPackage.this.addClassesListToJavaParameters(this.myClasses, CLASS_NAME_FUNCTION, packageName, TestPackage.this.createTempFiles(), TestPackage.this.getJavaParameters(), filters);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myShouldExecuteFinishMethod = !TargetEnvironmentUtil.reuploadRootFile((File)TestPackage.this.myTempFile, (TargetEnvironmentRequest)TestPackage.this.getTargetEnvironmentRequest(), (TargetEnvironment)remoteEnvironment, (TargetProgressIndicator)TestPackage.this.getTargetProgressIndicator(), () -> ApplicationManager.getApplication().invokeLater(() -> super.finish(), this.myProject.getDisposed()));
            }

            public void finish() {
                if (this.myShouldExecuteFinishMethod) {
                    super.finish();
                }
            }

            protected boolean requiresSmartMode() {
                return TestPackage.this.requiresSmartMode();
            }
        };
    }

    protected Module getModuleWithTestsToFilter(Module module) {
        return module;
    }

    @Nullable
    private TestClassFilter computeFilter(JUnitConfiguration.Data data) throws ExecutionException {
        try {
            TestClassFilter classFilter = (TestClassFilter)DumbService.getInstance((Project)this.getConfiguration().getProject()).computeWithAlternativeResolveEnabled(() -> this.getClassFilter(data));
            LOG.assertTrue(classFilter.getBase() != null);
            return classFilter;
        }
        catch (JUnitUtil.NoJUnitException e) {
            return null;
        }
        catch (IndexNotReadyException e) {
            throw new ExecutionException(JUnitBundle.message("running.tests.disabled.during.index.update.error.message", new Object[0]));
        }
    }

    protected boolean requiresSmartMode() {
        return !"-junit5".equals(this.getRunner());
    }

    protected boolean filterOutputByDirectoryForJunit5(Set<Location<?>> classNames) {
        return this.getConfiguration().getTestSearchScope() == TestSearchScope.SINGLE_MODULE;
    }

    @NlsSafe
    protected String getFilters(Set<Location<?>> foundClasses, @NlsSafe String packageName) {
        return foundClasses.isEmpty() ? (packageName.isEmpty() ? ".*" : packageName + "\\..*") : "";
    }

    protected void searchTests5(Module module, TestClassFilter classFilter, Set<Location<?>> classes) throws CantRunException {
    }

    protected void searchTests(Module module, TestClassFilter classFilter, Set<Location<?>> classes) throws CantRunException {
        if (Registry.is((String)"junit4.search.4.tests.all.in.scope", (boolean)true)) {
            Condition acceptClassCondition = aClass -> (Boolean)ReadAction.compute(() -> aClass.isValid() && classFilter.isAccepted((PsiClass)aClass));
            this.collectClassesRecursively(classFilter, (Condition<? super PsiClass>)acceptClassCondition, classes);
        } else {
            LinkedHashSet psiClasses = new LinkedHashSet();
            ConfigurationUtil.findAllTestClasses(classFilter, module, psiClasses);
            psiClasses.stream().map(PsiLocation::fromPsiElement).forEach(classes::add);
        }
    }

    protected boolean createTempFiles() {
        return false;
    }

    @NotNull
    @NlsSafe
    protected String getPackageName(JUnitConfiguration.Data data) throws CantRunException {
        PsiPackage aPackage = this.getPackage(data);
        return aPackage != null ? aPackage.getQualifiedName() : "";
    }

    protected void collectClassesRecursively(TestClassFilter classFilter, Condition<? super PsiClass> acceptClassCondition, Set<Location<?>> classes) throws CantRunException {
        PsiPackage aPackage = this.getPackage(this.getConfiguration().getPersistentData());
        if (aPackage != null) {
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.getConfiguration().getProject()).intersectWith(classFilter.getScope());
            TestPackage.collectClassesRecursively(aPackage, scope, acceptClassCondition, classes);
        }
    }

    private static void collectClassesRecursively(PsiPackage aPackage, GlobalSearchScope scope, Condition<? super PsiClass> acceptAsTest, Set<Location<?>> classes) {
        PsiClass[] psiClasses;
        PsiPackage[] psiPackages;
        for (PsiPackage psiPackage : psiPackages = (PsiPackage[])ReadAction.compute(() -> aPackage.getSubPackages(scope))) {
            TestPackage.collectClassesRecursively(psiPackage, scope, acceptAsTest, classes);
        }
        for (PsiClass aClass : psiClasses = (PsiClass[])ReadAction.compute(() -> aPackage.getClasses(scope))) {
            TestPackage.collectInnerClasses(aClass, acceptAsTest, classes);
        }
    }

    protected static void collectInnerClasses(PsiClass aClass, Condition<? super PsiClass> acceptAsTest, Set<Location<?>> classes) {
        if (Registry.is((String)"junit4.accept.inner.classes", (boolean)true)) {
            classes.addAll((Collection)ReadAction.compute(() -> ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.of(PsiClass::getInnerClasses).withRoot((Object)aClass)).filter(acceptAsTest)).map(psiClass -> PsiLocation.fromPsiElement((PsiElement)psiClass)).toList()));
        } else if (acceptAsTest.value((Object)aClass)) {
            classes.add(PsiLocation.fromPsiElement((PsiElement)aClass));
        }
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        Project project = this.getConfiguration().getProject();
        SourceScope sourceScope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
        if (sourceScope == null || !"-junit5".equals(this.getRunner())) {
            JUnitUtil.checkTestCase((SourceScope)sourceScope, (Project)project);
        }
        this.createTempFiles(javaParameters);
        this.createServerSocket(javaParameters);
        return javaParameters;
    }

    protected void collectPackagesToOpen(List<String> options) {
        try {
            SourceScope sourceScope = this.getSourceScope();
            if (sourceScope != null) {
                TestPackage.collectSubPackages(options, (PsiPackage)this.getPackage(this.getConfiguration().getPersistentData()), (GlobalSearchScope)sourceScope.getGlobalSearchScope());
            }
        }
        catch (CantRunException cantRunException) {
            // empty catch block
        }
    }

    protected boolean configureByModule(Module module) {
        return super.configureByModule(module) && this.getConfiguration().getPersistentData().getScope() != TestSearchScope.WHOLE_PROJECT;
    }

    protected TestClassFilter getClassFilter(JUnitConfiguration.Data data) throws CantRunException {
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        if (this.getConfiguration().getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            module = null;
        }
        TestClassFilter classFilter = TestClassFilter.create(this.getSourceScope(), module);
        return classFilter.intersectionWith(this.filterScope(data));
    }

    protected GlobalSearchScope filterScope(JUnitConfiguration.Data data) throws CantRunException {
        return (GlobalSearchScope)ReadAction.compute(() -> PackageScope.packageScope((PsiPackage)this.getPackage(data), (boolean)true));
    }

    protected PsiPackage getPackage(JUnitConfiguration.Data data) throws CantRunException {
        String packageName = data.getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw CantRunException.packageNotFound((String)packageName);
        }
        return aPackage;
    }

    @Override
    public String suggestActionName() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return data.getPackageName().trim().length() > 0 ? ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{data.getPackageName()}) : TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        return element instanceof PsiPackage ? RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), configuration.myPackage) : null;
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return testPackage != null && Objects.equals(testPackage.getQualifiedName(), configuration.getPersistentData().getPackageName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String packageName = this.getConfiguration().getPersistentData().getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw new RuntimeConfigurationWarning(JUnitBundle.message("package.does.not.exist.error.message", packageName));
        }
        if (this.getSourceScope() == null) {
            ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).checkForWarning();
        }
    }

    @TestOnly
    public File getWorkingDirsFile() {
        return this.myWorkingDirsFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteEnvironment", "com/intellij/execution/junit/TestPackage", "createSearchingForTestsTask"));
    }
}

