/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.Location;
import com.intellij.execution.TestClassCollector;
import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnit3Framework;
import com.intellij.execution.junit.JUnit4Framework;
import com.intellij.execution.junit.JUnit5Framework;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitTestFramework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.ProgressIndicatorWrapper;
import com.intellij.execution.junit.TestCategory;
import com.intellij.execution.junit.TestClass;
import com.intellij.execution.junit.TestDirectory;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit.TestTags;
import com.intellij.execution.junit.TestUniqueId;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit.testDiscovery.TestBySource;
import com.intellij.execution.junit.testDiscovery.TestsByChanges;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.junit4.JUnit4IdeaTestRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.rt.junit.JUnitStarter;
import com.intellij.spi.SPIFileType;
import com.intellij.spi.psi.SPIClassProviderReferenceElement;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public abstract class TestObject
extends JavaTestFrameworkRunnableState<JUnitConfiguration>
implements PossiblyDumbAware {
    protected static final Logger LOG = Logger.getInstance(TestObject.class);
    @NonNls
    private static final String DEBUG_RT_PATH = "idea.junit_rt.path";
    @NlsSafe
    private static final String JUNIT_TEST_FRAMEWORK_NAME = "JUnit";
    @NonNls
    private static final String DEFAULT_RUNNER = "default";
    private final JUnitConfiguration myConfiguration;
    protected File myListenersFile;
    private final Map<Module, JavaParameters> myAdditionalJarsForModuleFork = new HashMap<Module, JavaParameters>();
    private String myRunner;

    protected TestObject(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(environment);
        this.myConfiguration = configuration;
    }

    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<? super T, String> nameFunction, String packageName, boolean createTempFile, JavaParameters javaParameters) {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        this.addClassesListToJavaParameters(elements, nameFunction, packageName, createTempFile, javaParameters, "pattern".equals(data.TEST_OBJECT) ? data.getPatternPresentation() : "");
    }

    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<? super T, String> nameFunction, String packageName, boolean createTempFile, JavaParameters javaParameters, @NlsSafe String filters) {
        try {
            if (createTempFile) {
                this.createTempFiles(javaParameters);
            }
            TreeMap<Module, List<String>> perModule = this.forkPerModule() ? new TreeMap<Module, List<String>>((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true)) : null;
            ArrayList<String> testNames = new ArrayList<String>();
            if (elements.isEmpty() && perModule != null) {
                for (Module module : this.collectPackageModules(packageName)) {
                    perModule.put(module, TestObject.composeDirectoryFilter(module));
                }
            }
            for (Object element : elements) {
                String name = (String)nameFunction.fun(element);
                if (name == null) continue;
                PsiElement psiElement = this.retrievePsiElement(element);
                if (perModule != null && psiElement != null) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                    if (module == null) continue;
                    this.fillForkModule(perModule, module, name);
                    continue;
                }
                testNames.add(name);
            }
            JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
            if (perModule != null) {
                for (List perModuleClasses : perModule.values()) {
                    Collections.sort(perModuleClasses);
                    testNames.addAll(perModuleClasses);
                }
            } else if ("package".equals(data.TEST_OBJECT)) {
                Collections.sort(testNames);
            }
            String category = "category".equals(data.TEST_OBJECT) ? data.getCategory() : ("tags".equals(data.TEST_OBJECT) ? data.getTags().replaceAll(" ", "") : "");
            JUnitStarter.printClassesList(testNames, (String)packageName, (String)category, (String)filters, (File)this.myTempFile);
            this.writeClassesPerModule(packageName, javaParameters, perModule, filters);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private Set<Module> collectPackageModules(String packageName) {
        TestSearchScope scope;
        PsiPackage aPackage;
        HashSet<Module> result = new HashSet<Module>();
        SourceScope sourceScope = this.getSourceScope();
        Project project = this.getConfiguration().getProject();
        if (sourceScope != null && packageName != null && "-junit5".equals(this.getRunner()) && (aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName)) != null && (scope = this.getScope()) != null) {
            PsiDirectory[] directories;
            GlobalSearchScope configurationSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project).intersectWith(sourceScope.getGlobalSearchScope());
            for (PsiDirectory directory : directories = aPackage.getDirectories(configurationSearchScope)) {
                ContainerUtil.addIfNotNull(result, (Object)ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project));
            }
        }
        return result;
    }

    protected void fillForkModule(Map<Module, List<String>> perModule, Module module, String name) {
        perModule.computeIfAbsent(module, elemList -> new ArrayList()).add(name);
    }

    public Module[] getModulesToCompile() {
        SourceScope sourceScope = this.getSourceScope();
        return sourceScope != null ? sourceScope.getModulesToCompile() : Module.EMPTY_ARRAY;
    }

    @NlsActions.ActionText
    public abstract String suggestActionName();

    public abstract RefactoringElementListener getListener(PsiElement var1, JUnitConfiguration var2);

    public abstract boolean isConfiguredByElement(JUnitConfiguration var1, PsiClass var2, PsiMethod var3, PsiPackage var4, PsiDirectory var5);

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
    }

    @Nullable
    public SourceScope getSourceScope() {
        return SourceScope.modules((Module[])this.getConfiguration().getModules());
    }

    protected void configureRTClasspath(JavaParameters javaParameters, Module module) {
        String path = System.getProperty(DEBUG_RT_PATH);
        javaParameters.getClassPath().addFirst(path != null ? path : PathUtil.getJarPathForClass(JUnitStarter.class));
        javaParameters.getClassPath().addFirst(TestObject.getJUnit5RtFile());
        this.appendDownloadedDependenciesForForkedConfigurations(javaParameters, module);
    }

    private void appendDownloadedDependenciesForForkedConfigurations(JavaParameters javaParameters, Module module) {
        JavaParameters parameters;
        if (module != null && (parameters = this.myAdditionalJarsForModuleFork.get(module)) != null) {
            boolean toModulePath = parameters.getClassPath().isEmpty();
            PathsList sourcePath = toModulePath ? parameters.getModulePath() : parameters.getClassPath();
            PathsList targetPath = toModulePath ? javaParameters.getModulePath() : javaParameters.getClassPath();
            for (String dependencyPath : sourcePath.getPathList()) {
                targetPath.addFirst(dependencyPath);
            }
            ParamsGroup group = TestObject.getJigsawOptions((JavaParameters)parameters);
            if (group != null) {
                TestObject.getOrCreateJigsawOptions((JavaParameters)javaParameters).addParameters(group.getParameters());
            }
        }
    }

    public static File getJUnit5RtFile() {
        File junit4Rt = new File(PathUtil.getJarPathForClass(JUnit4IdeaTestRunner.class));
        String junit4Name = junit4Rt.getName();
        String junit5Name = junit4Rt.isDirectory() ? junit4Name.replace("junit", "junit.v5") : junit4Name.replace("junit", "junit5");
        return new File(junit4Rt.getParent(), junit5Name);
    }

    protected static List<String> composeDirectoryFilter(@NotNull Module module) {
        if (module == null) {
            TestObject.$$$reportNull$$$0(0);
        }
        return ContainerUtil.map((Object[])OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules().classes().getRoots(), root -> "+" + root.getPath());
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        String preferredRunner;
        JavaParameters javaParameters = super.createJavaParameters();
        javaParameters.setMainClass("com.intellij.rt.junit.JUnitStarter");
        javaParameters.getProgramParametersList().add("-ideVersion5");
        StringBuilder buf = new StringBuilder();
        this.collectListeners(javaParameters, buf, "com.intellij.junitListener", "\n");
        if (buf.length() > 0) {
            try {
                this.myListenersFile = FileUtil.createTempFile((String)"junit_listeners_", (String)"", (boolean)true);
                javaParameters.getProgramParametersList().add("@@" + this.myListenersFile.getPath());
                FileUtil.writeToFile((File)this.myListenersFile, (byte[])buf.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!DEFAULT_RUNNER.equals(preferredRunner = this.getRunner())) {
            javaParameters.getProgramParametersList().add(preferredRunner);
        }
        return javaParameters;
    }

    @TestOnly
    public JavaParameters createJavaParameters4Tests() throws ExecutionException {
        JavaParameters parameters = this.createJavaParameters();
        this.downloadAdditionalDependencies(parameters);
        return parameters;
    }

    public void appendJUnit5LauncherClasses(JavaParameters javaParameters, Project project, GlobalSearchScope globalSearchScope, boolean ensureOnModulePath) throws CantRunException {
        String launcherModuleName;
        ParamsGroup group;
        ParametersList vmParametersList;
        boolean isModularized;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        DumbService dumbService = DumbService.getInstance((Project)project);
        PsiClass classFromCommon = (PsiClass)dumbService.computeWithAlternativeResolveEnabled(() -> (PsiClass)ReadAction.compute(() -> psiFacade.findClass("org.junit.platform.commons.JUnitException", globalSearchScope)));
        String launcherVersion = TestObject.getVersion(classFromCommon);
        if (launcherVersion == null) {
            LOG.info("Failed to detect junit 5 launcher version, please configure explicit dependency");
            return;
        }
        boolean bl = isModularized = ensureOnModulePath && JavaSdkUtil.isJdkAtLeast((Sdk)javaParameters.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (Boolean)ReadAction.compute(() -> FilenameIndex.getFilesByName((Project)project, (String)"module-info.java", (GlobalSearchScope)globalSearchScope).length > 0) != false && VersionComparatorUtil.compare((String)launcherVersion, (String)"1.5.0") >= 0;
        if (isModularized && !(vmParametersList = (group = TestObject.getOrCreateJigsawOptions((JavaParameters)javaParameters)).getParametersList()).hasParameter(launcherModuleName = "org.junit.platform.launcher")) {
            vmParametersList.add("--add-modules");
            vmParametersList.add(launcherModuleName);
        }
        ArrayList<String> additionalDependencies = new ArrayList<String>();
        if (!TestObject.hasPackageWithDirectories(psiFacade, "org.junit.platform.launcher", globalSearchScope)) {
            this.downloadDependenciesWhenRequired(project, additionalDependencies, new RepositoryLibraryProperties("org.junit.platform", "junit-platform-launcher", launcherVersion));
        }
        if (!TestObject.hasJUnit5EnginesAPI(globalSearchScope, psiFacade) || !this.isCustomJUnit5(globalSearchScope)) {
            PsiClass junit4RunnerClass;
            PsiClass testAnnotation = (PsiClass)dumbService.computeWithAlternativeResolveEnabled(() -> (PsiClass)ReadAction.compute(() -> psiFacade.findClass("org.junit.jupiter.api.Test", globalSearchScope)));
            String jupiterVersion = (String)ObjectUtils.notNull((Object)TestObject.getVersion(testAnnotation), (Object)"5.0.0");
            if (TestObject.hasPackageWithDirectories(psiFacade, "org.junit.jupiter.api", globalSearchScope) && !TestObject.hasPackageWithDirectories(psiFacade, "org.junit.jupiter.engine", globalSearchScope)) {
                this.downloadDependenciesWhenRequired(project, additionalDependencies, new RepositoryLibraryProperties("org.junit.jupiter", "junit-jupiter-engine", jupiterVersion));
            }
            if (!TestObject.hasPackageWithDirectories(psiFacade, "org.junit.vintage", globalSearchScope) && TestObject.hasPackageWithDirectories(psiFacade, "junit.framework", globalSearchScope) && (junit4RunnerClass = (PsiClass)dumbService.computeWithAlternativeResolveEnabled(() -> (PsiClass)ReadAction.compute(() -> psiFacade.findClass("junit.runner.Version", globalSearchScope)))) != null && this.isAcceptableVintageVersion()) {
                String version = VersionComparatorUtil.compare((String)launcherVersion, (String)"1.1.0") >= 0 ? jupiterVersion : "4.12." + StringUtil.getShortName((String)launcherVersion);
                this.downloadDependenciesWhenRequired(project, additionalDependencies, new RepositoryLibraryProperties("org.junit.vintage", "junit-vintage-engine", version, false, ContainerUtil.emptyList()));
            }
        }
        PathsList targetList = isModularized ? javaParameters.getModulePath() : javaParameters.getClassPath();
        for (int i = additionalDependencies.size() - 1; i >= 0; --i) {
            targetList.addFirst((String)additionalDependencies.get(i));
        }
    }

    private boolean isAcceptableVintageVersion() {
        ClassLoader loader = TestClassCollector.createUsersClassLoader((JavaTestConfigurationBase)this.myConfiguration);
        try {
            Class<?> aClass = loader.loadClass("junit.runner.Version");
            Method id = aClass.getDeclaredMethod("id", new Class[0]);
            Object result = id.invoke(null, new Object[0]);
            return result instanceof String && VersionComparatorUtil.compare((String)"4.12", (String)((String)result)) <= 0;
        }
        catch (Throwable e) {
            LOG.debug(e);
            return false;
        }
    }

    public static boolean hasJUnit5EnginesAPI(GlobalSearchScope globalSearchScope, JavaPsiFacade psiFacade) {
        return TestObject.hasPackageWithDirectories(psiFacade, "org.junit.platform.engine", globalSearchScope);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion(PsiClass classFromCommon) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)classFromCommon);
        if (virtualFile == null) return null;
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)classFromCommon.getProject());
        VirtualFile root = index.getClassRootForFile(virtualFile);
        if (root == null) return null;
        if (!(root.getFileSystem() instanceof JarFileSystem)) return null;
        VirtualFile manifestFile = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile == null) return null;
        try (InputStream inputStream = manifestFile.getInputStream();){
            Attributes mainAttributes = new Manifest(inputStream).getMainAttributes();
            if (!"junit.org".equals(mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR))) return null;
            String string = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void downloadDependenciesWhenRequired(@NotNull Project project, @NotNull List<String> classPath, @NotNull RepositoryLibraryProperties properties) throws CantRunException {
        Collection<Object> roots;
        if (project == null) {
            TestObject.$$$reportNull$$$0(1);
        }
        if (classPath == null) {
            TestObject.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            TestObject.$$$reportNull$$$0(3);
        }
        try {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                roots = JarRepositoryManager.loadDependenciesModal((Project)project, (RepositoryLibraryProperties)properties, (boolean)false, (boolean)false, null, null);
            } else {
                ApplicationManager.getApplication().assertReadAccessNotAllowed();
                TargetProgressIndicator targetProgressIndicator = this.getTargetProgressIndicator();
                if (targetProgressIndicator != null) {
                    String title = JavaUiBundle.message((String)"jar.repository.manager.dialog.resolving.dependencies.title", (Object[])new Object[]{1});
                    targetProgressIndicator.addSystemLine(title);
                }
                roots = JarRepositoryManager.loadDependenciesSync((Project)project, (RepositoryLibraryProperties)properties, (boolean)false, (boolean)false, null, null, (ProgressIndicator)(targetProgressIndicator != null ? new ProgressIndicatorWrapper(targetProgressIndicator) : (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new DumbProgressIndicator())));
            }
        }
        catch (ProcessCanceledException e) {
            roots = Collections.emptyList();
        }
        catch (Throwable e) {
            LOG.error(e);
            roots = Collections.emptyList();
        }
        if (roots.isEmpty()) {
            throw new CantRunException(JUnitBundle.message("dialog.message.failed.to.resolve.maven.id", properties.getMavenId()));
        }
        for (OrderRoot root : roots) {
            String path;
            if (root.getType() != OrderRootType.CLASSES || classPath.contains(path = PathUtil.getLocalPath((VirtualFile)root.getFile()))) continue;
            classPath.add(path);
        }
    }

    private static boolean hasPackageWithDirectories(JavaPsiFacade psiFacade, String packageQName, GlobalSearchScope globalSearchScope) {
        return (Boolean)ReadAction.compute(() -> {
            PsiPackage aPackage = psiFacade.findPackage(packageQName);
            return aPackage != null && aPackage.getDirectories(globalSearchScope).length > 0;
        });
    }

    private static GlobalSearchScope getScopeForJUnit(@Nullable Module module, Project project) {
        return module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)project);
    }

    public static GlobalSearchScope getScopeForJUnit(JUnitConfiguration configuration) {
        return TestObject.getScopeForJUnit(((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule(), configuration.getProject());
    }

    public void appendRepeatMode() throws ExecutionException {
        String repeatMode = this.getConfiguration().getRepeatMode();
        if (!"Once".equals(repeatMode)) {
            int repeatCount = this.getConfiguration().getRepeatCount();
            String countString = "N Times".equals(repeatMode) && repeatCount > 0 ? RepeatCount.getCountString((int)repeatCount) : repeatMode;
            this.getJavaParameters().getProgramParametersList().add(countString);
        }
    }

    protected boolean useModulePath() {
        return this.getConfiguration().isUseModulePath();
    }

    protected boolean isIdBasedTestTree() {
        return "-junit5".equals(this.getRunner());
    }

    @NotNull
    protected String getForkMode() {
        String string = this.getConfiguration().getForkMode();
        if (string == null) {
            TestObject.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void downloadAdditionalDependencies(JavaParameters javaParameters) throws ExecutionException {
        super.downloadAdditionalDependencies(javaParameters);
        String preferredRunner = this.getRunner();
        if ("-junit5".equals(preferredRunner)) {
            JUnitConfiguration configuration = this.getConfiguration();
            Project project = configuration.getProject();
            Module module = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
            this.appendJUnit5LauncherClasses(javaParameters, project, TestObject.getScopeForJUnit(module, project), this.useModulePath() && module != null && ReadAction.compute(() -> TestObject.findJavaModule((Module)module, (boolean)true)) != null);
            if (this.forkPerModule()) {
                for (Module packageModule : this.collectPackageModules(configuration.getPackage())) {
                    JavaParameters parameters = new JavaParameters();
                    ParamsGroup group = TestObject.getJigsawOptions((JavaParameters)javaParameters);
                    if (group != null) {
                        parameters.getVMParametersList().addParamsGroup(group.clone());
                    }
                    parameters.setJdk(javaParameters.getJdk());
                    this.appendJUnit5LauncherClasses(parameters, project, TestObject.getScopeForJUnit(packageModule, project), this.useModulePath() && packageModule != null && ReadAction.compute(() -> TestObject.findJavaModule((Module)packageModule, (boolean)true)) != null);
                    this.myAdditionalJarsForModuleFork.put(packageModule, parameters);
                }
            }
        }
    }

    public static TestObject fromString(String id, JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            TestObject.$$$reportNull$$$0(5);
        }
        if ("method".equals(id)) {
            return new TestMethod(configuration, environment);
        }
        if ("class".equals(id)) {
            return new TestClass(configuration, environment);
        }
        if ("package".equals(id)) {
            return new TestPackage(configuration, environment);
        }
        if ("directory".equals(id)) {
            return new TestDirectory(configuration, environment);
        }
        if ("category".equals(id)) {
            return new TestCategory(configuration, environment);
        }
        if ("pattern".equals(id)) {
            return new TestsPattern(configuration, environment);
        }
        if ("uniqueId".equals(id)) {
            return new TestUniqueId(configuration, environment);
        }
        if ("tags".equals(id)) {
            return new TestTags(configuration, environment);
        }
        if ("source location".equals(id)) {
            return new TestBySource(configuration, environment);
        }
        if ("changes".equals(id)) {
            return new TestsByChanges(configuration, environment);
        }
        LOG.info(JUnitBundle.message("configuration.not.specified.message", id));
        return null;
    }

    protected PsiElement retrievePsiElement(Object element) {
        if (element instanceof String) {
            SourceScope scope = this.getSourceScope();
            Project project = this.getConfiguration().getProject();
            String qName = (String)element;
            int idx = qName.indexOf(44);
            String className = idx > 0 ? qName.substring(0, idx) : qName;
            return JavaPsiFacade.getInstance((Project)project).findClass(className, scope != null ? scope.getGlobalSearchScope() : GlobalSearchScope.projectScope((Project)project));
        }
        if (element instanceof Location) {
            return ((Location)element).getPsiElement();
        }
        return element instanceof PsiElement ? (PsiElement)element : null;
    }

    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.myListenersFile != null) {
            FileUtil.delete((File)this.myListenersFile);
        }
    }

    @NotNull
    protected String getFrameworkName() {
        return JUNIT_TEST_FRAMEWORK_NAME;
    }

    @NotNull
    protected String getFrameworkId() {
        return "junit";
    }

    protected void passTempFile(ParametersList parametersList, String tempFilePath) {
        parametersList.add(new CompositeParameterTargetedValue().addLocalPart("@").addPathPart(tempFilePath));
    }

    @NotNull
    public JUnitConfiguration getConfiguration() {
        JUnitConfiguration jUnitConfiguration = this.myConfiguration;
        if (jUnitConfiguration == null) {
            TestObject.$$$reportNull$$$0(6);
        }
        return jUnitConfiguration;
    }

    protected TestSearchScope getScope() {
        return this.getConfiguration().getPersistentData().getScope();
    }

    protected void passForkMode(String forkMode, File tempFile, JavaParameters parameters) {
        parameters.getProgramParametersList().add("@@@" + forkMode + "," + tempFile.getAbsolutePath());
        if (this.getForkSocket() != null) {
            parameters.getProgramParametersList().add("-debugSocket" + this.getForkSocket().getLocalPort());
        }
    }

    @NotNull
    protected String getRunner() {
        if (this.myRunner == null) {
            this.myRunner = (String)ReadAction.compute(this::getRunnerInner);
        }
        String string = this.myRunner;
        if (string == null) {
            TestObject.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getRunnerInner() {
        PsiClass psiClass;
        Project project = this.myConfiguration.getProject();
        LOG.assertTrue(!DumbService.getInstance((Project)project).isAlternativeResolveEnabled());
        GlobalSearchScope globalSearchScope = TestObject.getScopeForJUnit(this.myConfiguration);
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        boolean isMethodConfiguration = "method".equals(data.TEST_OBJECT);
        boolean isClassConfiguration = "class".equals(data.TEST_OBJECT);
        PsiClass psiClass2 = psiClass = isMethodConfiguration || isClassConfiguration ? JavaExecutionUtil.findMainClass((Project)project, (String)data.getMainClassName(), (GlobalSearchScope)globalSearchScope) : null;
        if (psiClass != null) {
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
            if (testFramework instanceof JUnit5Framework) {
                return "-junit5";
            }
            if (testFramework instanceof JUnit4Framework) {
                return "-junit4";
            }
            if (testFramework instanceof JUnit3Framework) {
                return isClassConfiguration ? "-junit4" : "-junit3";
            }
            if (testFramework instanceof JUnitTestFramework && !((JUnitTestFramework)testFramework).shouldRunSingleClassAsJUnit5(project, globalSearchScope)) {
                return "-junit4";
            }
        }
        return JUnitUtil.isJUnit5((GlobalSearchScope)globalSearchScope, (Project)project) || this.isCustomJUnit5(globalSearchScope) ? "-junit5" : DEFAULT_RUNNER;
    }

    private boolean isCustomJUnit5(GlobalSearchScope globalSearchScope) {
        Project project = this.myConfiguration.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        if (DumbService.isDumb((Project)project)) {
            return this.findCustomJUnit5TestEngineUsingClassLoader(globalSearchScope, psiFacade);
        }
        return (Boolean)ReadAction.compute(() -> TestObject.findCustomJunit5TestEngineUsingPsi(globalSearchScope, project, psiFacade));
    }

    private boolean findCustomJUnit5TestEngineUsingClassLoader(@NotNull GlobalSearchScope globalSearchScope, @NotNull JavaPsiFacade psiFacade) {
        boolean hasPlatformEngine;
        if (globalSearchScope == null) {
            TestObject.$$$reportNull$$$0(8);
        }
        if (psiFacade == null) {
            TestObject.$$$reportNull$$$0(9);
        }
        if (!(hasPlatformEngine = ((Boolean)ReadAction.compute(() -> {
            PsiPackage aPackage = psiFacade.findPackage("org.junit.platform.engine");
            return aPackage != null && aPackage.getDirectories(globalSearchScope).length > 0;
        })).booleanValue())) {
            return false;
        }
        ClassLoader loader = TestClassCollector.createUsersClassLoader((JavaTestConfigurationBase)this.myConfiguration);
        try {
            ServiceLoader<?> serviceLoader = ServiceLoader.load(Class.forName("org.junit.platform.engine.TestEngine", false, loader), loader);
            for (Object engine : serviceLoader) {
                String engineClassName = engine.getClass().getName();
                if (!TestObject.isCustomJunit5TestEngineName(engineClassName)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean findCustomJunit5TestEngineUsingPsi(@NotNull GlobalSearchScope globalSearchScope, @NotNull Project project, @NotNull JavaPsiFacade psiFacade) {
        PsiClass testEngine;
        if (globalSearchScope == null) {
            TestObject.$$$reportNull$$$0(10);
        }
        if (project == null) {
            TestObject.$$$reportNull$$$0(11);
        }
        if (psiFacade == null) {
            TestObject.$$$reportNull$$$0(12);
        }
        if ((testEngine = psiFacade.findClass("org.junit.platform.engine.TestEngine", globalSearchScope)) == null) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)globalSearchScope, (FileType[])new FileType[]{SPIFileType.INSTANCE});
        return Stream.of(FilenameIndex.getFilesByName((Project)project, (String)"org.junit.platform.engine.TestEngine", (GlobalSearchScope)scope)).flatMap(f -> PsiTreeUtil.findChildrenOfType((PsiElement)f, SPIClassProviderReferenceElement.class).stream()).map(r -> r.resolve()).filter(e -> e instanceof PsiClass).map(e -> (PsiClass)e).filter(c -> TestObject.isCustomJunit5TestEngineName(c.getQualifiedName())).anyMatch(c -> InheritanceUtil.isInheritorOrSelf((PsiClass)c, (PsiClass)testEngine, (boolean)true));
    }

    private static boolean isCustomJunit5TestEngineName(@Nullable String engineImplClassName) {
        return !"org.junit.jupiter.engine.JupiterTestEngine".equals(engineImplClassName) && !"org.junit.vintage.engine.VintageTestEngine".equals(engineImplClassName);
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/TestObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSearchScope";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/TestObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getForkMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "composeDirectoryFilter";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "downloadDependenciesWhenRequired";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCustomJUnit5TestEngineUsingClassLoader";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCustomJunit5TestEngineUsingPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

