/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.web.impl;

import com.intellij.openapi.util.JDOMUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javaee.model.impl.JpsJavaeeModuleExtensionSerializerBase;
import org.jetbrains.jps.javaee.model.web.JpsWebModuleExtension;
import org.jetbrains.jps.javaee.model.web.impl.JpsWebModuleExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

public class JpsWebModuleExtensionSerializer
extends JpsJavaeeModuleExtensionSerializerBase<JpsWebModuleExtension> {
    private static final String WEB_ROOTS_TAG = "webroots";
    private static final String ROOT_TAG = "root";
    private static final String URL_ATTRIBUTE = "url";
    private static final String RELATIVE_ATTRIBUTE = "relative";
    private static final String SOURCE_ROOTS_TAG = "sourceRoots";

    public JpsWebModuleExtensionSerializer() {
        super(JpsWebModuleExtensionImpl.ROLE, JpsWebModuleExtensionImpl.COLLECTION_ROLE, "web");
    }

    public JpsWebModuleExtension loadExtension(@NotNull Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
        if (facetConfigurationElement == null) {
            JpsWebModuleExtensionSerializer.$$$reportNull$$$0(0);
        }
        JpsWebModuleExtensionImpl extension = new JpsWebModuleExtensionImpl(name);
        for (Element webRoot : JDOMUtil.getChildren((Element)facetConfigurationElement.getChild(WEB_ROOTS_TAG), (String)ROOT_TAG)) {
            extension.addWebRoot(webRoot.getAttributeValue(URL_ATTRIBUTE), webRoot.getAttributeValue(RELATIVE_ATTRIBUTE));
        }
        Element sourceRootsTag = facetConfigurationElement.getChild(SOURCE_ROOTS_TAG);
        if (sourceRootsTag != null) {
            for (Element sourceRoot : JDOMUtil.getChildren((Element)sourceRootsTag, (String)ROOT_TAG)) {
                extension.getSourceRootsList().addUrl(sourceRoot.getAttributeValue(URL_ATTRIBUTE));
            }
        } else {
            for (String url : JpsWebModuleExtensionSerializer.getAllSourceRootsList(module)) {
                extension.getSourceRootsList().addUrl(url);
            }
        }
        JpsWebModuleExtensionSerializer.loadJavaeeConfigFiles(extension, facetConfigurationElement);
        return extension;
    }

    private static List<String> getAllSourceRootsList(JpsModule module) {
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            if (!root.getRootType().equals(JavaSourceRootType.SOURCE)) continue;
            sourceUrls.add(root.getUrl());
        }
        return sourceUrls;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfigurationElement", "org/jetbrains/jps/javaee/model/web/impl/JpsWebModuleExtensionSerializer", "loadExtension"));
    }
}

