/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.build.jspValidation;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileDependenciesAnalyzer;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.javaee.build.jspValidation.JspFileDependenciesData;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class JspFileDependenciesAnalyzer {
    private final ClassFileDependenciesAnalyzer myClassFileAnalyzingService;
    private final Mappings myMappings;

    public JspFileDependenciesAnalyzer(File dataDir, Mappings mappings) throws IOException {
        this.myClassFileAnalyzingService = new ClassFileDependenciesAnalyzer(dataDir, mappings.getRelativizer());
        this.myMappings = mappings;
    }

    public JspFileDependenciesData analyzeDependencies(File jspFile, String classFilePath, String[] pathsToIncludedFiles) throws IOException {
        List<File> includedFiles = Arrays.stream(pathsToIncludedFiles).map(File::new).filter(File::isFile).collect(Collectors.toList());
        ArrayList<File> dependencies = new ArrayList<File>(includedFiles);
        File classFile = new File(classFilePath);
        try (FileInputStream inputStream = new FileInputStream(classFile);){
            ClassReader classReader = new ClassReader((InputStream)new BufferedInputStream(inputStream));
            Set classDependencies = this.myClassFileAnalyzingService.collectDependencies(FileUtilRt.getNameWithoutExtension((String)classFile.getName()), classReader);
            for (String dependency : classDependencies) {
                Collection sources = this.myMappings.getClassSources(this.myMappings.getName(dependency));
                if (sources == null) continue;
                dependencies.addAll(sources);
            }
        }
        return new JspFileDependenciesData(jspFile, dependencies, includedFiles);
    }

    public void close() {
        this.myClassFileAnalyzingService.close();
    }
}

