/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.client.common.canvas.SwingCanvas;
import org.jetbrains.projector.client.swing.AbstractWindowManager;
import org.jetbrains.projector.client.swing.JFrameWindowManager;
import org.jetbrains.projector.client.swing.ProjectorTransport;
import org.jetbrains.projector.client.swing.ProjectorTransportKt;
import org.jetbrains.projector.client.swing.ProjectorViewPanel;
import org.jetbrains.projector.common.protocol.toClient.WindowData;
import org.jetbrains.projector.common.protocol.toServer.ClientEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowCloseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowMoveEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowResizeEvent;
import org.jetbrains.projector.common.protocol.toServer.ResizeDirection;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J \u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00102\u0010\u0010\u0014\u001a\f0\u001bR\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016J\u001a\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u001e\u001a\f0\u001bR\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016J\u001a\u0010\u001f\u001a\u00020\u00102\u0010\u0010\u001e\u001a\f0\u001bR\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/projector/client/swing/JFrameWindowManager;", "Lorg/jetbrains/projector/client/swing/AbstractWindowManager;", "Ljavax/swing/JFrame;", "transport", "Lorg/jetbrains/projector/client/swing/ProjectorTransport;", "(Lorg/jetbrains/projector/client/swing/ProjectorTransport;)V", "getTransport", "()Lorg/jetbrains/projector/client/swing/ProjectorTransport;", "windowOldPositionsMap", "Ljava/util/HashMap;", "", "Ljava/awt/Point;", "Lkotlin/collections/HashMap;", "windowOldSizesMap", "Ljava/awt/Dimension;", "addListeners", "", "jFrame", "windowId", "deleteFrame", "frame", "newFrame", "canvas", "Lorg/jetbrains/projector/client/common/canvas/SwingCanvas;", "windowData", "Lorg/jetbrains/projector/common/protocol/toClient/WindowData;", "redrawWindow", "Lorg/jetbrains/projector/client/swing/AbstractWindowManager$FrameData;", "shouldWindowBeShown", "", "frameData", "updateFrameProperties", "Companion", "projector-client-swing"})
public class JFrameWindowManager
extends AbstractWindowManager<JFrame> {
    private HashMap<Integer, Dimension> windowOldSizesMap;
    private HashMap<Integer, Point> windowOldPositionsMap;
    @NotNull
    private final ProjectorTransport transport;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JFrame newFrame(int windowId, @NotNull SwingCanvas canvas, @NotNull WindowData windowData) {
        void $this$a2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)windowData, (String)"windowData");
        JFrame jFrame = new JFrame();
        boolean bl = false;
        boolean bl2 = false;
        JFrame $this$apply = jFrame;
        boolean bl3 = false;
        JRootPane jRootPane = $this$apply.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
        ProjectorViewPanel projectorViewPanel = new ProjectorViewPanel(canvas, this.transport.getConnectionTime(), 0.0, 4, null);
        boolean bl4 = false;
        boolean bl5 = false;
        ProjectorViewPanel projectorViewPanel2 = projectorViewPanel;
        Container container = jRootPane.getContentPane();
        boolean bl6 = false;
        $this$a2.addListeners(windowId, (Function1<? super ClientEvent, Unit>)((Function1)new Function1<ClientEvent, Unit>(this, canvas, windowId, windowData){
            final /* synthetic */ JFrameWindowManager this$0;
            final /* synthetic */ SwingCanvas $canvas$inlined;
            final /* synthetic */ int $windowId$inlined;
            final /* synthetic */ WindowData $windowData$inlined;
            {
                this.this$0 = jFrameWindowManager;
                this.$canvas$inlined = swingCanvas;
                this.$windowId$inlined = n;
                this.$windowData$inlined = windowData;
                super(1);
            }

            public final void invoke(@NotNull ClientEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ProjectorTransportKt.send(this.this$0.getTransport(), it);
            }
        }));
        Unit unit = Unit.INSTANCE;
        container.add(projectorViewPanel);
        this.addListeners($this$apply, windowId);
        $this$apply.setUndecorated(windowData.getUndecorated());
        return jFrame;
    }

    public boolean shouldWindowBeShown(@NotNull AbstractWindowManager.FrameData frameData) {
        Intrinsics.checkNotNullParameter((Object)frameData, (String)"frameData");
        return true;
    }

    private final void addListeners(JFrame jFrame, int windowId) {
        ((Map)this.windowOldSizesMap).put(windowId, new Dimension(jFrame.getWidth(), jFrame.getHeight()));
        jFrame.addWindowListener(new WindowAdapter(this, windowId){
            final /* synthetic */ JFrameWindowManager this$0;
            final /* synthetic */ int $windowId;

            public void windowClosing(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProjectorTransportKt.send(this.this$0.getTransport(), (ClientEvent)new ClientWindowCloseEvent(this.$windowId));
            }
            {
                this.this$0 = this$0;
                this.$windowId = $captured_local_variable$1;
            }
        });
        jFrame.getRootPane().addComponentListener(new ComponentAdapter(this, windowId, jFrame){
            final /* synthetic */ JFrameWindowManager this$0;
            final /* synthetic */ int $windowId;
            final /* synthetic */ JFrame $jFrame;

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                V v = JFrameWindowManager.access$getWindowOldSizesMap$p(this.this$0).get(this.$windowId);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue(v, (String)"windowOldSizesMap[windowId]!!");
                Dimension oldDim = (Dimension)v;
                int deltaX = this.$jFrame.getWidth() - oldDim.width;
                int deltaY = this.$jFrame.getHeight() - oldDim.height;
                if (deltaX != 0 || deltaY != 0) {
                    ProjectorTransportKt.send(this.this$0.getTransport(), (ClientEvent)new ClientWindowResizeEvent(this.$windowId, deltaX, deltaY, ResizeDirection.SE));
                } else {
                    Logger.DefaultImpls.info$default((Logger)JFrameWindowManager.access$getLogger$cp(), null, (Function0)addListeners.componentResized.1.INSTANCE, (int)1, null);
                }
                ((Map)JFrameWindowManager.access$getWindowOldSizesMap$p(this.this$0)).put(this.$windowId, new Dimension(this.$jFrame.getWidth(), this.$jFrame.getHeight()));
            }
            {
                this.this$0 = this$0;
                this.$windowId = $captured_local_variable$1;
                this.$jFrame = $captured_local_variable$2;
            }
        });
        jFrame.addComponentListener(new ComponentAdapter(this, windowId, jFrame){
            final /* synthetic */ JFrameWindowManager this$0;
            final /* synthetic */ int $windowId;
            final /* synthetic */ JFrame $jFrame;

            public void componentMoved(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                V v = JFrameWindowManager.access$getWindowOldPositionsMap$p(this.this$0).get(this.$windowId);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue(v, (String)"windowOldPositionsMap[windowId]!!");
                Point oldPoint = (Point)v;
                int deltaX = this.$jFrame.getX() - oldPoint.x;
                int deltaY = this.$jFrame.getY() - oldPoint.y;
                if (deltaX != 0 || deltaY != 0) {
                    ProjectorTransportKt.send(this.this$0.getTransport(), (ClientEvent)new ClientWindowMoveEvent(this.$windowId, deltaX, deltaY));
                } else {
                    Logger.DefaultImpls.info$default((Logger)JFrameWindowManager.access$getLogger$cp(), null, (Function0)addListeners.componentMoved.1.INSTANCE, (int)1, null);
                }
                ((Map)JFrameWindowManager.access$getWindowOldPositionsMap$p(this.this$0)).put(this.$windowId, new Point(this.$jFrame.getX(), this.$jFrame.getY()));
            }
            {
                this.this$0 = this$0;
                this.$windowId = $captured_local_variable$1;
                this.$jFrame = $captured_local_variable$2;
            }
        });
    }

    @Override
    public void updateFrameProperties(@NotNull AbstractWindowManager.FrameData frameData) {
        Intrinsics.checkNotNullParameter((Object)frameData, (String)"frameData");
        JFrame newFrame = (JFrame)frameData.getFrame();
        WindowData it = frameData.getWindowData();
        newFrame.setTitle(it.getTitle());
        newFrame.setResizable(it.getResizable());
        Dimension newDimension = new Dimension((int)it.getBounds().getWidth(), (int)it.getBounds().getHeight());
        ((Map)this.windowOldSizesMap).put(it.getId(), newDimension);
        newFrame.setSize(newDimension);
        newFrame.setVisible(it.isShowing() && this.shouldWindowBeShown(frameData));
        ((Map)this.windowOldPositionsMap).put(it.getId(), new Point((int)it.getBounds().getX(), (int)it.getBounds().getY()));
        newFrame.setLocation((int)it.getBounds().getX(), (int)it.getBounds().getY());
    }

    @Override
    public void redrawWindow(@NotNull AbstractWindowManager.FrameData frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        JRootPane jRootPane = ((JFrame)frame.getFrame()).getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"frame.frame.rootPane");
        Component component = jRootPane.getContentPane().getComponent(0);
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.projector.client.swing.ProjectorViewPanel");
        }
        ProjectorViewPanel component2 = (ProjectorViewPanel)component;
        component2.revalidate();
        component2.repaint();
    }

    @Override
    public void deleteFrame(@NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        frame.setVisible(false);
        frame.dispose();
    }

    @NotNull
    public final ProjectorTransport getTransport() {
        return this.transport;
    }

    public JFrameWindowManager(@NotNull ProjectorTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        this.transport = transport;
        this.windowOldSizesMap = new HashMap();
        this.windowOldPositionsMap = new HashMap();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(JFrameWindowManager.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
    }

    public static final /* synthetic */ HashMap access$getWindowOldSizesMap$p(JFrameWindowManager $this) {
        return $this.windowOldSizesMap;
    }

    public static final /* synthetic */ void access$setWindowOldSizesMap$p(JFrameWindowManager $this, HashMap hashMap) {
        $this.windowOldSizesMap = hashMap;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ HashMap access$getWindowOldPositionsMap$p(JFrameWindowManager $this) {
        return $this.windowOldPositionsMap;
    }

    public static final /* synthetic */ void access$setWindowOldPositionsMap$p(JFrameWindowManager $this, HashMap hashMap) {
        $this.windowOldPositionsMap = hashMap;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/projector/client/swing/JFrameWindowManager$Companion;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "projector-client-swing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

