/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.ngram;

import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.grazie.detector.ngram.impl.NgramExtractor;
import com.intellij.grazie.detector.ngram.impl.NgramFrequencies;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfile;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfileReader;
import com.intellij.grazie.detector.utils.collections.UtilsKt;
import com.intellij.grazie.detector.utils.resources.ResourceLoader;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013BK\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grazie/detector/ngram/NgramDetectorBuilder;", "", "loader", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "ngramExtractor", "Lcom/intellij/grazie/detector/ngram/impl/NgramExtractor;", "alpha", "", "prefixFactor", "suffixFactor", "probabilityThreshold", "minimalConfidence", "(Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;Lcom/intellij/grazie/detector/ngram/impl/NgramExtractor;DDDDD)V", "build", "Lcom/intellij/grazie/detector/ngram/NgramDetector;", "languages", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/detector/model/Language;", "Lkotlin/collections/LinkedHashSet;", "Companion", "nlp-detector"})
public final class NgramDetectorBuilder {
    private final ResourceLoader loader;
    private final NgramExtractor ngramExtractor;
    private double alpha;
    private double prefixFactor;
    private double suffixFactor;
    private double probabilityThreshold;
    private double minimalConfidence;
    private static final double ALPHA_DEFAULT = 0.5;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final NgramDetectorBuilder alpha(double alpha) {
        double d = alpha;
        boolean bl = d >= 0.0 && d <= 1.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "alpha must be between 0 and 1, but was: " + alpha;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.alpha = alpha;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder prefixFactor(double prefixFactor) {
        this.prefixFactor = prefixFactor;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder suffixFactor(double suffixFactor) {
        this.suffixFactor = suffixFactor;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder probabilityThreshold(double probabilityThreshold) {
        this.probabilityThreshold = probabilityThreshold;
        return this;
    }

    @NotNull
    public final NgramDetectorBuilder minimalConfidence(double minimalConfidence) {
        this.minimalConfidence = minimalConfidence;
        return this;
    }

    @NotNull
    public final NgramDetector build(@NotNull LinkedHashSet<Language> languages) throws IllegalStateException {
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        return new NgramDetector(NgramFrequencies.Companion.create((Collection<? extends LanguageProfile>)LanguageProfileReader.INSTANCE.readAll(languages, this.loader), (Collection<Integer>)this.ngramExtractor.getGramLengths()), this.alpha, this.prefixFactor, this.suffixFactor, this.probabilityThreshold, this.minimalConfidence, this.ngramExtractor);
    }

    private NgramDetectorBuilder(ResourceLoader loader, NgramExtractor ngramExtractor, double alpha, double prefixFactor, double suffixFactor, double probabilityThreshold, double minimalConfidence) {
        this.loader = loader;
        this.ngramExtractor = ngramExtractor;
        this.alpha = alpha;
        this.prefixFactor = prefixFactor;
        this.suffixFactor = suffixFactor;
        this.probabilityThreshold = probabilityThreshold;
        this.minimalConfidence = minimalConfidence;
    }

    /* synthetic */ NgramDetectorBuilder(ResourceLoader resourceLoader, NgramExtractor ngramExtractor, double d, double d2, double d3, double d4, double d5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ngramExtractor = NgramExtractor.Companion.getStandard();
        }
        if ((n & 4) != 0) {
            d = 0.5;
        }
        if ((n & 8) != 0) {
            d2 = 1.0;
        }
        if ((n & 0x10) != 0) {
            d3 = 1.0;
        }
        if ((n & 0x20) != 0) {
            d4 = 0.1;
        }
        if ((n & 0x40) != 0) {
            d5 = 0.9999;
        }
        this(resourceLoader, ngramExtractor, d, d2, d3, d4, d5);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grazie/detector/ngram/NgramDetectorBuilder$Companion;", "", "()V", "ALPHA_DEFAULT", "", "standard", "Lcom/intellij/grazie/detector/ngram/NgramDetector;", "loader", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "standardForLanguage", "languages", "Ljava/util/LinkedHashSet;", "Lcom/intellij/grazie/detector/model/Language;", "Lkotlin/collections/LinkedHashSet;", "nlp-detector"})
    public static final class Companion {
        @NotNull
        public final NgramDetector standard(@NotNull ResourceLoader loader) {
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            return new NgramDetectorBuilder(loader, null, 0.0, 0.0, 0.0, 0.0, 0.0, 126, null).minimalConfidence(0.9).prefixFactor(1.5).suffixFactor(2.0).build(UtilsKt.toLinkedSet((Iterable)Language.Companion.getAll()));
        }

        @NotNull
        public final NgramDetector standardForLanguage(@NotNull ResourceLoader loader, @NotNull LinkedHashSet<Language> languages) {
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            return new NgramDetectorBuilder(loader, null, 0.0, 0.0, 0.0, 0.0, 0.0, 126, null).minimalConfidence(0.9).prefixFactor(1.5).suffixFactor(2.0).build(languages);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

