/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit3.TestRunnerUtil;
import com.intellij.junit4.JUnit45ClassesRequestBuilder;
import com.intellij.junit4.JUnit46ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ClassesRequestBuilder;
import com.intellij.junit4.JUnit4ReflectionUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runners.Parameterized;

public final class JUnit4TestRunnerUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Request buildRequest(String[] suiteClassNames, final String name, boolean notForked) {
        if (suiteClassNames.length == 0) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (String suiteClassName : suiteClassNames) {
            RunWith clazzAnnotation;
            Request request;
            Class<?> clazz;
            if (suiteClassName.charAt(0) == '@') {
                try {
                    final HashMap<String, Set<String>> classMethods = new HashMap<String, Set<String>>();
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(suiteClassName.substring(1)), "UTF-8"));
                    try {
                        Request allClasses;
                        HashSet<String> methodNames;
                        String line;
                        String packageName = reader.readLine();
                        if (packageName == null) {
                            Request request2 = null;
                            return request2;
                        }
                        String categoryName = reader.readLine();
                        Class<?> category = categoryName != null && categoryName.length() > 0 ? JUnit4TestRunnerUtil.loadTestClass(categoryName) : null;
                        String filters = reader.readLine();
                        while ((line = reader.readLine()) != null) {
                            String className = line;
                            int idx = line.indexOf(44);
                            if (idx != -1) {
                                className = line.substring(0, idx);
                                methodNames = (HashSet<String>)classMethods.get(className);
                                if (methodNames == null) {
                                    methodNames = new HashSet<String>();
                                    classMethods.put(className, methodNames);
                                }
                                methodNames.add(line.substring(idx + 1));
                            }
                            JUnit4TestRunnerUtil.appendTestClass(result, className);
                        }
                        String suiteName = packageName.length() == 0 ? "<default package>" : packageName;
                        Class<?>[] classes = JUnit4TestRunnerUtil.getArrayOfClasses(result);
                        if (classes.length == 0) {
                            System.out.println(TestRunnerUtil.testsFoundInPackageMessage(0, suiteName));
                            methodNames = null;
                            return methodNames;
                        }
                        try {
                            Class.forName("org.junit.runner.Computer");
                            allClasses = JUnit46ClassesRequestBuilder.getClassesRequest(suiteName, classes, classMethods, category);
                        }
                        catch (ClassNotFoundException e) {
                            allClasses = JUnit4TestRunnerUtil.getClassRequestsUsing44API(suiteName, classes);
                        }
                        catch (NoSuchMethodError e) {
                            allClasses = JUnit4TestRunnerUtil.getClassRequestsUsing44API(suiteName, classes);
                        }
                        Request request3 = classMethods.isEmpty() ? allClasses : allClasses.filterWith(new Filter(){

                            public boolean shouldRun(Description description) {
                                if (description.isTest()) {
                                    int idx;
                                    RunWith classAnnotation;
                                    Set methods = (Set)classMethods.get(JUnit4ReflectionUtil.getClassName(description));
                                    if (methods == null) {
                                        return true;
                                    }
                                    String methodName = JUnit4ReflectionUtil.getMethodName(description);
                                    if (methods.contains(methodName)) {
                                        return true;
                                    }
                                    if (name != null) {
                                        return methodName.endsWith(name) && methods.contains(methodName.substring(0, methodName.length() - name.length()));
                                    }
                                    Class testClass = description.getTestClass();
                                    if (testClass != null && (classAnnotation = testClass.getAnnotation(RunWith.class)) != null && Parameterized.class.isAssignableFrom(classAnnotation.value()) && (idx = methodName.indexOf("[")) > -1) {
                                        return methods.contains(methodName.substring(0, idx));
                                    }
                                    return false;
                                }
                                return true;
                            }

                            public String describe() {
                                return "Tests";
                            }
                        });
                        return request3;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                    continue;
                }
            }
            int index = suiteClassName.indexOf(44);
            if (index != -1) {
                clazz = JUnit4TestRunnerUtil.loadTestClass(suiteClassName.substring(0, index));
                final String methodName = suiteClassName.substring(index + 1);
                RunWith clazzAnnotation2 = clazz.getAnnotation(RunWith.class);
                Description testMethodDescription = Description.createTestDescription(clazz, (String)methodName);
                if (clazzAnnotation2 == null) {
                    try {
                        Method method = clazz.getMethod(methodName, new Class[0]);
                        if (method != null && notForked && (method.getAnnotation(Ignore.class) != null || clazz.getAnnotation(Ignore.class) != null)) {
                            Request classRequest = JUnit45ClassesRequestBuilder.createIgnoreIgnoredClassRequest(clazz, true);
                            final Filter ignoredTestFilter = Filter.matchMethodDescription((Description)testMethodDescription);
                            return classRequest.filterWith(new Filter(){

                                public boolean shouldRun(Description description) {
                                    return ignoredTestFilter.shouldRun(description);
                                }

                                public String describe() {
                                    return "Ignored " + methodName;
                                }
                            });
                        }
                    }
                    catch (Throwable method) {}
                } else {
                    Request request4 = JUnit4TestRunnerUtil.getParameterizedRequest(name, methodName, clazz, clazzAnnotation2);
                    if (request4 != null) {
                        return request4;
                    }
                }
                try {
                    if (clazz.getMethod("suite", new Class[0]) != null && !methodName.equals("suite")) {
                        return Request.classWithoutSuiteMethod(clazz).filterWith(testMethodDescription);
                    }
                }
                catch (Throwable request4) {
                    // empty catch block
                }
                try {
                    final Filter methodFilter = Filter.matchMethodDescription((Description)testMethodDescription);
                    return Request.aClass(clazz).filterWith(new Filter(){

                        public boolean shouldRun(Description description) {
                            if (description.isTest() && description.getDisplayName().startsWith("warning(junit.framework.TestSuite$")) {
                                return true;
                            }
                            return methodFilter.shouldRun(description);
                        }

                        public String describe() {
                            return methodFilter.describe();
                        }
                    });
                }
                catch (NoSuchMethodError e) {
                    return Request.method(clazz, (String)methodName);
                }
            }
            if (name != null && suiteClassNames.length == 1 && (clazz = JUnit4TestRunnerUtil.loadTestClass(suiteClassName)) != null && (request = JUnit4TestRunnerUtil.getParameterizedRequest(name, null, clazz, clazzAnnotation = clazz.getAnnotation(RunWith.class))) != null) {
                return request;
            }
            JUnit4TestRunnerUtil.appendTestClass(result, suiteClassName);
        }
        if (result.size() != 1) return Request.classes((Class[])JUnit4TestRunnerUtil.getArrayOfClasses(result));
        Class<?> clazz = result.get(0);
        try {
            if (clazz.getAnnotation(Ignore.class) == null) return Request.aClass(clazz);
            return JUnit45ClassesRequestBuilder.createIgnoreIgnoredClassRequest(clazz, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Request.aClass(clazz);
    }

    private static Request getParameterizedRequest(final String parameterString, final String methodName, Class<?> clazz, RunWith clazzAnnotation) {
        if (clazzAnnotation == null) {
            return null;
        }
        Class runnerClass = clazzAnnotation.value();
        if (Parameterized.class.isAssignableFrom(runnerClass)) {
            try {
                Method method;
                if (methodName != null && (method = clazz.getMethod(methodName, new Class[0])) != null && !method.isAnnotationPresent(Test.class) && TestCase.class.isAssignableFrom(clazz)) {
                    return Request.runner((Runner)JUnit45ClassesRequestBuilder.createIgnoreAnnotationAndJUnit4ClassRunner(clazz));
                }
                Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
                Constructor runnerConstructor = runnerClass.getConstructor(Class.class);
                return Request.runner((Runner)((Runner)runnerConstructor.newInstance(clazz))).filterWith(new Filter(){

                    public boolean shouldRun(Description description) {
                        String descriptionMethodName = description.getMethodName();
                        if (parameterString != null && descriptionMethodName != null && !descriptionMethodName.endsWith(parameterString)) {
                            return false;
                        }
                        return methodName == null || descriptionMethodName == null || descriptionMethodName.startsWith(methodName + "[") || descriptionMethodName.equals(methodName);
                    }

                    public String describe() {
                        if (parameterString == null) {
                            return methodName + " with any parameter";
                        }
                        if (methodName == null) {
                            return "Parameter " + parameterString + " for any method";
                        }
                        return methodName + " with parameter " + parameterString;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static Request getClassRequestsUsing44API(String suiteName, Class<?>[] classes) {
        Request allClasses;
        try {
            Class.forName("org.junit.internal.requests.ClassesRequest");
            allClasses = JUnit4ClassesRequestBuilder.getClassesRequest(suiteName, classes);
        }
        catch (ClassNotFoundException e1) {
            allClasses = JUnit45ClassesRequestBuilder.getClassesRequest(suiteName, classes);
        }
        return allClasses;
    }

    private static void appendTestClass(List<Class<?>> result, String className) {
        Class<?> aClass = JUnit4TestRunnerUtil.loadTestClass(className);
        if (!result.contains(aClass)) {
            result.add(aClass);
        }
    }

    private static Class<?>[] getArrayOfClasses(List<Class<?>> result) {
        return result.toArray(new Class[0]);
    }

    private static Class<?> loadTestClass(String suiteClassName) {
        try {
            return Class.forName(suiteClassName, false, JUnit4TestRunnerUtil.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            System.err.print(MessageFormat.format(ResourceBundle.getBundle("messages.RuntimeBundle").getString("junit.class.not.found"), clazz));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format(ResourceBundle.getBundle("messages.RuntimeBundle").getString("junit.cannot.instantiate.tests"), e.toString()));
            System.exit(1);
        }
        return null;
    }
}

