/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.metrics.aggregator.Aggregator;

abstract class AbstractAggregator
implements Aggregator {
    private volatile boolean hasRecordings = false;

    AbstractAggregator() {
    }

    @Override
    public void mergeToAndReset(Aggregator other) {
        if (!this.getClass().isInstance(other)) {
            return;
        }
        this.doMergeAndReset(other);
        this.hasRecordings = false;
    }

    abstract void doMergeAndReset(Aggregator var1);

    @Override
    public final void recordLong(long value) {
        this.doRecordLong(value);
        this.hasRecordings = true;
    }

    protected void doRecordLong(long value) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    @Override
    public final void recordDouble(double value) {
        this.doRecordDouble(value);
        this.hasRecordings = true;
    }

    protected void doRecordDouble(double value) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }

    @Override
    public boolean hasRecordings() {
        return this.hasRecordings;
    }
}

