/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.metrics.view.Aggregations;

class ViewRegistry {
    ViewRegistry() {
    }

    Batcher createBatcher(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor) {
        Aggregation aggregation = ViewRegistry.getRegisteredAggregation(descriptor);
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case SUM_OBSERVER: 
            case UP_DOWN_SUM_OBSERVER: {
                return Batchers.getCumulativeAllLabels(descriptor, meterProviderSharedState, meterSharedState, aggregation);
            }
            case VALUE_RECORDER: 
            case VALUE_OBSERVER: {
                return Batchers.getDeltaAllLabels(descriptor, meterProviderSharedState, meterSharedState, aggregation);
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }

    private static Aggregation getRegisteredAggregation(InstrumentDescriptor descriptor) {
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: {
                return Aggregations.sum();
            }
            case VALUE_RECORDER: {
                return Aggregations.minMaxSumCount();
            }
            case SUM_OBSERVER: 
            case UP_DOWN_SUM_OBSERVER: 
            case VALUE_OBSERVER: {
                return Aggregations.lastValue();
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }
}

