/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.Usage;
import com.intellij.find.usages.api.UsageSearchParameters;
import com.intellij.find.usages.api.UsageSearcher;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol;
import org.jetbrains.plugins.gradle.service.resolve.ProjectReferenceSearchKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectUsageSearcher;", "Lcom/intellij/find/usages/api/UsageSearcher;", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/Usage;", "parameters", "Lcom/intellij/find/usages/api/UsageSearchParameters;", "intellij.gradle.java"})
public final class GradleProjectUsageSearcher
implements UsageSearcher {
    @NotNull
    public Collection<Query<? extends Usage>> collectSearchRequests(@NotNull UsageSearchParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        SearchTarget searchTarget = parameters.getTarget();
        if (!(searchTarget instanceof GradleProjectSymbol)) {
            searchTarget = null;
        }
        GradleProjectSymbol gradleProjectSymbol = (GradleProjectSymbol)searchTarget;
        if (gradleProjectSymbol == null) {
            return CollectionsKt.emptyList();
        }
        GradleProjectSymbol projectSymbol = gradleProjectSymbol;
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.project");
        Function1 function1 = (Function1)new Function1<PsiSymbolReference, PsiUsage>(PsiUsage.Companion){

            @NotNull
            public final PsiUsage invoke(@NotNull PsiSymbolReference p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((PsiUsage.Companion)this.receiver).textUsage(p1);
            }
        };
        Query query2 = ProjectReferenceSearchKt.searchGradleProjectReferences(project, projectSymbol, parameters.getSearchScope()).mapping(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"searchGradleProjectRefer\u2026ping(PsiUsage::textUsage)");
        Query query3 = query2;
        return CollectionsKt.listOf((Object)query3);
    }
}

