/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.refactoring.rename.api.RenameUsageSearchParameters;
import com.intellij.refactoring.rename.api.RenameUsageSearcher;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectRenameUsageSearcher;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol;
import org.jetbrains.plugins.gradle.service.resolve.ProjectReferenceSearchKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectRenameUsageSearcher;", "Lcom/intellij/refactoring/rename/api/RenameUsageSearcher;", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/refactoring/rename/api/RenameUsage;", "parameters", "Lcom/intellij/refactoring/rename/api/RenameUsageSearchParameters;", "intellij.gradle.java"})
public final class GradleProjectRenameUsageSearcher
implements RenameUsageSearcher {
    @NotNull
    public Collection<Query<? extends RenameUsage>> collectSearchRequests(@NotNull RenameUsageSearchParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        RenameTarget renameTarget = parameters.getTarget();
        if (!(renameTarget instanceof GradleProjectSymbol)) {
            renameTarget = null;
        }
        GradleProjectSymbol gradleProjectSymbol = (GradleProjectSymbol)renameTarget;
        if (gradleProjectSymbol == null) {
            return CollectionsKt.emptyList();
        }
        GradleProjectSymbol projectSymbol = gradleProjectSymbol;
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.project");
        Query query2 = ProjectReferenceSearchKt.searchGradleProjectReferences(project, projectSymbol, parameters.getSearchScope()).mapping((Function)collectSearchRequests.query.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"searchGradleProjectRefer\u2026ge.textUsage(it))\n      }");
        Query query3 = query2;
        return CollectionsKt.listOf((Object)query3);
    }
}

