/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.wizard.MavenizedStructureWizardStep;
import com.intellij.openapi.externalSystem.util.ui.DataView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.layout.ValidationInfoBuilder;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.AbstractGradleModuleBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleStructureWizardStep$WhenMappings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleStructureWizardStep;", "Lcom/intellij/openapi/externalSystem/service/project/wizard/MavenizedStructureWizardStep;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "builder", "Lorg/jetbrains/plugins/gradle/service/project/wizard/AbstractGradleModuleBuilder;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "(Lorg/jetbrains/plugins/gradle/service/project/wizard/AbstractGradleModuleBuilder;Lcom/intellij/ide/util/projectWizard/WizardContext;)V", "_init", "", "createView", "Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleStructureWizardStep$GradleDataView;", "data", "findAllParents", "", "getBuilderId", "", "getHelpId", "getModuleFileDirectory", "getModuleFilePath", "updateProjectData", "validateArtifactId", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "validateGroupId", "validateName", "validateNameAndArtifactId", "validateVersion", "GradleDataView", "intellij.gradle.java"})
public final class GradleStructureWizardStep
extends MavenizedStructureWizardStep<ProjectData> {
    private final AbstractGradleModuleBuilder builder;

    @NotNull
    public String getHelpId() {
        return "Gradle_Archetype_Dialog";
    }

    @Nullable
    protected String getBuilderId() {
        return this.builder.getBuilderId();
    }

    @NotNull
    public GradleDataView createView(@NotNull ProjectData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new GradleDataView(data);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ProjectData> findAllParents() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Project project = this.getContext().getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project ?: return emptyList()");
        Project project2 = project;
        Collection collection = ProjectDataManager.getInstance().getExternalProjectsData(project2, GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ProjectDataManager.getIn\u2026radleConstants.SYSTEM_ID)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        DataNode dataNode = $this$forEach$iv$iv$iv.iterator();
        while (dataNode.hasNext()) {
            DataNode dataNode2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = dataNode.next();
            boolean bl = false;
            ExternalProjectInfo it = (ExternalProjectInfo)element$iv$iv;
            boolean bl2 = false;
            ExternalProjectInfo externalProjectInfo = it;
            Intrinsics.checkNotNullExpressionValue((Object)externalProjectInfo, (String)"it");
            if (externalProjectInfo.getExternalProjectStructure() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            DataNode it$iv$iv = dataNode2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            dataNode = (DataNode)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            ProjectData projectData = (ProjectData)v3.getData();
            collection2.add(projectData);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected ValidationInfo validateGroupId(@NotNull ValidationInfoBuilder $this$validateGroupId) {
        Intrinsics.checkNotNullParameter((Object)$this$validateGroupId, (String)"$this$validateGroupId");
        return null;
    }

    @Nullable
    protected ValidationInfo validateVersion(@NotNull ValidationInfoBuilder $this$validateVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$validateVersion, (String)"$this$validateVersion");
        return null;
    }

    @Nullable
    protected ValidationInfo validateName(@NotNull ValidationInfoBuilder $this$validateName) {
        Intrinsics.checkNotNullParameter((Object)$this$validateName, (String)"$this$validateName");
        ValidationInfo validationInfo = this.validateNameAndArtifactId($this$validateName);
        if (validationInfo == null) {
            validationInfo = this.superValidateName($this$validateName);
        }
        return validationInfo;
    }

    @Nullable
    protected ValidationInfo validateArtifactId(@NotNull ValidationInfoBuilder $this$validateArtifactId) {
        Intrinsics.checkNotNullParameter((Object)$this$validateArtifactId, (String)"$this$validateArtifactId");
        ValidationInfo validationInfo = this.validateNameAndArtifactId($this$validateArtifactId);
        if (validationInfo == null) {
            validationInfo = this.superValidateArtifactId($this$validateArtifactId);
        }
        return validationInfo;
    }

    private final ValidationInfo validateNameAndArtifactId(ValidationInfoBuilder $this$validateNameAndArtifactId) {
        if (Intrinsics.areEqual((Object)this.getArtifactId(), (Object)this.getEntityName())) {
            return null;
        }
        String string = this.getContext().getPresentationName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.presentationName");
        String presentationName = StringsKt.capitalize((String)string);
        String string2 = GradleBundle.message((String)"gradle.structure.wizard.name.and.artifact.id.is.different.error", (Object[])new Object[]{presentationName});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GradleBundle.message(\"gr\u2026error\", presentationName)");
        return $this$validateNameAndArtifactId.error(string2);
    }

    public void updateProjectData() {
        this.getContext().setProjectBuilder((ProjectBuilder)this.builder);
        this.builder.setParentProject((ProjectData)this.getParentData());
        this.builder.setProjectId(new ProjectId(this.getGroupId(), this.getArtifactId(), this.getVersion()));
        ProjectData projectData = (ProjectData)this.getParentData();
        this.builder.setInheritGroupId(Intrinsics.areEqual((Object)(projectData != null ? projectData.getGroup() : null), (Object)this.getGroupId()));
        ProjectData projectData2 = (ProjectData)this.getParentData();
        this.builder.setInheritVersion(Intrinsics.areEqual((Object)(projectData2 != null ? projectData2.getVersion() : null), (Object)this.getVersion()));
        this.builder.setName(this.getEntityName());
        this.builder.setContentEntryPath(this.getLocation());
        this.builder.setModuleFilePath(this.getModuleFilePath());
        this.builder.setCreatingNewProject(this.getContext().isCreatingNewProject());
        Sdk sdk = this.builder.getModuleJdk();
        if (sdk == null) {
            sdk = AbstractProjectWizard.getNewProjectJdk((WizardContext)this.getContext());
        }
        this.builder.setModuleJdk(sdk);
    }

    private final String getModuleFilePath() {
        String moduleFileDirectory = this.getModuleFileDirectory();
        String string = FileUtil.join((String[])new String[]{moduleFileDirectory, this.getArtifactId() + ".iml"});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.join(moduleFile\u2026pe.DOT_DEFAULT_EXTENSION)");
        String moduleFilePath = string;
        String string2 = FileUtil.toCanonicalPath((String)moduleFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.toCanonicalPath(moduleFilePath)");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getModuleFileDirectory() {
        Object object;
        Object object2 = this.getContext().getProject();
        if (object2 == null || (object2 = object2.getBasePath()) == null) {
            object2 = this.getLocation();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.project?.basePath ?: location");
        Object object3 = object2;
        StorageScheme storageScheme = this.getContext().getProjectStorageFormat();
        if (storageScheme != null) {
            switch (GradleStructureWizardStep$WhenMappings.$EnumSwitchMapping$0[storageScheme.ordinal()]) {
                case 1: {
                    object = this.getLocation();
                    return object;
                }
                case 2: {
                    String string = FileUtil.join((String[])new String[]{object3, ".idea", "modules"});
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.join(projectPat\u2026_STORE_FOLDER, \"modules\")");
                    return object;
                }
            }
        }
        object = object3;
        return object;
    }

    public void _init() {
        block4: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            boolean bl3;
            boolean bl4;
            String string2;
            String string3 = this.builder.getName();
            if (string3 != null) {
                string2 = string3;
                bl4 = false;
                bl3 = false;
                String it2 = string2;
                boolean bl5 = false;
                this.setEntityName(it2);
            }
            ProjectId projectId = this.builder.getProjectId();
            if (projectId == null) break block4;
            string2 = projectId;
            bl4 = false;
            bl3 = false;
            String projectId2 = string2;
            boolean bl6 = false;
            String string4 = projectId2.getGroupId();
            if (string4 != null) {
                string = string4;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl7 = false;
                String string5 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it");
                this.setGroupId(string5);
            }
            String string6 = projectId2.getArtifactId();
            if (string6 != null) {
                string = string6;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl8 = false;
                String string7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it");
                this.setArtifactId(string7);
            }
            String string8 = projectId2.getVersion();
            if (string8 != null) {
                string = string8;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl9 = false;
                String string9 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"it");
                this.setVersion(string9);
            }
        }
    }

    public GradleStructureWizardStep(@NotNull AbstractGradleModuleBuilder builder, @NotNull WizardContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.builder = builder;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/wizard/GradleStructureWizardStep$GradleDataView;", "Lcom/intellij/openapi/externalSystem/util/ui/DataView;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "data", "(Lcom/intellij/openapi/externalSystem/model/project/ProjectData;)V", "getData", "()Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "groupId", "", "getGroupId", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "location", "getLocation", "presentationName", "getPresentationName", "version", "getVersion", "intellij.gradle.java"})
    public static final class GradleDataView
    extends DataView<ProjectData> {
        @NotNull
        private final String location;
        @NotNull
        private final Icon icon;
        @NotNull
        private final String presentationName;
        @NotNull
        private final String groupId;
        @NotNull
        private final String version;
        @NotNull
        private final ProjectData data;

        @NotNull
        public String getLocation() {
            return this.location;
        }

        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public String getPresentationName() {
            return this.presentationName;
        }

        @NotNull
        public String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public String getVersion() {
            return this.version;
        }

        @NotNull
        public ProjectData getData() {
            return this.data;
        }

        public GradleDataView(@NotNull ProjectData data) {
            String string;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
            String string2 = this.getData().getLinkedExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data.linkedExternalProjectPath");
            this.location = string2;
            Icon icon = GradleIcons.GradleFile;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GradleIcons.GradleFile");
            this.icon = icon;
            String string3 = this.getData().getExternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"data.externalName");
            this.presentationName = string3;
            String string4 = this.getData().getGroup();
            if (string4 == null) {
                string4 = this.groupId = "";
            }
            if ((string = this.getData().getVersion()) == null) {
                string = "";
            }
            this.version = string;
        }
    }
}

