/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeTestEvent
extends AbstractTestEvent {
    public BeforeTestEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            BeforeTestEvent.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String name = eventXml.getTestName();
        String fqClassName = eventXml.getTestClassName();
        this.doProcess(testId, parentTestId, name, fqClassName);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            BeforeTestEvent.$$$reportNull$$$0(1);
        }
        TestOperationDescriptor testDescriptor = (TestOperationDescriptor)testEvent.getDescriptor();
        String testId = testEvent.getEventId();
        String parentTestId = testEvent.getParentEventId();
        String name = (String)ObjectUtils.coalesce((Object)testDescriptor.getDisplayName(), (Object)testDescriptor.getMethodName(), (Object)testId);
        String fqClassName = testDescriptor.getClassName();
        this.doProcess(testId, parentTestId, name, fqClassName);
    }

    private void doProcess(String testId, String parentTestId, String name, String fqClassName) {
        String locationUrl = this.findLocationUrl(name, fqClassName);
        GradleSMTestProxy testProxy = new GradleSMTestProxy(name, false, locationUrl, fqClassName);
        testProxy.setStarted();
        testProxy.setLocator(this.getExecutionConsole().getUrlProvider());
        this.registerTestProxy(testId, testProxy);
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.getResultsViewer().getTestsRootNode().addChild((SMTestProxy)testProxy);
        } else {
            SMTestProxy parentTestProxy = this.findTestProxy(parentTestId);
            if (parentTestProxy != null) {
                SmartList notYetAddedParents = new SmartList();
                SMTestProxy currentParentTestProxy = parentTestProxy;
                while (currentParentTestProxy instanceof GradleSMTestProxy) {
                    String parentId = ((GradleSMTestProxy)currentParentTestProxy).getParentId();
                    if (currentParentTestProxy.getParent() == null && parentId != null) {
                        notYetAddedParents.add((GradleSMTestProxy)currentParentTestProxy);
                    }
                    currentParentTestProxy = this.findTestProxy(parentId);
                }
                for (GradleSMTestProxy gradleSMTestProxy : ContainerUtil.reverse((List)notYetAddedParents)) {
                    SMTestProxy parentTestProxy1 = this.findTestProxy(gradleSMTestProxy.getParentId());
                    if (parentTestProxy1 == null) continue;
                    parentTestProxy1.addChild((SMTestProxy)gradleSMTestProxy);
                    this.getResultsViewer().onSuiteStarted((SMTestProxy)gradleSMTestProxy);
                    this.getExecutionConsole().getEventPublisher().onSuiteStarted((SMTestProxy)gradleSMTestProxy);
                }
                parentTestProxy.addChild((SMTestProxy)testProxy);
            }
        }
        this.getResultsViewer().onTestStarted((SMTestProxy)testProxy);
        this.getExecutionConsole().getEventPublisher().onTestStarted((SMTestProxy)testProxy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "eventXml";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "testEvent";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/BeforeTestEvent";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

