/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestTasksProvider;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public abstract class GradleTestRunConfigurationProducer
extends RunConfigurationProducer<ExternalSystemRunConfiguration> {
    protected static final Logger LOG = Logger.getInstance(GradleTestRunConfigurationProducer.class);
    private TestTasksChooser testTasksChooser = new TestTasksChooser();

    protected GradleTestRunConfigurationProducer() {
        super(true);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner(self.getSourceElement());
        return testRunner == TestRunner.CHOOSE_PER_TEST || testRunner == TestRunner.GRADLE;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (other == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return GradleTestRunConfigurationProducer.getTestRunner(self.getSourceElement()) == TestRunner.GRADLE;
    }

    protected boolean setupConfigurationFromContext(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        if (sourceElement.isNull()) {
            return false;
        }
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner((PsiElement)sourceElement.get());
        if (testRunner == TestRunner.PLATFORM) {
            return false;
        }
        if (configuration instanceof GradleRunConfiguration) {
            GradleRunConfiguration gradleRunConfiguration = (GradleRunConfiguration)configuration;
            gradleRunConfiguration.setScriptDebugEnabled(false);
        }
        boolean result = this.doSetupConfigurationFromContext(configuration, context, sourceElement);
        this.restoreDefaultScriptParametersIfNeeded((RunConfiguration)configuration, context);
        return result;
    }

    protected Runnable addCheckForTemplateParams(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (startRunnable == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        return () -> {
            this.restoreDefaultScriptParametersIfNeeded(configuration.getConfiguration(), context);
            startRunnable.run();
        };
    }

    protected void restoreDefaultScriptParametersIfNeeded(@NotNull RunConfiguration configuration, @NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings template;
        RunConfiguration original;
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if ((original = (template = context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory())).getConfiguration()) instanceof ExternalSystemRunConfiguration && configuration instanceof ExternalSystemRunConfiguration) {
            ExternalSystemRunConfiguration originalRC = (ExternalSystemRunConfiguration)original;
            ExternalSystemRunConfiguration configurationRC = (ExternalSystemRunConfiguration)configuration;
            String currentParams = configurationRC.getSettings().getScriptParameters();
            String defaultParams = originalRC.getSettings().getScriptParameters();
            if (!StringUtil.isEmptyOrSpaces((String)defaultParams)) {
                if (!StringUtil.isEmptyOrSpaces((String)currentParams)) {
                    configurationRC.getSettings().setScriptParameters(currentParams + " " + defaultParams);
                } else {
                    configurationRC.getSettings().setScriptParameters(defaultParams);
                }
            }
        }
    }

    protected abstract boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public boolean isConfigurationFromContext(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (!GradleConstants.SYSTEM_ID.equals((Object)configuration.getSettings().getExternalSystemId())) {
            return false;
        }
        String projectPath = configuration.getSettings().getExternalProjectPath();
        TestRunner testRunner = GradleTestRunConfigurationProducer.getTestRunner(context.getProject(), projectPath);
        if (testRunner == TestRunner.PLATFORM) {
            return false;
        }
        return this.doIsConfigurationFromContext(configuration, context);
    }

    protected abstract boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration var1, ConfigurationContext var2);

    @Nullable
    protected String resolveProjectPath(@NotNull Module module) {
        GradleModuleData gradleModuleData;
        if (module == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if ((gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module)) == null) {
            return null;
        }
        boolean isGradleProjectDirUsedToRunTasks = gradleModuleData.getDirectoryToRunTask().equals(gradleModuleData.getGradleProjectDir());
        if (!isGradleProjectDirUsedToRunTasks) {
            return gradleModuleData.getDirectoryToRunTask();
        }
        return GradleRunnerUtil.resolveProjectPath(module);
    }

    protected TestTasksChooser getTestTasksChooser() {
        return this.testTasksChooser;
    }

    @TestOnly
    public void setTestTasksChooser(TestTasksChooser testTasksChooser) {
        this.testTasksChooser = testTasksChooser;
    }

    public static boolean hasTasksInConfiguration(VirtualFile source, Project project, ExternalSystemTaskExecutionSettings settings) {
        List<TasksToRun> tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
        List escapedTasks = ContainerUtil.map(tasksToRun, tasks -> ContainerUtil.map((Collection)tasks, it -> TestGradleConfigurationProducerUtilKt.escapeIfNeeded(it)));
        List taskNames = settings.getTaskNames();
        if (escapedTasks.stream().anyMatch(taskNames::containsAll)) {
            return true;
        }
        String scriptParameters = settings.getScriptParameters();
        if (StringUtil.isEmpty((String)scriptParameters)) {
            return false;
        }
        List escapedJoinedTasks = ContainerUtil.map((Collection)escapedTasks, it -> StringUtil.join((Collection)it, (String)" "));
        return escapedJoinedTasks.stream().anyMatch(scriptParameters::contains);
    }

    @NotNull
    public static TasksToRun findTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        List<TasksToRun> tasksToRun;
        if (source == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if ((tasksToRun = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project)).isEmpty()) {
            TasksToRun.Empty empty = TasksToRun.EMPTY;
            if (empty == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(15);
            }
            return empty;
        }
        TasksToRun tasksToRun2 = tasksToRun.get(0);
        if (tasksToRun2 == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        return tasksToRun2;
    }

    @NotNull
    public static List<TasksToRun> findAllTestsTaskToRun(@NotNull VirtualFile source, @NotNull Project project) {
        if (source == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(17);
        }
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(18);
        }
        String sourcePath = source.getPath();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(source);
        if (module == null) {
            List<TasksToRun> list = Collections.emptyList();
            if (list == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(19);
            }
            return list;
        }
        ArrayList<TasksToRun> testTasks = new ArrayList<TasksToRun>();
        for (GradleTestTasksProvider provider : (GradleTestTasksProvider[])GradleTestTasksProvider.EP_NAME.getExtensions()) {
            List<String> tasks = provider.getTasks(module, source);
            if (ContainerUtil.isEmpty(tasks)) continue;
            String testName = StringUtil.join(tasks, (String)" ");
            testTasks.add(new TasksToRun.Impl(testName, tasks));
        }
        GradleModuleData gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
        if (gradleModuleData == null) {
            ArrayList<TasksToRun> arrayList = testTasks;
            if (arrayList == null) {
                GradleTestRunConfigurationProducer.$$$reportNull$$$0(20);
            }
            return arrayList;
        }
        for (TestData testData : gradleModuleData.findAll(ProjectKeys.TEST)) {
            Set sourceFolders = testData.getSourceFolders();
            for (String sourceFolder : sourceFolders) {
                if (!FileUtil.isAncestor((String)sourceFolder, (String)sourcePath, (boolean)false)) continue;
                String testTaskSimpleName = testData.getTestName();
                SmartList tasks = new SmartList((Object)gradleModuleData.getTaskPath(testTaskSimpleName, true));
                testTasks.add(new TasksToRun.Impl(testTaskSimpleName, (List<String>)tasks));
            }
        }
        ArrayList<TasksToRun> arrayList = testTasks;
        if (arrayList == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static TestRunner getTestRunner(@NotNull Project project, @NotNull String projectPath) {
        if (project == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(22);
        }
        if (projectPath == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(23);
        }
        return GradleProjectSettings.getTestRunner((Project)project, (String)projectPath);
    }

    private static TestRunner getTestRunner(@NotNull PsiElement sourceElement) {
        Module module;
        if (sourceElement == null) {
            GradleTestRunConfigurationProducer.$$$reportNull$$$0(24);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourceElement)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Cannot find module for %s", sourceElement.toString()), new Throwable());
            }
            return TestRunner.PLATFORM;
        }
        return GradleProjectSettings.getTestRunner((Module)module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestRunConfigurationProducer";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsTaskToRun";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTestsTaskToRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCheckForTemplateParams";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreDefaultScriptParametersIfNeeded";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTestsTaskToRun";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAllTestsTaskToRun";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTestRunner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

