/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/JCenterRepositoryInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "MyVisitor", "intellij.gradle.java"})
public final class JCenterRepositoryInspection
extends GradleBaseInspection {
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/JCenterRepositoryInspection$MyVisitor;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "()V", "visitLiteralExpression", "", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "visitMethodCall", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "intellij.gradle.java"})
    public static final class MyVisitor
    extends BaseInspectionVisitor {
        public void visitLiteralExpression(@NotNull GrLiteral literal) {
            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
            PsiFile psiFile = literal.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"literal.containingFile");
            PsiFile file = psiFile;
            if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                return;
            }
            super.visitLiteralExpression(literal);
            if (!(literal instanceof GrLiteralImpl) || !((GrLiteralImpl)literal).isStringLiteral()) {
                return;
            }
            Object object = ((GrLiteralImpl)literal).getValue();
            if (object == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"literal.value ?: return");
            Object value = object;
            if (Intrinsics.areEqual((Object)"https://jcenter.bintray.com", (Object)value) || StringsKt.startsWith$default((String)value.toString(), (String)"https://dl.bintray.com/", (boolean)false, (int)2, null)) {
                PsiElement $this$parentOfType$iv = (PsiElement)literal;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrClosableBlock.class, (boolean)true);
                if (grClosableBlock == null) {
                    return;
                }
                GrClosableBlock closure = grClosableBlock;
                DelegatesToInfo delegatesToInfo = GrDelegatesToUtilKt.getDelegatesToInfo((GrFunctionalExpression)((GrFunctionalExpression)closure));
                if (delegatesToInfo == null || (delegatesToInfo = delegatesToInfo.getTypeToDelegate()) == null) {
                    return;
                }
                DelegatesToInfo typeToDelegate = delegatesToInfo;
                if (Intrinsics.areEqual((Object)typeToDelegate.getCanonicalText(), (Object)"org.gradle.api.artifacts.repositories.MavenArtifactRepository")) {
                    this.registerError((PsiElement)literal, GradleInspectionBundle.message("jcenter.repository", new Object[0]), new LocalQuickFix[0], ProblemHighlightType.WARNING);
                }
            }
        }

        public void visitMethodCall(@NotNull GrMethodCall call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            PsiFile psiFile = call.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"call.containingFile");
            PsiFile file = psiFile;
            if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                return;
            }
            super.visitMethodCall(call);
            GroovyMethodCallReference groovyMethodCallReference = call.getCallReference();
            if (Intrinsics.areEqual((Object)"jcenter", (Object)(groovyMethodCallReference != null ? groovyMethodCallReference.getMethodName() : null)) ^ true) {
                return;
            }
            PsiElement $this$parentOfType$iv = (PsiElement)call;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrClosableBlock.class, (boolean)true);
            if (grClosableBlock == null) {
                return;
            }
            GrClosableBlock closure = grClosableBlock;
            DelegatesToInfo delegatesToInfo = GrDelegatesToUtilKt.getDelegatesToInfo((GrFunctionalExpression)((GrFunctionalExpression)closure));
            if (delegatesToInfo == null || (delegatesToInfo = delegatesToInfo.getTypeToDelegate()) == null) {
                return;
            }
            DelegatesToInfo typeToDelegate = delegatesToInfo;
            if (Intrinsics.areEqual((Object)typeToDelegate.getCanonicalText(), (Object)"org.gradle.api.artifacts.dsl.RepositoryHandler")) {
                this.registerError((PsiElement)call, GradleInspectionBundle.message("jcenter.repository", new Object[0]), new LocalQuickFix[0], ProblemHighlightType.WARNING);
            }
        }
    }
}

