/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.springSecurity;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class ThymeleafSpringSecurityContextVariableProvider
extends ThymeleafContextVariablesProvider {
    private static final Map<String, String> myImplicitSecurityVariablesMap = new HashMap<String, String>();

    ThymeleafSpringSecurityContextVariableProvider() {
    }

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(0);
        }
        HashSet<ThymeleafVariable> variables = new HashSet<ThymeleafVariable>();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)contextElement.getProject());
        if (module != null) {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PsiClass psiClass = psiFacade.findClass("org.springframework.security.core.Authentication", scope);
            if (psiClass != null) {
                Map properties = PropertyUtilBase.getAllProperties((PsiClass)psiClass, (boolean)false, (boolean)true);
                for (Map.Entry entry : properties.entrySet()) {
                    PsiClass userDetailsClass;
                    PsiMethod method = (PsiMethod)entry.getValue();
                    PsiType propertyType = PropertyUtilBase.getPropertyType((PsiMember)method);
                    if (propertyType == null) continue;
                    String name = (String)entry.getKey();
                    if (name.equals("principal") && (userDetailsClass = psiFacade.findClass("org.springframework.security.core.userdetails.UserDetails", scope)) != null) {
                        propertyType = PsiTypesUtil.getClassType((PsiClass)userDetailsClass);
                    }
                    variables.add(new ThymeleafVariable(name, propertyType, (PsiElement)method));
                }
            }
            for (Map.Entry<String, String> entry : myImplicitSecurityVariablesMap.entrySet()) {
                PsiClass aClass = psiFacade.findClass(entry.getValue(), scope);
                if (aClass == null) continue;
                variables.add(new ThymeleafVariable(entry.getKey(), (PsiType)PsiTypesUtil.getClassType((PsiClass)aClass), (PsiElement)aClass));
            }
        }
        HashSet<ThymeleafVariable> hashSet = variables;
        if (hashSet == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    public Collection<PsiMethod> getContextMethods(@NotNull PsiElement contextElement) {
        Module module;
        if (contextElement == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(2);
        }
        if (ThymeleafSpringSecurityContextVariableProvider.isSpringSecurityDialect(contextElement) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement)) != null) {
            return SecurityExpressionRootMethodsUtil.getExpressionRootMethods((Module)module, (String)"org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
        }
        return super.getContextMethods(contextElement);
    }

    private static boolean isSpringSecurityDialect(PsiElement contextElement) {
        XmlAttribute contextAttribute = ThymeleafCommonUtil.getContextAttribute(contextElement);
        if (contextAttribute != null) {
            String ns = contextAttribute.getNamespace();
            for (String sec_ns : ThymeleafSpringSecurityContextVariableProvider.collectUris()) {
                if (!sec_ns.equals(ns)) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] collectUris() {
        return ArrayUtil.mergeArrays((String[])ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_3_URIS, (String[])ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_4_URIS);
    }

    static {
        myImplicitSecurityVariablesMap.put("_csrf", "org.springframework.security.web.csrf.CsrfToken");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/springSecurity/ThymeleafSpringSecurityContextVariableProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/springSecurity/ThymeleafSpringSecurityContextVariableProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContextMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

