/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.thymeleaf.highlighting.fixes.DeclareThymeleafVarInCommentFix;
import com.intellij.thymeleaf.lang.psi.ThymesELSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlExpression;
import com.intellij.thymeleaf.lang.psi.ThymesVisitor;
import com.intellij.thymeleaf.resources.ThymeleafBundle;
import org.jetbrains.annotations.NotNull;

public class ThymeleafVariablesResolveInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ThymeleafVariablesResolveInspection.$$$reportNull$$$0(0);
        }
        return new ThymesVisitor(){

            @Override
            public void visitELVariable(@NotNull ThymesELVariable variable) {
                PsiReference reference;
                if (variable == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((reference = variable.getReference()) == null || reference.isSoft()) {
                    return;
                }
                PsiElement results = reference.resolve();
                if (results == null) {
                    holder.registerProblem((PsiElement)variable, ThymeleafBundle.message("ThymeleafVariablesResolveInspection.cannot.resolve.variable", variable.getText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.getFixes(variable));
                }
            }

            public LocalQuickFix[] getFixes(ThymesELVariable variable) {
                PsiElement parent = variable.getParent();
                if (parent instanceof ThymesELSelectExpression || parent instanceof ThymesOgnlExpression) {
                    return new LocalQuickFix[]{new DeclareThymeleafVarInCommentFix(variable.getText())};
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection$1", "visitELVariable"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/thymeleaf/highlighting/ThymeleafVariablesResolveInspection", "buildVisitor"));
    }
}

