/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DescriptionInspectionGotoRelatedProvider
extends GotoRelatedProvider {
    @NonNls
    private static final String INSPECTION_CLASS_NAME_SUFFIX = "Inspection";

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        PsiFile descriptionFile;
        if (context == null) {
            DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((descriptionFile = (PsiFile)context.getData(CommonDataKeys.PSI_FILE)) == null || descriptionFile.getFileType() != HtmlFileType.INSTANCE) {
            List list = Collections.emptyList();
            if (list == null) {
                DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Module module = (Module)context.getData(LangDataKeys.MODULE);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = module.getProject();
        if (!PsiUtil.isPluginProject(project)) {
            List list = Collections.emptyList();
            if (list == null) {
                DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        VirtualFile virtualFile = descriptionFile.getVirtualFile();
        if (virtualFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        VirtualFile folder = virtualFile.getParent();
        if (folder == null || !folder.getName().equals(DescriptionType.INSPECTION.getDescriptionFolder())) {
            List list = Collections.emptyList();
            if (list == null) {
                DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(InspectionProfileEntry.class.getCanonicalName(), GlobalSearchScope.allScope((Project)project));
        if (baseClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)project);
        Object possibleImplementationName = FileUtilRt.getNameWithoutExtension((String)descriptionFile.getName());
        if (!StringUtil.endsWith((CharSequence)possibleImplementationName, (CharSequence)INSPECTION_CLASS_NAME_SUFFIX)) {
            possibleImplementationName = (String)possibleImplementationName + INSPECTION_CLASS_NAME_SUFFIX;
        }
        HashSet<PsiClass> checkedPossibleImplementation = new HashSet<PsiClass>();
        for (GlobalSearchScope scope : DescriptionCheckerUtil.searchScopes(module)) {
            PsiClass[] possibleImplementations;
            for (PsiClass possibleImplementation : possibleImplementations = psiShortNamesCache.getClassesByName((String)possibleImplementationName, scope)) {
                if (DescriptionInspectionGotoRelatedProvider.isTargetInspectionPsiClass(possibleImplementation, descriptionFile, module)) {
                    List<GotoRelatedItem> list = DescriptionInspectionGotoRelatedProvider.createGotoRelatedItem(possibleImplementation);
                    if (list == null) {
                        DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(7);
                    }
                    return list;
                }
                checkedPossibleImplementation.add(possibleImplementation);
            }
        }
        for (GlobalSearchScope scope : DescriptionCheckerUtil.searchScopes(module)) {
            Query query = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            Ref resultItems = new Ref();
            query.forEach(psiClass -> {
                if (checkedPossibleImplementation.contains(psiClass)) {
                    return true;
                }
                if (!PsiUtil.isInstantiable(psiClass)) {
                    return true;
                }
                if (DescriptionInspectionGotoRelatedProvider.isTargetInspectionPsiClass(psiClass, descriptionFile, module)) {
                    resultItems.set(DescriptionInspectionGotoRelatedProvider.createGotoRelatedItem(psiClass));
                    return false;
                }
                return true;
            });
            if (resultItems.isNull()) continue;
            List list = (List)resultItems.get();
            if (list == null) {
                DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            DescriptionInspectionGotoRelatedProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isTargetInspectionPsiClass(PsiClass psiClass, PsiFile descriptionPsiFile, Module module) {
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        return descriptionPsiFile.equals(info.getDescriptionFile());
    }

    private static List<GotoRelatedItem> createGotoRelatedItem(PsiClass psiClass) {
        return GotoRelatedItem.createItems(Collections.singleton(psiClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/navigation/DescriptionInspectionGotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/navigation/DescriptionInspectionGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

