/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "AddDescriptionKeyIntention", "Companion", "ShowEPDeclarationIntention", "intellij.devkit"})
public final class RegistryPropertiesAnnotator
implements Annotator {
    @NonNls
    private static final Set<String> PLUGIN_GROUP_NAMES;
    @NonNls
    private static final String REGISTRY_PROPERTIES_FILENAME = "registry.properties";
    @NonNls
    @NotNull
    public static final String DESCRIPTION_SUFFIX = ".description";
    @NonNls
    @NotNull
    public static final String RESTART_REQUIRED_SUFFIX = ".restartRequired";
    @NotNull
    public static final Companion Companion;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof PropertyKeyImpl)) {
            return;
        }
        AnnotationSession annotationSession = holder.getCurrentAnnotationSession();
        Intrinsics.checkNotNullExpressionValue((Object)annotationSession, (String)"holder.currentAnnotationSession");
        PsiFile psiFile = annotationSession.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.currentAnnotationSession.file");
        PsiFile file = psiFile;
        if (!Companion.isRegistryPropertiesFile(file)) {
            return;
        }
        String string = ((PropertyKeyImpl)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        String propertyName = string;
        if (Companion.isImplicitUsageKey(propertyName)) {
            return;
        }
        String string2 = StringsKt.substringBefore$default((String)propertyName, (char)'.', null, (int)2, null);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String groupName = string4;
        if (PLUGIN_GROUP_NAMES.contains(groupName) || StringsKt.startsWith$default((String)propertyName, (String)"editor.config.", (boolean)false, (int)2, null)) {
            holder.newAnnotation(HighlightSeverity.ERROR, DevKitBundle.message("registry.properties.annotator.plugin.keys.use.ep", new Object[0])).withFix((IntentionAction)new ShowEPDeclarationIntention(propertyName)).create();
        }
        PsiFile psiFile2 = file;
        if (psiFile2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
        }
        PropertiesFile propertiesFile = (PropertiesFile)psiFile2;
        IProperty descriptionProperty = propertiesFile.findPropertyByKey(propertyName + DESCRIPTION_SUFFIX);
        if (descriptionProperty == null) {
            holder.newAnnotation(HighlightSeverity.WARNING, DevKitBundle.message("registry.properties.annotator.key.no.description.key", propertyName)).withFix((IntentionAction)new AddDescriptionKeyIntention(propertyName)).create();
        }
    }

    static {
        Companion = new Companion(null);
        PLUGIN_GROUP_NAMES = SetsKt.setOf((Object[])new String[]{"appcode", "cidr", "clion", "cvs", "git", "github", "svn", "hg4idea", "tfs", "dart", "markdown", "java", "javac", "uast", "junit4", "dsm", "js", "javascript", "typescript", "nodejs", "eslint", "jest", "ruby", "rubymine", "groovy", "grails", "python", "php", "kotlin"});
    }

    @JvmStatic
    public static final boolean isImplicitUsageKey(@NotNull String keyName) {
        return Companion.isImplicitUsageKey(keyName);
    }

    @JvmStatic
    public static final boolean isRegistryPropertiesFile(@NotNull PsiFile psiFile) {
        return Companion.isRegistryPropertiesFile(psiFile);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$ShowEPDeclarationIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "propertyName", "", "(Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.devkit"})
    private static final class ShowEPDeclarationIntention
    implements IntentionAction {
        private final String propertyName;

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("registry.properties.annotator.show.ep.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"re\u2026tor.show.ep.family.name\")");
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return true;
        }

        @NotNull
        public String getText() {
            String string = DevKitBundle.message("registry.properties.annotator.show.ep.name", this.propertyName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"re\u2026w.ep.name\", propertyName)");
            return string;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiFile psiFile = file;
            if (psiFile == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
            }
            PropertiesFile propertiesFile = (PropertiesFile)psiFile;
            IProperty iProperty = propertiesFile.findPropertyByKey(this.propertyName);
            Intrinsics.checkNotNull((Object)iProperty);
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"propertiesFile.findPropertyByKey(propertyName)!!");
            String defaultValue = iProperty.getValue();
            IProperty iProperty2 = propertiesFile.findPropertyByKey(this.propertyName + RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX);
            String description2 = iProperty2 != null ? iProperty2.getValue() : null;
            String restartRequiredText = "";
            if (propertiesFile.findPropertyByKey(this.propertyName + RegistryPropertiesAnnotator.RESTART_REQUIRED_SUFFIX) != null) {
                restartRequiredText = "restartRequired=\"true\"";
            }
            String epText = StringsKt.trimIndent((String)("\n        <registryKey key=\"" + this.propertyName + "\" defaultValue=\"" + defaultValue + "\" " + restartRequiredText + "\n                     description=\"" + description2 + "\"/>\n      "));
            Messages.showMultilineInputDialog((Project)project, (String)DevKitBundle.message("registry.properties.annotator.show.ep.message", new Object[0]), (String)DevKitBundle.message("registry.properties.annotator.show.ep.title", new Object[0]), (String)epText, null, null);
        }

        public ShowEPDeclarationIntention(@NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            this.propertyName = propertyName;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$AddDescriptionKeyIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "myPropertyName", "", "(Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.devkit"})
    private static final class AddDescriptionKeyIntention
    implements IntentionAction {
        private final String myPropertyName;

        @Nls
        @NotNull
        public String getText() {
            String string = DevKitBundle.message("registry.properties.annotator.add.description.text", this.myPropertyName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"re\u2026on.text\", myPropertyName)");
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("registry.properties.annotator.add.description.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"re\u2026description.family.name\")");
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PropertiesFile propertiesFile = (PropertiesFile)file;
            PropertyImpl originalProperty = (PropertyImpl)propertiesFile.findPropertyByKey(this.myPropertyName);
            IProperty iProperty = propertiesFile.addPropertyAfter(this.myPropertyName + RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX, "Description", (IProperty)originalProperty);
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"propertiesFile.addProper\u2026ption\", originalProperty)");
            IProperty descriptionProperty = iProperty;
            PsiElement psiElement = descriptionProperty.getPsiElement();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.lang.properties.psi.impl.PropertyImpl");
            }
            ASTNode aSTNode = ((PropertyImpl)psiElement).getValueNode();
            Intrinsics.checkNotNull((Object)aSTNode);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"(descriptionProperty.psi\u2026PropertyImpl).valueNode!!");
            ASTNode valueNode = aSTNode;
            PsiNavigateUtil.navigate((PsiElement)valueNode.getPsi());
        }

        public boolean startInWriteAction() {
            return true;
        }

        public AddDescriptionKeyIntention(@NotNull String myPropertyName) {
            Intrinsics.checkNotNullParameter((Object)myPropertyName, (String)"myPropertyName");
            this.myPropertyName = myPropertyName;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$Companion;", "", "()V", "DESCRIPTION_SUFFIX", "", "PLUGIN_GROUP_NAMES", "", "REGISTRY_PROPERTIES_FILENAME", "RESTART_REQUIRED_SUFFIX", "isImplicitUsageKey", "", "keyName", "isRegistryPropertiesFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.devkit"})
    public static final class Companion {
        @JvmStatic
        public final boolean isImplicitUsageKey(@NotNull String keyName) {
            Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
            return StringUtil.endsWith((CharSequence)keyName, (CharSequence)RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX) || StringUtil.endsWith((CharSequence)keyName, (CharSequence)RegistryPropertiesAnnotator.RESTART_REQUIRED_SUFFIX);
        }

        @JvmStatic
        public final boolean isRegistryPropertiesFile(@NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            return PsiUtil.isIdeaProject(psiFile.getProject()) && Intrinsics.areEqual((Object)psiFile.getName(), (Object)RegistryPropertiesAnnotator.REGISTRY_PROPERTIES_FILENAME);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

