/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.NonDefaultConstructorInspectionKt;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastFacade;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getArea", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint$Area;", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "intellij.devkit"})
public final class NonDefaultConstructorInspection
extends DevKitUastInspectionBase {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        block31: {
            block30: {
                Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                javaPsi = aClass.getJavaPsi();
                v0 = javaPsi.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"javaPsi.language");
                if (Intrinsics.areEqual((Object)v0.getID(), (Object)"Groovy") || javaPsi.getClassKind() != JvmClassKind.CLASS || PsiUtil.isInnerClass((PsiClass)javaPsi) || PsiUtil.isLocalOrAnonymousClass((PsiClass)javaPsi) || PsiUtil.isAbstractClass((PsiClass)javaPsi) || javaPsi.hasModifierProperty("private")) {
                    return null;
                }
                constructors = javaPsi.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)constructors, (String)"constructors");
                var6_6 = constructors;
                var7_7 = false;
                if (var6_6.length == 0) {
                    return null;
                }
                area = null;
                isService = false;
                serviceClientKind = null;
                isServiceAnnotation = false;
                extensionPoint = null;
                if (!javaPsi.hasAnnotation("com.intellij.openapi.components.Service")) break block30;
                area = null;
                isService = true;
                isServiceAnnotation = true;
                break block31;
            }
            if (!NonDefaultConstructorInspectionKt.access$isExtensionBean(aClass)) {
                v1 = manager.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"manager.project");
                v2 = NonDefaultConstructorInspectionKt.access$findExtensionPoint(aClass, v1);
                if (v2 == null) {
                    return null;
                }
                extensionPoint = v2;
            } else if (Intrinsics.areEqual((Object)javaPsi.getName(), (Object)"VcsConfigurableEP")) {
                return null;
            }
            area = this.getArea((ExtensionPoint)extensionPoint);
            v3 = extensionPoint;
            isService = Intrinsics.areEqual((Object)(v3 != null && (v3 = v3.getBeanClass()) != null ? v3.getStringValue() : null), (Object)"com.intellij.openapi.components.ServiceDescriptor");
            if (!isService) break block31;
            v4 = (ExtensionCandidate)ContainerUtil.getOnlyItem((Collection)ExtensionLocatorKt.locateExtensionsByPsiClass(javaPsi));
            v5 = extension = v4 != null && (v4 = v4.pointer) != null ? (XmlTag)v4.getElement() : null;
            v6 = DomManager.getDomManager((Project)manager.getProject()).getDomElement(extension);
            if (!(v6 instanceof Extension)) {
                v6 = null;
            }
            if ((v7 = (extensionTag = (Extension)v6)) != null && (v7 = v7.getXmlTag()) != null && (v7 = v7.getAttribute("client")) != null && (v7 = v7.getValue()) != null) {
                var13_14 = v7;
                v8 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"Locale.US");
                var14_15 = v8;
                var15_17 = false;
                var16_19 = var13_14;
                var17_21 = false;
                v9 = var16_19;
                if (v9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v10 = v9.toLowerCase(var14_15);
                v11 = v10;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"(this as java.lang.String).toLowerCase(locale)");
            } else {
                v11 = null;
            }
            if (v11 == null) ** GOTO lbl-1000
            var13_14 = v11;
            tmp = -1;
            switch (var13_14.hashCode()) {
                case 96673: {
                    if (!var13_14.equals("all")) break;
                    tmp = 1;
                    break;
                }
                case 98708952: {
                    if (!var13_14.equals("guest")) break;
                    tmp = 2;
                    break;
                }
                case 103145323: {
                    if (!var13_14.equals("local")) break;
                    tmp = 3;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v12 = ServiceDescriptor.ClientKind.ALL;
                    break;
                }
                case 2: {
                    v12 = ServiceDescriptor.ClientKind.GUEST;
                    break;
                }
                case 3: {
                    v12 = ServiceDescriptor.ClientKind.LOCAL;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v12 = null;
                }
            }
            serviceClientKind = v12;
        }
        isAppLevelExtensionPoint = area == null || area == ExtensionPoint.Area.IDEA_APPLICATION;
        errors = null;
        var15_18 = constructors;
        var16_20 = var15_18.length;
        for (var14_16 = 0; var14_16 < var16_20; ++var14_16) {
            block33: {
                block32: {
                    v13 = method = var15_18[var14_16];
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"method");
                    v14 = v13.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"method.parameterList");
                    if (NonDefaultConstructorInspectionKt.access$isAllowedParameters(v14, extensionPoint, isAppLevelExtensionPoint, serviceClientKind, isServiceAnnotation)) {
                        return null;
                    }
                    if (errors == null) {
                        errors = (List)new SmartList();
                    }
                    if (!method.isPhysical()) break block32;
                    v15 = method.getIdentifyingElement();
                    v16 = v15;
                    Intrinsics.checkNotNull((Object)v15);
                    break block33;
                }
                v16 = aClass.getSourcePsi();
                if (v16 == null) continue;
                var18_23 = v16;
                var19_24 = false;
                var20_26 = false;
                it = var18_23;
                $i$a$-let-NonDefaultConstructorInspection$checkClass$anchorElement$1 = false;
                v17 = UastFacade.INSTANCE.findPlugin(it);
                if (v17 == null) ** GOTO lbl-1000
                var23_29 = v17;
                var24_30 = (PsiElement)method;
                parent$iv = (UElement)aClass;
                $i$f$convertOpt = false;
                v18 = $this$convertOpt$iv.convertElement((PsiElement)element$iv, parent$iv, UMethod.class);
                if (!(v18 instanceof UMethod)) {
                    v18 = null;
                }
                if ((v17 = (UMethod)((UElement)((UMethod)v18))) != null) {
                    v19 = v17.getSourcePsi();
                } else lbl-1000:
                // 2 sources

                {
                    v19 = v16 = null;
                }
                if (v19 == null) {
                    continue;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"when {\n        method.is\u2026 ?: continue@loop\n      }");
            anchorElement = v16;
            v20 = kind = isService != false ? DevKitBundle.message("inspections.non.default.warning.type.service", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.type.extension", new Object[0]);
            suffix = area == null ? DevKitBundle.message("inspections.non.default.warning.suffix.project.or.module", new Object[0]) : (isAppLevelExtensionPoint != false ? "" : (area == ExtensionPoint.Area.IDEA_PROJECT ? DevKitBundle.message("inspections.non.default.warning.suffix.project", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.suffix.module", new Object[0])));
            v21 = manager.createProblemDescriptor(anchorElement, DevKitBundle.message("inspections.non.default.warning.and.suffix.message", new Object[]{kind, suffix}), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
            Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"manager.createProblemDes\u2026R_OR_WARNING, isOnTheFly)");
            errors.add(v21);
        }
        v22 = errors;
        if (v22 != null) {
            $this$toTypedArray$iv = v22;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            v23 = thisCollection$iv.toArray(new ProblemDescriptor[0]);
            if (v23 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            v24 = v23;
        } else {
            v24 = null;
        }
        return v24;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ExtensionPoint.Area getArea(ExtensionPoint extensionPoint) {
        String areaName;
        ExtensionPoint extensionPoint2 = extensionPoint;
        if (extensionPoint2 == null) {
            return ExtensionPoint.Area.IDEA_APPLICATION;
        }
        GenericAttributeValue<ExtensionPoint.Area> genericAttributeValue = extensionPoint2.getArea();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue, (String)"(extensionPoint ?: retur\u2026ea.IDEA_APPLICATION).area");
        String string = areaName = genericAttributeValue.getStringValue();
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case -660214604: {
                    if (!string2.equals("IDEA_MODULE")) break;
                    return ExtensionPoint.Area.IDEA_MODULE;
                }
                case -528560719: {
                    if (!string2.equals("IDEA_PROJECT")) break;
                    return ExtensionPoint.Area.IDEA_PROJECT;
                }
            }
        }
        GenericAttributeValue<String> genericAttributeValue2 = extensionPoint.getName();
        Intrinsics.checkNotNullExpressionValue(genericAttributeValue2, (String)"extensionPoint.name");
        String string3 = (String)genericAttributeValue2.getValue();
        if (string3 == null) return ExtensionPoint.Area.IDEA_APPLICATION;
        String string4 = string3;
        switch (string4.hashCode()) {
            case 350807721: {
                if (!string4.equals("moduleService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_MODULE;
            }
            case -1492183716: {
                if (!string4.equals("projectService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_PROJECT;
            }
        }
        return ExtensionPoint.Area.IDEA_APPLICATION;
    }

    public NonDefaultConstructorInspection() {
        super(UClass.class);
    }
}

