/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.ProjectProductionScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.ExtensionPointUsageAnalyzerKt;
import org.jetbrains.idea.devkit.inspections.Leak;
import org.jetbrains.idea.devkit.inspections.QualifiedCall;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u0010'\u001a\u00020\u001bH\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u0010)\u001a\u00020\u0016H\u0002J\u0014\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u0005H\u0002J \u00101\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u00102\u001a\u00020-2\b\b\u0001\u00100\u001a\u00020\u0005H\u0002J \u00103\u001a\b\u0012\u0004\u0012\u00020#0&2\u0006\u00104\u001a\u0002052\b\b\u0001\u00100\u001a\u00020\u0005H\u0002J\u0010\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u000fH\u0002J\u0010\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=H\u0002J\u0012\u0010>\u001a\u00020\u00072\b\u0010?\u001a\u0004\u0018\u00010@H\u0002J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020HH\u0002J\b\u0010I\u001a\u00020\u0007H\u0002R\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020#0\"0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001d\u00a8\u0006J"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LeakSearchContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "epName", "", "ignoreSafeClasses", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Z)V", "ANONYMOUS_PASS_THROUGH", "", "SAFE_CLASSES", "", "classSafe", "", "Lcom/intellij/psi/PsiClass;", "getEpName", "()Ljava/lang/String;", "getIgnoreSafeClasses", "()Z", "processedObjects", "", "Lorg/jetbrains/uast/UExpression;", "getProject", "()Lcom/intellij/openapi/project/Project;", "safeUsages", "", "Lcom/intellij/psi/PsiReference;", "getSafeUsages", "()Ljava/util/List;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "unsafeUsages", "Lkotlin/Pair;", "Lorg/jetbrains/idea/devkit/inspections/Leak;", "getUnsafeUsages", "analyzeEPUsage", "", "reference", "analyzeGetExtensionsCall", "fullExpression", "findEnclosingCall", "Lorg/jetbrains/uast/UCallExpression;", "expr", "Lorg/jetbrains/uast/UElement;", "findLeaksThroughCall", "call", "text", "findObjectLeaks", "e", "findVariableUsageLeaks", "variable", "Lorg/jetbrains/uast/UVariable;", "isConcreteExtension", "psiClass", "isSafeCall", "callee", "Lcom/intellij/psi/PsiMethod;", "isSafeClass", "resolveResult", "Lcom/intellij/psi/PsiClassType$ClassResolveResult;", "isSafeType", "type", "Lcom/intellij/psi/PsiType;", "processEPFieldUsages", "", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "resolveAnonymousClass", "Lorg/jetbrains/uast/UObjectLiteralExpression;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "tooManyObjects", "intellij.devkit"})
public final class LeakSearchContext {
    @NonNls
    private final Set<String> SAFE_CLASSES;
    @NonNls
    private final Map<String, String> ANONYMOUS_PASS_THROUGH;
    private final GlobalSearchScope searchScope;
    private final Map<PsiClass, Boolean> classSafe;
    private final Set<UExpression> processedObjects;
    @NotNull
    private final List<Pair<PsiReference, Leak>> unsafeUsages;
    @NotNull
    private final List<PsiReference> safeUsages;
    @NotNull
    private final Project project;
    @Nullable
    private final String epName;
    private final boolean ignoreSafeClasses;

    @NotNull
    public final List<Pair<PsiReference, Leak>> getUnsafeUsages() {
        return this.unsafeUsages;
    }

    @NotNull
    public final List<PsiReference> getSafeUsages() {
        return this.safeUsages;
    }

    public final void processEPFieldUsages(@NotNull PsiElement sourcePsi) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)sourcePsi, (String)"sourcePsi");
            Query query = ReferencesSearch.search((PsiElement)sourcePsi);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ReferencesSearch.search(sourcePsi)");
            Iterable $this$forEach$iv = (Iterable)query;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiReference ref = (PsiReference)element$iv;
                boolean bl = false;
                boolean $i$f$runReadAction = false;
                List leaks = (List)ApplicationManager.getApplication().runReadAction(new Computable(ref, this){
                    final /* synthetic */ PsiReference $ref$inlined;
                    final /* synthetic */ LeakSearchContext this$0;
                    {
                        this.$ref$inlined = psiReference;
                        this.this$0 = leakSearchContext;
                    }

                    public final T compute() {
                        boolean bl = false;
                        PsiReference psiReference = this.$ref$inlined;
                        Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"ref");
                        return (T)LeakSearchContext.access$analyzeEPUsage(this.this$0, psiReference);
                    }
                });
                if (leaks.isEmpty()) {
                    PsiReference psiReference = ref;
                    Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"ref");
                    this.safeUsages.add(psiReference);
                    continue;
                }
                for (Leak leak : leaks) {
                    this.unsafeUsages.add((Pair<PsiReference, Leak>)TuplesKt.to((Object)ref, (Object)leak));
                }
            }
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.project);
            if (statusBar == null) break block3;
            statusBar.setInfo("");
        }
    }

    private final List<Leak> analyzeEPUsage(PsiReference reference) {
        UElement parent;
        PsiFile containingFile;
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"reference.element");
        PsiFile psiFile = containingFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"containingFile");
        String string = FileUtil.getNameWithoutExtension((String)psiFile.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.getNameWithoutE\u2026sion(containingFile.name)");
        String containingFileName = string;
        if (StringsKt.endsWith$default((String)containingFileName, (String)"CoreEnvironment", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)containingFileName, (String)"CoreApplicationEnvironment", (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)containingFile.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getIn\u2026e(containingFile.project)");
        if (projectRootManager.getFileIndex().isInTestSourceContent(containingFile.getVirtualFile())) {
            return CollectionsKt.emptyList();
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)reference.getElement(), (Class[])new Class[]{PsiComment.class}) != null) {
            return CollectionsKt.emptyList();
        }
        UElement element = UastContextKt.toUElement((PsiElement)reference.getElement());
        QualifiedCall qualifiedCall = ExtensionPointUsageAnalyzerKt.access$findQualifiedCall(element);
        if (qualifiedCall != null) {
            String methodName = qualifiedCall.getCallExpression().getMethodName();
            if (Intrinsics.areEqual((Object)methodName, (Object)"getExtensions") || Intrinsics.areEqual((Object)methodName, (Object)"getExtensionList") || Intrinsics.areEqual((Object)methodName, (Object)"allForLanguage")) {
                return this.analyzeGetExtensionsCall(qualifiedCall.getFullExpression());
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"findExtension") || Intrinsics.areEqual((Object)methodName, (Object)"forLanguage")) {
                UElement uElement = (UElement)qualifiedCall.getCallExpression();
                String string2 = DevKitBundle.message("extension.point.analyzer.reason.extension.instance", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DevKitBundle.message(\"ex\u2026ason.extension.instance\")");
                return this.findObjectLeaks(uElement, string2);
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"getName")) {
                return CollectionsKt.emptyList();
            }
        }
        UElement uElement = element;
        Object object = parent = uElement != null ? uElement.getUastParent() : null;
        while (parent instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)parent).getSelector(), (Object)element)) {
            parent = parent.getUastParent();
        }
        if (parent instanceof UQualifiedReferenceExpression) {
            String name;
            UElement uElement2 = ((UQualifiedReferenceExpression)parent).getReferenceNameElement();
            if (!(uElement2 instanceof UIdentifier)) {
                uElement2 = null;
            }
            UIdentifier uIdentifier = (UIdentifier)uElement2;
            String string3 = name = uIdentifier != null ? uIdentifier.getName() : null;
            if (Intrinsics.areEqual((Object)name, (Object)"extensions") || Intrinsics.areEqual((Object)name, (Object)"extensionList")) {
                return this.analyzeGetExtensionsCall((UExpression)parent);
            }
        }
        String string4 = DevKitBundle.message("extension.point.analyzer.reason.unknown.usage", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DevKitBundle.message(\"ex\u2026er.reason.unknown.usage\")");
        return CollectionsKt.listOf((Object)new Leak(string4, reference.getElement()));
    }

    private final List<Leak> analyzeGetExtensionsCall(UExpression fullExpression) {
        UElement $this$getParentOfType$iv = (UElement)fullExpression;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UForEachExpression loop = (UForEachExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UForEachExpression.class, (boolean)strict$iv);
        if (loop != null) {
            if (Intrinsics.areEqual((Object)fullExpression, (Object)loop.getIteratedValue()) ^ true) {
                String string = DevKitBundle.message("extension.point.analyzer.reason.call.not.loop.value", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026son.call.not.loop.value\")");
                return CollectionsKt.listOf((Object)new Leak(string, fullExpression.getSourcePsi()));
            }
            UVariable uVariable = (UVariable)loop.getVariable();
            String string = DevKitBundle.message("extension.point.analyzer.reason.extension.instance", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026ason.extension.instance\")");
            return this.findVariableUsageLeaks(uVariable, string);
        }
        UElement uElement = (UElement)fullExpression;
        String string = DevKitBundle.message("extension.point.analyzer.reason.extension.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026r.reason.extension.list\")");
        return this.findObjectLeaks(uElement, string);
    }

    private final UCallExpression findEnclosingCall(UElement expr) {
        UQualifiedReferenceExpression qualifiedExpression;
        UQualifiedReferenceExpression uQualifiedReferenceExpression;
        UCallExpression call;
        UCallExpression uCallExpression;
        UElement uElement = expr;
        if (uElement != null) {
            UElement $this$getParentOfType$iv = uElement;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UCallExpression.class, (boolean)strict$iv);
        } else {
            uCallExpression = call = null;
        }
        if (call != null && CollectionsKt.contains((Iterable)call.getValueArguments(), (Object)expr)) {
            return call;
        }
        UElement uElement2 = expr;
        if (uElement2 != null) {
            UElement $this$getParentOfType$iv = uElement2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uQualifiedReferenceExpression = (UQualifiedReferenceExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UQualifiedReferenceExpression.class, (boolean)strict$iv);
        } else {
            uQualifiedReferenceExpression = qualifiedExpression = null;
        }
        if (qualifiedExpression != null && Intrinsics.areEqual((Object)qualifiedExpression.getReceiver(), (Object)expr)) {
            UExpression uExpression = qualifiedExpression.getSelector();
            if (!(uExpression instanceof UCallExpression)) {
                uExpression = null;
            }
            return (UCallExpression)uExpression;
        }
        return null;
    }

    private final List<Leak> findLeaksThroughCall(UCallExpression call, String text) {
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            String string = DevKitBundle.message("extension.point.analyzer.reason.unresolved.method.call", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026.unresolved.method.call\")");
            return CollectionsKt.listOf((Object)new Leak(string, call.getSourcePsi()));
        }
        PsiMethod callee = psiMethod;
        if (this.isSafeCall(callee)) {
            PsiType type = call.getReturnType();
            if (type == null || this.isSafeType(type)) {
                return CollectionsKt.emptyList();
            }
            UElement uElement = (UElement)call;
            String string = DevKitBundle.message("extension.point.analyzer.reason.return.value", text, callee.getName(), type.getPresentableText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026me, type.presentableText)");
            return this.findObjectLeaks(uElement, string);
        }
        String string = DevKitBundle.message("extension.point.analyzer.reason.impure.method", text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026son.impure.method\", text)");
        return CollectionsKt.listOf((Object)new Leak(string, call.getSourcePsi()));
    }

    private final boolean isSafeCall(PsiMethod callee) {
        if (JavaMethodContractUtil.isPure((PsiMethod)callee)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)callee.getName(), (Object)"getValue")) {
            PsiClass psiClass = callee.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"com.intellij.openapi.util.NotNullLazyValue")) {
                return true;
            }
        }
        if (Intrinsics.areEqual((Object)callee.getName(), (Object)"get")) {
            PsiClass psiClass = callee.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.util.Map")) {
                return true;
            }
        }
        return false;
    }

    private final boolean isSafeType(PsiType type) {
        boolean bl;
        if (!this.ignoreSafeClasses) {
            return false;
        }
        PsiType psiType = type;
        if (psiType == null) {
            bl = false;
        } else if (psiType instanceof PsiPrimitiveType) {
            bl = true;
        } else if (psiType instanceof PsiArrayType) {
            bl = this.isSafeType(((PsiArrayType)type).getDeepComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
            Intrinsics.checkNotNullExpressionValue((Object)classResolveResult, (String)"type.resolveGenerics()");
            PsiClassType.ClassResolveResult resolveResult = classResolveResult;
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"resolveResult.element ?: return false");
            PsiClass psiClass2 = psiClass;
            Boolean safe = this.classSafe.putIfAbsent(psiClass2, true);
            if (safe == null) {
                safe = this.isSafeClass(resolveResult);
                this.classSafe.put(psiClass2, safe);
            }
            bl = safe;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isSafeClass(PsiClassType.ClassResolveResult resolveResult) {
        boolean bl;
        block12: {
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"resolveResult.element ?: return false");
            PsiClass psiClass2 = psiClass;
            PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"resolveResult.substitutor");
            PsiSubstitutor substitutor = psiSubstitutor;
            if (CollectionsKt.contains((Iterable)this.SAFE_CLASSES, (Object)psiClass2.getQualifiedName())) {
                bl = true;
            } else if (psiClass2.isEnum()) {
                bl = true;
            } else if (InheritanceUtil.isInheritor((PsiClass)psiClass2, (String)"com.intellij.psi.PsiElement")) {
                bl = true;
            } else if (this.isConcreteExtension(psiClass2)) {
                bl = true;
            } else if (psiClass2.hasModifierProperty("final")) {
                PsiField[] psiFieldArray = psiClass2.getAllFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"psiClass.allFields");
                PsiField[] $this$any$iv = psiFieldArray;
                boolean $i$f$any = false;
                PsiField[] psiFieldArray2 = $this$any$iv;
                int n = psiFieldArray2.length;
                for (int i = 0; i < n; ++i) {
                    PsiField element$iv;
                    PsiField f = element$iv = psiFieldArray2[i];
                    boolean bl2 = false;
                    PsiField psiField = f;
                    Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"f");
                    if (!this.isSafeType(substitutor.substitute(psiField.getType()))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isConcreteExtension(PsiClass psiClass) {
        Extension extensionTag;
        Object object;
        if (this.epName == null) {
            return false;
        }
        ExtensionCandidate extensionCandidate = (ExtensionCandidate)ContainerUtil.getOnlyItem((Collection)ExtensionLocatorKt.locateExtensionsByPsiClass(psiClass));
        if (extensionCandidate == null || (extensionCandidate = extensionCandidate.pointer) == null || (extensionCandidate = (XmlTag)extensionCandidate.getElement()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)extensionCandidate, (String)"ContainerUtil.getOnlyIte\u2026?.element ?: return false");
        ExtensionCandidate extension = extensionCandidate;
        DomElement domElement = DomManager.getDomManager((Project)this.project).getDomElement((XmlTag)extension);
        if (!(domElement instanceof Extension)) {
            domElement = null;
        }
        if ((object = (extensionTag = (Extension)domElement)) == null || (object = object.getExtensionPoint()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensionTag?.extensionPoint ?: return false");
        Object extensionPoint = object;
        if (Intrinsics.areEqual((Object)extensionPoint.getEffectiveQualifiedName(), (Object)this.epName) ^ true) {
            return false;
        }
        PsiClass effectiveClass = extensionPoint.getEffectiveClass();
        return effectiveClass != null && psiClass.isInheritor(effectiveClass, true);
    }

    private final List<Leak> findObjectLeaks(UElement e, @Nls String text) {
        PsiElement targetElement = e.getSourcePsi();
        if (e instanceof UExpression && targetElement != null) {
            UElement jumpTarget;
            UElement target;
            UElement target2;
            UExpression leftOperand;
            UCallExpression call;
            if (!this.processedObjects.add((UExpression)e)) {
                return CollectionsKt.emptyList();
            }
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.project);
            if (statusBar != null) {
                statusBar.setInfo(DevKitBundle.message("extension.point.analyzer.analyze.status.bar.info", StringUtil.shortenTextWithEllipsis((String)targetElement.getText(), (int)50, (int)5), this.processedObjects.size()));
            }
            if (this.tooManyObjects()) {
                String string = DevKitBundle.message("extension.point.analyzer.reason.too.many.visited.objects", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026oo.many.visited.objects\")");
                return CollectionsKt.listOf((Object)new Leak(string, targetElement));
            }
            PsiType type = ((UExpression)e).getExpressionType();
            if (this.isSafeType(type)) {
                return CollectionsKt.emptyList();
            }
            UElement parent = e.getUastParent();
            if (parent instanceof UParenthesizedExpression || parent instanceof UIfExpression || parent instanceof UBinaryExpressionWithType || parent instanceof UUnaryExpression || e instanceof UCallExpression && parent instanceof UQualifiedReferenceExpression) {
                return this.findObjectLeaks(parent, text);
            }
            if (parent instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)parent).getOperator(), (Object)UastBinaryOperator.ASSIGN) ^ true) {
                return CollectionsKt.emptyList();
            }
            if (parent instanceof UForEachExpression && Intrinsics.areEqual((Object)((UForEachExpression)parent).getIteratedValue(), (Object)e)) {
                UVariable uVariable = (UVariable)((UForEachExpression)parent).getVariable();
                String string = DevKitBundle.message("extension.point.analyzer.reason.element.of", text);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026reason.element.of\", text)");
                return this.findVariableUsageLeaks(uVariable, string);
            }
            if (parent instanceof USwitchClauseExpression) {
                UElement $this$getParentOfType$iv = parent;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                USwitchExpression switchExpr = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, USwitchExpression.class, (boolean)strict$iv);
                if (switchExpr != null) {
                    return this.findObjectLeaks((UElement)switchExpr, text);
                }
            }
            if ((call = this.findEnclosingCall(e)) != null) {
                return this.findLeaksThroughCall(call, text);
            }
            if (parent instanceof UBinaryExpression && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getOperator(), (Object)UastBinaryOperator.ASSIGN) && (leftOperand = ((UBinaryExpression)parent).getLeftOperand()) instanceof USimpleNameReferenceExpression && (target2 = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)leftOperand))) instanceof ULocalVariable) {
                return this.findVariableUsageLeaks((UVariable)target2, text);
            }
            if (parent instanceof ULocalVariable) {
                return this.findVariableUsageLeaks((UVariable)parent, text);
            }
            if (parent instanceof UQualifiedReferenceExpression && (target = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)parent))) instanceof UField) {
                return this.findObjectLeaks(parent, text);
            }
            if (parent instanceof UReturnExpression && (jumpTarget = ((UReturnExpression)parent).getJumpTarget()) instanceof UMethod) {
                UObjectLiteralExpression target3 = this.resolveAnonymousClass((UMethod)jumpTarget);
                if (target3 != null) {
                    return this.findObjectLeaks((UElement)target3, text);
                }
                PsiMethod psiMethod = ((UMethod)jumpTarget).getJavaPsi();
                if (Intrinsics.areEqual((Object)psiMethod.getName(), (Object)"getInstance")) {
                    String string = DevKitBundle.message("extension.point.analyzer.reason.get.instance.method.skipped", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026instance.method.skipped\")");
                    return CollectionsKt.listOf((Object)new Leak(string, parent.getSourcePsi()));
                }
                boolean bl = false;
                Set methodsToFind = new LinkedHashSet();
                methodsToFind.add(psiMethod);
                PsiMethod[] psiMethodArray = psiMethod.findDeepestSuperMethods();
                ContainerUtil.addAll((Collection)methodsToFind, (Object[])Arrays.copyOf(psiMethodArray, psiMethodArray.length));
                boolean bl2 = false;
                List result = new ArrayList();
                for (PsiMethod methodToFind : methodsToFind) {
                    MethodReferencesSearch.search((PsiMethod)methodToFind, (SearchScope)((SearchScope)this.searchScope), (boolean)true).forEach(new Processor(this, result, text, psiMethod){
                        final /* synthetic */ LeakSearchContext this$0;
                        final /* synthetic */ List $result;
                        final /* synthetic */ String $text;
                        final /* synthetic */ PsiMethod $psiMethod;

                        public final boolean process(@NotNull PsiReference ref) {
                            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                            PsiElement psiElement = ref.getElement();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"ref.element");
                            PsiElement element = psiElement;
                            UElement uElement = UastContextKt.toUElement((PsiElement)element);
                            if (uElement instanceof UReferenceExpression) {
                                UElement uParent;
                                PsiElement psiElement2 = element.getParent();
                                Object object = uParent = psiElement2 != null ? UastContextKt.toUElement((PsiElement)psiElement2) : null;
                                if (uParent instanceof UCallExpression) {
                                    uElement = uParent;
                                } else {
                                    UCallExpression maybeCall;
                                    UElement uElement2 = uParent;
                                    if (!(uElement2 instanceof UQualifiedReferenceExpression)) {
                                        uElement2 = null;
                                    }
                                    UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uElement2;
                                    Object object2 = uQualifiedReferenceExpression != null ? uQualifiedReferenceExpression.getSelector() : null;
                                    if (!(object2 instanceof UCallExpression)) {
                                        object2 = null;
                                    }
                                    if ((maybeCall = (UCallExpression)object2) != null) {
                                        uElement = (UElement)maybeCall;
                                    }
                                }
                            }
                            if (uElement != null) {
                                String string = DevKitBundle.message("extension.point.analyzer.reason.returned.from.method", this.$text, this.$psiMethod.getName());
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026d\", text, psiMethod.name)");
                                this.$result.addAll(LeakSearchContext.access$findObjectLeaks(this.this$0, uElement, string));
                            }
                            return !LeakSearchContext.access$tooManyObjects(this.this$0);
                        }
                        {
                            this.this$0 = leakSearchContext;
                            this.$result = list;
                            this.$text = string;
                            this.$psiMethod = psiMethod;
                        }
                    });
                }
                Collection collection = result;
                boolean bl3 = false;
                if (!collection.isEmpty()) {
                    String string = DevKitBundle.message("extension.point.analyzer.reason.leak.returned.from.method", text, psiMethod.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026d\", text, psiMethod.name)");
                    result.add(0, new Leak(string, parent.getSourcePsi()));
                }
                return result;
            }
        }
        String string = DevKitBundle.message("extension.point.analyzer.reason.unknown.usage.text", text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026nknown.usage.text\", text)");
        PsiElement psiElement = targetElement;
        return CollectionsKt.listOf((Object)new Leak(string, (PsiElement)(psiElement != null ? psiElement.getParent() : null)));
    }

    private final UObjectLiteralExpression resolveAnonymousClass(UMethod uMethod) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)uMethod));
        if (uClass == null) {
            return null;
        }
        UClass uClass2 = uClass;
        UElement uElement = uClass2.getUastParent();
        if (!(uElement instanceof UObjectLiteralExpression)) {
            uElement = null;
        }
        UObjectLiteralExpression uObjectLiteralExpression = (UObjectLiteralExpression)uElement;
        if (uObjectLiteralExpression == null) {
            return null;
        }
        UObjectLiteralExpression anonymous = uObjectLiteralExpression;
        UTypeReferenceExpression uTypeReferenceExpression = (UTypeReferenceExpression)ContainerUtil.getOnlyItem((Collection)uClass2.getUastSuperTypes());
        if (uTypeReferenceExpression == null) {
            return null;
        }
        UTypeReferenceExpression onlySuperType = uTypeReferenceExpression;
        Map<String, String> map = this.ANONYMOUS_PASS_THROUGH;
        String string = onlySuperType.getQualifiedName();
        boolean bl = false;
        String methodName = map.get(string);
        return Intrinsics.areEqual((Object)uMethod.getName(), (Object)methodName) ? anonymous : null;
    }

    private final boolean tooManyObjects() {
        return this.processedObjects.size() > 500;
    }

    private final List<Leak> findVariableUsageLeaks(UVariable variable, @Nls String text) {
        PsiElement sourcePsi = variable.getSourcePsi();
        if (sourcePsi == null) {
            String string = DevKitBundle.message("extension.point.analyzer.reason.uast.no.source.psi", text);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ex\u2026ast.no.source.psi\", text)");
            return CollectionsKt.listOf((Object)new Leak(string, null));
        }
        boolean bl = false;
        List leaks = new ArrayList();
        ReferencesSearch.search((PsiElement)sourcePsi, (SearchScope)sourcePsi.getUseScope()).forEach(new Processor(this, leaks, text){
            final /* synthetic */ LeakSearchContext this$0;
            final /* synthetic */ List $leaks;
            final /* synthetic */ String $text;

            public final boolean process(PsiReference psiReference) {
                PsiReference psiReference2 = psiReference;
                Intrinsics.checkNotNullExpressionValue((Object)psiReference2, (String)"psiReference");
                UElement ref = UastContextKt.toUElement((PsiElement)psiReference2.getElement());
                if (ref != null) {
                    this.$leaks.addAll(LeakSearchContext.access$findObjectLeaks(this.this$0, ref, this.$text));
                }
                return !LeakSearchContext.access$tooManyObjects(this.this$0);
            }
            {
                this.this$0 = leakSearchContext;
                this.$leaks = list;
                this.$text = string;
            }
        });
        return leaks;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final String getEpName() {
        return this.epName;
    }

    public final boolean getIgnoreSafeClasses() {
        return this.ignoreSafeClasses;
    }

    public LeakSearchContext(@NotNull Project project, @Nullable String epName, boolean ignoreSafeClasses) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.epName = epName;
        this.ignoreSafeClasses = ignoreSafeClasses;
        this.SAFE_CLASSES = SetsKt.setOf((Object[])new String[]{"java.lang.String", "javax.swing.Icon", "java.net.URL", "java.io.File", "java.net.URI", "com.intellij.openapi.vfs.pointers.VirtualFilePointer", "com.intellij.openapi.vfs.VirtualFile"});
        this.ANONYMOUS_PASS_THROUGH = MapsKt.mapOf((Pair)TuplesKt.to((Object)"com.intellij.openapi.util.NotNullLazyValue", (Object)"compute"));
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.filterScope((Project)this.project, (NamedScope)((NamedScope)ProjectProductionScope.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScopesCore.f\u2026ProductionScope.INSTANCE)");
        this.searchScope = globalSearchScope;
        boolean bl = false;
        this.classSafe = new LinkedHashMap();
        bl = false;
        this.processedObjects = new LinkedHashSet();
        bl = false;
        this.unsafeUsages = new ArrayList();
        bl = false;
        this.safeUsages = new ArrayList();
    }

    public static final /* synthetic */ List access$analyzeEPUsage(LeakSearchContext $this, PsiReference reference) {
        return $this.analyzeEPUsage(reference);
    }

    public static final /* synthetic */ List access$findObjectLeaks(LeakSearchContext $this, UElement e, String text) {
        return $this.findObjectLeaks(e, text);
    }

    public static final /* synthetic */ boolean access$tooManyObjects(LeakSearchContext $this) {
        return $this.tooManyObjects();
    }
}

