/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.lang.properties.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ipp.base.Intention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.util.PsiUtil;

final class IntentionsImplicitPropertyUsageProvider
implements ImplicitPropertyUsageProvider {
    private static final String _FAMILY_NAME = ".family.name";
    private static final String _NAME = ".name";

    IntentionsImplicitPropertyUsageProvider() {
    }

    public boolean isUsed(@NotNull Property property) {
        String name;
        PsiFile containingFile;
        Project project;
        if (property == null) {
            IntentionsImplicitPropertyUsageProvider.$$$reportNull$$$0(0);
        }
        if (PsiUtil.isIdeaProject(project = (containingFile = property.getContainingFile()).getProject()) && containingFile.getName().endsWith("Bundle.properties") && (name = property.getName()) != null) {
            int limit;
            int length = name.length();
            if (name.endsWith(_FAMILY_NAME)) {
                limit = length - _FAMILY_NAME.length();
            } else if (name.endsWith(_NAME)) {
                limit = length - _NAME.length();
            } else {
                return false;
            }
            boolean toUpperCase = true;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < limit; ++i) {
                if (name.charAt(i) == '.') {
                    toUpperCase = true;
                    continue;
                }
                if (toUpperCase) {
                    buf.append(Character.toUpperCase(name.charAt(i)));
                } else {
                    buf.append(name.charAt(i));
                }
                toUpperCase = false;
            }
            Object[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(buf.toString(), GlobalSearchScopes.projectProductionScope((Project)project));
            return ContainerUtil.exists((Object[])classes, aClass -> InheritanceUtil.isInheritor((PsiClass)aClass, (String)Intention.class.getName()));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/devkit/inspections/IntentionsImplicitPropertyUsageProvider", "isUsed"));
    }
}

