/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.debug;

import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/debug/HttpDebugListener;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isSupported", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Companion", "intellij.devkit"})
public final class HttpDebugListener
extends HttpRequestHandler {
    private final Logger logger;
    @NonNls
    private static final String PREFIX = "/debug/attachToTestProcess";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.uri()");
        if (!StringsKt.startsWith$default((String)string, (String)PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String content = request.content().toString(Charset.defaultCharset());
        Object[] contentLines = StringUtil.splitByLines((String)content);
        String port = contentLines[0];
        Intrinsics.checkNotNullExpressionValue((Object)contentLines, (String)"contentLines");
        String name = (String)ArraysKt.getOrNull((Object[])contentLines, (int)1);
        this.logger.info("Debugger attach request to a test process by port '" + port + "' as '" + name + '\'');
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        Project[] projectArray = projectManager.getOpenProjects();
        int n = projectArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Project project;
            block2: {
                Project project2 = project = projectArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                ExecutionManager executionManager = ExecutionManager.Companion.getInstance(project2);
                ProcessHandler[] $this$any$iv = executionManager.getRunningProcesses();
                boolean $i$f$any = false;
                ProcessHandler[] processHandlerArray = $this$any$iv;
                int n2 = processHandlerArray.length;
                for (int j = 0; j < n2; ++j) {
                    ProcessHandler element$iv;
                    ProcessHandler it = element$iv = processHandlerArray[j];
                    boolean bl2 = false;
                    if (!(!it.isProcessTerminated())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            ApplicationManager.getApplication().invokeAndWait(new Runnable(port, name, project){
                final /* synthetic */ String $port;
                final /* synthetic */ String $name;
                final /* synthetic */ Project $project;

                public final void run() {
                    JavaAttachDebuggerProvider.attach((String)"dt_socket", (String)this.$port, (String)this.$name, (Project)this.$project);
                }
                {
                    this.$port = string;
                    this.$name = string2;
                    this.$project = project;
                }
            });
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.OK");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"context.channel()");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        this.logger.info("No projects with active test session found");
        return false;
    }

    public HttpDebugListener() {
        Logger logger = Logger.getInstance(HttpDebugListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(HttpDebugListener::class.java)");
        this.logger = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/devkit/debug/HttpDebugListener$Companion;", "", "()V", "PREFIX", "", "intellij.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

