/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellBuilder;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.xml.DomFileElement;
import java.awt.Container;
import java.util.Properties;
import java.util.UUID;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewThemeAction;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J \u0010\u001c\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/devkit/actions/NewThemeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/UpdateInBackground;", "()V", "THEME_JSON_TEMPLATE", "", "THEME_PROVIDER_EP_NAME", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createThemeJson", "Lcom/intellij/psi/PsiFile;", "themeName", "isDark", "", "project", "Lcom/intellij/openapi/project/Project;", "dir", "Lcom/intellij/psi/PsiDirectory;", "module", "Lcom/intellij/openapi/module/Module;", "getRandomId", "getSourceRootRelativeLocation", "file", "getThemeColorSchemeFileName", "getThemeJsonFileName", "registerTheme", "update", "NewThemeDialog", "intellij.devkit"})
public final class NewThemeAction
extends AnAction
implements UpdateInBackground {
    private final String THEME_JSON_TEMPLATE;
    private final String THEME_PROVIDER_EP_NAME;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IdeView ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (ideView == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ideView, (String)"e.getData(LangDataKeys.IDE_VIEW) ?: return");
        IdeView view = ideView;
        PsiDirectory psiDirectory = view.getOrChooseDirectory();
        if (psiDirectory == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"view.getOrChooseDirectory() ?: return");
        PsiDirectory dir = psiDirectory;
        Object object = e.getRequiredData(LangDataKeys.MODULE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(LangDataKeys.MODULE)");
        Module module = (Module)object;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        NewThemeDialog dialog = new NewThemeDialog(project2);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            String string = dialog.getName().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dialog.name.text");
            PsiFile file = this.createThemeJson(string, dialog.isDark().isSelected(), project2, dir, module);
            view.selectElement((PsiElement)file);
            FileEditorManager.getInstance((Project)project2).openFile(file.getVirtualFile(), true);
            this.registerTheme(dir, file, module);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(module != null && (PluginModuleType.get((Module)module) instanceof PluginModuleType || PsiUtil.isPluginModule(module)));
    }

    private final PsiFile createThemeJson(String themeName, boolean isDark, Project project, PsiDirectory dir, Module module) {
        String fileName = this.getThemeJsonFileName(themeName);
        String colorSchemeFilename = this.getThemeColorSchemeFileName(themeName);
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(this.THEME_JSON_TEMPLATE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"FileTemplateManager.getI\u2026late(THEME_JSON_TEMPLATE)");
        FileTemplate template = fileTemplate;
        Properties editorSchemeProps = new Properties();
        editorSchemeProps.setProperty("NAME", themeName);
        editorSchemeProps.setProperty("PARENT_SCHEME", isDark ? "Darcula" : "Default");
        FileTemplate fileTemplate2 = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("ThemeEditorColorScheme.xml");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate2, (String)"FileTemplateManager.getI\u2026meEditorColorScheme.xml\")");
        FileTemplate editorSchemeTemplate = fileTemplate2;
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)editorSchemeTemplate, (String)colorSchemeFilename, (Properties)editorSchemeProps, (PsiDirectory)dir);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"FileTemplateUtil.createF\u2026, editorSchemeProps, dir)");
        PsiElement colorScheme = psiElement;
        Properties props = new Properties();
        props.setProperty("NAME", themeName);
        props.setProperty("IS_DARK", String.valueOf(isDark));
        PsiElement psiElement2 = colorScheme;
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        props.setProperty("COLOR_SCHEME_NAME", this.getSourceRootRelativeLocation(module, (PsiFile)psiElement2));
        PsiElement psiElement3 = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)props, (PsiDirectory)dir);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"FileTemplateUtil.createF\u2026te, fileName, props, dir)");
        PsiElement created = psiElement3;
        boolean bl = created instanceof PsiFile;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        PsiElement psiElement4 = created;
        if (psiElement4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        return (PsiFile)psiElement4;
    }

    private final String getThemeJsonFileName(String themeName) {
        return FileUtil.sanitizeFileName((String)themeName) + ".theme.json";
    }

    private final String getThemeColorSchemeFileName(String themeName) {
        return FileUtil.sanitizeFileName((String)themeName) + ".xml";
    }

    private final void registerTheme(PsiDirectory dir, PsiFile file, Module module) {
        String string = this.getSourceRootRelativeLocation(module, file);
        if (string == null) {
            return;
        }
        String relativeLocation = string;
        XmlFile xmlFile = DevkitActionsUtil.choosePluginModuleDescriptor(dir);
        if (xmlFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"DevkitActionsUtil.choose\u2026Descriptor(dir) ?: return");
        XmlFile pluginXml = xmlFile;
        DescriptorUtil.checkPluginXmlsWritable(module.getProject(), pluginXml);
        DomFileElement<IdeaPlugin> domFileElement = DescriptorUtil.getIdeaPluginFileElement(pluginXml);
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])new PsiFile[]{(PsiFile)pluginXml}).run(new ThrowableRunnable(this, domFileElement, relativeLocation){
            final /* synthetic */ NewThemeAction this$0;
            final /* synthetic */ DomFileElement $domFileElement;
            final /* synthetic */ String $relativeLocation;

            public final void run() {
                Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)this.$domFileElement, NewThemeAction.access$getTHEME_PROVIDER_EP_NAME$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)extensions, (String)"PluginDescriptorChooser.\u2026, THEME_PROVIDER_EP_NAME)");
                Extensions extensions2 = extensions;
                Extension extension = extensions2.addExtension(NewThemeAction.access$getTHEME_PROVIDER_EP_NAME$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)extension, (String)"extensions.addExtension(THEME_PROVIDER_EP_NAME)");
                XmlTag xmlTag = extension.getXmlTag();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"extensions.addExtension(\u2026_PROVIDER_EP_NAME).xmlTag");
                XmlTag extensionTag = xmlTag;
                extensionTag.setAttribute("id", NewThemeAction.access$getRandomId(this.this$0));
                extensionTag.setAttribute("path", this.$relativeLocation);
            }
            {
                this.this$0 = newThemeAction;
                this.$domFileElement = domFileElement;
                this.$relativeLocation = string;
            }
        });
    }

    private final String getSourceRootRelativeLocation(Module module, PsiFile file) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] sourceRoots = rootManager.getSourceRoots(false);
        VirtualFile virtualFile = file.getVirtualFile();
        String relativeLocation = null;
        for (VirtualFile sourceRoot : sourceRoots) {
            if (!VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)virtualFile, (boolean)true)) continue;
            String string = VfsUtil.getRelativeLocation((VirtualFile)virtualFile, (VirtualFile)sourceRoot);
            if (string == null) {
                continue;
            }
            relativeLocation = string;
            break;
        }
        return '/' + relativeLocation;
    }

    private final String getRandomId() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        return string;
    }

    public NewThemeAction() {
        this.THEME_JSON_TEMPLATE = "ThemeJson.json";
        ExtensionPointName extensionPointName = UIThemeProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"UIThemeProvider.EP_NAME");
        String string = extensionPointName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UIThemeProvider.EP_NAME.name");
        this.THEME_PROVIDER_EP_NAME = string;
    }

    public static final /* synthetic */ String access$getTHEME_PROVIDER_EP_NAME$p(NewThemeAction $this) {
        return $this.THEME_PROVIDER_EP_NAME;
    }

    public static final /* synthetic */ String access$getRandomId(NewThemeAction $this) {
        return $this.getRandomId();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/actions/NewThemeAction$NewThemeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isDark", "Ljavax/swing/JCheckBox;", "()Ljavax/swing/JCheckBox;", "name", "Lcom/intellij/ui/components/JBTextField;", "getName", "()Lcom/intellij/ui/components/JBTextField;", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.devkit"})
    public static final class NewThemeDialog
    extends DialogWrapper {
        @NotNull
        private final JBTextField name;
        @NotNull
        private final JCheckBox isDark;

        @NotNull
        public final JBTextField getName() {
            return this.name;
        }

        @NotNull
        public final JCheckBox isDark() {
            return this.isDark;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            LayoutBuilder builder$iv;
            LCFlags[] constraints$iv = new LCFlags[]{};
            String title$iv = null;
            boolean $i$f$panel = false;
            LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
            boolean bl = false;
            RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), (String)DevKitBundle.message("new.theme.dialog.name.text.field.text", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ NewThemeDialog this$0;
                {
                    this.this$0 = newThemeDialog;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                    Row this_$iv = $this$row;
                    boolean isVerticalFlow$iv = false;
                    boolean isFullWidth$iv = false;
                    boolean $i$f$cell = false;
                    this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                    InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                    boolean bl = false;
                    String string = null;
                    CCFlags[] cCFlagsArray = new CCFlags[]{};
                    GrowPolicy growPolicy = GrowPolicy.MEDIUM_TEXT;
                    CellBuilder cellBuilder = Cell.invoke$default((Cell)((Cell)$this$cell), (JComponent)((JComponent)this.this$0.getName()), (CCFlags[])cCFlagsArray, (GrowPolicy)growPolicy, string, (int)4, null).focused();
                    String string2 = DevKitBundle.message("new.theme.dialog.name.empty", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DevKitBundle.message(\"ne\u2026theme.dialog.name.empty\")");
                    cellBuilder.withErrorOnApplyIf(string2, (Function1)createCenterPanel.1.1.1.1.INSTANCE);
                    this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                }
            }), (int)2, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), (String)"", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ NewThemeDialog this$0;
                {
                    this.this$0 = newThemeDialog;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                    Row this_$iv = $this$row;
                    boolean isVerticalFlow$iv = false;
                    boolean isFullWidth$iv = false;
                    boolean $i$f$cell = false;
                    this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                    InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                    boolean bl = false;
                    Cell.invoke$default((Cell)((Cell)$this$cell), (JComponent)this.this$0.isDark(), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                    this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                }
            }), (int)2, null);
            DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
            builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
            LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
            return (JComponent)panel$iv;
        }

        public NewThemeDialog(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
            this.name = new JBTextField();
            String string = DevKitBundle.message("new.theme.dialog.is.dark.checkbox.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ne\u2026g.is.dark.checkbox.text\")");
            this.isDark = ComponentsKt.CheckBox$default((String)string, (boolean)true, null, (int)4, null);
            this.setTitle(DevKitBundle.message("new.theme.dialog.title", new Object[0]));
            this.init();
        }
    }
}

