/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.actionsOnSave.ActionOnSaveBackedByOwnConfigurable;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfoProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.DropDownLink;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadOnSaveActionInfo
extends ActionOnSaveBackedByOwnConfigurable<PublishOptionsConfigurable> {
    private static final Logger LOG = Logger.getInstance(UploadOnSaveActionInfo.class);
    @NotNull
    private PublishConfig.AutoUploadState myLastUsedEnabledState;

    private UploadOnSaveActionInfo(@NotNull ActionOnSaveContext context) {
        if (context == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(0);
        }
        super(context, "reference.settings.deploy.options", PublishOptionsConfigurable.class);
        this.myLastUsedEnabledState = PublishConfig.AutoUploadState.ALWAYS;
    }

    @NotNull
    public String getActionOnSaveName() {
        String string = WDBundle.message("actions.on.save.page.upload.to.default.server.action.name", new Object[0]);
        if (string == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected ActionOnSaveComment getCommentAccordingToStoredState() {
        return this.getCommentAboutServer();
    }

    @Nullable
    protected ActionOnSaveComment getCommentAccordingToUiState(@NotNull PublishOptionsConfigurable configurable) {
        if (configurable == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(2);
        }
        return this.getCommentAboutServer();
    }

    @NotNull
    private ActionOnSaveComment getCommentAboutServer() {
        String defaultServerName;
        DeploymentConfigurable configurable = this.getDeploymentConfigurableIfInitialized();
        String string = defaultServerName = configurable != null ? configurable.getCurrentDefaultServerOrGroupName() : PublishConfig.getInstance(this.getProject()).getDefaultServerOrGroupName();
        if (defaultServerName != null) {
            ActionOnSaveComment actionOnSaveComment = ActionOnSaveComment.info((String)WDBundle.message("actions.on.save.comment.default.server.0", defaultServerName));
            if (actionOnSaveComment == null) {
                UploadOnSaveActionInfo.$$$reportNull$$$0(3);
            }
            return actionOnSaveComment;
        }
        String comment = WDBundle.message("actions.on.save.warning.default.server.not.configured", new Object[0]);
        if (this.isActionOnSaveEnabled()) {
            ActionOnSaveComment actionOnSaveComment = ActionOnSaveComment.warning((String)comment);
            if (actionOnSaveComment == null) {
                UploadOnSaveActionInfo.$$$reportNull$$$0(4);
            }
            return actionOnSaveComment;
        }
        ActionOnSaveComment actionOnSaveComment = ActionOnSaveComment.info((String)comment);
        if (actionOnSaveComment == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(5);
        }
        return actionOnSaveComment;
    }

    @Nullable
    private DeploymentConfigurable getDeploymentConfigurableIfInitialized() {
        Configurable configurable = this.getSettings().getConfigurableWithInitializedUiComponent("web.server", false);
        if (configurable == null) {
            return null;
        }
        if (configurable instanceof ConfigurableWrapper) {
            configurable = ((ConfigurableWrapper)configurable).getConfigurable();
        }
        if (!(configurable instanceof DeploymentConfigurable)) {
            LOG.error("Unexpected configurable type:" + configurable.getClass() + "\n" + (UnnamedConfigurable)configurable);
            return null;
        }
        return (DeploymentConfigurable)configurable;
    }

    protected boolean isActionOnSaveEnabledAccordingToStoredState() {
        boolean enabled;
        PublishConfig.AutoUploadState state = PublishConfig.getInstance(this.getProject()).getAutoUploadState();
        boolean bl = enabled = state != PublishConfig.AutoUploadState.NEVER;
        if (enabled) {
            this.myLastUsedEnabledState = state;
        }
        return enabled;
    }

    protected boolean isActionOnSaveEnabledAccordingToUiState(@NotNull PublishOptionsConfigurable configurable) {
        PublishConfig.AutoUploadState state;
        boolean enabled;
        if (configurable == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(6);
        }
        boolean bl = enabled = (state = configurable.getForm().getCurrentAutoUploadState()) != PublishConfig.AutoUploadState.NEVER;
        if (enabled) {
            this.myLastUsedEnabledState = state;
        }
        return enabled;
    }

    protected void setActionOnSaveEnabled(@NotNull PublishOptionsConfigurable configurable, boolean enabled) {
        PublishConfig.AutoUploadState state;
        boolean wasEnabled;
        if (configurable == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(7);
        }
        boolean bl = wasEnabled = (state = configurable.getForm().getCurrentAutoUploadState()) != PublishConfig.AutoUploadState.NEVER;
        if (wasEnabled) {
            this.myLastUsedEnabledState = state;
        }
        if (enabled) {
            configurable.getForm().setCurrentAutoUploadState(this.myLastUsedEnabledState);
        } else {
            configurable.getForm().setCurrentAutoUploadState(PublishConfig.AutoUploadState.NEVER);
        }
    }

    @NotNull
    public List<? extends ActionLink> getActionLinks() {
        String configureServers = WDBundle.message("actions.on.save.page.configure.servers.link", new Object[0]);
        String openDeploymentSettings = WDBundle.message("actions.on.save.page.open.deployment.settings.link", new Object[0]);
        List<ActionLink> list = List.of(this.createGoToPageInSettingsLink(configureServers, "web.server"), this.createGoToPageInSettingsLink(openDeploymentSettings, "reference.settings.deploy.options"));
        if (list == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    @NlsContexts.Label
    protected String getActivatedOnDefaultText() {
        if (this.isActionOnSaveEnabled()) {
            LOG.error("This method shouldn't be called because getActivatedOnDropDownLink() is expected to return not-null.");
        }
        return UploadOnSaveActionInfo.getTextForState(this.myLastUsedEnabledState);
    }

    @Nullable
    public DropDownLink<?> getActivatedOnDropDownLink() {
        if (!this.isActionOnSaveEnabled()) {
            return null;
        }
        String current = UploadOnSaveActionInfo.getTextForState(this.myLastUsedEnabledState);
        String optionOnAnySave = UploadOnSaveActionInfo.getTextForDropDownOption(PublishConfig.AutoUploadState.ALWAYS);
        String optionOnExplicitSave = UploadOnSaveActionInfo.getTextForDropDownOption(PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE);
        return new DropDownLink((Object)current, List.of(optionOnAnySave, optionOnExplicitSave), choice -> {
            PublishConfig.AutoUploadState state = choice == optionOnAnySave ? PublishConfig.AutoUploadState.ALWAYS : PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE;
            this.updateUiOnOwnPage(configurable -> configurable.getForm().setCurrentAutoUploadState(state));
        });
    }

    @NotNull
    @NlsContexts.Label
    private static String getTextForState(@NotNull PublishConfig.AutoUploadState state) {
        if (state == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(9);
        }
        if (state == PublishConfig.AutoUploadState.ALWAYS) {
            String string = UploadOnSaveActionInfo.getAnySaveText();
            if (string == null) {
                UploadOnSaveActionInfo.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (state == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE) {
            String string = UploadOnSaveActionInfo.getExplicitSaveText();
            if (string == null) {
                UploadOnSaveActionInfo.$$$reportNull$$$0(11);
            }
            return string;
        }
        LOG.error("Unexpected state: " + state);
        String string = UploadOnSaveActionInfo.getAnySaveText();
        if (string == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @NlsContexts.Label
    private static String getTextForDropDownOption(@NotNull PublishConfig.AutoUploadState state) {
        if (state == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(13);
        }
        if (state == PublishConfig.AutoUploadState.ALWAYS) {
            String string = UploadOnSaveActionInfo.getAnySaveTextForDropDownOption();
            if (string == null) {
                UploadOnSaveActionInfo.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (state == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE) {
            String string = UploadOnSaveActionInfo.getExplicitSaveText();
            if (string == null) {
                UploadOnSaveActionInfo.$$$reportNull$$$0(15);
            }
            return string;
        }
        LOG.error("Unexpected state: " + state);
        String string = UploadOnSaveActionInfo.getAnySaveTextForDropDownOption();
        if (string == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(16);
        }
        return string;
    }

    protected void resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage(@NotNull PublishOptionsConfigurable configurable) {
        if (configurable == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(17);
        }
        configurable.getForm().setCurrentAutoUploadState(PublishConfig.getInstance(this.getProject()).getAutoUploadState());
    }

    protected boolean areOptionsMirroredOnActionsOnSavePageModified(@NotNull PublishOptionsConfigurable configurable) {
        if (configurable == null) {
            UploadOnSaveActionInfo.$$$reportNull$$$0(18);
        }
        return configurable.getForm().getCurrentAutoUploadState() != PublishConfig.getInstance(this.getProject()).getAutoUploadState();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/UploadOnSaveActionInfo";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/UploadOnSaveActionInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionOnSaveName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentAboutServer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionLinks";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForState";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForDropDownOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommentAccordingToUiState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isActionOnSaveEnabledAccordingToUiState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setActionOnSaveEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextForState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTextForDropDownOption";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resetUiOnOwnPageThatIsMirroredOnActionsOnSavePage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "areOptionsMirroredOnActionsOnSavePageModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UploadOnSaveInfoProvider
    extends ActionOnSaveInfoProvider {
        @NotNull
        protected Collection<? extends ActionOnSaveInfo> getActionOnSaveInfos(@NotNull ActionOnSaveContext context) {
            if (context == null) {
                UploadOnSaveInfoProvider.$$$reportNull$$$0(0);
            }
            List<UploadOnSaveActionInfo> list = List.of(new UploadOnSaveActionInfo(context));
            if (list == null) {
                UploadOnSaveInfoProvider.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/UploadOnSaveActionInfo$UploadOnSaveInfoProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/UploadOnSaveActionInfo$UploadOnSaveInfoProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionOnSaveInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionOnSaveInfos";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

