/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections.platform;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SftpChannelNoSuchFileException;
import com.intellij.ssh.SftpChannelPermissionDeniedException;
import com.intellij.ssh.channels.SftpChannel;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileObject;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileProvider;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PlatformSftpFileSystem
extends AbstractFileSystem {
    private static final Logger LOG = Logger.getInstance(PlatformSftpFileSystem.class);
    private final SftpChannel mySftpChannel;
    @NonNls
    @NotNull
    private final ThrowableNotNullFunction<? super String, String, ? extends IOException> myExecuteCommandOnRemoteHost;
    @Nullable
    private Integer myUid;
    @Nullable
    private Collection<Integer> myGroupsIds;
    private final Object myExecuteCommandMonitor;
    @NotNull
    private final String myPathPrefix;

    PlatformSftpFileSystem(@NotNull FileName rootName, @NotNull FileSystemOptions fileSystemOptions, @NotNull SftpChannel sftpChannel, @Nullable String workingDirectory, @NotNull ThrowableNotNullFunction<? super String, String, ? extends IOException> executeCommandOnRemoteHost) {
        if (rootName == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(0);
        }
        if (fileSystemOptions == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(1);
        }
        if (sftpChannel == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(2);
        }
        if (executeCommandOnRemoteHost == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(3);
        }
        super(rootName, fileSystemOptions);
        this.myExecuteCommandMonitor = new Object();
        this.mySftpChannel = sftpChannel;
        this.myExecuteCommandOnRemoteHost = executeCommandOnRemoteHost;
        this.myPathPrefix = workingDirectory == null ? sftpChannel.getHome() : PlatformSftpFileUtil.stripTrailingSeparator(workingDirectory);
    }

    protected FileObject createFile(@NotNull AbstractFileName name) {
        if (name == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(4);
        }
        return new PlatformSftpFileObject(arg_0 -> ((SftpChannel)this.mySftpChannel).file(arg_0), name.getPath(), this);
    }

    protected void addCapabilities(@NotNull Collection<Capability> caps) {
        if (caps == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(5);
        }
        caps.addAll(PlatformSftpFileProvider.capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUId() throws IOException {
        Object object = this.myExecuteCommandMonitor;
        synchronized (object) {
            if (this.myUid == null) {
                this.myUid = Integer.parseInt((String)this.myExecuteCommandOnRemoteHost.fun((Object)"id -u"));
            }
            return this.myUid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Integer> getGroupsIds() throws IOException {
        Object object = this.myExecuteCommandMonitor;
        synchronized (object) {
            if (this.myGroupsIds == null) {
                String output = (String)this.myExecuteCommandOnRemoteHost.fun((Object)"id -G");
                this.myGroupsIds = Arrays.stream(output.split(" ")).map(String::trim).filter(StringUtils::isNotEmpty).map(Integer::valueOf).collect(Collectors.toSet());
            }
            return this.myGroupsIds;
        }
    }

    protected void doCloseCommunicationLink() {
        this.mySftpChannel.disconnect();
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    @NotNull
    String getPathPrefix() {
        String string = this.myPathPrefix;
        if (string == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    FileType getFileType(@NotNull RemoteFileObject object) {
        if (object == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(7);
        }
        if (!object.exists()) {
            return FileType.IMAGINARY;
        }
        if (object.isSymbolicLink()) {
            try {
                object = this.mySftpChannel.file(object.canonicalPath());
            }
            catch (SftpChannelNoSuchFileException | SftpChannelPermissionDeniedException ignored) {
                return FileType.IMAGINARY;
            }
            if (!object.exists()) {
                return FileType.IMAGINARY;
            }
        }
        if (object.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    void createFileAndCacheIt(RemoteFileObject fileObject, FileName fileName) throws FileSystemException {
        FileObject fileFromCache = this.getFileFromCache(fileName);
        if (fileFromCache != null) {
            LOG.assertTrue(fileFromCache instanceof PlatformSftpFileObject, (Object)("File " + fileFromCache.getClass() + " in PlatformSftpFileSystem cache"));
            ((PlatformSftpFileObject)fileFromCache).updateFileObject(fileObject);
        } else {
            PlatformSftpFileObject vfsFileObject = new PlatformSftpFileObject(arg_0 -> ((SftpChannel)this.mySftpChannel).file(arg_0), fileName.getPath(), this, fileObject);
            this.putFileToCache((FileObject)vfsFileObject);
        }
    }

    protected PlatformSftpFileObject createImaginaryFile(@NotNull FileName fileName) throws FileSystemException {
        if (fileName == null) {
            PlatformSftpFileSystem.$$$reportNull$$$0(8);
        }
        RemoteFileObject fileObject = this.mySftpChannel.nonExistentFile(this.getPathPrefix() + fileName.getPath());
        FileObject fileFromCache = this.getFileFromCache(fileName);
        if (fileFromCache != null) {
            LOG.assertTrue(fileFromCache instanceof PlatformSftpFileObject, (Object)("Unexpected file " + fileFromCache.getClass() + " in PlatformSftpFileSystem cache"));
            PlatformSftpFileObject sftpFile = (PlatformSftpFileObject)fileFromCache;
            ((PlatformSftpFileObject)fileFromCache).updateFileObject(fileObject);
            return sftpFile;
        }
        PlatformSftpFileObject vfsFileObject = new PlatformSftpFileObject(arg_0 -> ((SftpChannel)this.mySftpChannel).file(arg_0), fileName.getPath(), this, fileObject);
        this.putFileToCache((FileObject)vfsFileObject);
        return vfsFileObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystemOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sftpChannel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeCommandOnRemoteHost";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/connections/platform/PlatformSftpFileSystem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/connections/platform/PlatformSftpFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCapabilities";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createImaginaryFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

