/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.ssh.ExecChannelConfig;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.ExecChannel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.connections.PatchedSftpClientFactory;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystemConfigBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.jetbrains.annotations.NotNull;

public class PatchedSftpFileSystem
extends SftpFileSystem {
    protected PatchedSftpFileSystem(GenericFileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, fileSystemOptions);
    }

    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            this.idleChannel.disconnect();
            this.idleChannel = null;
        }
    }

    protected ChannelSftp getChannel() throws IOException {
        try {
            ChannelSftp channel;
            if (this.idleChannel != null) {
                channel = this.idleChannel;
                this.idleChannel = null;
            } else {
                Class<?> decoratorClass = PlatformSftpFileSystemConfigBuilder.getInstance().getSftpChannelDecorator(this.getFileSystemOptions());
                SftpChannelConfig channelConfig = new SftpChannelConfig(decoratorClass, 0L, TimeUnit.SECONDS);
                channel = SshConnectionService.getInstance().sftp(this.createSessionConfig(), channelConfig).getRawChannel();
                String controlEncoding = PlatformSftpFileSystemConfigBuilder.getInstance().getControlEncoding(this.getFileSystemOptions());
                if (controlEncoding != null) {
                    try {
                        channel.setFilenameEncoding(controlEncoding);
                    }
                    catch (SftpException sftpException) {
                        // empty catch block
                    }
                }
                Boolean userDirIsRoot = PlatformSftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                String workingDirectory = this.getRootName().getPath();
                String homeFolderOverride = PlatformSftpFileSystemConfigBuilder.getInstance().getHomeFolderOverride(this.getFileSystemOptions());
                if (homeFolderOverride != null) {
                    workingDirectory = homeFolderOverride;
                }
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue())) {
                    try {
                        channel.cd(workingDirectory);
                    }
                    catch (SftpException e) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", (Object)workingDirectory, (Throwable)e);
                    }
                }
            }
            String fileNameEncoding = PlatformSftpFileSystemConfigBuilder.getInstance().getFileNameEncoding(this.getFileSystemOptions());
            if (fileNameEncoding != null) {
                try {
                    channel.setFilenameEncoding(fileNameEncoding);
                }
                catch (SftpException e) {
                    throw new FileSystemException("vfs.provider.sftp/filename-encoding.error", (Object)fileNameEncoding);
                }
            }
            return channel;
        }
        catch (SshTransportException e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)e);
        }
    }

    protected int executeCommand(String command, StringBuilder output) throws JSchException, IOException {
        ExecChannel channel = SshConnectionService.getInstance().exec(this.createSessionConfig(), ExecChannelConfig.Factory.create(command));
        PatchedSftpFileSystem.copy(channel.getInputStream(), output);
        while (!channel.isClosed()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        channel.disconnect();
        return channel.getExitStatus();
    }

    @NotNull
    private SessionConfig createSessionConfig() throws FileSystemException {
        SessionConfig sessionConfig;
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)this.getFileSystemOptions(), (UserAuthenticationData.Type[])SftpFileProvider.AUTHENTICATOR_TYPES);
            char[] username = UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, null);
            if (username == null) {
                throw new CustomFileSystemException(WDBundle.message("exception.username.is.not.provided", new Object[0]));
            }
            sessionConfig = PatchedSftpClientFactory.configConnection(this.getFileSystemOptions());
        }
        catch (Exception e) {
            try {
                throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.getRootName(), (Throwable)e);
            }
            catch (Throwable throwable) {
                UserAuthenticatorUtils.cleanup(authData);
                throw throwable;
            }
        }
        UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        SessionConfig sessionConfig2 = sessionConfig;
        if (sessionConfig2 == null) {
            PatchedSftpFileSystem.$$$reportNull$$$0(0);
        }
        return sessionConfig2;
    }

    private static void copy(InputStream input, StringBuilder output) throws IOException {
        try (InputStreamReader stream = new InputStreamReader(input, StandardCharsets.UTF_8);){
            int read;
            char[] buffer = new char[128];
            while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
                output.append(buffer, 0, read);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/connections/PatchedSftpFileSystem", "createSessionConfig"));
    }
}

