/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.conflicts;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotificationPanelCreator;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigurable;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteChangeNotifier {
    private static final Logger LOG = Logger.getInstance(RemoteChangeNotifier.class);
    private static final Key<JPanel> PANEL_KEY = Key.create((String)"remoteFilesConflictsPanel");
    private static final Key<Integer> VERSION_KEY = Key.create((String)"remoteFilesConflictsVersion");
    @NotNull
    private final Project myProject;
    private final Set<VirtualFile> myOpenFiles;
    private final AtomicInteger myFailureReported;
    private final Object LOCK;

    public static RemoteChangeNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(0);
        }
        return (RemoteChangeNotifier)project.getService(RemoteChangeNotifier.class);
    }

    private RemoteChangeNotifier(@NotNull Project project) {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(1);
        }
        this.myOpenFiles = new HashSet<VirtualFile>();
        this.myFailureReported = new AtomicInteger(0);
        this.LOCK = new Object();
        this.myProject = project;
    }

    private void projectOpened(final @NotNull Project project) {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(2);
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (PublishConfig.getInstance(project).isNotifyRemoteChanges() && source.getAllEditors(file).length == 0) {
                    RemoteChangeNotifier.this.myOpenFiles.remove(file);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (PublishConfig.getInstance(project).isNotifyRemoteChanges()) {
                    VirtualFile newFile = event.getNewFile();
                    if (newFile == null) {
                        return;
                    }
                    if (!newFile.isInLocalFileSystem()) {
                        return;
                    }
                    if (RemoteChangeNotifier.this.myOpenFiles.add(newFile)) {
                        RemoteChangeNotifier.this.updateNotifications(newFile);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void optionsChanged() {
                RemoteChangeNotifier.this.update(project);
            }

            @Override
            public void excludedPathsChanged() {
                RemoteChangeNotifier.this.update(project);
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)GroupedServersConfigManager.getInstance(project)).subscribe(WebDeploymentTopics.WEB_SERVER_CONFIGS, () -> this.update(project));
    }

    private void update(@NotNull Project project) {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(3);
        }
        for (VirtualFile file : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            this.updateNotifications(file);
        }
        if (!PublishConfig.getInstance(project).isNotifyRemoteChanges()) {
            this.myOpenFiles.clear();
        }
    }

    public void updateNotificationsForRemoteItem(@NotNull FileObject fileObject, PublishConfig config, Deployable serverConfig) throws FileSystemException {
        if (fileObject == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(4);
        }
        if (!RemoteChangeNotifier.serverIsUnderNotifications(serverConfig, config)) {
            return;
        }
        Pair<DeploymentPathMapping, Boolean> mappingPair = config.getNearestMappingDeploy2Local(fileObject, false, (Mappable)serverConfig);
        if (mappingPair.getFirst() != null) {
            FileObject source = ((DeploymentPathMapping)mappingPair.getFirst()).mapToLocalFile(fileObject, serverConfig);
            this.updateNotificationsForLocalItem(source);
        }
        Pair<List<DeploymentPathMapping>, Boolean> mappingCollectionPair = config.getChildMappingsDeploy2Local(fileObject, (Mappable)serverConfig);
        for (DeploymentPathMapping mapping : (List)mappingCollectionPair.getFirst()) {
            FileObject localRoot = DeploymentPathUtils.getLocalFile(mapping.getLocalPath());
            if (localRoot == null) continue;
            this.updateNotificationsForLocalItem(localRoot);
        }
    }

    public void updateNotificationsForLocalItem(@NotNull FileObject fileObject, @NotNull ExecutionContext context) throws FileSystemException {
        if (fileObject == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(5);
        }
        if (context == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(6);
        }
        if (!RemoteChangeNotifier.serverIsUnderNotifications(context.getServer(), context.getConfig())) {
            return;
        }
        this.updateNotificationsForLocalItem(fileObject);
    }

    private static boolean serverIsUnderNotifications(@NotNull Deployable server, @NotNull PublishConfig publishConfig) {
        if (server == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(7);
        }
        if (publishConfig == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(8);
        }
        if (!publishConfig.isNotifyRemoteChanges()) {
            return false;
        }
        Pair<WebServerGroupingWrap, WebServerConfig> defaultEntity = publishConfig.findDefaultServerOrGroup();
        if (defaultEntity == null) {
            return false;
        }
        if (defaultEntity.second != null) {
            return StringUtil.equals((CharSequence)server.getName(), (CharSequence)((WebServerConfig)defaultEntity.second).getName());
        }
        for (WebServerConfig defaultServer : ((WebServerGroupingWrap)defaultEntity.first).getServers()) {
            if (!StringUtil.equals((CharSequence)server.getName(), (CharSequence)defaultServer.getName())) continue;
            return true;
        }
        return false;
    }

    private void updateNotificationsForLocalItem(@NotNull FileObject fileObject) throws FileSystemException {
        VirtualFile fileByURL;
        if (fileObject == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(9);
        }
        if ((fileByURL = VfsUtil.findFileByURL((URL)fileObject.getURL())) != null) {
            this.updateNotifications(fileByURL);
        }
    }

    public void updateNotifications(@NotNull VirtualFile file, @NotNull PublishConfig publishConfig, @NotNull Deployable server) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(10);
        }
        if (publishConfig == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(11);
        }
        if (server == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(12);
        }
        if (!RemoteChangeNotifier.serverIsUnderNotifications(server, publishConfig)) {
            return;
        }
        this.updateNotifications(file);
    }

    private void updateNotifications(@NotNull VirtualFile file) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(13);
        }
        Runnable action = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            List<WebServerConfig> servers = PublishConfig.getInstance(this.myProject).findValidDefaultTransferableServers();
            if (servers.isEmpty()) {
                return;
            }
            final List deployables = ContainerUtil.map(servers, s -> Deployable.create(s, this.myProject));
            ArrayList<Object> files = new ArrayList<Object>();
            if (file.isDirectory()) {
                for (VirtualFile vFile : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)vFile, (boolean)false)) continue;
                    files.add(vFile);
                }
            } else if (FileEditorManager.getInstance((Project)this.myProject).isFileOpen(file)) {
                files.add(file);
            }
            for (final VirtualFile virtualFile : files) {
                String title = WDBundle.message("progress.title.for.change.notifier", virtualFile.getPresentableName());
                final int version = this.incAndGetNotificationVersion(virtualFile);
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true){
                    private final List myCreators;
                    {
                        super(arg0, arg1, arg2);
                        this.myCreators = new SmartList();
                    }

                    public void run(@NotNull ProgressIndicator pi) {
                        if (pi == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        for (Deployable deployable : deployables) {
                            RemoteChangeNotificationPanelCreator creator = RemoteChangeNotifier.this.getNotificationCreator(virtualFile, pi, deployable);
                            if (creator == null) continue;
                            this.myCreators.add(creator);
                        }
                    }

                    public void onCancel() {
                        if (RemoteChangeNotifier.this.myProject.isDisposed()) {
                            return;
                        }
                        for (int i = this.myCreators.size(); i < deployables.size(); ++i) {
                            Deployable deployable = (Deployable)deployables.get(i);
                            this.myCreators.add(new RemoteChangeNotificationPanelCreator.Cancel(virtualFile, RemoteChangeNotifier.this.myProject, PublishConfig.getInstance(RemoteChangeNotifier.this.myProject), deployable));
                        }
                        RemoteChangeNotifier.this.updateNotificationForAllEditors(virtualFile, this.myCreators, version);
                    }

                    public void onSuccess() {
                        RemoteChangeNotifier.this.updateNotificationForAllEditors(virtualFile, this.myCreators, version);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$3", "run"));
                    }
                });
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(action);
        } else {
            action.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationForAllEditors(@NotNull VirtualFile file, @NotNull List<RemoteChangeNotificationPanelCreator> creators, int version) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(14);
        }
        if (creators == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(15);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (version < this.getNotificationVersion(file) || this.myProject.isDisposed()) {
                return;
            }
            for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file)) {
                JPanel panel = null;
                if (!creators.isEmpty()) {
                    panel = new JPanel((LayoutManager)new GridLayoutManager(creators.size(), 1));
                    Color background = null;
                    for (int i = 0; i < creators.size(); ++i) {
                        GridConstraints constraints = new GridConstraints();
                        constraints.setRow(i);
                        constraints.setAnchor(8);
                        constraints.setFill(1);
                        EditorNotificationPanel editorPanel = creators.get(i).createPanel(editor);
                        if (background == null) {
                            background = editorPanel.getBackground();
                        }
                        panel.add((Component)editorPanel, constraints);
                    }
                    panel.setBackground(background);
                }
                this.updateNotificationForTheEditor(editor, panel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incAndGetNotificationVersion(VirtualFile file) {
        Object object = this.LOCK;
        synchronized (object) {
            Integer version = (Integer)file.getUserData(VERSION_KEY);
            version = version == null ? Integer.valueOf(0) : Integer.valueOf(version + 1);
            file.putUserData(VERSION_KEY, (Object)version);
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNotificationVersion(VirtualFile file) {
        Object object = this.LOCK;
        synchronized (object) {
            Integer version = (Integer)file.getUserData(VERSION_KEY);
            if (version == null) {
                version = 0;
                file.putUserData(VERSION_KEY, (Object)version);
            }
            return version;
        }
    }

    public void hideNotification(@NotNull FileEditor editor) {
        if (editor == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(16);
        }
        this.updateNotificationForTheEditor(editor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationForTheEditor(@NotNull FileEditor editor, @Nullable JPanel component) {
        if (editor == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(17);
        }
        Object object = this.LOCK;
        synchronized (object) {
            JPanel old = (JPanel)editor.getUserData(PANEL_KEY);
            if (old != null) {
                LOG.debug("old " + old);
                FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, (JComponent)old);
            }
            if (component != null) {
                LOG.debug("new " + component);
                FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, (JComponent)component);
                editor.putUserData(PANEL_KEY, (Object)component);
            } else {
                editor.putUserData(PANEL_KEY, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RemoteChangeNotificationPanelCreator getNotificationCreator(@NotNull VirtualFile file, @NotNull ProgressIndicator pi, @NotNull Deployable serverConfig) {
        if (file == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(18);
        }
        if (pi == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(19);
        }
        if (serverConfig == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(20);
        }
        if (!PublishConfig.getInstance(this.myProject).isNotifyRemoteChanges()) {
            return null;
        }
        assert (PublishConfig.getInstance(this.myProject).getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE);
        if (!serverConfig.needsTransfer() || serverConfig.validateFast() != null) {
            return null;
        }
        DeploymentRevisionTracker.Revision revision = ProjectDeploymentRevisionTracker.getInstance(this.myProject).getBaseRevision(file.getPath(), serverConfig);
        DeploymentPathMapping mapping = (DeploymentPathMapping)PublishConfig.getInstance(this.myProject).getNearestMappingForLocal(file.getPath(), false, true, false, (Mappable)serverConfig).getFirst();
        if (mapping == null) {
            return null;
        }
        WebServerConfig.RemotePath remotePath = mapping.mapToDeployPath(file.getPath(), (Mappable)serverConfig);
        for (ExcludedPath excludedPath : PublishConfig.getInstance(this.myProject).getExcludedPaths(serverConfig.getId())) {
            if (excludedPath.isLocal() || !excludedPath.isParentForRemotePath(remotePath, serverConfig)) continue;
            return null;
        }
        if (!AuthHelper.ensureAuthSpecified(serverConfig, this.myProject)) {
            return null;
        }
        Ref resultRef = new Ref();
        Ref exceptionRef = new Ref();
        RemoteConnection connection = null;
        try {
            RemoteConnection finalConnection = connection = RemoteConnectionManager.getInstance().openConnection(ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)this.myProject), WDBundle.message("browse.0", remotePath.path), (Connectable)serverConfig, FileTransferConfig.Origin.Default, null, pi);
            connection.executeServerOperation((ThrowableRunnable<? extends FileSystemException>)((ThrowableRunnable)() -> {
                FileObject remoteFile = PublishUtils.findFile(finalConnection, remotePath, (Connectable)serverConfig);
                if (remoteFile != null) {
                    remoteFile.refresh();
                    FileObject parent = remoteFile.getParent();
                    if (parent != null) {
                        parent.refresh();
                    }
                }
                if (pi.isCanceled()) {
                    return;
                }
                try {
                    if (remoteFile == null || !remoteFile.exists()) {
                        resultRef.set((Object)new RemoteChangeNotificationPanelCreator.Delete(file, serverConfig, this.myProject));
                        return;
                    }
                    if (pi.isCanceled()) {
                        return;
                    }
                    if (remoteFile.getContent().getSize() > DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
                        resultRef.set((Object)new RemoteChangeNotificationPanelCreator.TooLargeFile(file, serverConfig, this.myProject, remoteFile, mapping));
                        return;
                    }
                    if (pi.isCanceled() || this.myProject.isDisposed()) {
                        return;
                    }
                    if (!RemoteChangeNotifier.isRemoteFileChangedAndLocalFileDifferentFromRemote(this.myProject, remoteFile, file, serverConfig, revision, PublishConfig.getInstance(this.myProject).getPromptOnRemoteOverwrite(), pi)) {
                        LOG.debug("Changed: false; file: " + remoteFile.getName().getPath());
                        return;
                    }
                    LOG.debug("Changed: true; file: " + remoteFile.getName().getPath());
                    resultRef.set((Object)new RemoteChangeNotificationPanelCreator.Update(file, serverConfig, PublishConfig.getInstance(this.myProject), revision, this.myProject));
                }
                catch (IOException e) {
                    exceptionRef.set((Object)e);
                }
            }), pi);
        }
        catch (FileSystemException e) {
            int reports = this.myFailureReported.incrementAndGet();
            RemoteChangeNotifier.showErrorMessage(WDBundle.message("operation.failed", WDBundle.message("error.message.remote.file.0.loading", remotePath), PublishUtils.getMessage(e, true)), serverConfig, this.myProject, PublishConfig.getInstance(this.myProject), reports == 1);
            RemoteChangeNotifier.complainOnFailures(reports, this.myProject, serverConfig, PublishUtils.getMessage(e, true));
            PublishUtils.showLoginDialogAfterAuthFail(e, serverConfig);
            RemoteChangeNotificationPanelCreator remoteChangeNotificationPanelCreator = null;
            return remoteChangeNotificationPanelCreator;
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        if (!exceptionRef.isNull()) {
            IOException e = (IOException)exceptionRef.get();
            LOG.warn((Throwable)e);
            int reports = this.myFailureReported.incrementAndGet();
            RemoteChangeNotifier.showErrorMessage(WDBundle.message("failed.to.check.remote.file.0.1", remotePath.path, PublishUtils.getMessage(e, true)), serverConfig, this.myProject, PublishConfig.getInstance(this.myProject), reports == 1);
            RemoteChangeNotifier.complainOnFailures(reports, this.myProject, serverConfig, PublishUtils.getMessage(e, true));
            return null;
        }
        this.myFailureReported.set(0);
        return (RemoteChangeNotificationPanelCreator)resultRef.get();
    }

    private static boolean isRemoteFileChangedAndLocalFileDifferentFromRemote(@NotNull Project project, @NotNull FileObject remoteFile, @NotNull VirtualFile local, Deployable serverConfig, @Nullable DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(21);
        }
        if (remoteFile == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(22);
        }
        if (local == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(23);
        }
        if (baseRevision == null) {
            return !RemoteChangeNotifier.compareFilesAndCreateRevisionIfEqual(project, remoteFile, local, serverConfig, promptOnRemoteOverwrite, pi);
        }
        boolean remoteFileUnchanged = RemoteChangeNotifier.isFileEqualToRevision(remoteFile, serverConfig, baseRevision, promptOnRemoteOverwrite, pi);
        if (remoteFileUnchanged) {
            return false;
        }
        return !RemoteChangeNotifier.compareFilesAndCreateRevisionIfEqual(project, remoteFile, local, serverConfig, promptOnRemoteOverwrite, pi);
    }

    private static boolean compareFilesAndCreateRevisionIfEqual(Project project, FileObject remoteFile, VirtualFile local, Deployable serverConfig, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        FileObject localFile = DeploymentPathUtils.getLocalFile(local.getPath());
        if (localFile == null) {
            return false;
        }
        FileContent remoteFileContent = remoteFile.getContent();
        FileContent localFileContent = localFile.getContent();
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            boolean equal;
            boolean accurateTimestamp = serverConfig.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long currentRemoteTimestamp = remoteFileContent.getLastModifiedTime(accurateTimestamp);
            long currentLocalTimestamp = localFileContent.getLastModifiedTime(accurateTimestamp);
            boolean bl = equal = TransferOperation.areTimestampsEqual(currentLocalTimestamp, currentRemoteTimestamp, localFile.getFileSystem().getLastModTimeAccuracy() + remoteFile.getFileSystem().getLastModTimeAccuracy()) && localFileContent.getSize() == remoteFileContent.getSize();
            if (equal) {
                RemoteChangeNotifier.createRevision(project, local.getPath(), RemoteChangeNotifier.getContent(localFile, pi, true), currentRemoteTimestamp, serverConfig);
            }
            return equal;
        }
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_CONTENT) {
            byte[] localContent;
            if (remoteFileContent.getSize() != localFileContent.getSize()) {
                return false;
            }
            byte[] remoteContent = RemoteChangeNotifier.getContent(remoteFile, pi, false);
            boolean equal = Arrays.equals(remoteContent, localContent = RemoteChangeNotifier.getContent(localFile, pi, true));
            if (equal) {
                boolean accurateTimestamp = serverConfig.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                long currentRemoteTimestamp = remoteFileContent.getLastModifiedTime(accurateTimestamp);
                RemoteChangeNotifier.createRevision(project, local.getPath(), localContent, currentRemoteTimestamp, serverConfig);
            }
            return equal;
        }
        throw new IllegalStateException("PublishConfig.PromptOnRemoteOverwrite.NONE is not expected here");
    }

    public static byte[] getContent(FileObject file, ProgressIndicator pi, boolean isLocal) throws CustomFileSystemException {
        try {
            return FileTransferUtil.getContent(file, pi);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(WDBundle.message(isLocal ? "failed.to.load.local.file.0.content" : "failed.to.load.remote.file.0.content", file.getName().getPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void createRevision(@NotNull Project project, String path, byte @NotNull [] content, long timestamp, @NotNull Deployable deployable) throws IOException {
        void server;
        if (project == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(24);
        }
        if (deployable == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(25);
        }
        if (content == null) {
            RemoteChangeNotifier.$$$reportNull$$$0(26);
        }
        if ((long)content.length > DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
            LOG.warn("File " + path + "  is larger than " + DeploymentRevisionTrackerBase.MAX_FILE_SIZE + " bytes, its base revision will not be stored");
            return;
        }
        if (project.isDisposed()) {
            return;
        }
        LOG.debug("Creating revision for '" + path + "' from RemoteChangeNotifier");
        DeploymentRevisionTracker tracker = ProjectDeploymentRevisionTracker.getInstance(project);
        ThrowableComputable revisionFactory = () -> new DeploymentRevisionTracker.Revision(timestamp, content);
        tracker.putBaseRevision(path, server.clone(), (ThrowableComputable<? extends DeploymentRevisionTracker.Revision, ? extends IOException>)revisionFactory);
    }

    public static boolean isFileChanged(@Nullable FileObject source, Deployable serverConfig, @Nullable DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        if (source == null || !source.exists()) {
            return baseRevision != null;
        }
        if (baseRevision == null) {
            return true;
        }
        return !RemoteChangeNotifier.isFileEqualToRevision(source, serverConfig, baseRevision, promptOnRemoteOverwrite, pi);
    }

    public static boolean isFileEqualToRevision(FileObject source, DeploymentRevisionTracker.Revision baseRevision, ExecutionContext context) throws IOException {
        return RemoteChangeNotifier.isFileEqualToRevision(source, context.getServer(), baseRevision, context.getConfig().getPromptOnRemoteOverwrite(), context.getProgressIndicator());
    }

    private static boolean isFileEqualToRevision(FileObject source, Deployable serverConfig, DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        LOG.debug("source " + source.getName().getPath());
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            boolean accurateTimestamp = serverConfig.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long currentRemoteTimestamp = source.getContent().getLastModifiedTime(accurateTimestamp);
            LOG.debug("Timestamps\n local: " + source.getFileSystem().getLastModTimeAccuracy() + "\nremote: " + currentRemoteTimestamp + "\n revision: " + baseRevision.timestamp);
            return TransferOperation.areTimestampsEqual(baseRevision.timestamp, currentRemoteTimestamp, source.getFileSystem().getLastModTimeAccuracy()) && source.getContent().getSize() == (long)baseRevision.content.length;
        }
        return Arrays.equals(baseRevision.content, FileTransferUtil.getContent(source, pi));
    }

    private static void showErrorMessage(@NlsContexts.NotificationContent String message, Deployable serverConfig, Project project, PublishConfig config, boolean showBalloon) {
        if (project.isDisposed()) {
            return;
        }
        FileTransferToolWindow.printWithTimestamp(project, serverConfig, message, ConsoleViewContentType.ERROR_OUTPUT, config.getTraceLevel());
        if (showBalloon) {
            DeploymentNotifier.notifyWithBalloon(WDBundle.message("remote.files.merging", new Object[0]), message, NotificationType.ERROR, null, project, FileTransferToolWindow.ID_PROVIDER);
        }
    }

    private static void complainOnFailures(int number, final Project project, Deployable serverConfig, @NlsContexts.NotificationContent String failure) {
        if (number == 10 && !project.isDisposed()) {
            NotificationListener listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PublishOptionsConfigurable(project));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$4";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            DeploymentNotifier.notifyWithBalloon(WDBundle.message("constantly.fail.to.connect.to.server.0.maybe.configure.turn.off.auto.notification", serverConfig.getName()), failure, NotificationType.WARNING, listener, project, FileTransferToolWindow.ID_PROVIDER);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileObject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creators";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "projectOpened";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationsForRemoteItem";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationsForLocalItem";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "serverIsUnderNotifications";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotifications";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationForAllEditors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "hideNotification";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "updateNotificationForTheEditor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotificationCreator";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "isRemoteFileChangedAndLocalFileDifferentFromRemote";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "createRevision";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyStartupActivity
    implements StartupActivity.DumbAware {
        MyStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            RemoteChangeNotifier.getInstance(project).projectOpened(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$MyStartupActivity", "runActivity"));
        }
    }
}

