/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.ServerBaseDeployable;
import com.jetbrains.plugins.webDeployment.config.ServerPasswordSafeDeployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import javax.swing.Icon;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Deployable
extends Connectable,
Mappable {
    @NlsSafe
    public String getRootNodePresentableDescription(boolean var1);

    public boolean isPassMemoryOnly();

    @Override
    @NotNull
    default public Icon getIcon() {
        Icon icon = this.getAccessType().getIcon();
        if (icon == null) {
            Deployable.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    @NotNull
    public Deployable clone();

    @Override
    @NotNull
    public Deployable copyToImmutable();

    @NotNull
    public WebServerConfig computeWebServerConfig();

    default public void copyToCredentials(MutableRemoteCredentials remoteCredentials) {
        String pass;
        remoteCredentials.setHost(this.getHost());
        remoteCredentials.setLiteralPort(this.getLiteralPort());
        if (this.isAnonymous()) {
            remoteCredentials.setUserName("anonymous");
            remoteCredentials.setPassword("user@example.com");
            remoteCredentials.setStorePassword(true);
        }
        remoteCredentials.setAuthType(this.getAuthType());
        remoteCredentials.setPrivateKeyFile(this.getPrivateKeyFile());
        Credentials credentials = this.getCredentials();
        remoteCredentials.setUserName(credentials == null ? null : credentials.getUserName());
        boolean store = !this.isPassMemoryOnly();
        String string = pass = credentials == null ? null : credentials.getPasswordAsString();
        if (this.getAuthType() == AuthType.KEY_PAIR) {
            remoteCredentials.setPassword(null);
            remoteCredentials.setStorePassword(false);
            remoteCredentials.setPassphrase(pass);
            remoteCredentials.setStorePassphrase(store);
        } else if (this.getAuthType() == AuthType.OPEN_SSH) {
            remoteCredentials.setPassword(null);
            remoteCredentials.setStorePassword(false);
            remoteCredentials.setPassphrase(null);
            remoteCredentials.setStorePassphrase(false);
        } else {
            remoteCredentials.setPassphrase(null);
            remoteCredentials.setStorePassphrase(false);
            remoteCredentials.setPassword(pass);
            remoteCredentials.setStorePassword(store);
        }
    }

    @Contract(value="null,_->null;!null,_->!null")
    public static Deployable create(@Nullable WebServerConfig serverConfig, @Nullable Project project) {
        if (serverConfig == null) {
            return null;
        }
        SshUiData data = serverConfig.getOrCreateSshUiData(project);
        return new ServerPasswordSafeDeployable(serverConfig, data);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Contract(value="null->null;!null->!null")
    public static Deployable create(@Nullable WebServerConfig serverConfig) {
        if (serverConfig == null) {
            return null;
        }
        return new ServerPasswordSafeDeployable(serverConfig, null);
    }

    public static String getDebugDescription(@NotNull Deployable deployable, @NotNull XMLOutputter outputter) {
        if (deployable == null) {
            Deployable.$$$reportNull$$$0(1);
        }
        if (outputter == null) {
            Deployable.$$$reportNull$$$0(2);
        }
        @NonNls String message = "Server config: " + deployable.getClass();
        if (deployable instanceof ServerBaseDeployable) {
            message = message + "\n" + outputter.outputString(XmlSerializer.serialize((Object)((ServerBaseDeployable)deployable).getServer()));
        }
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/Deployable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/Deployable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDebugDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

