/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.ui.ProductIcons;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.FileChooserStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.SpecifyLocalPathStep;
import com.jetbrains.plugins.webDeployment.ui.UiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeploymentFileChooserDialog
extends FileChooserDialogImpl {
    private final EventDispatcher<StateChangeListener> myEventDispatcher;
    private TreePath myProjectRootPath;
    private final MultiMap<String, TreePath> myActionPaths;
    private final VirtualFile myToSelect;

    DeploymentFileChooserDialog(@NotNull FileChooserDescriptor descriptor, @Nullable Project project) {
        if (descriptor == null) {
            DeploymentFileChooserDialog.$$$reportNull$$$0(0);
        }
        super(descriptor, project);
        this.myEventDispatcher = EventDispatcher.create(StateChangeListener.class);
        this.myActionPaths = new MultiMap();
        String baseDir = SpecifyLocalPathStep.getDefaultBaseDir();
        this.myToSelect = baseDir == null ? null : LocalFileSystem.getInstance().findFileByPath(baseDir);
    }

    public JComponent getTitlePane() {
        return this.createTitlePane();
    }

    public JComponent createCenterPanel() {
        JComponent panel = super.createCenterPanel();
        this.restoreSelection(this.myToSelect);
        return panel;
    }

    @Nullable
    public VirtualFile getProjectRoot() {
        if (this.myProjectRootPath != null) {
            return FileSystemTreeImpl.getVirtualFile((TreePath)this.myProjectRootPath);
        }
        VirtualFile[] path = this.myFileSystemTree.getSelectedFiles();
        if (path.length == 1) {
            return path[0];
        }
        return null;
    }

    @Nullable
    protected JPanel createExtraToolbarPanel() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        JTree tree = this.myFileSystemTree.getTree();
        SetRootFolderAction setRootFolderAction = new SetRootFolderAction();
        actionGroup.add((AnAction)setRootFolderAction);
        setRootFolderAction.registerCustomShortcutSet(setRootFolderAction.getShortcutSet(), tree, this.myDisposable);
        for (ActionTypeDescription.Local description : FileChooserStep.LOCAL_ACTION_TYPE_DESCRIPTIONS) {
            ParametrizedAction action = new ParametrizedAction(description);
            actionGroup.add((AnAction)action);
            action.registerCustomShortcutSet(action.getShortcutSet(), tree, this.myDisposable);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("WebDeploymentFileChooser", (ActionGroup)actionGroup, true);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolbar.getComponent(), "Center");
        return toolbarPanel;
    }

    protected JTree createTree() {
        super.createTree();
        NodeRenderer renderer = new NodeRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                TreePath path = tree.getPathForRow(row);
                if (path == null) {
                    return;
                }
                for (ActionTypeDescription.Local desc : FileChooserStep.LOCAL_ACTION_TYPE_DESCRIPTIONS) {
                    if (!DeploymentFileChooserDialog.this.isActionApplied(desc, path)) continue;
                    this.setIcon(desc.closedIcon);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$1", "customizeCellRenderer"));
            }
        };
        this.myFileSystemTree.addListener(new FileSystemTree.Listener(){

            public void selectionChanged(@NotNull List<? extends VirtualFile> selection) {
                if (selection == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((StateChangeListener)DeploymentFileChooserDialog.this.myEventDispatcher.getMulticaster()).stateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$2", "selectionChanged"));
            }
        }, this.myDisposable);
        JTree tree = this.myFileSystemTree.getTree();
        tree.setCellRenderer((TreeCellRenderer)renderer);
        tree.setOpaque(false);
        return tree;
    }

    @NotNull
    protected Tree createInternalTree() {
        return new Tree(){

            @Nullable
            public Color getFileColorForPath(@NotNull TreePath path) {
                if (path == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (DeploymentFileChooserDialog.this.isMapped(path)) {
                    return UiConstants.MAPPED_BACKGROUND;
                }
                return super.getFileColorForPath(path);
            }

            public boolean isFileColorsEnabled() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$3", "getFileColorForPath"));
            }
        };
    }

    protected void createDefaultActions() {
        DialogWrapper.DialogWrapperAction disabledAction = new DialogWrapper.DialogWrapperAction(""){

            public boolean isEnabled() {
                return false;
            }

            protected void doAction(ActionEvent e) {
            }
        };
        this.myOKAction = disabledAction;
        this.myCancelAction = disabledAction;
        this.myHelpAction = disabledAction;
    }

    private boolean isMapped(@NotNull TreePath path) {
        if (path == null) {
            DeploymentFileChooserDialog.$$$reportNull$$$0(1);
        }
        if (!this.isUnderRoot(path)) {
            return false;
        }
        for (TreePath excluded : this.myActionPaths.get((Object)ActionTypeDescription.LOCAL_EXCLUDE_FOLDERS_ACTION_DESCRIPTION.key)) {
            if (!path.isDescendant(excluded)) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public MultiMap<String, VirtualFile> getActionPaths() {
        MultiMap map = new MultiMap();
        for (Map.Entry entry : this.myActionPaths.entrySet()) {
            @NotNull List files = ContainerUtil.mapNotNull((Collection)((Collection)entry.getValue()), path -> FileSystemTreeImpl.getVirtualFile((TreePath)path));
            map.put((Object)((String)entry.getKey()), (Collection)files);
        }
        return map;
    }

    public void addListener(StateChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private boolean isUnderRoot(TreePath ... paths) {
        if (this.myProjectRootPath == null || paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            if (path != null && this.myProjectRootPath.isDescendant(path)) continue;
            return false;
        }
        return true;
    }

    private boolean isActionApplied(ActionTypeDescription.Local desc, TreePath ... paths) {
        if (desc.isRecursive) {
            for (TreePath path : paths) {
                boolean found = false;
                for (TreePath remotePath : this.myActionPaths.get((Object)desc.key)) {
                    if (!remotePath.isDescendant(path)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else {
            for (TreePath path : paths) {
                if (this.myActionPaths.get((Object)desc.key).contains(path)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMapped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class ParametrizedAction
    extends ToggleAction
    implements DumbAware {
        private final ActionTypeDescription.Local myDescription;

        private ParametrizedAction(ActionTypeDescription.Local description) {
            super(description.title, description.description, description.closedIcon);
            this.myDescription = description;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(description.keystroke, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            boolean underRoot = DeploymentFileChooserDialog.this.isUnderRoot(DeploymentFileChooserDialog.this.myFileSystemTree.getTree().getSelectionPaths());
            e.getPresentation().setEnabled(underRoot);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TreePath[] paths;
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(1);
            }
            if (!DeploymentFileChooserDialog.this.isUnderRoot(paths = DeploymentFileChooserDialog.this.myFileSystemTree.getTree().getSelectionPaths())) {
                return false;
            }
            return DeploymentFileChooserDialog.this.isActionApplied(this.myDescription, paths);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            block9: {
                TreePath[] selectionPaths;
                block8: {
                    TreeModel model;
                    if (e == null) {
                        ParametrizedAction.$$$reportNull$$$0(2);
                    }
                    if ((selectionPaths = DeploymentFileChooserDialog.this.myFileSystemTree.getTree().getSelectionPaths()) == null) {
                        return;
                    }
                    if (state) {
                        Collection paths = DeploymentFileChooserDialog.this.myActionPaths.get((Object)this.myDescription.key);
                        for (TreePath path : selectionPaths) {
                            if (paths.contains(path)) continue;
                            DeploymentFileChooserDialog.this.myActionPaths.putValue((Object)this.myDescription.key, (Object)path);
                        }
                    } else {
                        for (TreePath path : selectionPaths) {
                            DeploymentFileChooserDialog.this.myActionPaths.remove((Object)this.myDescription.key, (Object)path);
                        }
                    }
                    if (!((model = DeploymentFileChooserDialog.this.myFileSystemTree.getTree().getModel()) instanceof AsyncTreeModel)) break block8;
                    for (TreePath path : selectionPaths) {
                        ((AsyncTreeModel)model).treeStructureChanged(path);
                    }
                    break block9;
                }
                AbstractTreeBuilder builder = DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder();
                if (builder == null) break block9;
                for (TreePath path : selectionPaths) {
                    builder.queueUpdateFrom((Object)FileSystemTreeImpl.getVirtualFile((TreePath)path), false, false);
                }
            }
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$ParametrizedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class SetRootFolderAction
    extends ToggleAction
    implements DumbAware {
        private SetRootFolderAction() {
            super(WDBundle.message("project.root.action.text", new Object[0]), WDBundle.message("project.root.action.description", new Object[0]), ProductIcons.getInstance().getProjectIcon());
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(74, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles().length == 1);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TreePath[] selectionPaths;
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(1);
            }
            if ((selectionPaths = DeploymentFileChooserDialog.this.myFileSystemTree.getTree().getSelectionPaths()) == null || selectionPaths.length != 1) {
                return false;
            }
            return selectionPaths[0].equals(DeploymentFileChooserDialog.this.myProjectRootPath);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            TreePath[] selectionPaths;
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(2);
            }
            if ((selectionPaths = DeploymentFileChooserDialog.this.myFileSystemTree.getTree().getSelectionPaths()) == null || selectionPaths.length != 1) {
                return;
            }
            TreePath oldRootPath = DeploymentFileChooserDialog.this.myProjectRootPath;
            DeploymentFileChooserDialog.this.myProjectRootPath = state ? selectionPaths[0] : null;
            TreeModel model = DeploymentFileChooserDialog.this.myFileSystemTree.getTree().getModel();
            if (model instanceof AsyncTreeModel) {
                if (oldRootPath != null) {
                    ((AsyncTreeModel)model).treeStructureChanged(oldRootPath);
                    if (DeploymentFileChooserDialog.this.myProjectRootPath != null) {
                        DeploymentFileChooserDialog.this.myFileSystemTree.expand(FileSystemTreeImpl.getVirtualFile((TreePath)DeploymentFileChooserDialog.this.myProjectRootPath), null);
                    }
                }
                if (DeploymentFileChooserDialog.this.myProjectRootPath != null) {
                    ((AsyncTreeModel)model).treeStructureChanged(DeploymentFileChooserDialog.this.myProjectRootPath);
                }
            } else {
                AbstractTreeBuilder builder = DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder();
                if (builder != null) {
                    if (oldRootPath != null) {
                        builder.queueUpdateFrom((Object)FileSystemTreeImpl.getVirtualFile((TreePath)oldRootPath), false);
                    }
                    if (DeploymentFileChooserDialog.this.myProjectRootPath != null) {
                        builder.queueUpdateFrom((Object)FileSystemTreeImpl.getVirtualFile((TreePath)DeploymentFileChooserDialog.this.myProjectRootPath), false);
                    }
                }
            }
            ((StateChangeListener)DeploymentFileChooserDialog.this.myEventDispatcher.getMulticaster()).stateChanged();
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$SetRootFolderAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface StateChangeListener
    extends EventListener {
        public void stateChanged();
    }
}

