/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter.trailingComma;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContextKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u0004\u0018\u00010\b*\u00020\bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaHelper;", "", "()V", "LEFT_BARRIERS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "RIGHT_BARRIERS", "lastSignificantChild", "Lcom/intellij/psi/PsiElement;", "getLastSignificantChild", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "elementAfterLastElement", "commaOwner", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementBeforeFirstElement", "findInvalidCommas", "", "lineBreakIsMissing", "", "trailingCommaExists", "trailingCommaExistsOrCanExist", "psiElement", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "trailingCommaOrLastElement", "takeIfIsNotError", "kotlin.formatter"})
public final class TrailingCommaHelper {
    private static final TokenSet RIGHT_BARRIERS;
    private static final TokenSet LEFT_BARRIERS;
    @NotNull
    public static final TrailingCommaHelper INSTANCE;

    @NotNull
    public final List<PsiElement> findInvalidCommas(@NotNull KtElement commaOwner) {
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        PsiElement psiElement = commaOwner.getFirstChild();
        List list = psiElement != null && (psiElement = PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)1, null)) != null && (psiElement = SequencesKt.filter((Sequence)psiElement, (Function1)findInvalidCommas.1.INSTANCE)) != null && (psiElement = SequencesKt.filter((Sequence)psiElement, (Function1)findInvalidCommas.2.INSTANCE)) != null ? SequencesKt.toList((Sequence)psiElement) : null;
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean trailingCommaExistsOrCanExist(@NotNull PsiElement psiElement, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return TrailingCommaContextKt.commaExistsOrMayExist(TrailingCommaContext.Companion.create(psiElement), CodeStyleUtilsKt.getKotlinCustomSettings(settings));
    }

    public final boolean trailingCommaExists(@NotNull KtElement commaOwner) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        KtElement ktElement = commaOwner;
        if (ktElement instanceof KtFunctionLiteral) {
            KtParameterList ktParameterList = ((KtFunctionLiteral)commaOwner).getValueParameterList();
            bl = (ktParameterList != null ? ktParameterList.getTrailingComma() : null) != null;
        } else if (ktElement instanceof KtWhenEntry) {
            bl = ((KtWhenEntry)commaOwner).getTrailingComma() != null;
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            bl = ((KtDestructuringDeclaration)commaOwner).getTrailingComma() != null;
        } else {
            PsiElement psiElement = this.trailingCommaOrLastElement(commaOwner);
            bl = psiElement != null && FormatterUtilKt.isComma(psiElement);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PsiElement trailingCommaOrLastElement(@NotNull KtElement commaOwner) {
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        PsiElement psiElement = this.getLastSignificantChild((PsiElement)commaOwner);
        if (psiElement == null) return null;
        PsiElement lastChild = psiElement;
        IElementType iElementType = PsiUtil.getElementType((PsiElement)lastChild);
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.COMMA)) {
            return lastChild;
        }
        boolean withSelf = !RIGHT_BARRIERS.contains(iElementType);
        PsiElement psiElement3 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)lastChild, (boolean)withSelf);
        psiElement3 = psiElement3;
        if (psiElement2 == null) return null;
        iElementType = psiElement3;
        boolean bl = false;
        boolean bl2 = false;
        IElementType it = iElementType;
        boolean bl3 = false;
        if (LEFT_BARRIERS.contains(PsiUtil.getElementType((PsiElement)it))) return null;
        boolean bl4 = true;
        if (!bl4) return null;
        IElementType iElementType2 = iElementType;
        psiElement3 = iElementType2;
        if (iElementType2 == null) return null;
        PsiElement psiElement4 = this.takeIfIsNotError(psiElement3);
        return psiElement4;
    }

    public final boolean lineBreakIsMissing(@NotNull KtElement commaOwner) {
        PsiElement last;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        if (!this.trailingCommaExists(commaOwner)) {
            return false;
        }
        PsiElement first = this.elementBeforeFirstElement(commaOwner);
        PsiElement psiElement2 = first;
        if (psiElement2 != null && (psiElement2 = PsiUtilsKt.nextLeaf((PsiElement)psiElement2, (boolean)true)) != null) {
            if (!FormatterUtilKt.isLineBreak(psiElement2)) {
                return true;
            }
        }
        return (psiElement = (last = this.elementAfterLastElement(commaOwner))) != null && (psiElement = PsiUtilsKt.prevLeaf((PsiElement)psiElement, (boolean)true)) != null && !FormatterUtilKt.isLineBreak(psiElement);
    }

    @Nullable
    public final PsiElement elementBeforeFirstElement(@NotNull KtElement commaOwner) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        KtElement ktElement = commaOwner;
        if (ktElement instanceof KtParameterList) {
            PsiElement parent = ((KtParameterList)commaOwner).getParent();
            object = parent instanceof KtFunctionLiteral ? ((KtFunctionLiteral)parent).getLBrace() : ((KtParameterList)commaOwner).getLeftParenthesis();
        } else if (ktElement instanceof KtWhenEntry) {
            PsiElement $this$cast$iv = ((KtWhenEntry)commaOwner).getParent();
            boolean $i$f$cast = false;
            PsiElement psiElement = $this$cast$iv;
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
            }
            object = ((KtWhenExpression)psiElement).getOpenBrace();
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            object = ((KtDestructuringDeclaration)commaOwner).getLPar();
        } else {
            PsiElement psiElement = commaOwner.getFirstChild();
            object = psiElement != null ? this.takeIfIsNotError(psiElement) : null;
        }
        return object;
    }

    @Nullable
    public final PsiElement elementAfterLastElement(@NotNull KtElement commaOwner) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)commaOwner, (String)"commaOwner");
        KtElement ktElement = commaOwner;
        if (ktElement instanceof KtParameterList) {
            PsiElement parent = ((KtParameterList)commaOwner).getParent();
            object = parent instanceof KtFunctionLiteral ? ((KtFunctionLiteral)parent).getArrow() : ((KtParameterList)commaOwner).getRightParenthesis();
        } else if (ktElement instanceof KtWhenEntry) {
            object = ((KtWhenEntry)commaOwner).getArrow();
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            object = ((KtDestructuringDeclaration)commaOwner).getRPar();
        } else {
            PsiElement psiElement = commaOwner.getLastChild();
            object = psiElement != null ? this.takeIfIsNotError(psiElement) : null;
        }
        return object;
    }

    private final PsiElement takeIfIsNotError(PsiElement $this$takeIfIsNotError) {
        PsiElement psiElement = $this$takeIfIsNotError;
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        return !(it instanceof PsiErrorElement) ? psiElement : null;
    }

    private final PsiElement getLastSignificantChild(PsiElement $this$lastSignificantChild) {
        PsiElement psiElement = $this$lastSignificantChild;
        return psiElement instanceof KtWhenEntry ? ((KtWhenEntry)$this$lastSignificantChild).getArrow() : (psiElement instanceof KtDestructuringDeclaration ? ((KtDestructuringDeclaration)$this$lastSignificantChild).getRPar() : $this$lastSignificantChild.getLastChild());
    }

    private TrailingCommaHelper() {
    }

    static {
        TrailingCommaHelper trailingCommaHelper;
        INSTANCE = trailingCommaHelper = new TrailingCommaHelper();
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.RBRACKET, (IElementType)KtTokens.RPAR, (IElementType)KtTokens.RBRACE, (IElementType)KtTokens.GT, (IElementType)KtTokens.ARROW});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(KtTokens\u2026okens.GT, KtTokens.ARROW)");
        RIGHT_BARRIERS = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KtTokens.LBRACKET, (IElementType)KtTokens.LPAR, (IElementType)KtTokens.LBRACE, (IElementType)KtTokens.LT});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"TokenSet.create(KtTokens\u2026kens.LBRACE, KtTokens.LT)");
        LEFT_BARRIERS = tokenSet2;
    }
}

