/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.Revision;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RevisionType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class Archive {
    public static HostConfig sHostConfig = new HostConfig();

    public boolean isCompatible() {
        if (this.getHostOs() != null && !this.getHostOs().equals(sHostConfig.mOs)) {
            return false;
        }
        if (this.getJvmBits() != null && this.getJvmBits() != sHostConfig.mJvmBits) {
            return false;
        }
        if (this.getHostBits() != null && this.getHostBits() != sHostConfig.mHostBits) {
            return false;
        }
        return this.getMinJvmVersion() == null || this.getMinJvmVersion().toRevision().compareTo(sHostConfig.mJvmVersion) <= 0;
    }

    public abstract CompleteType getComplete();

    public void setComplete(CompleteType complete) {
    }

    public Integer getHostBits() {
        return null;
    }

    public void setHostBits(Integer bits) {
    }

    public Integer getJvmBits() {
        return null;
    }

    public void setJvmBits(Integer bits) {
    }

    public String getHostOs() {
        return null;
    }

    public void setHostOs(String os) {
    }

    public List<PatchType> getAllPatches() {
        PatchesType patches = this.getPatches();
        if (patches == null) {
            return ImmutableList.of();
        }
        return patches.getPatch();
    }

    public PatchType getPatch(Revision fromRevision) {
        for (PatchType p : this.getAllPatches()) {
            if (!p.getBasedOn().toRevision().equals(fromRevision)) continue;
            return p;
        }
        return null;
    }

    protected PatchesType getPatches() {
        return null;
    }

    protected void setPatches(PatchesType patches) {
    }

    public RevisionType getMinJvmVersion() {
        return null;
    }

    public void setMinJvmVersion(RevisionType revision) {
    }

    public abstract CommonFactory createFactory();

    @XmlTransient
    public static abstract class PatchesType {
        public List<PatchType> getPatch() {
            return ImmutableList.of();
        }
    }

    @XmlTransient
    public static abstract class PatchType
    extends ArchiveFile {
        public abstract RevisionType getBasedOn();

        public void setBasedOn(RevisionType revision) {
        }
    }

    @XmlTransient
    public static abstract class CompleteType
    extends ArchiveFile {
    }

    public static abstract class ArchiveFile {
        public abstract String getChecksum();

        public void setChecksum(String checksum) {
        }

        public abstract String getUrl();

        public void setUrl(String url) {
        }

        public abstract long getSize();

        public void setSize(long size) {
        }
    }

    @XmlTransient
    public static final class HostConfig {
        private static final String OS_OVERRIDE_ENV_VAR = "REPO_OS_OVERRIDE";
        private final int mJvmBits;
        private final int mHostBits;
        private final String mOs;
        private final Revision mJvmVersion;

        public HostConfig() {
            this(HostConfig.detectOs());
        }

        public HostConfig(String os) {
            this.mOs = os;
            this.mJvmBits = HostConfig.detectJvmBits();
            this.mHostBits = HostConfig.detectHostBits(this.mJvmBits);
            this.mJvmVersion = HostConfig.detectJvmRevision();
        }

        private static String detectOs() {
            String os = System.getenv(OS_OVERRIDE_ENV_VAR);
            if (os == null) {
                os = System.getProperty("os.name");
            }
            if (os.startsWith("Mac")) {
                os = "macosx";
            } else if (os.startsWith("Windows")) {
                os = "windows";
            } else if (os.startsWith("Linux")) {
                os = "linux";
            }
            return os;
        }

        private static int detectJvmBits() {
            String arch = System.getProperty("os.arch");
            int jvmBits = arch.equalsIgnoreCase("x86_64") || arch.equalsIgnoreCase("ia64") || arch.equalsIgnoreCase("aarch64") || arch.equalsIgnoreCase("amd64") ? 64 : 32;
            return jvmBits;
        }

        private static int detectHostBits(int jvmBits) {
            return jvmBits;
        }

        private static Revision detectJvmRevision() {
            Revision minJvmVersion = null;
            String javav = System.getProperty("java.version");
            Pattern p = Pattern.compile("((\\d+)(\\.\\d+)?(\\.\\d+)?).*");
            Matcher m = p.matcher(javav);
            if (m.matches()) {
                minJvmVersion = Revision.parseRevision(m.group(1));
            }
            return minJvmVersion;
        }
    }
}

