/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.services;

import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.view.services.DockerContainerItem;
import com.intellij.docker.view.services.DockerNewServiceContributor;
import com.intellij.docker.view.services.DockerServerItem;
import com.intellij.docker.view.services.DockerServiceGroup;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DockerRuntimeItemBase {
    protected static final Logger LOG = Logger.getInstance(DockerContainerItem.class);
    private final DockerServerItem myServer;
    private DockerPhysicalRuntime myRuntime;

    DockerRuntimeItemBase(@NotNull DockerServerItem server, @NotNull DockerPhysicalRuntime runtime) {
        if (server == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(0);
        }
        if (runtime == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(1);
        }
        this.myServer = server;
        this.myRuntime = runtime;
    }

    @Nullable
    protected abstract DockerServiceGroup getGroup();

    @NotNull
    protected abstract ServiceViewDescriptor createViewDescriptor();

    @NotNull
    abstract String getUniqueId();

    protected final void replaceRuntime(@NotNull DockerPhysicalRuntime newRuntime) {
        if (newRuntime == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(2);
        }
        this.myRuntime = newRuntime;
    }

    @NotNull
    protected DockerPhysicalRuntime getRuntime() {
        DockerPhysicalRuntime dockerPhysicalRuntime = this.myRuntime;
        if (dockerPhysicalRuntime == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(3);
        }
        return dockerPhysicalRuntime;
    }

    @NotNull
    protected final DockerServerItem getServerItem() {
        DockerServerItem dockerServerItem = this.myServer;
        if (dockerServerItem == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(4);
        }
        return dockerServerItem;
    }

    @NlsSafe
    final String getPresentableName() {
        return StringUtil.notNullize((String)this.getRuntime().getPresentableName());
    }

    protected final void refreshRuntime(@NotNull DockerServerRuntimeInstance docker, @NotNull DockerEvent event, boolean containerNotImage) {
        if (docker == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(5);
        }
        if (event == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(6);
        }
        ((CompletableFuture)docker.findRuntimeLater(this.getUniqueId(), containerNotImage).thenAcceptAsync(newRuntime -> {
            if (newRuntime == null) {
                LOG.warn("Docker container event without existing container: " + event);
                this.getServerItem().forgetChild(this);
            } else {
                this.replaceRuntime((DockerPhysicalRuntime)((Object)newRuntime));
                this.getServerItem().broadcast(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)this, DockerNewServiceContributor.class));
            }
        })).exceptionally(ex -> DockerRuntimeItemBase.logException(event, ex));
    }

    @Nullable
    static Void logException(@NotNull DockerEvent event, @NotNull Throwable ex) {
        if (event == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(7);
        }
        if (ex == null) {
            DockerRuntimeItemBase.$$$reportNull$$$0(8);
        }
        LOG.warn("Failed to process event: " + event, ex);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRuntime";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/services/DockerRuntimeItemBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docker";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/services/DockerRuntimeItemBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntime";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceRuntime";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshRuntime";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

