/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0015J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010 \u001a\u0004\u0018\u00010\u00112\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020#0\"H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00112\u0006\u0010&\u001a\u00020\u0019H\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110(H\u0016J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0019H\u0017J\b\u0010*\u001a\u00020\u0015H\u0007J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001bH\u0007J\u0010\u0010,\u001a\u00020\u00002\b\b\u0001\u0010-\u001a\u00020\u001bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/intellij/docker/view/details/TabManagerImpl;", "Lcom/intellij/docker/view/details/ITabManager;", "project", "Lcom/intellij/openapi/project/Project;", "deployment", "Lcom/intellij/remoteServer/runtime/Deployment;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/remoteServer/runtime/Deployment;)V", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "getContentManager", "()Lcom/intellij/ui/content/ContentManager;", "getDeployment", "()Lcom/intellij/remoteServer/runtime/Deployment;", "myLock", "Ljava/lang/Object;", "myTabs", "", "Lcom/intellij/docker/view/details/DockerDetailsTab;", "getProject", "()Lcom/intellij/openapi/project/Project;", "aboutToShow", "", "addTab", "tab", "contentByDisplayName", "Lcom/intellij/ui/content/Content;", "displayName", "", "disposeTabs", "findDefaultContentIndex", "", "findFirstReadyTab", "findTab", "condition", "Lkotlin/Function1;", "", "tabDisplayName", "findTabForContent", "content", "getTabs", "", "insertTabContent", "refreshTabs", "selectDetailsTab", "withHelpTopicId", "topicId", "MyContentManager", "intellij.clouds.docker"})
public final class TabManagerImpl
implements ITabManager {
    @NotNull
    private final ContentManager contentManager;
    private final Object myLock;
    private final List<DockerDetailsTab> myTabs;
    @NotNull
    private final Project project;
    @NotNull
    private final Deployment deployment;

    @Override
    @NotNull
    public ContentManager getContentManager() {
        return this.contentManager;
    }

    @Override
    @NotNull
    public List<DockerDetailsTab> getTabs() {
        return CollectionsKt.toList((Iterable)this.myTabs);
    }

    @NotNull
    public final TabManagerImpl withHelpTopicId(@NonNls @NotNull String topicId) {
        Intrinsics.checkNotNullParameter((Object)topicId, (String)"topicId");
        DataManager.registerDataProvider((JComponent)this.getContentManager().getComponent(), (DataProvider)new DataProvider(topicId){
            final /* synthetic */ String $topicId;

            @Nullable
            public final Object getData(@NotNull String dataId) {
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                return PlatformDataKeys.HELP_ID.is(dataId) ? this.$topicId : null;
            }
            {
                this.$topicId = string;
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public void insertTabContent(@NotNull DockerDetailsTab tab, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.getContentManager().addContent(content, this.findDefaultContentIndex(tab));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTab(@NotNull DockerDetailsTab tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Boolean bl3;
            boolean bl4 = false;
            if (tab.getPreferredPosition() != null) {
                int tabPosition = tab.getPreferredPosition() < 0 ? 0 : (tab.getPreferredPosition() > this.myTabs.size() ? this.myTabs.size() : tab.getPreferredPosition().intValue());
                this.myTabs.add(tabPosition, tab);
                bl3 = Unit.INSTANCE;
            } else {
                bl3 = this.myTabs.add(tab);
            }
            Boolean bl5 = bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DockerDetailsTab findTab(@NotNull Function1<? super DockerDetailsTab, Boolean> condition) {
        DockerDetailsTab dockerDetailsTab;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Object v0;
            block4: {
                boolean bl3 = false;
                Iterable iterable = this.myTabs;
                Function1<? super DockerDetailsTab, Boolean> function1 = condition;
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                boolean bl5 = false;
                for (Object t : iterable2) {
                    if (!((Boolean)function1.invoke(t)).booleanValue()) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            dockerDetailsTab = v0;
        }
        return dockerDetailsTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void aboutToShow() {
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Unit unit;
            boolean bl3 = false;
            Content selectedContent = this.getContentManager().getSelectedContent();
            if (selectedContent == null) {
                Iterable $this$forEach$iv = this.myTabs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DockerDetailsTab it = (DockerDetailsTab)element$iv;
                    boolean bl4 = false;
                    it.createContent();
                }
                DockerDetailsTab dockerDetailsTab = this.findFirstReadyTab();
                if (dockerDetailsTab != null) {
                    DockerDetailsTab dockerDetailsTab2 = dockerDetailsTab;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    DockerDetailsTab it = dockerDetailsTab2;
                    boolean bl7 = false;
                    it.aboutToShow();
                    ContentManager contentManager = this.getContentManager();
                    Content content = it.getContent();
                    Intrinsics.checkNotNull((Object)content);
                    contentManager.setSelectedContent(content);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            } else {
                DockerDetailsTab dockerDetailsTab = this.findTabForContent(selectedContent);
                if (dockerDetailsTab != null) {
                    dockerDetailsTab.aboutToShow();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void refreshTabs() {
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.myTabs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerDetailsTab it = (DockerDetailsTab)element$iv;
                boolean bl4 = false;
                if (it.getContent() == null) {
                    it.createContent();
                }
                it.refreshTab(it.isContentSelected());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DockerDetailsTab findTab(@NotNull String tabDisplayName) {
        DockerDetailsTab dockerDetailsTab;
        Intrinsics.checkNotNullParameter((Object)tabDisplayName, (String)"tabDisplayName");
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Object v0;
            block4: {
                boolean bl3 = false;
                Iterable iterable = this.myTabs;
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                boolean bl5 = false;
                for (Object t : iterable2) {
                    DockerDetailsTab it = (DockerDetailsTab)t;
                    boolean bl6 = false;
                    if (!(it.getContent() == this.contentByDisplayName(tabDisplayName))) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            dockerDetailsTab = v0;
        }
        return dockerDetailsTab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeTabs() {
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Iterable $this$forEach$iv = this.myTabs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerDetailsTab p1 = (DockerDetailsTab)element$iv;
                boolean bl4 = false;
                p1.disposeTab();
            }
            this.myTabs.clear();
            Unit unit = Unit.INSTANCE;
        }
        Disposer.dispose((Disposable)((Disposable)this.getContentManager()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void selectDetailsTab(@NotNull String tabDisplayName) {
        Intrinsics.checkNotNullParameter((Object)tabDisplayName, (String)"tabDisplayName");
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Unit unit;
            Content content;
            boolean bl3 = false;
            Content content2 = content = this.contentByDisplayName(tabDisplayName);
            if (content2 != null) {
                Content content3 = content2;
                boolean bl4 = false;
                boolean bl5 = false;
                Content it = content3;
                boolean bl6 = false;
                ContentManager contentManager = it.getManager();
                if (contentManager != null) {
                    contentManager.setSelectedContent(it, true);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Content contentByDisplayName(String displayName) {
        Object v0;
        block3: {
            void $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.myTabs;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Content content;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                DockerDetailsTab it = (DockerDetailsTab)element$iv$iv;
                boolean bl2 = false;
                if (it.getContent() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Content it$iv$iv = content;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Content it = (Content)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getManager(), (Object)this.getContentManager())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)displayName)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    private final int findDefaultContentIndex(DockerDetailsTab tab) {
        int n;
        Function1<DockerDetailsTab, Content> $fun$findLeftAnchorContent$1 = new Function1<DockerDetailsTab, Content>(this){
            final /* synthetic */ TabManagerImpl this$0;

            @Nullable
            public final Content invoke(@NotNull DockerDetailsTab tab) {
                DockerDetailsTab nextTab;
                Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
                Content result2 = null;
                Iterator<E> iterator = TabManagerImpl.access$getMyTabs$p(this.this$0).iterator();
                while (iterator.hasNext() && !Intrinsics.areEqual((Object)(nextTab = (DockerDetailsTab)iterator.next()), (Object)tab)) {
                    Content nextContent;
                    Content content = nextContent = nextTab.getContent();
                    if (!Intrinsics.areEqual((Object)(content != null ? content.getManager() : null), (Object)this.this$0.getContentManager())) continue;
                    result2 = nextContent;
                }
                return result2;
            }
            {
                this.this$0 = tabManagerImpl;
                super(1);
            }
        };
        Content content = $fun$findLeftAnchorContent$1.invoke(tab);
        if (content != null) {
            Content content2 = content;
            boolean bl = false;
            boolean bl2 = false;
            Content it = content2;
            boolean bl3 = false;
            n = this.getContentManager().getIndexOfContent(it);
        } else {
            n = -1;
        }
        int anchorIndex = n;
        return anchorIndex + 1;
    }

    private final DockerDetailsTab findFirstReadyTab() {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = this.myTabs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DockerDetailsTab it = (DockerDetailsTab)element$iv;
                boolean bl = false;
                Content content = it.getContent();
                if (!Intrinsics.areEqual((Object)(content != null ? content.getManager() : null), (Object)this.getContentManager())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final DockerDetailsTab findTabForContent(Content content) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.myTabs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DockerDetailsTab it = (DockerDetailsTab)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContent(), (Object)content)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Deployment getDeployment() {
        return this.deployment;
    }

    public TabManagerImpl(@NotNull Project project, @NotNull Deployment deployment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        this.project = project;
        this.deployment = deployment;
        this.contentManager = (ContentManager)new MyContentManager(this.getProject());
        this.myLock = new Object();
        boolean bl = false;
        this.myTabs = new ArrayList();
        this.getContentManager().addContentManagerListener(new ContentManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    Object object = myLock;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        Unit unit;
                        boolean bl3 = false;
                        Content content = event.getContent();
                        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"event.content");
                        DockerDetailsTab dockerDetailsTab = this.findTabForContent(content);
                        if (dockerDetailsTab != null) {
                            dockerDetailsTab.aboutToShow();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void contentRemoved(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content = event.getContent();
                boolean bl = false;
                boolean bl2 = false;
                Content it = content;
                boolean bl3 = false;
                if (!Disposer.isDisposed((Disposable)((Disposable)it))) {
                    Object object = myLock;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    synchronized (object) {
                        Unit unit;
                        boolean bl6 = false;
                        Content content2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"it");
                        DockerDetailsTab dockerDetailsTab = this.findTabForContent(content2);
                        if (dockerDetailsTab != null) {
                            DockerDetailsTab dockerDetailsTab2 = dockerDetailsTab;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            DockerDetailsTab tab = dockerDetailsTab2;
                            boolean bl9 = false;
                            tab.disposeTab();
                            Content content3 = event.getContent();
                            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"event.content");
                            if (content3.isCloseable()) {
                                myTabs.remove(tab);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/view/details/TabManagerImpl$MyContentManager;", "Lcom/intellij/ui/content/impl/ContentManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "canCloseAllContents", "", "intellij.clouds.docker"})
    private static final class MyContentManager
    extends ContentManagerImpl {
        public boolean canCloseAllContents() {
            return false;
        }

        public MyContentManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super((ContentUI)new TabbedPaneContentUI(1), true, project);
        }
    }
}

