/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.agent.DockerAgentLogProvider;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.pull.DockerRedirectToTerminal;
import com.intellij.docker.registry.search.DockerSearchImageTextField;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.view.details.ImagePullPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remoteServer.impl.runtime.log.CloudTerminalProvider;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\r\u0010 \u001a\u00020\fH\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u001eH\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0015H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/docker/view/details/ImagePullPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "runtime", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;)V", "focusManager", "Lcom/intellij/openapi/wm/IdeFocusManager;", "getFocusManager", "()Lcom/intellij/openapi/wm/IdeFocusManager;", "imageTagField", "Lcom/intellij/docker/registry/search/DockerSearchImageTextField;", "mainPanel", "Ljavax/swing/JComponent;", "getMainPanel$intellij_clouds_docker", "()Ljavax/swing/JComponent;", "operationLabel", "Lcom/intellij/ui/components/JBLabel;", "pullQueue", "Ljava/util/Deque;", "", "spinningLabel", "terminalHandler", "Lcom/intellij/remoteServer/impl/runtime/log/TerminalHandlerBase;", "terminalPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "chooseNextValidTagToPull", "Lcom/intellij/docker/agent/DockerRepoTag;", "disposeTerminal", "", "disposeTerminal$intellij_clouds_docker", "preferredFocusableComponent", "preferredFocusableComponent$intellij_clouds_docker", "pullNextOne", "refreshQueueLabel", "requestPull", "request", "Companion", "intellij.clouds.docker"})
public final class ImagePullPanel {
    private final JBLabel spinningLabel;
    private final JBLabel operationLabel;
    private final DockerSearchImageTextField imageTagField;
    private final DockerTerminalPipe.WithTty terminalPipe;
    private final Deque<String> pullQueue;
    private final TerminalHandlerBase terminalHandler;
    @NotNull
    private final JComponent mainPanel;
    private final Project project;
    private final DockerGroupRuntime.ImagesGroup runtime;
    public static final int ICON_GAP = 6;
    private static final Lazy LOG$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final JComponent getMainPanel$intellij_clouds_docker() {
        return this.mainPanel;
    }

    public final void disposeTerminal$intellij_clouds_docker() {
        if (!this.terminalHandler.isClosed()) {
            this.terminalHandler.close();
        }
    }

    @NotNull
    public final DockerSearchImageTextField preferredFocusableComponent$intellij_clouds_docker() {
        return this.imageTagField;
    }

    private final void requestPull(String request) {
        CharSequence charSequence = request;
        String string = "\\s+";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List newTags = string.split(charSequence, n);
        boolean queueWasEmpty = this.pullQueue.isEmpty();
        this.pullQueue.addAll(newTags);
        this.imageTagField.setText("");
        this.getFocusManager().requestFocusInProject((Component)this.terminalHandler.getComponent(), this.project);
        if (queueWasEmpty) {
            this.pullNextOne();
        }
    }

    private final void pullNextOne() {
        DockerRepoTag tagToPull = this.chooseNextValidTagToPull();
        if (tagToPull == null) {
            this.getFocusManager().requestFocusInProject((Component)((Object)this.imageTagField), this.project);
            return;
        }
        ((CompletableFuture)new DockerRedirectToTerminal(this.terminalPipe.asTtySink()).redirectToTerminalLater(this.runtime.asyncPullImage(tagToPull)).thenRun(new Runnable(this){
            final /* synthetic */ ImagePullPanel this$0;

            public final void run() {
                DockerTerminalPipe.WithTty.println$default(ImagePullPanel.access$getTerminalPipe$p(this.this$0), null, 1, null);
            }
            {
                this.this$0 = imagePullPanel;
            }
        })).thenRun(new Runnable(this){
            final /* synthetic */ ImagePullPanel this$0;

            public final void run() {
                ImagePullPanel.access$pullNextOne(this.this$0);
            }
            {
                this.this$0 = imagePullPanel;
            }
        });
    }

    private final DockerRepoTag chooseNextValidTagToPull() {
        while (!this.pullQueue.isEmpty()) {
            DockerRepoTag nextTag;
            String nextTagString = this.pullQueue.removeFirst();
            this.refreshQueueLabel();
            this.terminalPipe.printlnSystem("docker pull " + nextTagString);
            Intrinsics.checkNotNullExpressionValue((Object)DockerRepoTag.fromString(nextTagString), (String)"DockerRepoTag.fromString(nextTagString)");
            if (!nextTag.hasCustomTag()) {
                String string = nextTagString;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextTagString");
                CharSequence charSequence = string;
                String string2 = nextTag.getTagNotNull();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextTag.tagNotNull");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) {
                    String string3 = DockerBundle.message("ImagePullPanel.terminal.info.using.default.tag", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DockerBundle.message(\"Im\u2026.info.using.default.tag\")");
                    this.terminalPipe.printlnSystem(string3);
                }
            }
            if (nextTag.isValidReferenceFormat()) {
                return nextTag;
            }
            String string = DockerBundle.message("ImagePullPanel.terminal.error.reference.format", nextTagString);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Im\u2026e.format\", nextTagString)");
            this.terminalPipe.printlnError(string);
            DockerTerminalPipe.WithTty.println$default(this.terminalPipe, null, 1, null);
        }
        return null;
    }

    private final void refreshQueueLabel() {
        this.operationLabel.setText(DockerBundle.message("ImagePullPanel.queue.label", this.pullQueue.size()));
        Collection collection = this.pullQueue;
        boolean bl = false;
        this.operationLabel.setVisible(!collection.isEmpty());
        collection = this.pullQueue;
        bl = false;
        this.spinningLabel.setVisible(!collection.isEmpty());
    }

    private final IdeFocusManager getFocusManager() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getInstance(project)");
        return ideFocusManager;
    }

    public ImagePullPanel(@NotNull Project project, @NotNull DockerGroupRuntime.ImagesGroup runtime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.project = project;
        this.runtime = runtime;
        this.spinningLabel = new JBLabel((Icon)new AnimatedIcon.Default());
        this.operationLabel = new JBLabel("");
        this.terminalPipe = new DockerTerminalPipe.WithTty("ImagePullPanel.pipe", new DockerAgentLogProvider(terminalPipe.1.INSTANCE, terminalPipe.2.INSTANCE, terminalPipe.3.INSTANCE, terminalPipe.4.INSTANCE, false, 16, null));
        this.pullQueue = new ArrayDeque();
        this.terminalPipe.setUseBufferedWriter(true).setShowCursor(false);
        this.imageTagField = new DockerSearchImageTextField(this.project, null, 2, null);
        this.imageTagField.setPreferredSize(new JTextField(30).getPreferredSize());
        ShortcutSet shortcut = CommonShortcuts.CTRL_ENTER;
        new DumbAwareAction(DockerBundle.message("ImagePullPanel.action.pull", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = imageTagField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imageTagField.text");
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                CharSequence charSequence = it;
                boolean bl4 = false;
                if (charSequence.length() > 0) {
                    this.requestPull(it);
                }
            }
        }.registerCustomShortcutSet(shortcut, (JComponent)((Object)this.imageTagField), null);
        JPanel jPanel = UI.PanelFactory.panel((JComponent)((JComponent)((Object)this.imageTagField))).withLabel(DockerBundle.message("ImagePullPanel.image.to.pull.label", new Object[0])).withComment(DockerBundle.message("ImagePullPanel.image.to.pull.comment", KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)shortcut)), false).moveCommentRight().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"UI.PanelFactory.panel(im\u2026ht()\n      .createPanel()");
        JPanel imageTagPanel = jPanel;
        this.mainPanel = new JPanel(new BorderLayout(ImagePullPanel.Companion.scale(10), ImagePullPanel.Companion.scale(4)));
        JPanel jPanel2 = new JPanel((LayoutManager)new HorizontalLayout(6));
        boolean bl = false;
        boolean bl2 = false;
        JPanel it = jPanel2;
        boolean bl3 = false;
        it.setBorder((Border)JBUI.Borders.emptyRight((int)ImagePullPanel.Companion.scale(10)));
        it.add((Component)new JBLabel(), "LEFT");
        it.add((Component)imageTagPanel, "LEFT");
        it.add((Component)this.operationLabel, "RIGHT");
        it.add((Component)this.spinningLabel, "RIGHT");
        JPanel topRow = jPanel2;
        this.mainPanel.add((Component)topRow, "North");
        TerminalHandlerBase terminalHandlerBase = CloudTerminalProvider.getInstance().createTerminal(DockerBundle.message("ImagePullPanel.terminal.name", new Object[0]), this.project, this.terminalPipe.getTerminalOutput(), this.terminalPipe.getTerminalInput(), true);
        Intrinsics.checkNotNullExpressionValue((Object)terminalHandlerBase, (String)"CloudTerminalProvider.ge\u2026rminalInput, true\n      )");
        this.terminalHandler = terminalHandlerBase;
        this.mainPanel.add((Component)this.terminalHandler.getComponent(), "Center");
        this.refreshQueueLabel();
    }

    static {
        Companion = new Companion(null);
        LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    }

    public static final /* synthetic */ DockerTerminalPipe.WithTty access$getTerminalPipe$p(ImagePullPanel $this) {
        return $this.terminalPipe;
    }

    public static final /* synthetic */ void access$pullNextOne(ImagePullPanel $this) {
        $this.pullNextOne();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/view/details/ImagePullPanel$Companion;", "", "()V", "ICON_GAP", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "scale", "value", "intellij.clouds.docker"})
    public static final class Companion {
        private final int scale(int value) {
            return JBUIScale.scale((int)value);
        }

        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        private Companion() {
        }

        public static final /* synthetic */ Logger access$getLOG$p(Companion $this) {
            return $this.getLOG();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

