/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.github.dockerjava.api.model.Network;
import com.intellij.docker.action.networks.ConnectNetworkDialog;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntimeImpl;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.view.DockerPropertiesRuntimeEditorBase;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.docker.view.details.DockerDeferredDetailsTab;
import com.intellij.docker.view.details.DockerDeploymentDetailsBase;
import com.intellij.docker.view.details.DockerNetworkDetails;
import com.intellij.docker.view.details.DockerRuntimeLabelsTab;
import com.intellij.docker.view.details.DockerRuntimePropertiesTab;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.execution.services.RepaintLinkMouseListenerBase;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersDeploymentManager;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.content.Content;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SortOrder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \r2\u00020\u0001:\t\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails;", "Lcom/intellij/docker/view/details/DockerDeploymentDetailsBase;", "project", "Lcom/intellij/openapi/project/Project;", "deployment", "Lcom/intellij/remoteServer/runtime/Deployment;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/remoteServer/runtime/Deployment;)V", "createTabs", "", "tabManager", "Lcom/intellij/docker/view/details/ITabManager;", "runtime", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentRuntime;", "Companion", "ContainerRow", "ContainersTab", "IpamPropertiesEditor", "IpamTab", "LinkedContainerRenderer", "NetworkPropertiesEditor", "PropertiesTab", "TableLinkMouseListener", "intellij.clouds.docker"})
public final class DockerNetworkDetails
extends DockerDeploymentDetailsBase {
    private static final String HELP_TOPIC = "Docker.interacting-with-networks";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected void createTabs(@NotNull ITabManager tabManager, @NotNull DeploymentRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        boolean bl = false;
        boolean bl2 = false;
        ITabManager $this$with = tabManager;
        boolean bl3 = false;
        $this$with.addTab(new PropertiesTab($this$with));
        if (runtime instanceof DockerNetworkRuntime) {
            $this$with.addTab(new ContainersTab($this$with, (DockerNetworkRuntime)runtime));
        }
        $this$with.addTab(new IpamTab($this$with));
        $this$with.addTab(new DockerRuntimeLabelsTab($this$with, (Function1<? super DockerRuntimeBase, ? extends Map<String, String>>)((Function1)createTabs.1.1.INSTANCE)));
    }

    public DockerNetworkDetails(@NotNull Project project, @NotNull Deployment deployment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        super(project, deployment, HELP_TOPIC);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$PropertiesTab;", "Lcom/intellij/docker/view/details/DockerRuntimePropertiesTab;", "tabManager", "Lcom/intellij/docker/view/details/ITabManager;", "(Lcom/intellij/docker/view/details/ITabManager;)V", "doCreateContent", "Lcom/intellij/ui/content/Content;", "intellij.clouds.docker"})
    private static final class PropertiesTab
    extends DockerRuntimePropertiesTab {
        @Override
        @Nullable
        protected Content doCreateContent() {
            DockerRuntimeBase dockerRuntimeBase = this.getRuntimeImpl();
            if (!(dockerRuntimeBase instanceof DockerNetworkRuntime)) {
                dockerRuntimeBase = null;
            }
            DockerNetworkRuntime dockerNetworkRuntime = (DockerNetworkRuntime)dockerRuntimeBase;
            if (dockerNetworkRuntime == null) {
                return null;
            }
            DockerNetworkRuntime network = dockerNetworkRuntime;
            Function1 function1 = (Function1)new Function1<DockerAgentContainerConfig, Boolean>(this){

                public final boolean invoke(@NotNull DockerAgentContainerConfig p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((PropertiesTab)this.receiver).onEditorSave(p1);
                }
            };
            return DockerRuntimePropertiesTab.createContent$default(this, new NetworkPropertiesEditor(network, new DockerRuntimeEditorBase.ConfigApplier(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ boolean applyNewConfig(DockerAgentContainerConfig newConfig) {
                    Object object = this.function.invoke((Object)newConfig);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return (Boolean)object;
                }
            }), false, 1, null);
        }

        public PropertiesTab(@NotNull ITabManager tabManager) {
            Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
            super(tabManager, null, 2, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$IpamTab;", "Lcom/intellij/docker/view/details/DockerRuntimePropertiesTab;", "tabManager", "Lcom/intellij/docker/view/details/ITabManager;", "(Lcom/intellij/docker/view/details/ITabManager;)V", "doCreateContent", "Lcom/intellij/ui/content/Content;", "intellij.clouds.docker"})
    private static final class IpamTab
    extends DockerRuntimePropertiesTab {
        @Override
        @Nullable
        protected Content doCreateContent() {
            DockerRuntimeBase dockerRuntimeBase = this.getRuntimeImpl();
            if (!(dockerRuntimeBase instanceof DockerNetworkRuntime)) {
                dockerRuntimeBase = null;
            }
            DockerNetworkRuntime dockerNetworkRuntime = (DockerNetworkRuntime)dockerRuntimeBase;
            if (dockerNetworkRuntime == null) {
                return null;
            }
            DockerNetworkRuntime network = dockerNetworkRuntime;
            Network.Ipam ipam = network.getNetwork().getIpam();
            if (ipam == null) {
                return null;
            }
            Network.Ipam ipam2 = ipam;
            Function1 function1 = (Function1)new Function1<DockerAgentContainerConfig, Boolean>(this){

                public final boolean invoke(@NotNull DockerAgentContainerConfig p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((IpamTab)this.receiver).onEditorSave(p1);
                }
            };
            return DockerRuntimePropertiesTab.createContent$default(this, new IpamPropertiesEditor(ipam2, new /* invalid duplicate definition of identical inner class */), false, 1, null);
        }

        public IpamTab(@NotNull ITabManager tabManager) {
            Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
            super(tabManager, null, 2, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$NetworkPropertiesEditor;", "Lcom/intellij/docker/view/DockerPropertiesRuntimeEditorBase;", "runtime", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "onSave", "Lcom/intellij/docker/view/DockerRuntimeEditorBase$ConfigApplier;", "(Lcom/intellij/docker/runtimes/DockerNetworkRuntime;Lcom/intellij/docker/view/DockerRuntimeEditorBase$ConfigApplier;)V", "addRow", "", "name", "", "value", "", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "intellij.clouds.docker"})
    private static final class NetworkPropertiesEditor
    extends DockerPropertiesRuntimeEditorBase {
        private final void addRow(@Nls String name, Boolean value) {
            Boolean bl = value;
            this.addRow(name, String.valueOf(bl != null ? bl : false));
        }

        public NetworkPropertiesEditor(@NotNull DockerNetworkRuntime runtime, @NotNull DockerRuntimeEditorBase.ConfigApplier onSave2) {
            Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
            Intrinsics.checkNotNullParameter((Object)onSave2, (String)"onSave");
            super(onSave2);
            Network network = runtime.getNetwork();
            boolean bl = false;
            boolean bl2 = false;
            Network it = network;
            boolean bl3 = false;
            String string = DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Do\u2026iesEditor.property.name\")");
            this.addRow(string, it.getName());
            String string2 = DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.id", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DockerBundle.message(\"Do\u2026rtiesEditor.property.id\")");
            this.addRow(string2, it.getId());
            String string3 = DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.scope", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DockerBundle.message(\"Do\u2026esEditor.property.scope\")");
            this.addRow(string3, it.getScope());
            String string4 = DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.driver", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DockerBundle.message(\"Do\u2026sEditor.property.driver\")");
            this.addRow(string4, it.getDriver());
            String string5 = DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.ipv6.enabled", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"DockerBundle.message(\"Do\u2026r.property.ipv6.enabled\")");
            this.addRow(string5, it.getEnableIPv6());
            String string6 = DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.internal", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"DockerBundle.message(\"Do\u2026ditor.property.internal\")");
            this.addRow(string6, it.getInternal());
            String string7 = DockerBundle.message("DockerNetworkDetails.NetworkPropertiesEditor.property.attachable", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"DockerBundle.message(\"Do\u2026tor.property.attachable\")");
            this.addRow(string7, it.isAttachable());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$IpamPropertiesEditor;", "Lcom/intellij/docker/view/DockerPropertiesRuntimeEditorBase;", "ipam", "Lcom/github/dockerjava/api/model/Network$Ipam;", "onSave", "Lcom/intellij/docker/view/DockerRuntimeEditorBase$ConfigApplier;", "(Lcom/github/dockerjava/api/model/Network$Ipam;Lcom/intellij/docker/view/DockerRuntimeEditorBase$ConfigApplier;)V", "addRowIfNotEmpty", "", "name", "", "value", "intellij.clouds.docker"})
    private static final class IpamPropertiesEditor
    extends DockerPropertiesRuntimeEditorBase {
        private final void addRowIfNotEmpty(@Nls String name, String value) {
            block1: {
                String string = value;
                if (string == null) break block1;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                CharSequence charSequence = it;
                boolean bl4 = false;
                string = !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
                if (string != null) {
                    string2 = string;
                    bl = false;
                    bl2 = false;
                    it = string2;
                    boolean bl5 = false;
                    this.addRow(name, it);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public IpamPropertiesEditor(@NotNull Network.Ipam ipam, @NotNull DockerRuntimeEditorBase.ConfigApplier onSave2) {
            Intrinsics.checkNotNullParameter((Object)ipam, (String)"ipam");
            Intrinsics.checkNotNullParameter((Object)onSave2, (String)"onSave");
            String string = DockerBundle.message("DockerNetworkDetails.IpamPropertiesEditor.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Do\u2026mPropertiesEditor.title\")");
            super(string, onSave2);
            String string2 = DockerBundle.message("DockerNetworkDetails.IpamPropertiesEditor.property.driver", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DockerBundle.message(\"Do\u2026sEditor.property.driver\")");
            this.addRow(string2, ipam.getDriver());
            List list = ipam.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ipam.config");
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void next;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Network.Ipam.Config config = (Network.Ipam.Config)item$iv;
                int idx = n;
                boolean bl2 = false;
                String string3 = DockerBundle.message("DockerNetworkDetails.IpamPropertiesEditor.property.network.id", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DockerBundle.message(\"Do\u2026tor.property.network.id\")");
                void v4 = next;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"next");
                this.addRowIfNotEmpty(string3, v4.getNetworkID());
                String string4 = DockerBundle.message("DockerNetworkDetails.IpamPropertiesEditor.property.subnet", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DockerBundle.message(\"Do\u2026sEditor.property.subnet\")");
                this.addRowIfNotEmpty(string4, next.getSubnet());
                String string5 = DockerBundle.message("DockerNetworkDetails.IpamPropertiesEditor.property.gateway", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"DockerBundle.message(\"Do\u2026Editor.property.gateway\")");
                this.addRowIfNotEmpty(string5, next.getGateway());
                String string6 = DockerBundle.message("DockerNetworkDetails.IpamPropertiesEditor.property.ip.range", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"DockerBundle.message(\"Do\u2026ditor.property.ip.range\")");
                this.addRowIfNotEmpty(string6, next.getIpRange());
                if (idx <= 0) continue;
                this.addRow("", "");
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0018H\u0014J\f\u0010\u0019\u001a\u00020\u0014*\u00020\u001aH\u0002R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainersTab;", "Lcom/intellij/docker/view/details/DockerDeferredDetailsTab;", "Lcom/github/dockerjava/api/model/Network;", "tabManager", "Lcom/intellij/docker/view/details/ITabManager;", "runtime", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "(Lcom/intellij/docker/view/details/ITabManager;Lcom/intellij/docker/runtimes/DockerNetworkRuntime;)V", "nodeSelector", "Lcom/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeNodeSelector;", "Lorg/jetbrains/annotations/NotNull;", "getNodeSelector", "()Lcom/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeNodeSelector;", "runtimeImpl", "getRuntimeImpl", "()Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "createComponentNow", "Ljavax/swing/JComponent;", "inspection", "disconnectContainer", "", "row", "Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainerRow;", "promiseInspection", "Ljava/util/concurrent/CompletableFuture;", "revealContainer", "Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "Companion", "ContainersEditor", "intellij.clouds.docker"})
    private static final class ContainersTab
    extends DockerDeferredDetailsTab<Network> {
        private final DockerNetworkRuntime runtime;
        private static final Companion.COLUMN_IPV4.1 COLUMN_IPV4;
        private static final Companion.COLUMN_IPV6.1 COLUMN_IPV6;
        @NotNull
        public static final Companion Companion;

        @Override
        @NotNull
        protected JComponent createComponentNow(@NotNull Network inspection) {
            Intrinsics.checkNotNullParameter((Object)inspection, (String)"inspection");
            Function1 function1 = (Function1)new Function1<DockerAgentContainerConfig, Boolean>(this){

                public final boolean invoke(@NotNull DockerAgentContainerConfig p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((ContainersTab)this.receiver).onEditorSave(p1);
                }
            };
            ContainersEditor editor2 = new ContainersEditor(this.runtime, inspection, new /* invalid duplicate definition of identical inner class */);
            return editor2.getComponent();
        }

        @Override
        @Nullable
        protected CompletableFuture<Network> promiseInspection() {
            DockerNetworkRuntime dockerNetworkRuntime = this.getRuntimeImpl();
            return dockerNetworkRuntime != null ? dockerNetworkRuntime.promiseInspection() : null;
        }

        private final void revealContainer(DockerContainerRuntime $this$revealContainer) {
            ServerConnection serverConnection = this.getTabManager().getDeployment().getConnection();
            Intrinsics.checkNotNullExpressionValue((Object)serverConnection, (String)"tabManager.deployment.connection");
            ServerConnection connection = serverConnection;
            this.getNodeSelector().select(connection, $this$revealContainer.getApplicationName(), this.getTitle());
        }

        private final void disconnectContainer(ContainerRow row) {
            ((CompletableFuture)this.runtime.disconnectContainer(row.getContainerId()).thenAcceptAsync(new Consumer(this){
                final /* synthetic */ ContainersTab this$0;

                public final void accept(Boolean isOk) {
                    Boolean bl = isOk;
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isOk");
                    if (bl.booleanValue()) {
                        DockerNetworkRuntime dockerNetworkRuntime = ContainersTab.access$getRuntime$p(this.this$0);
                        if (dockerNetworkRuntime == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.docker.runtimes.DockerNetworkRuntimeImpl");
                        }
                        ((DockerNetworkRuntimeImpl)dockerNetworkRuntime).forgetInspection();
                        this.this$0.requestRecreateEditor();
                    }
                }
                {
                    this.this$0 = containersTab;
                }
            })).exceptionally((Function)disconnectContainer.2.INSTANCE);
        }

        @Override
        @Nullable
        protected DockerNetworkRuntime getRuntimeImpl() {
            DeploymentRuntime deploymentRuntime = this.getDeployment().getRuntime();
            if (!(deploymentRuntime instanceof DockerNetworkRuntime)) {
                deploymentRuntime = null;
            }
            return (DockerNetworkRuntime)deploymentRuntime;
        }

        private final ServersTreeNodeSelector getNodeSelector() {
            RemoteServersDeploymentManager remoteServersDeploymentManager = RemoteServersDeploymentManager.getInstance((Project)this.getTabManager().getProject());
            Intrinsics.checkNotNullExpressionValue((Object)remoteServersDeploymentManager, (String)"RemoteServersDeploymentM\u2026tance(tabManager.project)");
            ServersTreeNodeSelector serversTreeNodeSelector = remoteServersDeploymentManager.getNodeSelector();
            Intrinsics.checkNotNullExpressionValue((Object)serversTreeNodeSelector, (String)"RemoteServersDeploymentM\u2026ger.project).nodeSelector");
            return serversTreeNodeSelector;
        }

        public ContainersTab(@NotNull ITabManager tabManager, @NotNull DockerNetworkRuntime runtime) {
            Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
            Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
            String string = DockerBundle.message("DockerNetworkDetails.ContainersEditor.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Do\u2026.ContainersEditor.title\")");
            super(tabManager, string, false, null, 12, null);
            this.runtime = runtime;
        }

        static {
            Companion = new Companion(null);
            COLUMN_IPV4 = new ColumnInfo<ContainerRow, String>(DockerBundle.message("DockerNetworkDetails.ContainersEditor.header.ipv4", new Object[0])){

                @NotNull
                public String valueOf(@NotNull ContainerRow item) {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    String string = item.getNetworkConfig().getIpv4Address();
                    if (string == null) {
                        string = "";
                    }
                    return string;
                }
            };
            COLUMN_IPV6 = new ColumnInfo<ContainerRow, String>(DockerBundle.message("DockerNetworkDetails.ContainersEditor.header.ipv6", new Object[0])){

                @NotNull
                public String valueOf(@NotNull ContainerRow item) {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    String string = item.getNetworkConfig().getIpv6Address();
                    if (string == null) {
                        string = "";
                    }
                    return string;
                }
            };
        }

        public static final /* synthetic */ void access$disconnectContainer(ContainersTab $this, ContainerRow row) {
            $this.disconnectContainer(row);
        }

        public static final /* synthetic */ void access$revealContainer(ContainersTab $this, DockerContainerRuntime $this$access_u24revealContainer) {
            $this.revealContainer($this$access_u24revealContainer);
        }

        public static final /* synthetic */ DockerNetworkRuntime access$getRuntime$p(ContainersTab $this) {
            return $this.runtime;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000*\u0001\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\b\u0001\u0012\u00020\u00180\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\rH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$ContainersEditor;", "Lcom/intellij/docker/view/DockerRuntimeEditorBase;", "runtime", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "inspection", "Lcom/github/dockerjava/api/model/Network;", "onSave", "Lcom/intellij/docker/view/DockerRuntimeEditorBase$ConfigApplier;", "(Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainersTab;Lcom/intellij/docker/runtimes/DockerNetworkRuntime;Lcom/github/dockerjava/api/model/Network;Lcom/intellij/docker/view/DockerRuntimeEditorBase$ConfigApplier;)V", "COLUMN_CONTAINER", "com/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$ContainersEditor$COLUMN_CONTAINER$1", "Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$ContainersEditor$COLUMN_CONTAINER$1;", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "component$delegate", "Lkotlin/Lazy;", "containerLinkRenderer", "Lcom/intellij/docker/view/details/DockerNetworkDetails$LinkedContainerRenderer;", "computeColumns", "", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainerRow;", "", "()[Lcom/intellij/util/ui/ColumnInfo;", "createComponent", "createConfig", "Lcom/intellij/docker/agent/settings/DockerAgentContainerConfig;", "createTable", "Ljavax/swing/JComponent;", "onAddContainer", "", "intellij.clouds.docker"})
        private final class ContainersEditor
        extends DockerRuntimeEditorBase {
            @NotNull
            private final Lazy component$delegate;
            private final LinkedContainerRenderer containerLinkRenderer;
            private final COLUMN_CONTAINER.1 COLUMN_CONTAINER;
            private final DockerNetworkRuntime runtime;
            private final Network inspection;

            @NotNull
            public final JPanel getComponent() {
                Lazy lazy = this.component$delegate;
                ContainersEditor containersEditor = this;
                Object var3_3 = null;
                boolean bl = false;
                return (JPanel)lazy.getValue();
            }

            @Override
            @Nullable
            protected DockerAgentContainerConfig createConfig() {
                return null;
            }

            private final JPanel createComponent() {
                JPanel jPanel = new JPanel();
                boolean bl = false;
                boolean bl2 = false;
                JPanel it = jPanel;
                boolean bl3 = false;
                this.initControls(it, null);
                it.setLayout(new BorderLayout());
                it.add(this.createTable());
                return jPanel;
            }

            /*
             * WARNING - void declaration
             */
            private final JComponent createTable() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.inspection.getContainers().entrySet();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object k = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                    String string = (String)k;
                    Object v = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                    ContainerRow containerRow = new ContainerRow(this.runtime, string, (Network.ContainerNetworkConfig)v);
                    collection.add(containerRow);
                }
                List items = (List)destination$iv$iv;
                ListTableModel model2 = new ListTableModel(this.computeColumns(), items, 0, SortOrder.UNSORTED);
                TableView table = new TableView(model2);
                new TableLinkMouseListener((JBTable)table).installOn((Component)table);
                JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)table)).setEditAction(null).setMoveDownAction(null).setMoveUpAction(null).setAddAction(new AnActionButtonRunnable(this){
                    final /* synthetic */ ContainersEditor this$0;

                    public final void run(AnActionButton it) {
                        ContainersEditor.access$onAddContainer(this.this$0);
                    }
                    {
                        this.this$0 = containersEditor;
                    }
                }).setRemoveAction(new AnActionButtonRunnable(this, table){
                    final /* synthetic */ ContainersEditor this$0;
                    final /* synthetic */ TableView $table;

                    public final void run(AnActionButton it) {
                        block0: {
                            ContainerRow containerRow = (ContainerRow)this.$table.getSelectedObject();
                            if (containerRow == null) break block0;
                            ContainerRow containerRow2 = containerRow;
                            boolean bl = false;
                            boolean bl2 = false;
                            ContainerRow it2 = containerRow2;
                            boolean bl3 = false;
                            ContainersTab containersTab = this.this$0.ContainersTab.this;
                            ContainerRow containerRow3 = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)containerRow3, (String)"it");
                            ContainersTab.access$disconnectContainer(containersTab, containerRow3);
                        }
                    }
                    {
                        this.this$0 = containersEditor;
                        this.$table = tableView;
                    }
                }).createPanel();
                Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"ToolbarDecorator.createD\u2026\n          .createPanel()");
                JPanel result2 = jPanel;
                return result2;
            }

            private final ColumnInfo<ContainerRow, ? extends Object>[] computeColumns() {
                boolean bl;
                Object[] objectArray;
                Companion.COLUMN_IPV6.1 var1_1;
                block4: {
                    Object[] objectArray2 = new ColumnInfo[3];
                    objectArray2[0] = this.COLUMN_CONTAINER;
                    objectArray2[1] = COLUMN_IPV4;
                    var1_1 = COLUMN_IPV6;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Companion.COLUMN_IPV6.1 var4_5 = var1_1;
                    int n = 2;
                    Object[] objectArray3 = objectArray2;
                    objectArray = objectArray2;
                    boolean bl4 = false;
                    Iterable $this$any$iv = this.inspection.getContainers().values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Network.ContainerNetworkConfig it = (Network.ContainerNetworkConfig)element$iv;
                            boolean bl5 = false;
                            Network.ContainerNetworkConfig containerNetworkConfig = it;
                            Intrinsics.checkNotNullExpressionValue((Object)containerNetworkConfig, (String)"it");
                            if (!Companion.hasIPv6(containerNetworkConfig)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                boolean bl6 = bl;
                objectArray3[n] = bl6 ? var1_1 : null;
                Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                ColumnInfo[] columnInfoArray = thisCollection$iv.toArray(new ColumnInfo[0]);
                if (columnInfoArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return columnInfoArray;
            }

            private final void onAddContainer() {
                ConnectNetworkDialog.Settings settings = (ConnectNetworkDialog.Settings)new ConnectNetworkDialog(ContainersTab.this.getProject(), this.runtime).getDialog().showAndGet();
                if (settings == null) {
                    return;
                }
                ConnectNetworkDialog.Settings result2 = settings;
                ((CompletableFuture)DockerNetworkRuntime.connectContainer$default(this.runtime, result2.getContainer(), null, 2, null).thenAcceptAsync(new Consumer(this){
                    final /* synthetic */ ContainersEditor this$0;

                    public final void accept(Boolean it) {
                        Boolean bl = it;
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"it");
                        if (bl.booleanValue()) {
                            DockerNetworkRuntime dockerNetworkRuntime = ContainersEditor.access$getRuntime$p(this.this$0);
                            if (dockerNetworkRuntime == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.intellij.docker.runtimes.DockerNetworkRuntimeImpl");
                            }
                            ((DockerNetworkRuntimeImpl)dockerNetworkRuntime).forgetInspection();
                            this.this$0.ContainersTab.this.requestRecreateEditor();
                        }
                    }
                    {
                        this.this$0 = containersEditor;
                    }
                })).exceptionally((Function)onAddContainer.2.INSTANCE);
            }

            public ContainersEditor(@NotNull DockerNetworkRuntime runtime, @NotNull Network inspection, DockerRuntimeEditorBase.ConfigApplier onSave2) {
                Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
                Intrinsics.checkNotNullParameter((Object)inspection, (String)"inspection");
                Intrinsics.checkNotNullParameter((Object)onSave2, (String)"onSave");
                super(DockerBundle.message("DockerNetworkDetails.ContainersEditor.title", new Object[0]), onSave2);
                this.runtime = runtime;
                this.inspection = inspection;
                this.component$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JPanel>(this){
                    final /* synthetic */ ContainersEditor this$0;

                    @NotNull
                    public final JPanel invoke() {
                        return ContainersEditor.access$createComponent(this.this$0);
                    }
                    {
                        this.this$0 = containersEditor;
                        super(0);
                    }
                }));
                this.containerLinkRenderer = new LinkedContainerRenderer((Function1<? super DockerContainerRuntime, Unit>)((Function1)new Function1<DockerContainerRuntime, Unit>(this){
                    final /* synthetic */ ContainersEditor this$0;

                    public final void invoke(@NotNull DockerContainerRuntime it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        ContainersTab.access$revealContainer(this.this$0.ContainersTab.this, it);
                    }
                    {
                        this.this$0 = containersEditor;
                        super(1);
                    }
                }));
                this.COLUMN_CONTAINER = new ColumnInfo<ContainerRow, ContainerRow>(this, DockerBundle.message("DockerNetworkDetails.ContainersEditor.header.container", new Object[0])){
                    final /* synthetic */ ContainersEditor this$0;

                    @NotNull
                    public ContainerRow valueOf(@NotNull ContainerRow item) {
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        return item;
                    }

                    @NotNull
                    public LinkedContainerRenderer getRenderer(@NotNull ContainerRow item) {
                        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                        return ContainersEditor.access$getContainerLinkRenderer$p(this.this$0);
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1);
                    }
                };
            }

            public static final /* synthetic */ void access$onAddContainer(ContainersEditor $this) {
                $this.onAddContainer();
            }

            public static final /* synthetic */ DockerNetworkRuntime access$getRuntime$p(ContainersEditor $this) {
                return $this.runtime;
            }

            public static final /* synthetic */ JPanel access$createComponent(ContainersEditor $this) {
                return $this.createComponent();
            }

            public static final /* synthetic */ LinkedContainerRenderer access$getContainerLinkRenderer$p(ContainersEditor $this) {
                return $this.containerLinkRenderer;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000*\u0002\u0004\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$Companion;", "", "()V", "COLUMN_IPV4", "com/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$Companion$COLUMN_IPV4$1", "Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$Companion$COLUMN_IPV4$1;", "COLUMN_IPV6", "com/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$Companion$COLUMN_IPV6$1", "Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainersTab$Companion$COLUMN_IPV6$1;", "hasIPv6", "", "Lcom/github/dockerjava/api/model/Network$ContainerNetworkConfig;", "intellij.clouds.docker"})
        public static final class Companion {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasIPv6(Network.ContainerNetworkConfig $this$hasIPv6) {
                String string = $this$hasIPv6.getIpv6Address();
                if (string == null) return false;
                CharSequence charSequence = string;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)charSequence)) return false;
                return true;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J:\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$LinkedContainerRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "onClick", "Lkotlin/Function1;", "Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "", "(Lkotlin/jvm/functions/Function1;)V", "customizeCellRenderer", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row1", "", "column", "intellij.clouds.docker"})
    private static final class LinkedContainerRenderer
    extends ColoredTableCellRenderer {
        private final Function1<DockerContainerRuntime, Unit> onClick;

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row1, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            if (!(value instanceof ContainerRow)) {
                return;
            }
            this.setOpaque(selected);
            DockerContainerRuntime container = ((ContainerRow)value).getContainer();
            if (container != null) {
                String string = container.getPresentableName();
                if (string == null) {
                    string = "";
                }
                this.append(string, SimpleTextAttributes.LINK_ATTRIBUTES, new Runnable(this, container){
                    final /* synthetic */ LinkedContainerRenderer this$0;
                    final /* synthetic */ DockerContainerRuntime $container;

                    public final void run() {
                        LinkedContainerRenderer.access$getOnClick$p(this.this$0).invoke((Object)((Object)this.$container));
                    }
                    {
                        this.this$0 = linkedContainerRenderer;
                        this.$container = dockerContainerRuntime;
                    }
                });
            } else {
                String shortId = DockerUtil.shortedId(((ContainerRow)value).getContainerId());
                this.append(shortId, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        public LinkedContainerRenderer(@NotNull Function1<? super DockerContainerRuntime, Unit> onClick) {
            Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
            this.onClick = onClick;
        }

        public /* synthetic */ LinkedContainerRenderer(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function1 = 1.INSTANCE;
            }
            this((Function1<? super DockerContainerRuntime, Unit>)function1);
        }

        public LinkedContainerRenderer() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Function1 access$getOnClick$p(LinkedContainerRenderer $this) {
            return $this.onClick;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$ContainerRow;", "", "network", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "containerId", "", "networkConfig", "Lcom/github/dockerjava/api/model/Network$ContainerNetworkConfig;", "(Lcom/intellij/docker/runtimes/DockerNetworkRuntime;Ljava/lang/String;Lcom/github/dockerjava/api/model/Network$ContainerNetworkConfig;)V", "container", "Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "getContainer", "()Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "getContainerId", "()Ljava/lang/String;", "getNetwork", "()Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "getNetworkConfig", "()Lcom/github/dockerjava/api/model/Network$ContainerNetworkConfig;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.docker"})
    private static final class ContainerRow {
        @NotNull
        private final DockerNetworkRuntime network;
        @NotNull
        private final String containerId;
        @NotNull
        private final Network.ContainerNetworkConfig networkConfig;

        @Nullable
        public final DockerContainerRuntime getContainer() {
            DockerPhysicalRuntime<?> dockerPhysicalRuntime = this.network.findRuntimeById(this.containerId);
            if (!(dockerPhysicalRuntime instanceof DockerContainerRuntime)) {
                dockerPhysicalRuntime = null;
            }
            return (DockerContainerRuntime)dockerPhysicalRuntime;
        }

        @NotNull
        public final DockerNetworkRuntime getNetwork() {
            return this.network;
        }

        @NotNull
        public final String getContainerId() {
            return this.containerId;
        }

        @NotNull
        public final Network.ContainerNetworkConfig getNetworkConfig() {
            return this.networkConfig;
        }

        public ContainerRow(@NotNull DockerNetworkRuntime network, @NotNull String containerId, @NotNull Network.ContainerNetworkConfig networkConfig) {
            Intrinsics.checkNotNullParameter((Object)((Object)network), (String)"network");
            Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
            Intrinsics.checkNotNullParameter((Object)networkConfig, (String)"networkConfig");
            this.network = network;
            this.containerId = containerId;
            this.networkConfig = networkConfig;
        }

        @NotNull
        public final DockerNetworkRuntime component1() {
            return this.network;
        }

        @NotNull
        public final String component2() {
            return this.containerId;
        }

        @NotNull
        public final Network.ContainerNetworkConfig component3() {
            return this.networkConfig;
        }

        @NotNull
        public final ContainerRow copy(@NotNull DockerNetworkRuntime network, @NotNull String containerId, @NotNull Network.ContainerNetworkConfig networkConfig) {
            Intrinsics.checkNotNullParameter((Object)((Object)network), (String)"network");
            Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
            Intrinsics.checkNotNullParameter((Object)networkConfig, (String)"networkConfig");
            return new ContainerRow(network, containerId, networkConfig);
        }

        public static /* synthetic */ ContainerRow copy$default(ContainerRow containerRow, DockerNetworkRuntime dockerNetworkRuntime, String string, Network.ContainerNetworkConfig containerNetworkConfig, int n, Object object) {
            if ((n & 1) != 0) {
                dockerNetworkRuntime = containerRow.network;
            }
            if ((n & 2) != 0) {
                string = containerRow.containerId;
            }
            if ((n & 4) != 0) {
                containerNetworkConfig = containerRow.networkConfig;
            }
            return containerRow.copy(dockerNetworkRuntime, string, containerNetworkConfig);
        }

        @NotNull
        public String toString() {
            return "ContainerRow(network=" + (Object)((Object)this.network) + ", containerId=" + this.containerId + ", networkConfig=" + this.networkConfig + ")";
        }

        public int hashCode() {
            DockerNetworkRuntime dockerNetworkRuntime = this.network;
            String string = this.containerId;
            Network.ContainerNetworkConfig containerNetworkConfig = this.networkConfig;
            return ((dockerNetworkRuntime != null ? ((Object)((Object)dockerNetworkRuntime)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (containerNetworkConfig != null ? containerNetworkConfig.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ContainerRow)) break block3;
                    ContainerRow containerRow = (ContainerRow)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.network), (Object)((Object)containerRow.network)) || !Intrinsics.areEqual((Object)this.containerId, (Object)containerRow.containerId) || !Intrinsics.areEqual((Object)this.networkConfig, (Object)containerRow.networkConfig)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$TableLinkMouseListener;", "Lcom/intellij/execution/services/RepaintLinkMouseListenerBase;", "", "myTable", "Lcom/intellij/ui/table/JBTable;", "(Lcom/intellij/ui/table/JBTable;)V", "getTagAt", "e", "Ljava/awt/event/MouseEvent;", "isEnabled", "", "repaintComponent", "", "intellij.clouds.docker"})
    private static final class TableLinkMouseListener
    extends RepaintLinkMouseListenerBase<Object> {
        private final JBTable myTable;

        protected boolean isEnabled() {
            return this.myTable.getRowCount() > 0;
        }

        protected void repaintComponent(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.myTable.repaint();
        }

        @Nullable
        protected Object getTagAt(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Integer n = this.myTable.rowAtPoint(e.getPoint());
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                return null;
            }
            int row = n2;
            Integer n3 = this.myTable.columnAtPoint(e.getPoint());
            bl2 = false;
            it = 0;
            int it2 = ((Number)n3).intValue();
            boolean bl4 = false;
            Integer n4 = it2 >= 0 ? n3 : null;
            if (n4 == null) {
                return null;
            }
            int col = n4;
            Rectangle rectangle = this.myTable.getCellRect(row, col, false);
            if (rectangle == null) {
                return null;
            }
            Rectangle rectangle2 = rectangle;
            int dx = e.getX() - rectangle2.x;
            Object value = this.myTable.getValueAt(row, col);
            Component component2 = this.myTable.getCellRenderer(row, col).getTableCellRendererComponent((JTable)this.myTable, value, false, false, row, col);
            if (!(component2 instanceof SimpleColoredComponent)) {
                component2 = null;
            }
            SimpleColoredComponent simpleColoredComponent = (SimpleColoredComponent)component2;
            if (simpleColoredComponent == null) {
                return null;
            }
            SimpleColoredComponent component3 = simpleColoredComponent;
            return component3.getFragmentTagAt(dx);
        }

        public TableLinkMouseListener(@NotNull JBTable myTable) {
            Intrinsics.checkNotNullParameter((Object)myTable, (String)"myTable");
            this.myTable = myTable;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/view/details/DockerNetworkDetails$Companion;", "", "()V", "HELP_TOPIC", "", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

