/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.view.details.DockerComposeDetails;
import com.intellij.docker.view.details.DockerContainerDetails;
import com.intellij.docker.view.details.DockerDeploymentDetails;
import com.intellij.docker.view.details.DockerDeploymentDetailsBase;
import com.intellij.docker.view.details.DockerImageDetails;
import com.intellij.docker.view.details.DockerImagesGroupDetails;
import com.intellij.docker.view.details.DockerNetworkDetails;
import com.intellij.docker.view.details.DockerVolumeDetails;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentDetailsManager {
    private final Project myProject;
    private final Map<Deployment, DockerDeploymentDetails> myDeployment2Details;
    private long myLastCleanup;

    public DockerDeploymentDetailsManager(Project project) {
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(ServerConnectionListener.TOPIC, (Object)new ServerConnectionListener(){

            public void onConnectionCreated(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void onConnectionStatusChanged(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (connection.getStatus() == ConnectionStatus.DISCONNECTED) {
                    DockerDeploymentDetailsManager.this.myDeployment2Details.entrySet().stream().filter(e -> ((Deployment)e.getKey()).getConnection().equals(connection)).forEach(e -> DockerDeploymentDetailsManager.this.removeDeployment((Deployment)e.getKey()).disposeDetails());
                }
            }

            public void onDeploymentsChanged(@NotNull ServerConnection<?> connection) {
                long currentTime;
                if (connection == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((currentTime = System.currentTimeMillis()) - DockerDeploymentDetailsManager.this.myLastCleanup > 5000L) {
                    DockerDeploymentDetailsManager.this.myLastCleanup = currentTime;
                    Collection connectionDeployments = connection.getDeployments();
                    HashSet<Deployment> deployments2 = new HashSet<Deployment>(DockerDeploymentDetailsManager.this.myDeployment2Details.keySet());
                    List<Deployment> toRemove = DockerDeploymentDetailsManager.subtract(ContainerUtil.filter(deployments2, deployment -> deployment.getConnection().equals(connection)), connectionDeployments);
                    toRemove.forEach(d -> DockerDeploymentDetailsManager.this.removeDeployment((Deployment)d).disposeDetails());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "connection";
                objectArray2[1] = "com/intellij/docker/view/details/DockerDeploymentDetailsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionStatusChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onDeploymentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myDeployment2Details = ConcurrentFactoryMap.create(this::createDeploymentDetails, ConcurrentHashMap::new);
    }

    private static List<Deployment> subtract(Collection<Deployment> l1, Collection<?> l2) {
        ArrayList<Deployment> temp = new ArrayList<Deployment>(l1);
        temp.removeAll(l2);
        return temp;
    }

    public void updateContent(Deployment deployment) {
        if (this.myDeployment2Details.containsKey(deployment)) {
            DockerDeploymentDetails content = this.myDeployment2Details.get(deployment);
            UIUtil.invokeLaterIfNeeded(() -> content.update());
        }
    }

    private DockerDeploymentDetails createDeploymentDetails(@NotNull Deployment deployment) {
        DeploymentRuntime runtime;
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(0);
        }
        if ((runtime = deployment.getRuntime()) instanceof DockerGroupRuntime.ImagesGroup) {
            return new DockerImagesGroupDetails(this.myProject, deployment, (DockerGroupRuntime.ImagesGroup)runtime);
        }
        if (runtime instanceof DockerGroupRuntime) {
            return new EmptyDetails(this.myProject, deployment);
        }
        if (runtime instanceof ComposeServiceRuntime.WithoutContainers) {
            return new EmptyDetails(this.myProject, deployment);
        }
        if (DockerDeploymentDetailsManager.isComposeDeployment(deployment) || runtime instanceof ComposeServiceRuntime || runtime instanceof ComposeApplicationRuntime) {
            return new DockerComposeDetails(this.myProject, deployment);
        }
        if (DockerDeploymentDetailsManager.isImageDeployment(deployment)) {
            return new DockerImageDetails(this.myProject, deployment);
        }
        if (deployment.getRuntime() instanceof DockerVolumeRuntime) {
            return new DockerVolumeDetails(this.myProject, deployment);
        }
        if (deployment.getRuntime() instanceof DockerNetworkRuntime) {
            return new DockerNetworkDetails(this.myProject, deployment);
        }
        return new DockerContainerDetails(this.myProject, deployment);
    }

    @NotNull
    public DockerDeploymentDetails getDeploymentDetails(@NotNull Deployment deployment) {
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(1);
        }
        DockerDeploymentDetails dockerDeploymentDetails = this.myDeployment2Details.get(deployment);
        if (dockerDeploymentDetails == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(2);
        }
        return dockerDeploymentDetails;
    }

    public DockerDeploymentDetails removeDeployment(Deployment deployment) {
        return this.myDeployment2Details.remove(deployment);
    }

    private static boolean isComposeDeployment(@NotNull Deployment deployment) {
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(3);
        }
        return Optional.ofNullable(deployment.getDeploymentTask()).map(DeploymentTask::getSource).map(DeploymentSource::getType).orElse(null) instanceof DockerComposeDeploymentSourceType;
    }

    private static boolean isImageDeployment(@NotNull Deployment deployment) {
        DeploymentTask deploymentTask;
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(4);
        }
        if ((deploymentTask = deployment.getDeploymentTask()) != null && deploymentTask.getSource().getType() instanceof DockerFileDeploymentSourceType) {
            DockerDeploymentConfiguration configuration = (DockerDeploymentConfiguration)ObjectUtils.tryCast((Object)deploymentTask.getConfiguration(), DockerDeploymentConfiguration.class);
            return configuration != null && configuration.isBuildOnly();
        }
        return deployment.getRuntime() instanceof DockerImageRuntime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/details/DockerDeploymentDetailsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/details/DockerDeploymentDetailsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeploymentDetails";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentDetails";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isComposeDeployment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isImageDeployment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyDetails
    extends DockerDeploymentDetailsBase {
        EmptyDetails(@NotNull Project project, @NotNull Deployment deployment) {
            if (project == null) {
                EmptyDetails.$$$reportNull$$$0(0);
            }
            if (deployment == null) {
                EmptyDetails.$$$reportNull$$$0(1);
            }
            super(project, deployment);
        }

        @Override
        protected void createTabs(@NotNull ITabManager tabManager, @NotNull DeploymentRuntime runtime) {
            if (tabManager == null) {
                EmptyDetails.$$$reportNull$$$0(2);
            }
            if (runtime == null) {
                EmptyDetails.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtime";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/view/details/DockerDeploymentDetailsManager$EmptyDetails";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTabs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

