/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerPluginDisposable;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeployedContainerRuntime;
import com.intellij.docker.runtimes.DockerDeployingDeploymentRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntimeBase;
import com.intellij.docker.runtimes.DockerFailedDeploymentRuntime;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.view.DockerServiceViewDeleteProvider;
import com.intellij.docker.view.DockerTreeFilter;
import com.intellij.docker.view.details.DockerDeploymentDetails;
import com.intellij.docker.view.details.DockerDeploymentDetailsManager;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewLazyContributor;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerServiceViewContributor
extends RemoteServersServiceViewContributor
implements ServiceViewLazyContributor {
    private static final RemoteServersServiceViewContributor.ActionGroups DOCKER_ACTION_GROUPS = new RemoteServersServiceViewContributor.ActionGroups("Docker.RemoteServersViewToolbar", "Docker.RemoteServersViewToolbar.Top", "Docker.RemoteServersViewPopup");
    private static final DataProvider DATA_PROVIDER = dataId -> {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DockerServiceViewDeleteProvider();
        }
        return null;
    };
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new SimpleServiceViewDescriptor(DockerBundle.message("DockerServiceViewContributor.contributor.descriptor.name", new Object[0]), DockerIcons.Docker){

        @NotNull
        public DataProvider getDataProvider() {
            DataProvider dataProvider = DATA_PROVIDER;
            if (dataProvider == null) {
                1.$$$reportNull$$$0(0);
            }
            return dataProvider;
        }

        public ActionGroup getToolbarActions() {
            return DockerServiceViewContributor.getToolbarActions((RemoteServersServiceViewContributor.ActionGroups)DOCKER_ACTION_GROUPS);
        }

        public ActionGroup getPopupActions() {
            return DockerServiceViewContributor.getPopupActions((RemoteServersServiceViewContributor.ActionGroups)DOCKER_ACTION_GROUPS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/view/DockerServiceViewContributor$1", "getDataProvider"));
        }
    };
    private final Map<Project, DockerDeploymentDetailsManager> myDeploymentContentManagers = ConcurrentFactoryMap.createMap(project -> {
        DockerDeploymentDetailsManager deploymentContentManager = new DockerDeploymentDetailsManager((Project)project);
        Disposer.register((Disposable)DockerPluginDisposable.getInstance(project), () -> this.myDeploymentContentManagers.remove(project));
        return deploymentContentManager;
    });
    private DockerServerRuntimeInstance.TokenModificationTracker.Token myDeploymentsChangesToken;

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(0);
        }
        ServiceViewDescriptor serviceViewDescriptor = CONTRIBUTOR_DESCRIPTOR;
        if (serviceViewDescriptor == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(1);
        }
        return serviceViewDescriptor;
    }

    public boolean accept(@NotNull RemoteServer<?> server) {
        if (server == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(2);
        }
        return server.getType().equals((Object)DockerCloudType.getInstance());
    }

    public void selectLog(@NotNull AbstractTreeNode<?> deploymentNode, @NotNull String logName) {
        if (deploymentNode == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(3);
        }
        if (logName == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(4);
        }
        ServiceViewManager.getInstance((Project)deploymentNode.getProject()).select(deploymentNode, DockerServiceViewContributor.class, true, true).onSuccess(any -> {
            DockerDeploymentNode node = (DockerDeploymentNode)ObjectUtils.tryCast((Object)deploymentNode, DockerDeploymentNode.class);
            if (node != null) {
                node.selectDetailsTab(logName);
            }
        });
    }

    @NotNull
    public RemoteServersServiceViewContributor.ActionGroups getActionGroups() {
        RemoteServersServiceViewContributor.ActionGroups actionGroups = DOCKER_ACTION_GROUPS;
        if (actionGroups == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(5);
        }
        return actionGroups;
    }

    public AbstractTreeNode<?> createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        Project project = Objects.requireNonNull(serverNode.getProject());
        if (project.isDisposed()) {
            return new DockerDeploymentNode(project, connection, serverNode, deployment, (ServersTreeStructure.DeploymentNodeProducer)this, DeploymentDetailsProvider.NO_DETAILS);
        }
        DockerDeploymentDetailsManager deploymentContentManager = this.myDeploymentContentManagers.get(project);
        deploymentContentManager.updateContent(deployment);
        return new DockerDeploymentNode(project, connection, serverNode, deployment, (ServersTreeStructure.DeploymentNodeProducer)this, deploymentContentManager::getDeploymentDetails);
    }

    @NotNull
    protected RemoteServersServiceViewContributor.RemoteServerNodeServiceViewContributor createNodeContributor(@NotNull AbstractTreeNode<?> node) {
        DockerRuntimeBase appRuntime;
        if (node == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(6);
        }
        if ((appRuntime = (DockerRuntimeBase)Optional.of(node).map(o -> (ServersTreeStructure.DeploymentNodeImpl)ObjectUtils.tryCast((Object)o, ServersTreeStructure.DeploymentNodeImpl.class)).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).map(Deployment::getRuntime).map(o -> (DockerRuntimeBase)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerRuntimeBase.class)))).orElse(null)) instanceof DockerParentRuntime) {
            if (appRuntime instanceof ComposeServiceRuntime && !((ComposeServiceRuntime)appRuntime).isContainsContainers()) {
                return new DockerNodeServiceViewContributor(this, node);
            }
            return new DockerNodeLazyServiceViewContributor(this, node);
        }
        return new DockerNodeServiceViewContributor(this, node);
    }

    @NotNull
    protected ServiceEventListener.ServiceEvent createDeploymentsChangedEvent(@NotNull ServerConnection<?> connection) {
        ServerConnectionImpl connectionImpl;
        DockerServerRuntimeInstance.TokenModificationTracker tracker;
        if (connection == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(7);
        }
        if ((tracker = (DockerServerRuntimeInstance.TokenModificationTracker)Optional.ofNullable((connectionImpl = (ServerConnectionImpl)connection).getServerRuntimeInstance()).map(o -> (DockerServerRuntimeInstance)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerServerRuntimeInstance.class)))).map(DockerServerRuntimeInstance::getModificationTracker).orElse(null)) != null) {
            boolean hasActualChanges;
            if (this.myDeploymentsChangesToken == null) {
                this.myDeploymentsChangesToken = tracker.createToken();
            }
            if (!(hasActualChanges = tracker.checkAndUpdateToken(this.myDeploymentsChangesToken))) {
                ServiceEventListener.ServiceEvent serviceEvent = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.RESET, (Object)ServiceEventListener.POLLING_RESET_TARGET, ((Object)((Object)this)).getClass());
                if (serviceEvent == null) {
                    DockerServiceViewContributor.$$$reportNull$$$0(8);
                }
                return serviceEvent;
            }
        }
        ServiceEventListener.ServiceEvent serviceEvent = super.createDeploymentsChangedEvent(connection);
        if (serviceEvent == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(9);
        }
        return serviceEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/DockerServiceViewContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/DockerServiceViewContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroups";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeploymentsChangedEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectLog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNodeContributor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDeploymentsChangedEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface DeploymentDetailsProvider {
        public static final DeploymentDetailsProvider NO_DETAILS = deployment -> null;

        @Nullable
        public DockerDeploymentDetails getDeploymentDetails(@NotNull Deployment var1);
    }

    private static class DockerDeploymentNode
    extends ServersTreeStructure.DeploymentNodeImpl
    implements DetailsProvidingNode {
        private final DeploymentDetailsProvider myDetailsProvider;
        private DockerDeploymentDetails myDetails;
        private boolean myShowDetails;

        DockerDeploymentNode(Project project, @NotNull ServerConnection<?> connection, @NotNull ServersTreeStructure.RemoteServerNode serverNode, @NotNull Deployment value, @NotNull ServersTreeStructure.DeploymentNodeProducer nodeProducer, @NotNull DeploymentDetailsProvider detailsProvider) {
            if (connection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(0);
            }
            if (serverNode == null) {
                DockerDeploymentNode.$$$reportNull$$$0(1);
            }
            if (value == null) {
                DockerDeploymentNode.$$$reportNull$$$0(2);
            }
            if (nodeProducer == null) {
                DockerDeploymentNode.$$$reportNull$$$0(3);
            }
            if (detailsProvider == null) {
                DockerDeploymentNode.$$$reportNull$$$0(4);
            }
            super(project, connection, serverNode, value, nodeProducer);
            this.myShowDetails = false;
            this.myDetailsProvider = detailsProvider;
        }

        public void setShowDetails() {
            this.myShowDetails = true;
        }

        @Nullable
        public JComponent getComponent() {
            DockerDeploymentDetails content = this.getDetails();
            return content != null && !content.isDisposed() ? content.show() : null;
        }

        public boolean isDeployActionEnabled() {
            if (this.getDeployment().getRuntime() instanceof DockerDeployingDeploymentRuntime) {
                return false;
            }
            return super.isDeployActionEnabled();
        }

        @Override
        @Nullable
        public DockerDeploymentDetails getDetails() {
            if (this.myDetails == null && this.getDeployment().getRuntime() != null) {
                this.myDetails = this.myDetailsProvider.getDeploymentDetails(this.getDeployment());
            }
            return this.myDetails;
        }

        @Override
        @Nullable
        public ITabManager getDetailsTabs() {
            DockerDeploymentDetails details = this.getDetails();
            return details == null ? null : details.forceCreateTabManager();
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            ArrayList result2 = new ArrayList();
            this.collectDeploymentChildren(result2);
            Stream stream = result2.stream();
            Collection collection = stream.filter(node -> !DockerDeploymentNode.isUndeployedDockerNode(node)).collect(Collectors.toList());
            if (collection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private static boolean isUndeployedDockerNode(@Nullable AbstractTreeNode<?> node) {
            Deployment deployment = Optional.ofNullable(node).map(o -> (DockerDeploymentNode)ObjectUtils.tryCast((Object)o, DockerDeploymentNode.class)).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).orElse(null);
            return deployment != null && DockerDeploymentStatus.DELETED.matches(deployment) && deployment.getRuntime() instanceof DockerDeployedContainerRuntime;
        }

        public void selectDetailsTab(@NotNull String tabName) {
            DockerDeploymentDetails details;
            if (tabName == null) {
                DockerDeploymentNode.$$$reportNull$$$0(6);
            }
            if ((details = this.getDetails()) != null) {
                details.selectTab(tabName);
            }
        }

        protected void update(@NotNull PresentationData presentation) {
            ComposeServiceRuntime serviceRuntime;
            if (presentation == null) {
                DockerDeploymentNode.$$$reportNull$$$0(7);
            }
            super.update(presentation);
            Deployment deployment = this.getDeployment();
            DockerDeploymentRuntimeBase runtime = (DockerDeploymentRuntimeBase)deployment.getRuntime();
            if (deployment.getStatus() == DeploymentStatus.DEPLOYED) {
                Icon icon = DockerIcons.SingleRunningContainer;
                if (runtime != null) {
                    if (runtime.getStatus() == DockerDeploymentStatus.IMAGE) {
                        icon = DockerIcons.SingleImage;
                    } else if (runtime instanceof DockerNetworkRuntime) {
                        if (runtime.getParent() instanceof ComposeApplicationRuntime) {
                            icon = DockerIcons.Network;
                        }
                    } else if (runtime instanceof ComposeApplicationRuntime) {
                        icon = DockerIcons.ContainersList_2;
                    }
                }
                presentation.setIcon(icon);
            }
            if ((serviceRuntime = (ComposeServiceRuntime)ObjectUtils.tryCast((Object)((Object)runtime), ComposeServiceRuntime.class)) != null) {
                presentation.setPresentableText(serviceRuntime.getServiceName());
            }
            if (this.myShowDetails) {
                if (this.myDetails != null) {
                    this.myDetails.update();
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        DockerDeploymentDetails content;
                        if (deployment.getRuntime() != null && (content = this.myDetailsProvider.getDeploymentDetails(deployment)) != null) {
                            content.update();
                        }
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeProducer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/DockerServiceViewContributor$DockerDeploymentNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/DockerServiceViewContributor$DockerDeploymentNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "selectDetailsTab";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DetailsProvidingNode
    extends DeploymentNode {
        @Nullable
        public DockerDeploymentDetails getDetails();

        @Nullable
        public ITabManager getDetailsTabs();
    }

    private static class DockerNodeServiceViewContributor
    extends RemoteServersServiceViewContributor.RemoteServerNodeServiceViewContributor {
        DockerNodeServiceViewContributor(@NotNull RemoteServersServiceViewContributor rootContributor, @NotNull AbstractTreeNode<?> node) {
            if (rootContributor == null) {
                DockerNodeServiceViewContributor.$$$reportNull$$$0(0);
            }
            if (node == null) {
                DockerNodeServiceViewContributor.$$$reportNull$$$0(1);
            }
            super(rootContributor, node);
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            if (project == null) {
                DockerNodeServiceViewContributor.$$$reportNull$$$0(2);
            }
            return new DockerNodeDescriptor(this.asService(), this.getRootContributor().getActionGroups());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootContributor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/view/DockerServiceViewContributor$DockerNodeServiceViewContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getViewDescriptor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DockerNodeLazyServiceViewContributor
    extends DockerNodeServiceViewContributor
    implements ServiceViewLazyContributor {
        DockerNodeLazyServiceViewContributor(@NotNull RemoteServersServiceViewContributor rootContributor, @NotNull AbstractTreeNode<?> node) {
            if (rootContributor == null) {
                DockerNodeLazyServiceViewContributor.$$$reportNull$$$0(0);
            }
            if (node == null) {
                DockerNodeLazyServiceViewContributor.$$$reportNull$$$0(1);
            }
            super(rootContributor, node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootContributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/view/DockerServiceViewContributor$DockerNodeLazyServiceViewContributor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DockerNodeDescriptor
    extends RemoteServersServiceViewContributor.RemoteServerNodeDescriptor
    implements ServiceViewLocatableDescriptor {
        DockerNodeDescriptor(@NotNull AbstractTreeNode<?> node, @NotNull RemoteServersServiceViewContributor.ActionGroups actionGroups) {
            if (node == null) {
                DockerNodeDescriptor.$$$reportNull$$$0(0);
            }
            if (actionGroups == null) {
                DockerNodeDescriptor.$$$reportNull$$$0(1);
            }
            super(node, actionGroups);
        }

        public void onNodeSelected() {
            super.onNodeSelected();
            AbstractTreeNode node = this.getNode();
            if (node instanceof DockerDeploymentNode) {
                ((DockerDeploymentNode)node).setShowDetails();
            }
        }

        @Nullable
        public Navigatable getNavigatable() {
            AbstractTreeNode node = this.getNode();
            if (!(node instanceof DeploymentNode)) {
                return null;
            }
            Project project = node.getProject();
            if (project == null) {
                return null;
            }
            DockerRuntimeBase runtime = (DockerRuntimeBase)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)((DeploymentNode)node), DockerRuntimeBase.class));
            if (runtime == null) {
                DockerFailedDeploymentRuntime failedRuntime = (DockerFailedDeploymentRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)((DeploymentNode)node), DockerFailedDeploymentRuntime.class));
                if (failedRuntime != null) {
                    return failedRuntime.computeNavigatable(project);
                }
                return null;
            }
            return runtime.computeNavigatable(project);
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            AbstractTreeNode node = this.getNode();
            if (!(node instanceof DeploymentNode)) {
                return null;
            }
            DockerRuntimeBase runtime = (DockerRuntimeBase)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)((DeploymentNode)node), DockerRuntimeBase.class));
            if (runtime == null) {
                return null;
            }
            return runtime.computeVirtualFile(node.getProject());
        }

        @Nullable
        public Runnable getRemover() {
            Runnable remover = super.getRemover();
            if (remover != null) {
                return remover;
            }
            AbstractTreeNode node = this.getNode();
            if (!(node instanceof DeploymentNode)) {
                return null;
            }
            Deployment deployment = ApplicationActionUtils.getDeployment((DeploymentNode)((DeploymentNode)node));
            if (DockerActionUtils.isFailedContainerDeployment(deployment)) {
                return () -> {
                    deployment.setStatus(DeploymentStatus.DEPLOYING, null);
                    deployment.getConnection().undeploy(deployment, null);
                };
            }
            DockerRuntimeBase runtime = (DockerRuntimeBase)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)((DeploymentNode)node), DockerRuntimeBase.class));
            if (runtime instanceof DockerImageRuntime) {
                return () -> ((DockerImageRuntime)runtime).deleteImage();
            }
            if (runtime instanceof DockerApplicationRuntime && DockerActionUtils.isContainerRuntime((DockerApplicationRuntime)runtime)) {
                return () -> ((DockerApplicationRuntime)runtime).deleteContainer();
            }
            if (runtime instanceof ComposeServiceRuntime.WithoutContainers) {
                return null;
            }
            if (runtime instanceof ComposeServiceRuntime) {
                return () -> ((ComposeServiceRuntime)runtime).deleteAllContainers();
            }
            if (runtime instanceof DockerNetworkRuntime) {
                if (((DockerNetworkRuntime)runtime).isPredefined()) {
                    return null;
                }
                return () -> ((DockerNetworkRuntime)runtime).deleteNetwork();
            }
            if (runtime instanceof DockerVolumeRuntime) {
                return () -> ((DockerVolumeRuntime)runtime).deleteVolume();
            }
            return null;
        }

        public boolean isVisible() {
            return DockerTreeFilter.getInstance().acceptNode(this.getNode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionGroups";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/view/DockerServiceViewContributor$DockerNodeDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

