/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRuntimeEditorBase {
    @Nls
    private final String myName;
    private final ConfigApplier myOnSave;
    private JPanel myMainPanel;
    @Nullable
    private JButton mySaveButton;

    public DockerRuntimeEditorBase(@Nls(capitalization=Nls.Capitalization.Title) String name, ConfigApplier onSave2) {
        this.myName = name;
        this.myOnSave = onSave2;
    }

    protected final void initControls(@NotNull JPanel mainPanel, @Nullable JButton saveButton) {
        if (mainPanel == null) {
            DockerRuntimeEditorBase.$$$reportNull$$$0(0);
        }
        this.myMainPanel = mainPanel;
        this.myMainPanel.putClientProperty("DataProvider", dataId -> {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return this.getContextHelpId();
            }
            return null;
        });
        if (saveButton != null) {
            saveButton.addActionListener(e -> this.save());
        }
        this.mySaveButton = saveButton;
    }

    @Nullable
    protected String getContextHelpId() {
        return null;
    }

    private void save() {
        boolean applied;
        DockerAgentContainerConfig config = this.createConfig();
        if (config != null && (applied = this.myOnSave.applyNewConfig(config))) {
            UIUtil.setEnabled((Component)this.myMainPanel, (boolean)false, (boolean)true);
            if (this.mySaveButton != null) {
                this.mySaveButton.setText(DockerBundle.message("DockerRuntimeEditorBase.save.button.title", new Object[0]));
            }
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    @Nullable
    protected abstract DockerAgentContainerConfig createConfig();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainPanel", "com/intellij/docker/view/DockerRuntimeEditorBase", "initControls"));
    }

    public static interface ConfigApplier {
        public boolean applyNewConfig(DockerAgentContainerConfig var1);
    }
}

