/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.DockerPropertiesRuntimeEditorBase;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerPropertiesRuntimeEditor
extends DockerPropertiesRuntimeEditorBase {
    private final ComboBox<String> myContainerNamesBox;
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("^[\\/]?[a-zA-Z0-9_.-]+");

    public DockerPropertiesRuntimeEditor(@Nullable DockerAgentContainerConfig config, @NotNull DockerApplicationRuntime containerRuntime, @Nullable DockerRuntimeEditorBase.ConfigApplier configApplier) {
        String[] containerNames;
        if (containerRuntime == null) {
            DockerPropertiesRuntimeEditor.$$$reportNull$$$0(0);
        }
        super(DockerBundle.message("DockerPropertiesRuntimeEditor.name", new Object[0]), configApplier);
        JPanel topPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), 0));
        topPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
        JLabel label = new JLabel(DockerBundle.message("DockerPropertiesRuntimeEditor.container.name.text", new Object[0]));
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)1));
        topPanel.add((Component)label, "West");
        this.myContainerNamesBox = new ComboBox();
        this.myContainerNamesBox.setEditable(true);
        topPanel.add((Component)this.myContainerNamesBox, "Center");
        JButton saveButton = new JButton(DockerBundle.message("DockerRuntimeEditor.save.text", new Object[0]));
        topPanel.add((Component)saveButton, "East");
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel tablePlaceHolder = new JPanel(new BorderLayout());
        mainPanel.add((Component)tablePlaceHolder, "Center");
        mainPanel.add((Component)topPanel, "North");
        this.initControls(mainPanel, saveButton);
        this.addRow(DockerBundle.message("DockerPropertiesRuntimeEditor.property.image.id", new Object[0]), containerRuntime.getImageId());
        this.addRow(DockerBundle.message("DockerPropertiesRuntimeEditor.property.container.id", new Object[0]), containerRuntime.getContainerId());
        this.myContainerNamesBox.removeAllItems();
        @NlsSafe String requestedContainerName = config != null ? config.getContainerName() : DockerSingletonDeploymentSourceType.NAME_PIECE_UNKNOWN.get();
        for (String name : containerNames = Optional.ofNullable(containerRuntime.getContainerNames()).orElseGet(() -> new String[]{requestedContainerName})) {
            this.myContainerNamesBox.addItem((Object)name);
        }
        this.myContainerNamesBox.setSelectedItem((Object)requestedContainerName);
        this.addRow(DockerBundle.message("DockerPropertiesRuntimeEditor.property.container.names", new Object[0]), StringUtil.join((String[])containerNames, (String)"; "));
        tablePlaceHolder.add(this.createTable());
    }

    @Override
    protected DockerAgentContainerConfig createConfig() {
        final String containerName2 = this.myContainerNamesBox.getEditor().getItem().toString();
        if (this.myContainerNamesBox.getItemCount() > 1 && Messages.showYesNoDialog((Component)this.getMainPanel(), (String)DockerBundle.message("DockerPropertiesRuntimeEditor.containers.names.warning.message", new Object[0]), (String)DockerBundle.message("DockerPropertiesRuntimeEditor.containers.names.warning.title", new Object[0]), (Icon)Messages.getWarningIcon()) != 1 || this.myContainerNamesBox.getItemCount() == 1) {
            if (!CONTAINER_NAME_PATTERN.matcher(containerName2).matches()) {
                Messages.showErrorDialog((String)(containerName2.isEmpty() ? DockerBundle.message("DockerPropertiesRuntimeEditor.container.name.error.empty.message", new Object[0]) : DockerBundle.message("DockerPropertiesRuntimeEditor.container.name.error.invalid.message", containerName2)), (String)DockerBundle.message("DockerPropertiesRuntimeEditor.container.name.error.title", new Object[0]));
            } else {
                return new DockerAgentContainerConfig.Adapter(){

                    @Override
                    public String getContainerName() {
                        return StringUtil.nullize((String)containerName2);
                    }
                };
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected String getContextHelpId() {
        return "reference.docker.runtime.properties";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerRuntime", "com/intellij/docker/view/DockerPropertiesRuntimeEditor", "<init>"));
    }
}

