/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerPluginDisposable;
import com.intellij.docker.agent.cli.communicator.CliCommunicator;
import com.intellij.docker.cli.executor.DockerCliCommunicator;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.docker.utils.DockerUtils$toVirtualFilePointer$;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.UtilKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a'\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u000e\b\u0004\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a\u001e\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b*\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0000\u001a%\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\u0011\u001a\u0002H\u0006H\u0000\u00a2\u0006\u0002\u0010\u0012\u001a\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014*\u0006\u0012\u0002\b\u00030\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0001\u001a+\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u0006\"\u000e\b\u0001\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00060\u0019*\u0004\u0018\u0001H\u0018H\u0000\u00a2\u0006\u0002\u0010\u001a\u001a<\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u0002H\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u000b0\u001c\"\u0004\b\u0000\u0010\u001e\"\u0004\b\u0001\u0010\u001d*\u0014\u0012\u0004\u0012\u0002H\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u000b0\u001cH\u0000\u001a\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000b*\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!H\u0000\u001a\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020%H\u0000\u001a\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020 H\u0000\u001aR\u0010&\u001a\u0004\u0018\u00010\"*\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u00102\b\b\u0002\u0010(\u001a\u00020)2\u0016\b\u0002\u0010*\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020,0+2\u0016\b\u0002\u0010-\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020,0+H\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006."}, d2={"findProjectByName", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "name", "", "runReedActionIfNeeded", "T", "function", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "allServersExceptKnowns", "", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "containsOnly", "", "element", "(Ljava/util/List;Ljava/lang/Object;)Z", "inspect", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/runtimes/DockerPhysicalRuntime;", "format", "nullize", "C", "", "(Ljava/util/Collection;)Ljava/util/Collection;", "reverse", "", "V", "K", "toFiles", "Ljava/io/File;", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "toPsiFile", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "toVirtualFilePointer", "isUrl", "disposer", "Lcom/intellij/openapi/Disposable;", "beforeChange", "Lkotlin/Function1;", "", "afterChange", "intellij.clouds.docker"})
@JvmName(name="DockerUtils")
public final class DockerUtils {
    public static final <T> boolean containsOnly(@NotNull List<? extends T> $this$containsOnly, T element) {
        Intrinsics.checkNotNullParameter($this$containsOnly, (String)"$this$containsOnly");
        return $this$containsOnly.size() == 1 && $this$containsOnly.contains(element);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RemoteServer<DockerCloudConfiguration>> allServersExceptKnowns(@NotNull List<DockerRunConfig.Wrapper> $this$allServersExceptKnowns) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$allServersExceptKnowns, (String)"$this$allServersExceptKnowns");
        Iterable $this$mapNotNull$iv = $this$allServersExceptKnowns;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DockerRunConfig.Wrapper it = (DockerRunConfig.Wrapper)element$iv$iv;
            boolean bl2 = false;
            if (it.getConfig().getServerName() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set knownServerNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List list = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"RemoteServersManager.get\u2026rCloudType.getInstance())");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RemoteServer it = (RemoteServer)element$iv$iv;
            boolean bl = false;
            RemoteServer remoteServer = it;
            Intrinsics.checkNotNullExpressionValue((Object)remoteServer, (String)"it");
            if (!(!knownServerNames.contains(remoteServer.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Project findProjectByName(@NotNull String name) {
        Project project;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] projectArray2 = projectArray;
            boolean bl = false;
            Project[] projectArray3 = projectArray2;
            boolean bl2 = false;
            Project[] projectArray4 = projectArray3;
            int n = projectArray4.length;
            for (int j = 0; j < n; ++j) {
                Project project2;
                Project it = project2 = projectArray4[j];
                boolean bl3 = false;
                Project project3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
                if (!Intrinsics.areEqual((Object)project3.getName(), (Object)name)) continue;
                project = project2;
                break block1;
            }
            project = null;
        }
        return project;
    }

    @Nullable
    public static final PsiFile toPsiFile(@NotNull File $this$toPsiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toPsiFile, (String)"$this$toPsiFile");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath($this$toPsiFile.toPath());
        return virtualFile != null ? DockerUtils.toPsiFile(virtualFile) : null;
    }

    public static final <T> T runReedActionIfNeeded(@NotNull Function0<? extends T> function) {
        Object object;
        int $i$f$runReedActionIfNeeded = 0;
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean reedAccessAllowed = application.isReadAccessAllowed();
        if (reedAccessAllowed) {
            object = function.invoke();
        } else {
            boolean $i$f$runReadAction = false;
            object = ApplicationManager.getApplication().runReadAction(new Computable(function){
                final /* synthetic */ Function0 $runnable;
                {
                    this.$runnable = function0;
                }

                public final T compute() {
                    return (T)this.$runnable.invoke();
                }
            });
        }
        return (T)object;
    }

    @Nullable
    public static final <T, C extends Collection<? extends T>> C nullize(@Nullable C $this$nullize) {
        return UtilKt.isNullOrEmpty($this$nullize) ? null : (C)$this$nullize;
    }

    @Nullable
    public static final PsiFile toPsiFile(@NotNull VirtualFile $this$toPsiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toPsiFile, (String)"$this$toPsiFile");
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        for (Project project : projectManager.getOpenProjects()) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile($this$toPsiFile);
            if (psiFile == null) continue;
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final CompletableFuture<String> inspect(@NotNull DockerPhysicalRuntime<?> $this$inspect, @Nullable String format) {
        void type2;
        Pair pair;
        Intrinsics.checkNotNullParameter($this$inspect, (String)"$this$inspect");
        DockerPhysicalRuntime<?> dockerPhysicalRuntime = $this$inspect;
        if (dockerPhysicalRuntime instanceof DockerImageRuntime) {
            pair = new Pair((Object)"image", (Object)((DockerImageRuntime)$this$inspect).getImageId());
        } else if (dockerPhysicalRuntime instanceof DockerVolumeRuntime) {
            pair = new Pair((Object)"volume", (Object)((DockerVolumeRuntime)$this$inspect).getVolumeId());
        } else if (dockerPhysicalRuntime instanceof DockerNetworkRuntime) {
            pair = new Pair((Object)"network", (Object)((DockerNetworkRuntime)$this$inspect).getNetwork().getId());
        } else if (dockerPhysicalRuntime instanceof DockerContainerRuntime) {
            pair = new Pair((Object)"container", (Object)((DockerContainerRuntime)$this$inspect).getContainerId());
        } else {
            throw (Throwable)new RuntimeException("Unknown runtime type " + Reflection.getOrCreateKotlinClass(((Object)$this$inspect).getClass()).getSimpleName());
        }
        Pair pair2 = pair;
        String string = (String)pair2.component1();
        String id = (String)pair2.component2();
        CliCommunicator cliCommunicator = $this$inspect.getContext().getAgent().getCliFacade().createDockerCommunicator();
        if (cliCommunicator == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.docker.cli.executor.DockerCliCommunicator");
        }
        return ((DockerCliCommunicator)cliCommunicator).inspect((String)type2, id, format);
    }

    public static /* synthetic */ CompletableFuture inspect$default(DockerPhysicalRuntime dockerPhysicalRuntime, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return DockerUtils.inspect(dockerPhysicalRuntime, string);
    }

    @JvmOverloads
    @NotNull
    public static final CompletableFuture<String> inspect(@NotNull DockerPhysicalRuntime<?> $this$inspect) {
        return DockerUtils.inspect$default($this$inspect, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<V, List<K>> reverse(@NotNull Map<K, ? extends List<? extends V>> $this$reverse) {
        Intrinsics.checkNotNullParameter($this$reverse, (String)"$this$reverse");
        Map map2 = FactoryMap.create((Function)reverse.result.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"FactoryMap.create<V, Mut\u2026{\n    mutableListOf()\n  }");
        Map result2 = map2;
        Map<K, List<V>> $this$forEach$iv = $this$reverse;
        boolean $i$f$forEach = false;
        Map<K, List<V>> map3 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<K, List<V>>> iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, List<List<List<List<V>>>>> element$iv;
            Map.Entry<K, List<List<List<List<V>>>>> $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<K, List<List<List<List<V>>>>> entry = $dstr$k$v;
            boolean bl3 = false;
            K k = entry.getKey();
            entry = $dstr$k$v;
            bl3 = false;
            List<? extends List<? extends V>> v = entry.getValue();
            Iterable $this$forEach$iv2 = v;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                void k2;
                Object element$iv2;
                Object it = element$iv2 = iterator2.next();
                boolean bl4 = false;
                Object v2 = result2.get(it);
                Intrinsics.checkNotNull(v2);
                ((List)v2).add(k2);
            }
        }
        return result2;
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFilePointer toVirtualFilePointer(@NotNull String $this$toVirtualFilePointer, boolean isUrl, @NotNull Disposable disposer, @NotNull Function1<? super VirtualFilePointer, Unit> beforeChange, @NotNull Function1<? super VirtualFilePointer, Unit> afterChange) {
        VirtualFilePointer virtualFilePointer;
        Intrinsics.checkNotNullParameter((Object)$this$toVirtualFilePointer, (String)"$this$toVirtualFilePointer");
        Intrinsics.checkNotNullParameter((Object)disposer, (String)"disposer");
        Intrinsics.checkNotNullParameter(beforeChange, (String)"beforeChange");
        Intrinsics.checkNotNullParameter(afterChange, (String)"afterChange");
        String string = isUrl ? VfsUtilCore.urlToPath((String)$this$toVirtualFilePointer) : $this$toVirtualFilePointer;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (isUrl) VfsUtilCore.urlToPath(this) else this");
        String path = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile file2 = virtualFile2;
            boolean bl3 = false;
            boolean $i$f$runReadAction = false;
            virtualFilePointer = (VirtualFilePointer)ApplicationManager.getApplication().runReadAction(new Computable(file2, disposer, afterChange, beforeChange){
                final /* synthetic */ VirtualFile $file$inlined;
                final /* synthetic */ Disposable $disposer$inlined;
                final /* synthetic */ Function1 $afterChange$inlined;
                final /* synthetic */ Function1 $beforeChange$inlined;
                {
                    this.$file$inlined = virtualFile;
                    this.$disposer$inlined = disposable;
                    this.$afterChange$inlined = function1;
                    this.$beforeChange$inlined = function12;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)VirtualFilePointerManager.getInstance().create(this.$file$inlined, this.$disposer$inlined, new VirtualFilePointerListener(this){
                        final /* synthetic */ toVirtualFilePointer$$inlined$let$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
                            Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
                            this.this$0.$afterChange$inlined.invoke(ArraysKt.firstOrNull((Object[])pointers));
                        }

                        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
                            Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
                            this.this$0.$beforeChange$inlined.invoke(ArraysKt.firstOrNull((Object[])pointers));
                        }
                    });
                }
            });
        } else {
            virtualFilePointer = null;
        }
        return virtualFilePointer;
    }

    public static /* synthetic */ VirtualFilePointer toVirtualFilePointer$default(String string, boolean bl, Disposable disposable, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            disposable = DockerPluginDisposable.Companion.getInstance$default(DockerPluginDisposable.Companion, null, 1, null);
        }
        if ((n & 4) != 0) {
            function1 = toVirtualFilePointer.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function12 = toVirtualFilePointer.2.INSTANCE;
        }
        return DockerUtils.toVirtualFilePointer(string, bl, disposable, (Function1<? super VirtualFilePointer, Unit>)function1, (Function1<? super VirtualFilePointer, Unit>)function12);
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFilePointer toVirtualFilePointer(@NotNull String $this$toVirtualFilePointer, boolean isUrl, @NotNull Disposable disposer, @NotNull Function1<? super VirtualFilePointer, Unit> beforeChange) {
        return DockerUtils.toVirtualFilePointer$default($this$toVirtualFilePointer, isUrl, disposer, beforeChange, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFilePointer toVirtualFilePointer(@NotNull String $this$toVirtualFilePointer, boolean isUrl, @NotNull Disposable disposer) {
        return DockerUtils.toVirtualFilePointer$default($this$toVirtualFilePointer, isUrl, disposer, null, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFilePointer toVirtualFilePointer(@NotNull String $this$toVirtualFilePointer, boolean isUrl) {
        return DockerUtils.toVirtualFilePointer$default($this$toVirtualFilePointer, isUrl, null, null, null, 14, null);
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFilePointer toVirtualFilePointer(@NotNull String $this$toVirtualFilePointer) {
        return DockerUtils.toVirtualFilePointer$default($this$toVirtualFilePointer, false, null, null, null, 15, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> toFiles(@NotNull Iterable<? extends VirtualFilePointer> $this$toFiles) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toFiles, (String)"$this$toFiles");
        Iterable<? extends VirtualFilePointer> $this$mapNotNull$iv = $this$toFiles;
        boolean $i$f$mapNotNull = false;
        Iterable<? extends VirtualFilePointer> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFilePointer it = (VirtualFilePointer)element$iv$iv;
            boolean bl2 = false;
            Object object = it;
            if ((object != null && (object = object.getFile()) != null && (object = object.toNioPath()) != null ? object.toFile() : null) == null) continue;
            file2 = file2;
            boolean bl3 = false;
            boolean bl4 = false;
            File it$iv$iv = file2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

