/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.delete.provider;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.graph.DockerAbstractDependenciesResolver;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.ui.delete.provider.DockerAbstractDeleteProvider;
import com.intellij.docker.ui.utils.DockerDeleteConfirmation;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u00020\u0005:\u0002\u001e\u001fB\u001f\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0001H$\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H$J\u0015\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0017R\u0018\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\u00070\f\u00a2\u0006\u0002\b\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider;", "RUNTIME", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "RESOLVER", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver;", "", "runtimes", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "cancelButtonText", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "forceDeleteButtonText", "runtimeName", "getRuntimeName", "()Ljava/lang/String;", "smartDeleteButtonText", "createResolver", "()Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver;", "deleteNode", "", "node", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver$Node;", "deleteRuntime", "runtime", "(Lcom/intellij/docker/runtimes/DockerRuntimeBase;)V", "performDeletion", "DeleteQueueComputer", "SmartDeleteDialog", "intellij.clouds.docker"})
public abstract class DockerAbstractDeleteProvider<RUNTIME extends DockerRuntimeBase, RESOLVER extends DockerAbstractDependenciesResolver<?, ?, ?>> {
    private final String forceDeleteButtonText;
    private final String smartDeleteButtonText;
    private final String cancelButtonText;
    private final List<RUNTIME> runtimes;
    private final Project project;

    @NotNull
    protected abstract String getRuntimeName();

    protected abstract void deleteRuntime(@NotNull RUNTIME var1);

    protected abstract void deleteNode(@NotNull DockerAbstractDependenciesResolver.Node<?> var1);

    @Nullable
    protected abstract RESOLVER createResolver();

    /*
     * WARNING - void declaration
     */
    public final void performDeletion() {
        String dialog2;
        if (this.runtimes.isEmpty()) {
            return;
        }
        Object object = this.createResolver();
        if (object == null || (object = ((DockerAbstractDependenciesResolver)object).resolve()) == null) {
            return;
        }
        RESOLVER resolver = object;
        Collection collection = ((DockerAbstractDependenciesResolver)resolver).getRoots();
        boolean bl = false;
        if (!collection.isEmpty()) {
            void title$iv;
            List<DockerAbstractDependenciesResolver.Node<?>> list;
            String string = DockerBundle.message("DockerDeleteProvider.confirmation.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"DockerDeleteProvider.confirmation.title\")");
            String string2 = DockerBundle.message("DockerDeleteProvider.confirmation.text.runtime.with.dependencies", this.runtimes.size(), this.getRuntimeName());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"DockerDeletePro\u2026ntimes.size, runtimeName)");
            dialog2 = new MessageDialogBuilder.Message(string, string2).buttons(new String[]{this.forceDeleteButtonText, this.smartDeleteButtonText, this.cancelButtonText}).defaultButton(this.forceDeleteButtonText);
            String string3 = MessageDialogBuilder.Message.show$default((MessageDialogBuilder.Message)dialog2, null, null, (int)3, null);
            if (Intrinsics.areEqual((Object)string3, (Object)this.smartDeleteButtonText)) {
                SmartDeleteDialog smartDialog = new SmartDeleteDialog((DockerAbstractDependenciesResolver<?, ?, ?>)resolver);
                if (!smartDialog.showAndGet()) {
                    return;
                }
                list = new DeleteQueueComputer<Object>(resolver, smartDialog.getUncheckedElements()).getQueue();
            } else if (Intrinsics.areEqual((Object)string3, (Object)this.forceDeleteButtonText)) {
                list = new DeleteQueueComputer((DockerAbstractDependenciesResolver)resolver, null, 2, null).getQueue();
            } else {
                return;
            }
            List<DockerAbstractDependenciesResolver.Node<?>> queue = list;
            String string4 = DockerBundle.message("DockerDeleteProvider.background.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"DockerDeleteProvider.background.message\")");
            string3 = string4;
            Project project$iv = this.project;
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, this, queue){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ DockerAbstractDeleteProvider this$0;
                final /* synthetic */ List $queue$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.this$0 = dockerAbstractDeleteProvider;
                    this.$queue$inlined = list;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                /*
                 * WARNING - void declaration
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    Iterable iterable = this.$queue$inlined;
                    DockerAbstractDeleteProvider dockerAbstractDeleteProvider = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DockerAbstractDependenciesResolver.Node p1 = (DockerAbstractDependenciesResolver.Node)element$iv;
                        boolean bl2 = false;
                        dockerAbstractDeleteProvider.deleteNode(p1);
                    }
                }
            });
        } else if (DockerDeleteConfirmation.getUserConfirmation(this.runtimes.size())) {
            void title$iv;
            String string = DockerBundle.message("DockerDeleteProvider.background.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"DockerDeleteProvider.background.message\")");
            dialog2 = string;
            Project project$iv = this.project;
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, this){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ DockerAbstractDeleteProvider this$0;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.this$0 = dockerAbstractDeleteProvider;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                /*
                 * WARNING - void declaration
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    Iterable iterable = DockerAbstractDeleteProvider.access$getRuntimes$p(this.this$0);
                    DockerAbstractDeleteProvider dockerAbstractDeleteProvider = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DockerRuntimeBase p1 = (DockerRuntimeBase)((Object)element$iv);
                        boolean bl2 = false;
                        dockerAbstractDeleteProvider.deleteRuntime(p1);
                    }
                }
            });
        }
    }

    public DockerAbstractDeleteProvider(@NotNull List<? extends RUNTIME> runtimes, @Nullable Project project) {
        Intrinsics.checkNotNullParameter(runtimes, (String)"runtimes");
        this.runtimes = runtimes;
        this.project = project;
        String string = DockerBundle.message("DockerDeleteProvider.buttons.force.delete", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"DockerDeletePro\u2026er.buttons.force.delete\")");
        this.forceDeleteButtonText = string;
        String string2 = DockerBundle.message("DockerDeleteProvider.buttons.smart.delete", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"DockerDeletePro\u2026er.buttons.smart.delete\")");
        this.smartDeleteButtonText = string2;
        String string3 = DockerBundle.message("DockerDeleteProvider.buttons.cancel", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"DockerDeleteProvider.buttons.cancel\")");
        this.cancelButtonText = string3;
    }

    public /* synthetic */ DockerAbstractDeleteProvider(List list, Project project, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        this(list, project);
    }

    public static final /* synthetic */ List access$getRuntimes$p(DockerAbstractDeleteProvider $this) {
        return $this.runtimes;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0014\b\u0002\u0010\u0001*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0012\b\u0002\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0010H\u0002J\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006R&\u0010\t\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\nj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider$DeleteQueueComputer;", "RESOLVER", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver;", "", "resolver", "unchecked", "", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver$Node;", "(Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver;Ljava/util/List;)V", "myQueue", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver;", "computeQueueRec", "", "nodes", "", "getQueue", "intellij.clouds.docker"})
    private static final class DeleteQueueComputer<RESOLVER extends DockerAbstractDependenciesResolver<?, ?, ?>> {
        private final LinkedHashSet<DockerAbstractDependenciesResolver.Node<?>> myQueue;
        private final RESOLVER resolver;
        private final List<DockerAbstractDependenciesResolver.Node<?>> unchecked;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DockerAbstractDependenciesResolver.Node<?>> getQueue() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CollectionsKt.plus((Collection)CollectionsKt.reversed((Iterable)this.myQueue), (Iterable)((DockerAbstractDependenciesResolver)this.resolver).getStandaloneNodes());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DockerAbstractDependenciesResolver.Node it = (DockerAbstractDependenciesResolver.Node)element$iv$iv;
                boolean bl = false;
                if (!(!this.unchecked.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final void computeQueueRec(Collection<? extends DockerAbstractDependenciesResolver.Node<?>> nodes) {
            Iterable<DockerAbstractDependenciesResolver.Node<Object>> iterable = nodes;
            boolean bl = false;
            if (!iterable.isEmpty()) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                this.myQueue.addAll(nodes);
                iterable = nodes;
                DeleteQueueComputer deleteQueueComputer = this;
                boolean $i$f$flatMap = false;
                void var4_5 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    DockerAbstractDependenciesResolver.Node it = (DockerAbstractDependenciesResolver.Node)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = it.getChildren$intellij_clouds_docker();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list = (List)destination$iv$iv;
                deleteQueueComputer.computeQueueRec(list);
            }
        }

        public DeleteQueueComputer(@NotNull RESOLVER resolver, @NotNull List<? extends DockerAbstractDependenciesResolver.Node<?>> unchecked) {
            Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter(unchecked, (String)"unchecked");
            this.resolver = resolver;
            this.unchecked = unchecked;
            this.myQueue = new LinkedHashSet();
            this.computeQueueRec(((DockerAbstractDependenciesResolver)this.resolver).getRoots());
        }

        public /* synthetic */ DeleteQueueComputer(DockerAbstractDependenciesResolver dockerAbstractDependenciesResolver, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            }
            this(dockerAbstractDependenciesResolver, list);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider$SmartDeleteDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "resolver", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver;", "(Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver;)V", "myTree", "Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider$SmartDeleteDialog$MyCheckboxTree;", "createCenterPanel", "Ljavax/swing/JComponent;", "findCheckedNodes", "", "Lcom/intellij/ui/CheckedTreeNode;", "findUncheckedNodes", "getUncheckedElements", "", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver$Node;", "Companion", "MyCheckboxTree", "MyCheckboxTreeCellRenderer", "MyCheckedTreeNode", "intellij.clouds.docker"})
    private static final class SmartDeleteDialog
    extends DialogWrapper {
        private final MyCheckboxTree myTree;
        @NotNull
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<DockerAbstractDependenciesResolver.Node<?>> getUncheckedElements() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.findUncheckedNodes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DockerAbstractDependenciesResolver.Node node;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                CheckedTreeNode it = (CheckedTreeNode)element$iv$iv;
                boolean bl2 = false;
                Object object = it.getUserObject();
                if (!(object instanceof DockerAbstractDependenciesResolver.Node)) {
                    object = null;
                }
                if ((DockerAbstractDependenciesResolver.Node)object == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                DockerAbstractDependenciesResolver.Node it$iv$iv = node;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected JComponent createCenterPanel() {
            void $this$addExtraAction$iv;
            String text$iv;
            void $this$apply;
            JPanel panel2 = new JPanel(new BorderLayout());
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTree)((JTree)((Object)this.myTree)));
            boolean bl = false;
            boolean bl2 = false;
            ToolbarDecorator toolbarDecorator2 = toolbarDecorator;
            JPanel jPanel = panel2;
            boolean bl3 = false;
            void var7_8 = $this$apply;
            String string = DockerBundle.message("DockerDeleteProvider.button.expand.all", new Object[0]);
            Icon icon$iv = AllIcons.Actions.Expandall;
            String description$iv = null;
            boolean $i$f$addExtraAction = false;
            Object object = new DumbAware(text$iv, description$iv, icon$iv, text$iv, description$iv, icon$iv, this){
                final /* synthetic */ String $text;
                final /* synthetic */ String $description;
                final /* synthetic */ Icon $icon;
                final /* synthetic */ SmartDeleteDialog this$0;
                {
                    this.$text = $captured_local_variable$1;
                    this.$description = $captured_local_variable$2;
                    this.$icon = $captured_local_variable$3;
                    this.this$0 = smartDeleteDialog;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AnActionEvent it = e;
                    boolean bl = false;
                    TreeUtil.expandAll((JTree)((JTree)((Object)SmartDeleteDialog.access$getMyTree$p(this.this$0))));
                }
            };
            boolean bl4 = false;
            boolean bl5 = false;
            AnActionButton p1$iv = (AnActionButton)object;
            boolean bl6 = false;
            $this$addExtraAction$iv.addExtraAction(p1$iv);
            ((AnActionButton)object).registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ExpandAll"), (JComponent)((Object)this.myTree));
            $this$addExtraAction$iv = $this$apply;
            text$iv = DockerBundle.message("DockerDeleteProvider.button.collapse.all", new Object[0]);
            icon$iv = AllIcons.Actions.Collapseall;
            description$iv = null;
            $i$f$addExtraAction = false;
            object = new DumbAware(text$iv, description$iv, icon$iv, text$iv, description$iv, icon$iv, this){
                final /* synthetic */ String $text;
                final /* synthetic */ String $description;
                final /* synthetic */ Icon $icon;
                final /* synthetic */ SmartDeleteDialog this$0;
                {
                    this.$text = $captured_local_variable$1;
                    this.$description = $captured_local_variable$2;
                    this.$icon = $captured_local_variable$3;
                    this.this$0 = smartDeleteDialog;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AnActionEvent it = e;
                    boolean bl = false;
                    TreeUtil.collapseAll((JTree)((JTree)((Object)SmartDeleteDialog.access$getMyTree$p(this.this$0))), (boolean)true, (int)-1);
                }
            };
            bl4 = false;
            bl5 = false;
            p1$iv = (AnActionButton)object;
            bl6 = false;
            $this$addExtraAction$iv.addExtraAction(p1$iv);
            ((AnActionButton)object).registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CollapseAll"), (JComponent)((Object)this.myTree));
            DockerUiUtilsKt.addSeparator((ToolbarDecorator)$this$apply);
            $this$addExtraAction$iv = $this$apply;
            text$iv = DockerBundle.message("DockerDeleteProvider.button.select.all", new Object[0]);
            icon$iv = PlatformIcons.SELECT_ALL_ICON;
            description$iv = null;
            $i$f$addExtraAction = false;
            object = new DumbAware(text$iv, description$iv, icon$iv, text$iv, description$iv, icon$iv, this){
                final /* synthetic */ String $text;
                final /* synthetic */ String $description;
                final /* synthetic */ Icon $icon;
                final /* synthetic */ SmartDeleteDialog this$0;
                {
                    this.$text = $captured_local_variable$1;
                    this.$description = $captured_local_variable$2;
                    this.$icon = $captured_local_variable$3;
                    this.this$0 = smartDeleteDialog;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AnActionEvent it = e;
                    boolean bl = false;
                    Iterable $this$forEach$iv = SmartDeleteDialog.access$findUncheckedNodes(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        CheckedTreeNode it2 = (CheckedTreeNode)element$iv;
                        boolean bl2 = false;
                        it2.setChecked(true);
                    }
                    SmartDeleteDialog.access$getMyTree$p(this.this$0).repaint();
                }
            };
            bl4 = false;
            bl5 = false;
            p1$iv = (AnActionButton)object;
            bl6 = false;
            $this$addExtraAction$iv.addExtraAction(p1$iv);
            AnActionButton cfr_ignored_0 = (AnActionButton)object;
            $this$addExtraAction$iv = $this$apply;
            text$iv = DockerBundle.message("DockerDeleteProvider.button.deselect.all", new Object[0]);
            icon$iv = PlatformIcons.UNSELECT_ALL_ICON;
            description$iv = null;
            $i$f$addExtraAction = false;
            object = new DumbAware(text$iv, description$iv, icon$iv, text$iv, description$iv, icon$iv, this){
                final /* synthetic */ String $text;
                final /* synthetic */ String $description;
                final /* synthetic */ Icon $icon;
                final /* synthetic */ SmartDeleteDialog this$0;
                {
                    this.$text = $captured_local_variable$1;
                    this.$description = $captured_local_variable$2;
                    this.$icon = $captured_local_variable$3;
                    this.this$0 = smartDeleteDialog;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AnActionEvent it = e;
                    boolean bl = false;
                    Iterable $this$forEach$iv = SmartDeleteDialog.access$findCheckedNodes(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        CheckedTreeNode it2 = (CheckedTreeNode)element$iv;
                        boolean bl2 = false;
                        it2.setChecked(false);
                    }
                    SmartDeleteDialog.access$getMyTree$p(this.this$0).repaint();
                }
            };
            bl4 = false;
            bl5 = false;
            p1$iv = (AnActionButton)object;
            bl6 = false;
            $this$addExtraAction$iv.addExtraAction(p1$iv);
            AnActionButton cfr_ignored_1 = (AnActionButton)object;
            Unit unit = Unit.INSTANCE;
            jPanel.add((Component)toolbarDecorator.createPanel(), "Center");
            panel2.add((Component)ComponentPanelBuilder.createCommentComponent((String)DockerBundle.message("DockerDeleteProvider.dialog.hint", new Object[0]), (boolean)true, (int)100, (boolean)true), "South");
            return panel2;
        }

        private final List<CheckedTreeNode> findCheckedNodes() {
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            TreeModel treeModel = this.myTree.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"myTree.model");
            Object object = treeModel.getRoot();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
            }
            SmartDeleteDialog.Companion.findNodesRec((CheckedTreeNode)object, $this$apply, (Function1<? super CheckedTreeNode, Boolean>)findCheckedNodes.1.1.INSTANCE);
            return list;
        }

        private final List<CheckedTreeNode> findUncheckedNodes() {
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            TreeModel treeModel = this.myTree.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"myTree.model");
            Object object = treeModel.getRoot();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
            }
            SmartDeleteDialog.Companion.findNodesRec((CheckedTreeNode)object, $this$apply, (Function1<? super CheckedTreeNode, Boolean>)findUncheckedNodes.1.1.INSTANCE);
            return list;
        }

        /*
         * WARNING - void declaration
         */
        public SmartDeleteDialog(@NotNull DockerAbstractDependenciesResolver<?, ?, ?> resolver) {
            Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
            super(false);
            CheckedTreeNode checkedTreeNode = new CheckedTreeNode();
            boolean bl = false;
            boolean bl2 = false;
            CheckedTreeNode checkedTreeNode2 = checkedTreeNode;
            SmartDeleteDialog smartDeleteDialog = this;
            boolean bl3 = false;
            Iterable $this$forEach$iv = CollectionsKt.plus((Collection)resolver.getRoots(), (Iterable)resolver.getStandaloneNodes());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$apply;
                DockerAbstractDependenciesResolver.Node it = (DockerAbstractDependenciesResolver.Node)element$iv;
                boolean bl4 = false;
                $this$apply.add((MutableTreeNode)((Object)new MyCheckedTreeNode(it)));
            }
            Unit unit = Unit.INSTANCE;
            CheckedTreeNode checkedTreeNode3 = checkedTreeNode;
            smartDeleteDialog.myTree = new MyCheckboxTree(checkedTreeNode3);
            this.init();
            this.setSize(500, 300);
            this.setOKButtonText(DockerBundle.message("DockerDeleteProvider.smart.delete.dialog.ok.text", new Object[0]));
            this.setTitle(DockerBundle.message("DockerDeleteProvider.smart.delete.dialog.title", new Object[0]));
            TreeUtil.expandAll((JTree)((JTree)((Object)this.myTree)));
        }

        public static final /* synthetic */ MyCheckboxTree access$getMyTree$p(SmartDeleteDialog $this) {
            return $this.myTree;
        }

        public static final /* synthetic */ List access$findUncheckedNodes(SmartDeleteDialog $this) {
            return $this.findUncheckedNodes();
        }

        public static final /* synthetic */ List access$findCheckedNodes(SmartDeleteDialog $this) {
            return $this.findCheckedNodes();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider$SmartDeleteDialog$MyCheckboxTree;", "Lcom/intellij/ui/CheckboxTree;", "root", "Lcom/intellij/ui/CheckedTreeNode;", "(Lcom/intellij/ui/CheckedTreeNode;)V", "intellij.clouds.docker"})
        private static final class MyCheckboxTree
        extends CheckboxTree {
            public MyCheckboxTree(@NotNull CheckedTreeNode root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                super((CheckboxTree.CheckboxTreeCellRenderer)new MyCheckboxTreeCellRenderer(), root, new CheckboxTreeBase.CheckPolicy(true, false, false, true));
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider$SmartDeleteDialog$MyCheckboxTreeCellRenderer;", "Lcom/intellij/ui/CheckboxTree$CheckboxTreeCellRenderer;", "()V", "customizeRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.clouds.docker"})
        private static final class MyCheckboxTreeCellRenderer
        extends CheckboxTree.CheckboxTreeCellRenderer {
            public void customizeRenderer(@Nullable JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                block5: {
                    Object object;
                    Object nodeValue;
                    block6: {
                        block4: {
                            Object object2;
                            Object object3 = value;
                            if (!(object3 instanceof MyCheckedTreeNode)) {
                                object3 = null;
                            }
                            if ((object2 = (MyCheckedTreeNode)((Object)object3)) == null || (object2 = ((MyCheckedTreeNode)((Object)object2)).getUserObject()) == null) {
                                return;
                            }
                            object = nodeValue = object2;
                            if (!(object instanceof DockerAbstractDependenciesResolver.Node.Image)) break block4;
                            this.getTextRenderer().append(((DockerAbstractDependenciesResolver.Node)nodeValue).getName());
                            ColoredTreeCellRenderer coloredTreeCellRenderer = this.getTextRenderer();
                            Intrinsics.checkNotNullExpressionValue((Object)coloredTreeCellRenderer, (String)"textRenderer");
                            coloredTreeCellRenderer.setIcon(DockerIcons.SingleImage);
                            break block5;
                        }
                        if (!(object instanceof DockerAbstractDependenciesResolver.Node.Container)) break block6;
                        ColoredTreeCellRenderer coloredTreeCellRenderer = this.getTextRenderer();
                        Intrinsics.checkNotNullExpressionValue((Object)coloredTreeCellRenderer, (String)"textRenderer");
                        coloredTreeCellRenderer.setIcon(((DockerAbstractDependenciesResolver.Node.Container)nodeValue).isRunning() ? DockerIcons.SingleRunningContainer : DockerIcons.SingleStoppedContainer);
                        String composeProject = ((DockerAbstractDependenciesResolver.Node.Container)nodeValue).getComposeProject();
                        if (composeProject == null) {
                            this.getTextRenderer().append(((DockerAbstractDependenciesResolver.Node)nodeValue).getName());
                        } else {
                            this.getTextRenderer().append(DockerBundle.message("DockerDeleteProvider.smart.delete.compose", composeProject), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                            this.getTextRenderer().append(' ' + ((DockerAbstractDependenciesResolver.Node)nodeValue).getName());
                        }
                        break block5;
                    }
                    if (!(object instanceof DockerAbstractDependenciesResolver.Node.Volume)) break block5;
                    ColoredTreeCellRenderer coloredTreeCellRenderer = this.getTextRenderer();
                    Intrinsics.checkNotNullExpressionValue((Object)coloredTreeCellRenderer, (String)"textRenderer");
                    coloredTreeCellRenderer.setIcon(DockerIcons.Volume);
                    Intrinsics.checkNotNullExpressionValue((Object)this.getTextRenderer().append(DockerUiUtilsKt.shortenizeIfNeeded(((DockerAbstractDependenciesResolver.Node)nodeValue).getName(), 25)), (String)"textRenderer.append(node\u2026e.shortenizeIfNeeded(25))");
                }
            }

            public MyCheckboxTreeCellRenderer() {
                super(true, false);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider$SmartDeleteDialog$MyCheckedTreeNode;", "Lcom/intellij/ui/CheckedTreeNode;", "node", "Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver$Node;", "(Lcom/intellij/docker/graph/DockerAbstractDependenciesResolver$Node;)V", "getUserObject", "intellij.clouds.docker"})
        private static final class MyCheckedTreeNode
        extends CheckedTreeNode {
            @NotNull
            public DockerAbstractDependenciesResolver.Node<?> getUserObject() {
                Object object = this.userObject;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.docker.graph.DockerAbstractDependenciesResolver.Node<*>");
                }
                return (DockerAbstractDependenciesResolver.Node)object;
            }

            public MyCheckedTreeNode(@NotNull DockerAbstractDependenciesResolver.Node<?> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                super(node);
                Iterable $this$forEach$iv = node.getChildren$intellij_clouds_docker();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DockerAbstractDependenciesResolver.Node it = (DockerAbstractDependenciesResolver.Node)element$iv;
                    boolean bl = false;
                    this.add((MutableTreeNode)((Object)new MyCheckedTreeNode(it)));
                }
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/ui/delete/provider/DockerAbstractDeleteProvider$SmartDeleteDialog$Companion;", "", "()V", "findNodesRec", "", "node", "Lcom/intellij/ui/CheckedTreeNode;", "collector", "", "predicate", "Lkotlin/Function1;", "", "intellij.clouds.docker"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            private final void findNodesRec(CheckedTreeNode node, List<CheckedTreeNode> collector2, Function1<? super CheckedTreeNode, Boolean> predicate) {
                void $this$forEach$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                if (((Boolean)predicate.invoke((Object)node)).booleanValue()) {
                    collector2.add(node);
                }
                Enumeration enumeration = node.children();
                Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"node.children()");
                Object object = enumeration;
                boolean bl = false;
                ArrayList arrayList = Collections.list(object);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                object = arrayList;
                boolean $i$f$filterIsInstance = false;
                Iterator iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof CheckedTreeNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CheckedTreeNode it = (CheckedTreeNode)element$iv;
                    boolean bl2 = false;
                    Companion.findNodesRec(it, collector2, predicate);
                }
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

