/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ssh.transport;

import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.intellij.docker.ssh.transport.HijackingInterceptor;
import com.intellij.docker.ssh.transport.OkDockerHttpViaSshClient;
import com.intellij.docker.ssh.transport.TrustAllX509TrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/ssh/transport/OkDockerHttpViaSshClient;", "Lcom/github/dockerjava/transport/DockerHttpClient;", "socketFactory", "Ljavax/net/SocketFactory;", "sslConfig", "Lcom/github/dockerjava/transport/SSLConfig;", "readTimeout", "", "connectTimeout", "retryOnConnectionFailure", "", "(Ljavax/net/SocketFactory;Lcom/github/dockerjava/transport/SSLConfig;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;)V", "baseUrl", "Lokhttp3/HttpUrl;", "client", "Lokhttp3/OkHttpClient;", "streamingClient", "close", "", "execute", "Lcom/github/dockerjava/transport/DockerHttpClient$Response;", "request", "Lcom/github/dockerjava/transport/DockerHttpClient$Request;", "toRequestBody", "Lokhttp3/RequestBody;", "Companion", "OkResponse", "intellij.clouds.docker.ssh"})
public final class OkDockerHttpViaSshClient
implements DockerHttpClient {
    private final OkHttpClient client;
    private final OkHttpClient streamingClient;
    private final HttpUrl baseUrl;
    private static final Logger LOGGER;
    private static final String SOCKET_SUFFIX = ".socket";
    @NotNull
    public static final Companion Companion;

    private final RequestBody toRequestBody(DockerHttpClient.Request request) {
        InputStream body = request.body();
        if (body != null) {
            return new RequestBody(body){
                final /* synthetic */ InputStream $body;

                @Nullable
                public MediaType contentType() {
                    return null;
                }

                public void writeTo(@NotNull BufferedSink sink) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.writeAll(Okio.source((InputStream)this.$body));
                }
                {
                    this.$body = $captured_local_variable$0;
                }
            };
        }
        return Intrinsics.areEqual((Object)"POST", (Object)request.method()) ? RequestBody.create(null, (String)"") : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DockerHttpClient.Response execute(@NotNull DockerHttpClient.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = this.baseUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"baseUrl.toString()");
        String url = string;
        if (StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = request.path();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.path()");
            if (StringsKt.startsWith$default((String)string2, (String)"/", (boolean)false, (int)2, null)) {
                String string3 = url;
                int n = 0;
                int n2 = url.length() - 1;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                url = string5;
            }
        }
        Request.Builder requestBuilder = new Request.Builder().url(url + request.path()).tag(DockerHttpClient.Request.class, (Object)request).method(request.method(), this.toRequestBody(request));
        Map map2 = request.headers();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"request.headers()");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Map map3 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry element$iv;
            Map.Entry $dstr$name$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$name$value;
            boolean bl3 = false;
            String string6 = (String)entry.getKey();
            entry = $dstr$name$value;
            bl3 = false;
            String value = (String)entry.getValue();
            requestBuilder.header((String)name, value);
        }
        OkHttpClient clientToUse = request.hijackedInput() == null ? this.client : this.streamingClient;
        Call call = clientToUse.newCall(requestBuilder.build());
        try {
            Call call2 = call;
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
            map3 = new OkResponse(call2);
        }
        catch (IOException e) {
            call.cancel();
            throw (Throwable)new UncheckedIOException("Error while executing " + request, e);
        }
        return map3;
    }

    public void close() {
        for (OkHttpClient clientToClose : new OkHttpClient[]{this.client, this.streamingClient}) {
            clientToClose.dispatcher().cancelAll();
            clientToClose.dispatcher().executorService().shutdown();
            clientToClose.connectionPool().evictAll();
        }
    }

    public OkDockerHttpViaSshClient(@NotNull SocketFactory socketFactory, @Nullable SSLConfig sslConfig, @Nullable Integer readTimeout, @Nullable Integer connectTimeout, @Nullable Boolean retryOnConnectionFailure) {
        Intrinsics.checkNotNullParameter((Object)socketFactory, (String)"socketFactory");
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)new HijackingInterceptor()).readTimeout(0L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
        if (readTimeout != null) {
            clientBuilder.readTimeout((long)readTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (connectTimeout != null) {
            clientBuilder.connectTimeout((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (retryOnConnectionFailure != null) {
            clientBuilder.retryOnConnectionFailure(retryOnConnectionFailure.booleanValue());
        }
        clientBuilder.socketFactory(socketFactory);
        clientBuilder.connectionPool(new ConnectionPool(0, 1L, TimeUnit.SECONDS)).dns((Dns)1.INSTANCE);
        if (sslConfig != null) {
            try {
                SSLContext sslContext = sslConfig.getSSLContext();
                if (sslContext != null) {
                    clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)new TrustAllX509TrustManager());
                }
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException(e);
            }
        }
        OkHttpClient okHttpClient = clientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"clientBuilder.build()");
        this.client = okHttpClient;
        OkHttpClient okHttpClient2 = this.client.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient2, (String)"client.newBuilder().build()");
        this.streamingClient = okHttpClient2;
        HttpUrl httpUrl = new HttpUrl.Builder().scheme("http").host("127.0.0.1").build();
        Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"HttpUrl.Builder().scheme\u2026host(\"127.0.0.1\").build()");
        this.baseUrl = httpUrl;
    }

    public /* synthetic */ OkDockerHttpViaSshClient(SocketFactory socketFactory, SSLConfig sSLConfig, Integer n, Integer n2, Boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            sSLConfig = null;
        }
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            bl = null;
        }
        this(socketFactory, sSLConfig, n, n2, bl);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(OkDockerHttpViaSshClient.class);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ssh/transport/OkDockerHttpViaSshClient$OkResponse;", "Lcom/github/dockerjava/transport/DockerHttpClient$Response;", "call", "Lokhttp3/Call;", "(Lokhttp3/Call;)V", "response", "Lokhttp3/Response;", "close", "", "getBody", "Ljava/io/InputStream;", "getHeaders", "", "", "", "getStatusCode", "", "Companion", "intellij.clouds.docker.ssh"})
    public static final class OkResponse
    implements DockerHttpClient.Response {
        private final Response response;
        private final Call call;
        @NotNull
        private static final ThreadLocal<Boolean> CLOSING;
        @NotNull
        public static final Companion Companion;

        public int getStatusCode() {
            return this.response.code();
        }

        @NotNull
        public Map<String, List<String>> getHeaders() {
            Map map2 = this.response.headers().toMultimap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"response.headers().toMultimap()");
            return map2;
        }

        @Nullable
        public InputStream getBody() {
            ResponseBody responseBody = this.response.body();
            if (responseBody == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)responseBody, (String)"response.body() ?: return null");
            ResponseBody body = responseBody;
            return body.source().inputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Boolean previous = CLOSING.get();
            CLOSING.set(true);
            try {
                this.call.cancel();
                this.response.close();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to close the response", (Throwable)e);
            }
            catch (AssertionError e) {
                LOGGER.debug("Failed to close the response", (Throwable)((Object)e));
            }
            finally {
                CLOSING.set(previous);
            }
        }

        public OkResponse(@NotNull Call call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            this.call = call;
            Response response = this.call.execute();
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"call.execute()");
            this.response = response;
        }

        static {
            Companion = new Companion(null);
            ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.CLOSING.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"ThreadLocal.withInitial { false }");
            CLOSING = threadLocal;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/ssh/transport/OkDockerHttpViaSshClient$OkResponse$Companion;", "", "()V", "CLOSING", "Ljava/lang/ThreadLocal;", "", "getCLOSING", "()Ljava/lang/ThreadLocal;", "intellij.clouds.docker.ssh"})
        public static final class Companion {
            @NotNull
            public final ThreadLocal<Boolean> getCLOSING() {
                return CLOSING;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/ssh/transport/OkDockerHttpViaSshClient$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SOCKET_SUFFIX", "", "intellij.clouds.docker.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

