/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ssh;

import com.github.dockerjava.transport.DockerHttpClient;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudConnectionConfigurator;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ssh.SshSocketFactory;
import com.intellij.docker.ssh.transport.OkDockerHttpViaSshClient;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lcom/intellij/docker/ssh/DockerSshConnectionConfigurator;", "Lcom/intellij/docker/DockerCloudConnectionConfigurator;", "()V", "id", "", "getId", "()Ljava/lang/String;", "label", "getLabel", "orderKey", "", "getOrderKey", "()I", "computeDockerHost", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "configureConnection", "Lcom/intellij/docker/agent/DockerAgentConfig;", "createEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "parent", "Lcom/intellij/openapi/Disposable;", "createSshSocketFactory", "Ljavax/net/SocketFactory;", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "findSshConfig", "isEditorModified", "", "editor", "baseline", "isModified", "Companion", "MyEditor", "intellij.clouds.docker.ssh"})
public final class DockerSshConnectionConfigurator
implements DockerCloudConnectionConfigurator {
    @NotNull
    private final String id;
    private final int orderKey;
    @NotNull
    public static final String KEY_SSH_CONFIG_ID = "DockerSshConnectionConfigurator.SshConfigId";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getLabel() {
        String string = DockerBundle.message("DockerSshConnectionConfigurator.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Do\u2026ctionConfigurator.label\")");
        return string;
    }

    @Override
    public int getOrderKey() {
        return this.orderKey;
    }

    @Override
    @NotNull
    public SettingsEditor<DockerCloudConfiguration> createEditor(@NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new MyEditor(parent);
    }

    @Override
    public boolean isModified(@NotNull DockerCloudConfiguration config, @NotNull DockerCloudConfiguration baseline) {
        Map map2;
        Map actualData;
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        Map map3 = config.getContributedData();
        if (map3 == null) {
            map3 = actualData = MapsKt.emptyMap();
        }
        if ((map2 = baseline.getContributedData()) == null) {
            map2 = MapsKt.emptyMap();
        }
        Map baseLineData = map2;
        boolean result2 = Intrinsics.areEqual((Object)((String)actualData.get(KEY_SSH_CONFIG_ID)), (Object)((String)baseLineData.get(KEY_SSH_CONFIG_ID))) ^ true;
        return result2;
    }

    @Override
    public boolean isEditorModified(@NotNull SettingsEditor<DockerCloudConfiguration> editor2, @NotNull DockerCloudConfiguration baseline) {
        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        SettingsEditor<DockerCloudConfiguration> settingsEditor = editor2;
        if (!(settingsEditor instanceof MyEditor)) {
            settingsEditor = null;
        }
        MyEditor myEditor = (MyEditor)settingsEditor;
        if (myEditor == null) {
            return true;
        }
        MyEditor editorImpl = myEditor;
        return editorImpl.isModified(baseline);
    }

    @Override
    @Nullable
    public DockerAgentConfig configureConnection(@NotNull DockerCloudConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        SshConfig sshConfig = this.findSshConfig(config);
        if (sshConfig == null) {
            return null;
        }
        SshConfig sshConfig2 = sshConfig;
        SocketFactory socketFactory = this.createSshSocketFactory(sshConfig2);
        Function0 customHttpClient2 = (Function0)new Function0<OkDockerHttpViaSshClient>(socketFactory){
            final /* synthetic */ SocketFactory $socketFactory;

            @NotNull
            public final OkDockerHttpViaSshClient invoke() {
                return new OkDockerHttpViaSshClient(this.$socketFactory, null, null, null, null, 30, null);
            }
            {
                this.$socketFactory = socketFactory;
                super(0);
            }
        };
        return new DockerAgentConfig.Impl("http://127.0.0.1", null, (Function0<? extends DockerHttpClient>)customHttpClient2);
    }

    @Override
    @Nullable
    public String computeDockerHost(@NotNull DockerCloudConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        SshConfig sshConfig = this.findSshConfig(config);
        if (sshConfig == null) {
            return null;
        }
        SshConfig sshConfig2 = sshConfig;
        return "ssh://" + sshConfig2.getUsername() + '@' + sshConfig2.getHost();
    }

    private final SocketFactory createSshSocketFactory(SshConfig sshConfig) {
        ConnectionBuilder connectionBuilder = Companion.toConnectionBuilder(sshConfig, null, null);
        return new SshSocketFactory(connectionBuilder);
    }

    private final SshConfig findSshConfig(DockerCloudConfiguration config) {
        Map<String, String> map2 = config.getContributedData();
        if (map2 == null || (map2 = map2.get(KEY_SSH_CONFIG_ID)) == null) {
            return null;
        }
        Map<String, String> sshConfigId = map2;
        SshConfig sshConfig = SshConfigManager.getInstance(null).findConfigById((String)((Object)sshConfigId));
        if (sshConfig == null) {
            throw (Throwable)new IllegalArgumentException("Failed to find SSH config with id '" + (String)((Object)sshConfigId) + '\'');
        }
        return sshConfig;
    }

    public DockerSshConnectionConfigurator() {
        String string = Reflection.getOrCreateKotlinClass(DockerSshConnectionConfigurator.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.id = string;
        this.orderKey = 100;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\b\u0010\u000b\u001a\u00020\u0007H\u0014J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/ssh/DockerSshConnectionConfigurator$MyEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/docker/DockerCloudConfiguration;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "sshConfigComboBox", "Lcom/intellij/ssh/ui/unified/SshConfigComboBox;", "applyEditorTo", "", "model", "createEditor", "isModified", "", "baseline", "resetEditorFrom", "intellij.clouds.docker.ssh"})
    private static final class MyEditor
    extends SettingsEditor<DockerCloudConfiguration> {
        private final SshConfigComboBox sshConfigComboBox;

        @NotNull
        protected SshConfigComboBox createEditor() {
            return this.sshConfigComboBox;
        }

        public final boolean isModified(@NotNull DockerCloudConfiguration baseline) {
            Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
            Map map2 = baseline.getContributedData();
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map data = map2;
            PresentableId presentableId = this.sshConfigComboBox.getSelectedPresentableId();
            String sshConfigId = presentableId != null ? presentableId.getId() : null;
            return Intrinsics.areEqual((Object)((String)data.get(DockerSshConnectionConfigurator.KEY_SSH_CONFIG_ID)), (Object)sshConfigId) ^ true;
        }

        protected void resetEditorFrom(@NotNull DockerCloudConfiguration model2) {
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            Map map2 = model2.getContributedData();
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map contributedData = map2;
            SshConfig sshConfig = SshConfigManager.getInstance(null).findConfigById((String)contributedData.get(DockerSshConnectionConfigurator.KEY_SSH_CONFIG_ID));
            this.sshConfigComboBox.select(sshConfig);
        }

        protected void applyEditorTo(@NotNull DockerCloudConfiguration model2) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            PresentableId presentableId = this.sshConfigComboBox.getSelectedPresentableId();
            String sshConfigId = presentableId != null ? presentableId.getId() : null;
            Map<String, String> map2 = model2.getContributedData();
            if (map2 == null) {
                boolean bl = false;
                object = new LinkedHashMap();
                boolean bl2 = false;
                boolean bl3 = false;
                Object it = object;
                boolean bl4 = false;
                model2.setContributedData((Map<String, String>)it);
                map2 = object;
            }
            Map<String, String> contributedData = map2;
            object = sshConfigId;
            if (object == null) {
                contributedData.remove(DockerSshConnectionConfigurator.KEY_SSH_CONFIG_ID);
            } else {
                contributedData.put(DockerSshConnectionConfigurator.KEY_SSH_CONFIG_ID, sshConfigId);
            }
        }

        /*
         * WARNING - void declaration
         */
        public MyEditor(@NotNull Disposable parentDisposable) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            SshConfigComboBox sshConfigComboBox = new SshConfigComboBox(null, parentDisposable, SshConfigVisibility.App);
            boolean bl = false;
            boolean bl2 = false;
            SshConfigComboBox sshConfigComboBox2 = sshConfigComboBox;
            MyEditor myEditor = this;
            boolean bl3 = false;
            $this$apply.reload();
            Unit unit = Unit.INSTANCE;
            myEditor.sshConfigComboBox = sshConfigComboBox;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/ssh/DockerSshConnectionConfigurator$Companion;", "", "()V", "KEY_SSH_CONFIG_ID", "", "toConnectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "Lcom/intellij/ssh/config/unified/SshConfig;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.clouds.docker.ssh"})
    public static final class Companion {
        @NotNull
        public final ConnectionBuilder toConnectionBuilder(@NotNull SshConfig $this$toConnectionBuilder, @Nullable Project project, @Nullable ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)$this$toConnectionBuilder, (String)"$this$toConnectionBuilder");
            RemoteCredentials remoteCredentials = $this$toConnectionBuilder.copyToCredentials();
            Intrinsics.checkNotNullExpressionValue((Object)remoteCredentials, (String)"copyToCredentials()");
            return RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)remoteCredentials, (Project)project, (ProgressIndicator)progressIndicator, (boolean)false, (int)4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

