/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.github.dockerjava.api.model.ContainerMount;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentNetwork;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.compose.ComposeFilesSynchronizedWithServiceView;
import com.intellij.docker.compose.ComposeNavigatableHelper;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.ComposeExternalRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerDeployedContainerRuntime;
import com.intellij.docker.runtimes.DockerDeployer;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerImageRuntimeImpl;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntimeImpl;
import com.intellij.docker.runtimes.DockerPhysicalRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.docker.runtimes.DockerVolumeRuntimeImpl;
import com.intellij.docker.utils.ComposeMetadataProvider;
import com.intellij.docker.utils.DockerComposeData;
import com.intellij.docker.utils.DockerComposeUtilsKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.FactoryMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 H2\u00020\u0001:\u0003HIJB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\f2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)J\u0014\u0010+\u001a\u00020,2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u0012\u0010-\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010.\u001a\u00020 J\u0010\u0010/\u001a\u0004\u0018\u00010&2\u0006\u00100\u001a\u00020\tJ\u0010\u00101\u001a\u00020&2\u0006\u00100\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J(\u00103\u001a\u00020\u001d2\u001e\u00104\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001d05H\u0002J\u000e\u00106\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005J!\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u000109082\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020\tH\u0016JD\u0010<\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n08*\n\u0012\u0004\u0012\u00020 \u0018\u0001082\u0006\u0010!\u001a\u00020\"2\u001c\u0010=\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0>H\u0002J\u0014\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\n*\u00020 H\u0002J\u001f\u0010@\u001a\t\u0018\u00010A\u00a2\u0006\u0002\bB*\u00020\u00142\n\b\u0002\u0010C\u001a\u0004\u0018\u00010DH\u0002J\f\u0010E\u001a\u00020F*\u00020GH\u0002R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006K"}, d2={"Lcom/intellij/docker/runtimes/DockerRuntimesCache;", "", "myManager", "Lcom/intellij/docker/runtimes/DockerRuntimesManagerService$DockerRuntimesManager;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "(Lcom/intellij/docker/runtimes/DockerRuntimesManagerService$DockerRuntimesManager;Lcom/intellij/docker/runtimes/DockerRuntimeContext;)V", "myApplicationId2Runtime", "", "", "Lcom/intellij/docker/runtimes/DockerPhysicalRuntime;", "myComposeDeployments", "Lcom/intellij/docker/runtimes/ComposeDeploymentRuntime;", "myContainersGroup", "Lcom/intellij/docker/runtimes/DockerGroupRuntime;", "myErrors", "Lcom/intellij/docker/runtimes/DockerRuntimesCache$ReportedContainerErrors;", "myExternalComposeApps", "Lcom/intellij/docker/runtimes/ComposeExternalRuntime;", "myFile2ProjectNameCache", "Ljava/io/File;", "myImagesGroup", "myNetworksGroup", "myVolumesGroup", "<set-?>", "runtimeContext", "getRuntimeContext", "()Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "cleanup", "", "agentApps", "", "Lcom/intellij/docker/agent/DockerAgentApplication;", "delta", "Lcom/intellij/docker/runtimes/DockerRuntimesCache$DeltaImpl;", "([Lcom/intellij/docker/agent/DockerAgentApplication;Lcom/intellij/docker/runtimes/DockerRuntimesCache$DeltaImpl;)V", "composeApplicationUndeployed", "undeployed", "Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;", "createComposeRuntime", "task", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "createDeployer", "Lcom/intellij/docker/runtimes/DockerDeployer;", "createRuntimeForExternalUse", "agentApp", "findComposeApplicationRuntime", "composeProject", "findOrCreateApplicationRuntime", "fireRuntimesRefreshed", "processServicesSynchronizedWithServiceView", "func", "Lkotlin/Function3;", "refreshContextIfNeeded", "refreshStructure", "", "Lcom/intellij/remoteServer/util/CloudApplicationRuntime;", "([Lcom/intellij/docker/agent/DockerAgentApplication;)Ljava/util/List;", "toString", "computeNewLeaves", "process", "Lkotlin/Function2;", "createApplicationRuntime", "getProject", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isServiceContainer", "", "Lcom/intellij/docker/agent/DockerAgentContainer;", "Companion", "DeltaImpl", "ReportedContainerErrors", "intellij.clouds.docker"})
public final class DockerRuntimesCache {
    @NotNull
    private DockerRuntimeContext runtimeContext;
    private DockerGroupRuntime myContainersGroup;
    private DockerGroupRuntime myImagesGroup;
    private DockerGroupRuntime myVolumesGroup;
    private DockerGroupRuntime myNetworksGroup;
    private final Map<File, String> myFile2ProjectNameCache;
    private final Map<String, ComposeDeploymentRuntime> myComposeDeployments;
    private final Map<String, ComposeExternalRuntime> myExternalComposeApps;
    private final Map<String, DockerPhysicalRuntime<?>> myApplicationId2Runtime;
    private final ReportedContainerErrors myErrors;
    private final DockerRuntimesManagerService.DockerRuntimesManager myManager;
    private static final Logger LOG;
    private static final String IMAGE_GROUP_KEY = "image";
    private static final String CONTAINER_GROUP_KEY = "container";
    private static final String SERVICE_GROUP_KEY = "service";
    private static final String NETWORK_GROUP_KEY = "network";
    private static final String VOLUME_GROUP_KEY = "volume";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final DockerRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public final void refreshContextIfNeeded(@NotNull DockerRuntimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)context, (Object)this.runtimeContext) ^ true) {
            this.runtimeContext = context;
            this.myContainersGroup = new DockerGroupRuntime.ContainersGroup(this.runtimeContext);
            this.myImagesGroup = new DockerGroupRuntime.ImagesGroup(this.runtimeContext);
            this.myVolumesGroup = new DockerGroupRuntime.VolumesGroup(this.runtimeContext);
            this.myNetworksGroup = new DockerGroupRuntime.NetworksGroup(this.runtimeContext);
        }
    }

    @NotNull
    public final DockerDeployer createDeployer(@NotNull DeploymentTask<DockerDeploymentConfiguration> task2) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        DeploymentSource deploymentSource = task2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)deploymentSource, (String)"task.source");
        boolean imageNotContainer = deploymentSource.getType() instanceof DockerFileDeploymentSourceType && ((DockerDeploymentConfiguration)task2.getConfiguration()).isBuildOnly();
        DockerGroupRuntime parentGroup = imageNotContainer ? this.myImagesGroup : this.myContainersGroup;
        return new DockerDeployer(this.runtimeContext, task2, parentGroup, (Function1<? super DockerDeployedContainerRuntime, Unit>)((Function1)new Function1<DockerDeployedContainerRuntime, Unit>(this){
            final /* synthetic */ DockerRuntimesCache this$0;

            public final void invoke(@NotNull DockerDeployedContainerRuntime it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                Map map2 = DockerRuntimesCache.access$getMyApplicationId2Runtime$p(this.this$0);
                DockerAgentContainer dockerAgentContainer = it.getAgentApplication();
                Intrinsics.checkNotNullExpressionValue((Object)dockerAgentContainer, (String)"it.agentApplication");
                String string = dockerAgentContainer.getUniqueName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.agentApplication.uniqueName");
                map2.put(string, it);
            }
            {
                this.this$0 = dockerRuntimesCache;
                super(1);
            }
        }));
    }

    @NotNull
    public final ComposeDeploymentRuntime createComposeRuntime(@NotNull DeploymentTask<DockerDeploymentConfiguration> task2) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        ComposeDeploymentRuntime newRuntime = new ComposeDeploymentRuntime(this, task2);
        String string = newRuntime.getComposeProjectName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newRuntime.composeProjectName");
        String projectName = string;
        ComposeDeploymentRuntime existingRuntime = this.myComposeDeployments.get(projectName);
        if (existingRuntime != null) {
            existingRuntime.appendDeploymentTask(task2);
            return existingRuntime;
        }
        Object object = this.myExternalComposeApps.remove(projectName);
        if (object != null && (object = ((ComposeApplicationRuntime)object).getServices()) != null) {
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$u = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$_u24__u24$u;
                boolean bl3 = false;
                ComposeServiceRuntime u = (ComposeServiceRuntime)entry.getValue();
                u.setParent(newRuntime);
            }
        }
        this.myComposeDeployments.put(projectName, newRuntime);
        return newRuntime;
    }

    @NotNull
    public final DockerPhysicalRuntime<?> createRuntimeForExternalUse(@NotNull DockerAgentApplication agentApp) {
        Intrinsics.checkNotNullParameter((Object)agentApp, (String)"agentApp");
        return this.createApplicationRuntime(agentApp);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CloudApplicationRuntime> refreshStructure(@NotNull DockerAgentApplication[] agentApps) {
        Object mounts;
        void $this$groupByTo$iv$iv322;
        Intrinsics.checkNotNullParameter((Object)agentApps, (String)"agentApps");
        DeltaImpl delta = new DeltaImpl();
        boolean bl = false;
        List newLeaves = new ArrayList();
        boolean bl2 = false;
        Map containerMounts = new LinkedHashMap();
        Object $this$groupBy$iv = agentApps;
        boolean $i$f$groupBy22 = false;
        DockerAgentApplication[] dockerAgentApplicationArray = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        void var11_19 = $this$groupByTo$iv$iv322;
        int n = ((void)var11_19).length;
        for (int j = 0; j < n; ++j) {
            Object object;
            String string;
            void element$iv$iv;
            void it = element$iv$iv = var11_19[j];
            boolean bl3 = false;
            void var17_30 = it;
            if (var17_30 instanceof DockerAgentImage) {
                string = IMAGE_GROUP_KEY;
            } else if (var17_30 instanceof DockerAgentContainer) {
                List list = ((DockerAgentContainer)it).getContainer().getMounts();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                mounts = list;
                Collection collection = (Collection)mounts;
                boolean bl4 = false;
                if (!collection.isEmpty()) {
                    containerMounts.put(((DockerAgentContainer)it).getContainerId(), mounts);
                }
                string = this.isServiceContainer((DockerAgentContainer)it) ? SERVICE_GROUP_KEY : CONTAINER_GROUP_KEY;
            } else if (var17_30 instanceof DockerAgentVolume) {
                string = VOLUME_GROUP_KEY;
            } else if (var17_30 instanceof DockerAgentNetwork) {
                string = NETWORK_GROUP_KEY;
            } else {
                throw (Throwable)new IllegalStateException("Unknown agent type");
            }
            String key$iv$iv = string;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedApps = destination$iv$iv;
        $this$groupBy$iv = newLeaves;
        Iterable $i$f$groupBy22 = this.computeNewLeaves((List)groupedApps.get(IMAGE_GROUP_KEY), delta, (Function2)new Function2<DockerPhysicalRuntime<?>, DockerAgentApplication, Unit>(this){
            final /* synthetic */ DockerRuntimesCache this$0;

            public final void invoke(@NotNull DockerPhysicalRuntime<?> runtime, @NotNull DockerAgentApplication $noName_1) {
                Intrinsics.checkNotNullParameter(runtime, (String)"runtime");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                runtime.setParent(DockerRuntimesCache.access$getMyImagesGroup$p(this.this$0));
            }
            {
                this.this$0 = dockerRuntimesCache;
                super(2);
            }
        });
        boolean $this$groupByTo$iv$iv322 = false;
        CollectionsKt.addAll((Collection)$this$groupBy$iv, (Iterable)$i$f$groupBy22);
        $this$groupBy$iv = newLeaves;
        $i$f$groupBy22 = this.computeNewLeaves((List)groupedApps.get(CONTAINER_GROUP_KEY), delta, (Function2)new Function2<DockerPhysicalRuntime<?>, DockerAgentApplication, Unit>(this){
            final /* synthetic */ DockerRuntimesCache this$0;

            public final void invoke(@NotNull DockerPhysicalRuntime<?> runtime, @NotNull DockerAgentApplication $noName_1) {
                Intrinsics.checkNotNullParameter(runtime, (String)"runtime");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                runtime.setParent(DockerRuntimesCache.access$getMyContainersGroup$p(this.this$0));
            }
            {
                this.this$0 = dockerRuntimesCache;
                super(2);
            }
        });
        $this$groupByTo$iv$iv322 = false;
        CollectionsKt.addAll((Collection)$this$groupBy$iv, (Iterable)$i$f$groupBy22);
        $this$groupBy$iv = newLeaves;
        $i$f$groupBy22 = this.computeNewLeaves((List)groupedApps.get(NETWORK_GROUP_KEY), delta, (Function2)new Function2<DockerPhysicalRuntime<?>, DockerAgentApplication, Unit>(this){
            final /* synthetic */ DockerRuntimesCache this$0;

            public final void invoke(@NotNull DockerPhysicalRuntime<?> runtime, @NotNull DockerAgentApplication $noName_1) {
                String composeProject;
                Intrinsics.checkNotNullParameter(runtime, (String)"runtime");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                DockerNetworkRuntime network = (DockerNetworkRuntime)runtime;
                Map map2 = network.getNetwork().labels;
                String string = composeProject = map2 != null ? (String)map2.get("com.docker.compose.project") : null;
                if (composeProject != null) {
                    ComposeApplicationRuntime composeApp = this.this$0.findComposeApplicationRuntime(composeProject);
                    if (composeApp != null) {
                        runtime.setParent(composeApp);
                    } else {
                        runtime.setParent(DockerRuntimesCache.access$getMyNetworksGroup$p(this.this$0));
                    }
                } else {
                    runtime.setParent(DockerRuntimesCache.access$getMyNetworksGroup$p(this.this$0));
                }
            }
            {
                this.this$0 = dockerRuntimesCache;
                super(2);
            }
        });
        $this$groupByTo$iv$iv322 = false;
        CollectionsKt.addAll((Collection)$this$groupBy$iv, (Iterable)$i$f$groupBy22);
        LinkedHashSet<DockerGroupRuntime> parents = new LinkedHashSet<DockerGroupRuntime>();
        parents.add(this.myContainersGroup);
        parents.add(this.myImagesGroup);
        parents.add(this.myNetworksGroup);
        parents.add(this.myVolumesGroup);
        Map map2 = FactoryMap.create((com.intellij.util.Function)refreshStructure.app2Services.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"FactoryMap.create<Compos\u2026     mutableMapOf()\n    }");
        Map app2Services2 = map2;
        Collection $this$groupByTo$iv$iv322 = newLeaves;
        destination$iv$iv = this.computeNewLeaves((List)groupedApps.get(SERVICE_GROUP_KEY), delta, (Function2)new Function2<DockerPhysicalRuntime<?>, DockerAgentApplication, Unit>(this, app2Services2){
            final /* synthetic */ DockerRuntimesCache this$0;
            final /* synthetic */ Map $app2Services;

            public final void invoke(@NotNull DockerPhysicalRuntime<?> runtime, @NotNull DockerAgentApplication agent) {
                Intrinsics.checkNotNullParameter(runtime, (String)"runtime");
                Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
                DockerComposeData composeData = ComposeMetadataProvider.INSTANCE.getComposeData((DockerAgentContainer)agent);
                DockerContainerRuntime container = (DockerContainerRuntime)runtime;
                if (composeData != null) {
                    File firstFile = (File)CollectionsKt.firstOrNull((Iterable)composeData.getFiles());
                    ComposeApplicationRuntime composeRuntime = DockerRuntimesCache.access$findOrCreateApplicationRuntime(this.this$0, composeData.getProject());
                    V v = this.$app2Services.get(composeRuntime);
                    Intrinsics.checkNotNull(v);
                    V v2 = ((Map)v).computeIfAbsent(composeData.getService(), new Function(this, composeRuntime, composeData, firstFile){
                        final /* synthetic */ refreshStructure.4 this$0;
                        final /* synthetic */ ComposeApplicationRuntime $composeRuntime;
                        final /* synthetic */ DockerComposeData $composeData;
                        final /* synthetic */ File $firstFile;

                        @NotNull
                        public final ComposeServiceRuntime apply(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            ComposeServiceRuntime composeServiceRuntime = this.$composeRuntime.findService(it);
                            if (composeServiceRuntime == null) {
                                composeServiceRuntime = new ComposeServiceRuntime(this.$composeRuntime, it, this.$composeData.getVersion(), (Function0<? extends Project>)((Function0)new Function0<Project>(this){
                                    final /* synthetic */ refreshStructure.service.1 this$0;

                                    @Nullable
                                    public final Project invoke() {
                                        File file2 = this.this$0.$firstFile;
                                        return file2 != null ? DockerRuntimesCache.getProject$default(this.this$0.this$0.this$0, file2, null, 1, null) : null;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }
                                }));
                            }
                            return composeServiceRuntime;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$composeRuntime = composeApplicationRuntime;
                            this.$composeData = dockerComposeData;
                            this.$firstFile = file2;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"app2Services[composeRunt\u2026) }\n          )\n        }");
                    ComposeServiceRuntime service2 = (ComposeServiceRuntime)v2;
                    service2.addContainer(container);
                }
            }
            {
                this.this$0 = dockerRuntimesCache;
                this.$app2Services = map2;
                super(2);
            }
        });
        $i$f$groupByTo22 = false;
        CollectionsKt.addAll((Collection)$this$groupByTo$iv$iv322, (Iterable)destination$iv$iv);
        $this$groupByTo$iv$iv322 = newLeaves;
        destination$iv$iv = this.computeNewLeaves((List)groupedApps.get(VOLUME_GROUP_KEY), delta, (Function2)new Function2<DockerPhysicalRuntime<?>, DockerAgentApplication, Unit>(this, containerMounts){
            final /* synthetic */ DockerRuntimesCache this$0;
            final /* synthetic */ Map $containerMounts;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DockerPhysicalRuntime<?> runtime, @NotNull DockerAgentApplication $noName_1) {
                Intrinsics.checkNotNullParameter(runtime, (String)"runtime");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                DockerVolumeRuntimeImpl runtimeImpl = (DockerVolumeRuntimeImpl)runtime;
                runtimeImpl.setParent(DockerRuntimesCache.access$getMyVolumesGroup$p(this.this$0));
                Map $this$forEach$iv = this.$containerMounts;
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    DockerContainerRuntime attachedTo;
                    void containerId;
                    ContainerMount mount;
                    Object v0;
                    block3: {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> $dstr$containerId$list = element$iv = iterator.next();
                        boolean bl2 = false;
                        Map.Entry<K, V> entry = $dstr$containerId$list;
                        boolean bl3 = false;
                        String string = (String)entry.getKey();
                        entry = $dstr$containerId$list;
                        bl3 = false;
                        List list = (List)entry.getValue();
                        Iterable $this$firstOrNull$iv = list;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv2 : $this$firstOrNull$iv) {
                            ContainerMount it = (ContainerMount)element$iv2;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)runtimeImpl.getVolumeId())) continue;
                            v0 = element$iv2;
                            break block3;
                        }
                        v0 = null;
                    }
                    if ((mount = (ContainerMount)v0) == null) continue;
                    V v = DockerRuntimesCache.access$getMyApplicationId2Runtime$p(this.this$0).get(containerId);
                    if (!(v instanceof DockerContainerRuntime)) {
                        v = null;
                    }
                    if ((attachedTo = (DockerContainerRuntime)((Object)v)) == null) continue;
                    runtimeImpl.setContainerMount(attachedTo, mount);
                }
            }
            {
                this.this$0 = dockerRuntimesCache;
                this.$containerMounts = map2;
                super(2);
            }
        });
        $i$f$groupByTo22 = false;
        CollectionsKt.addAll((Collection)$this$groupByTo$iv$iv322, (Iterable)destination$iv$iv);
        this.processServicesSynchronizedWithServiceView((Function3<? super String, ? super ComposeApplicationRuntime, ? super File, Unit>)((Function3)new Function3<String, ComposeApplicationRuntime, File, Unit>(this, app2Services2, parents){
            final /* synthetic */ DockerRuntimesCache this$0;
            final /* synthetic */ Map $app2Services;
            final /* synthetic */ LinkedHashSet $parents;

            public final void invoke(@NotNull String service2, @NotNull ComposeApplicationRuntime runtime, @NotNull File file2) {
                Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
                Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                V v = this.$app2Services.get(runtime);
                Intrinsics.checkNotNull(v);
                ((Map)v).computeIfAbsent(service2, new Function(this, runtime, file2){
                    final /* synthetic */ refreshStructure.6 this$0;
                    final /* synthetic */ ComposeApplicationRuntime $runtime;
                    final /* synthetic */ File $file;

                    @NotNull
                    public final ComposeServiceRuntime apply(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ComposeServiceRuntime.WithoutContainers withoutContainers = new ComposeServiceRuntime.WithoutContainers(this.$runtime, it, this.$file, (Function0<? extends Project>)((Function0)new Function0<Project>(this){
                            final /* synthetic */ refreshStructure.1 this$0;

                            @Nullable
                            public final Project invoke() {
                                return DockerRuntimesCache.getProject$default(this.this$0.this$0.this$0, this.this$0.$file, null, 1, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                        boolean bl = false;
                        boolean bl2 = false;
                        ComposeServiceRuntime.WithoutContainers $this$apply = withoutContainers;
                        boolean bl3 = false;
                        this.this$0.$parents.add($this$apply);
                        this.this$0.$parents.add($this$apply.getParent());
                        return withoutContainers;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$runtime = composeApplicationRuntime;
                        this.$file = file2;
                    }
                });
            }
            {
                this.this$0 = dockerRuntimesCache;
                this.$app2Services = map2;
                this.$parents = linkedHashSet;
                super(3);
            }
        }));
        Map $this$forEach$iv = app2Services2;
        boolean $i$f$forEach = false;
        Map $i$f$groupByTo22 = $this$forEach$iv;
        boolean bl6 = false;
        Iterator iterator = $i$f$groupByTo22.entrySet().iterator();
        while (iterator.hasNext()) {
            void app;
            Map services;
            Map.Entry element$iv;
            Map.Entry $dstr$app$services = element$iv = iterator.next();
            boolean bl7 = false;
            Map.Entry entry = $dstr$app$services;
            boolean bl8 = false;
            mounts = (ComposeApplicationRuntime)entry.getKey();
            entry = $dstr$app$services;
            bl8 = false;
            Map map3 = services = (Map)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"services");
            app.refreshServices(map3);
        }
        for (DockerPhysicalRuntime nextLeaf : newLeaves) {
            boolean unknownParent;
            DeploymentRuntime parent = (DeploymentRuntime)nextLeaf.getParent();
            while (parent instanceof DockerRuntimeBase && (unknownParent = parents.add((DockerGroupRuntime)parent))) {
                parent = (DeploymentRuntime)((DockerRuntimeBase)parent).getParent();
            }
        }
        List result2 = CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)parents), (Iterable)newLeaves);
        this.cleanup(agentApps, delta);
        if (!delta.isEmpty()) {
            this.fireRuntimesRefreshed(delta);
        }
        return result2;
    }

    public final void composeApplicationUndeployed(@NotNull ComposeApplicationRuntime undeployed) {
        Intrinsics.checkNotNullParameter((Object)undeployed, (String)"undeployed");
        ComposeDeploymentRuntime composeDeploymentRuntime = this.myComposeDeployments.remove(undeployed.getComposeProjectName());
        if (composeDeploymentRuntime != null) {
        } else {
            ComposeApplicationRuntime cfr_ignored_1 = this.myExternalComposeApps.remove(undeployed.getComposeProjectName());
        }
    }

    @Nullable
    public final ComposeApplicationRuntime findComposeApplicationRuntime(@NotNull String composeProject) {
        Intrinsics.checkNotNullParameter((Object)composeProject, (String)"composeProject");
        ComposeDeploymentRuntime composeDeploymentRuntime = this.myComposeDeployments.get(composeProject);
        return composeDeploymentRuntime != null ? (ComposeApplicationRuntime)composeDeploymentRuntime : (ComposeApplicationRuntime)this.myExternalComposeApps.get(composeProject);
    }

    @NotNull
    public String toString() {
        return "DockerRuntimeCache@" + Integer.toHexString(System.identityHashCode(this));
    }

    private final List<DockerPhysicalRuntime<?>> computeNewLeaves(List<? extends DockerAgentApplication> $this$computeNewLeaves, DeltaImpl delta, Function2<? super DockerPhysicalRuntime<?>, ? super DockerAgentApplication, Unit> process2) {
        boolean bl = false;
        List result2 = new ArrayList();
        List<? extends DockerAgentApplication> list = $this$computeNewLeaves;
        if (list == null) {
            boolean bl2 = false;
            return CollectionsKt.emptyList();
        }
        for (DockerAgentApplication dockerAgentApplication : list) {
            String nextId;
            Intrinsics.checkNotNullExpressionValue((Object)dockerAgentApplication.getUniqueName(), (String)"nextAgentApp.uniqueName");
            DockerPhysicalRuntime<Object> nextRuntime = this.myApplicationId2Runtime.get(nextId);
            DeploymentStatus nextStatusBefore = null;
            if (nextRuntime == null) {
                nextRuntime = this.createApplicationRuntime(dockerAgentApplication);
                this.myApplicationId2Runtime.put(nextId, nextRuntime);
                delta.markAdded(nextRuntime);
                nextStatusBefore = null;
            } else {
                nextStatusBefore = nextRuntime.getStatus();
            }
            boolean changedStatus = nextRuntime.checkAndClearInternalChangeStatus();
            nextRuntime.internalSetAgentApplication(dockerAgentApplication);
            process2.invoke(nextRuntime, (Object)dockerAgentApplication);
            if (nextStatusBefore != null && !changedStatus) {
                DockerPhysicalRuntime<Object> dockerPhysicalRuntime = nextRuntime;
                Intrinsics.checkNotNullExpressionValue(dockerPhysicalRuntime, (String)"nextRuntime");
                DeploymentStatus statusAfter = dockerPhysicalRuntime.getStatus();
                boolean bl2 = changedStatus = statusAfter != null && Intrinsics.areEqual((Object)nextStatusBefore, (Object)statusAfter) ^ true;
            }
            if (changedStatus) {
                delta.markChanged(nextRuntime);
            }
            result2.add(nextRuntime);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void processServicesSynchronizedWithServiceView(Function3<? super String, ? super ComposeApplicationRuntime, ? super File, Unit> func) {
        for (VirtualFile virtualFile : ComposeFilesSynchronizedWithServiceView.Companion.getInstance().getFiles()) {
            List services;
            List list;
            boolean $i$f$runReadAction2 = false;
            List list2 = (List)ApplicationManager.getApplication().runReadAction(new Computable(virtualFile){
                final /* synthetic */ VirtualFile $virtualFile$inlined;
                {
                    this.$virtualFile$inlined = virtualFile;
                }

                public final T compute() {
                    List<PsiElement> list;
                    boolean bl = false;
                    ComposeNavigatableHelper composeNavigatableHelper = ComposeNavigatableHelper.getInstance();
                    if (composeNavigatableHelper != null) {
                        VirtualFile virtualFile = this.$virtualFile$inlined;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"virtualFile");
                        list = composeNavigatableHelper.findAllComposeServices(DockerUtils.toPsiFile(virtualFile));
                    } else {
                        list = null;
                    }
                    return (T)list;
                }
            });
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable $i$f$runReadAction2 = list2;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PsiElement psiElement = (PsiElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    String string = v1.getText();
                    collection.add(string);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List list3 = services = list;
            if (list3 == null) continue;
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String composeProject;
                String it = (String)element$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = virtualFile;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile");
                VirtualFile virtualFile3 = virtualFile2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile.parent");
                Intrinsics.checkNotNullExpressionValue((Object)ComposeDeploymentRuntime.computeErasedProjectName(virtualFile3.getName()), (String)"ComposeDeploymentRuntime\u2026(virtualFile.parent.name)");
                ComposeApplicationRuntime composeRuntime = this.findOrCreateApplicationRuntime(composeProject);
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                File file2 = virtualFile.toNioPath().toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualFile.toNioPath().toFile()");
                func.invoke((Object)string, (Object)composeRuntime, (Object)file2);
            }
        }
    }

    private final Project getProject(File $this$getProject, VirtualFile virtualFile) {
        Project project;
        String projectName = this.myFile2ProjectNameCache.get($this$getProject);
        if (projectName == null) {
            boolean $i$f$runReadAction = false;
            project = (Project)ApplicationManager.getApplication().runReadAction(new Computable(this, $this$getProject, virtualFile){
                final /* synthetic */ DockerRuntimesCache this$0;
                final /* synthetic */ File $this_getProject$inlined;
                final /* synthetic */ VirtualFile $virtualFile$inlined;
                {
                    this.this$0 = dockerRuntimesCache;
                    this.$this_getProject$inlined = file2;
                    this.$virtualFile$inlined = virtualFile;
                }

                public final T compute() {
                    Project project;
                    Object object;
                    boolean bl = false;
                    if (this.$virtualFile$inlined == null) {
                        PsiFile psiFile = DockerUtils.toPsiFile(this.$this_getProject$inlined);
                        object = psiFile != null ? psiFile.getProject() : null;
                    } else {
                        PsiFile psiFile = DockerUtils.toPsiFile(this.$virtualFile$inlined);
                        object = psiFile != null ? psiFile.getProject() : null;
                    }
                    if (object != null) {
                        Project project2 = object;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Project it = project2;
                        boolean bl4 = false;
                        Map map2 = DockerRuntimesCache.access$getMyFile2ProjectNameCache$p(this.this$0);
                        Project project3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
                        String string = project3.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        map2.put(this.$this_getProject$inlined, string);
                        project = project2;
                    } else {
                        project = null;
                    }
                    return (T)project;
                }
            });
        } else {
            project = DockerUtils.findProjectByName(projectName);
        }
        return project;
    }

    static /* synthetic */ Project getProject$default(DockerRuntimesCache dockerRuntimesCache, File file2, VirtualFile virtualFile, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFile = null;
        }
        return dockerRuntimesCache.getProject(file2, virtualFile);
    }

    private final boolean isServiceContainer(DockerAgentContainer $this$isServiceContainer) {
        Object object = $this$isServiceContainer.getContainerLabels();
        String string = "com.docker.compose.project";
        boolean bl = false;
        Map<String, String> map2 = object;
        boolean bl2 = false;
        if (!map2.containsKey(string)) {
            return false;
        }
        object = ComposeMetadataProvider.INSTANCE.getComposeData($this$isServiceContainer);
        boolean bl3 = false;
        bl = false;
        Object $this$with = object;
        boolean bl4 = false;
        if ($this$with == null) {
            this.myErrors.reportContainerLabels($this$isServiceContainer.getContainerLabels());
            return false;
        }
        if ((((DockerComposeData)$this$with).getFiles().isEmpty() || StringsKt.isBlank((CharSequence)((DockerComposeData)$this$with).getWorkingDir())) && DockerComposeUtilsKt.isComposeFilesLabelSupported(((DockerComposeData)$this$with).getVersion())) {
            this.myErrors.reportContainerLabels($this$isServiceContainer.getContainerLabels());
            return true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanup(DockerAgentApplication[] agentApps, DeltaImpl delta) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        DockerAgentApplication[] $this$map$iv = agentApps;
        boolean $i$f$map = false;
        DockerAgentApplication[] dockerAgentApplicationArray = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var9_11 = $this$mapTo$iv$iv;
        int n = ((void)var9_11).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var13_22 = item$iv$iv = var9_11[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getUniqueName();
            collection.add(string);
        }
        List uniqueNames = (List)destination$iv$iv;
        Iterable $this$filter$iv = this.myApplicationId2Runtime.keySet();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!uniqueNames.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DockerPhysicalRuntime<?> nextRuntime;
            String it = (String)element$iv;
            boolean bl = false;
            if (this.myApplicationId2Runtime.remove(it) == null) {
                String string = "for removed id: " + it;
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            nextRuntime.setParent(null);
            delta.markDeleted(nextRuntime);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ComposeApplicationRuntime findOrCreateApplicationRuntime(String composeProject) {
        ComposeApplicationRuntime composeApplicationRuntime;
        ComposeDeploymentRuntime composeDeploymentRuntime = this.myComposeDeployments.get(composeProject);
        if (composeDeploymentRuntime != null) {
            ComposeDeploymentRuntime composeDeploymentRuntime2 = composeDeploymentRuntime;
            boolean bl = false;
            boolean bl2 = false;
            ComposeDeploymentRuntime $this$apply = composeDeploymentRuntime2;
            boolean bl3 = false;
            this.myExternalComposeApps.remove(composeProject);
            composeDeploymentRuntime = composeDeploymentRuntime2;
            if (composeDeploymentRuntime != null) {
                composeApplicationRuntime = composeDeploymentRuntime;
                return composeApplicationRuntime;
            }
        }
        ComposeExternalRuntime composeExternalRuntime = this.myExternalComposeApps.computeIfAbsent(composeProject, new Function(this){
            final /* synthetic */ DockerRuntimesCache this$0;

            @NotNull
            public final ComposeExternalRuntime apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ComposeExternalRuntime(this.this$0, it);
            }
            {
                this.this$0 = dockerRuntimesCache;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)composeExternalRuntime, (String)"myExternalComposeApps.co\u2026rnalRuntime(this, it)\n  }");
        composeApplicationRuntime = composeExternalRuntime;
        return composeApplicationRuntime;
    }

    private final DockerPhysicalRuntime<? extends DockerAgentApplication> createApplicationRuntime(DockerAgentApplication $this$createApplicationRuntime) {
        DockerPhysicalRuntime dockerPhysicalRuntime;
        DockerAgentApplication dockerAgentApplication = $this$createApplicationRuntime;
        if (dockerAgentApplication instanceof DockerAgentImage) {
            dockerPhysicalRuntime = new DockerImageRuntimeImpl(this.runtimeContext, (DockerAgentImage)$this$createApplicationRuntime, null);
        } else if (dockerAgentApplication instanceof DockerAgentContainer) {
            dockerPhysicalRuntime = new DockerApplicationRuntime(this.runtimeContext, (DockerAgentContainer)$this$createApplicationRuntime, null);
        } else if (dockerAgentApplication instanceof DockerAgentVolume) {
            dockerPhysicalRuntime = new DockerVolumeRuntimeImpl(this.runtimeContext, (DockerAgentVolume)$this$createApplicationRuntime, null);
        } else if (dockerAgentApplication instanceof DockerAgentNetwork) {
            dockerPhysicalRuntime = new DockerNetworkRuntimeImpl(this.runtimeContext, (DockerAgentNetwork)$this$createApplicationRuntime, null, (Function1)new Function1<String, DockerPhysicalRuntime<?>>(this.myApplicationId2Runtime){

                @Nullable
                public final DockerPhysicalRuntime<?> invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return (DockerPhysicalRuntime)((Object)((Map)this.receiver).get(p1));
                }
            });
        } else {
            throw (Throwable)new IllegalStateException("Unknown subtype: " + $this$createApplicationRuntime);
        }
        return dockerPhysicalRuntime;
    }

    private final void fireRuntimesRefreshed(DeltaImpl delta) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshed: " + this + ": " + delta.toLogString());
        }
        DockerRuntimesCache.Companion.syncPublisher().runtimesRefreshed(this.myManager, delta);
    }

    public DockerRuntimesCache(@NotNull DockerRuntimesManagerService.DockerRuntimesManager myManager, @NotNull DockerRuntimeContext context) {
        Intrinsics.checkNotNullParameter((Object)myManager, (String)"myManager");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.myManager = myManager;
        this.runtimeContext = context;
        this.myContainersGroup = new DockerGroupRuntime.ContainersGroup(context);
        this.myImagesGroup = new DockerGroupRuntime.ImagesGroup(context);
        this.myVolumesGroup = new DockerGroupRuntime.VolumesGroup(context);
        this.myNetworksGroup = new DockerGroupRuntime.NetworksGroup(context);
        boolean bl = false;
        this.myFile2ProjectNameCache = new LinkedHashMap();
        this.myComposeDeployments = new ConcurrentHashMap();
        this.myExternalComposeApps = new ConcurrentHashMap();
        this.myApplicationId2Runtime = new HashMap();
        this.myErrors = new ReportedContainerErrors();
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(DockerRuntimesCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Docke\u2026untimesCache::class.java)");
        LOG = logger2;
    }

    public static final /* synthetic */ Map access$getMyApplicationId2Runtime$p(DockerRuntimesCache $this) {
        return $this.myApplicationId2Runtime;
    }

    public static final /* synthetic */ DockerGroupRuntime access$getMyImagesGroup$p(DockerRuntimesCache $this) {
        return $this.myImagesGroup;
    }

    public static final /* synthetic */ void access$setMyImagesGroup$p(DockerRuntimesCache $this, DockerGroupRuntime dockerGroupRuntime) {
        $this.myImagesGroup = dockerGroupRuntime;
    }

    public static final /* synthetic */ DockerGroupRuntime access$getMyContainersGroup$p(DockerRuntimesCache $this) {
        return $this.myContainersGroup;
    }

    public static final /* synthetic */ void access$setMyContainersGroup$p(DockerRuntimesCache $this, DockerGroupRuntime dockerGroupRuntime) {
        $this.myContainersGroup = dockerGroupRuntime;
    }

    public static final /* synthetic */ DockerGroupRuntime access$getMyNetworksGroup$p(DockerRuntimesCache $this) {
        return $this.myNetworksGroup;
    }

    public static final /* synthetic */ void access$setMyNetworksGroup$p(DockerRuntimesCache $this, DockerGroupRuntime dockerGroupRuntime) {
        $this.myNetworksGroup = dockerGroupRuntime;
    }

    public static final /* synthetic */ ComposeApplicationRuntime access$findOrCreateApplicationRuntime(DockerRuntimesCache $this, String composeProject) {
        return $this.findOrCreateApplicationRuntime(composeProject);
    }

    public static final /* synthetic */ DockerGroupRuntime access$getMyVolumesGroup$p(DockerRuntimesCache $this) {
        return $this.myVolumesGroup;
    }

    public static final /* synthetic */ void access$setMyVolumesGroup$p(DockerRuntimesCache $this, DockerGroupRuntime dockerGroupRuntime) {
        $this.myVolumesGroup = dockerGroupRuntime;
    }

    public static final /* synthetic */ Map access$getMyFile2ProjectNameCache$p(DockerRuntimesCache $this) {
        return $this.myFile2ProjectNameCache;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\fH\u0016J\u0012\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\fH\u0016J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\fH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\bJ\u0012\u0010\u0012\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\bJ\u0012\u0010\u0014\u001a\u00020\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\bJ\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/docker/runtimes/DockerRuntimesCache$DeltaImpl;", "Lcom/intellij/docker/runtimes/DockerRuntimesManagerService$DockerRuntimesListener$Delta;", "()V", "isEmpty", "", "()Z", "myDeleted", "", "Lcom/intellij/docker/runtimes/DockerPhysicalRuntime;", "myNew", "myStatusChanged", "getDeleted", "", "getNewRuntimes", "getStatusChanged", "markAdded", "", "newRuntime", "markChanged", "startedOrStopped", "markDeleted", "deletedRuntime", "toLogString", "", "intellij.clouds.docker"})
    private static final class DeltaImpl
    implements DockerRuntimesManagerService.DockerRuntimesListener.Delta {
        private final List<DockerPhysicalRuntime<?>> myNew = new LinkedList();
        private final List<DockerPhysicalRuntime<?>> myDeleted = new LinkedList();
        private final List<DockerPhysicalRuntime<?>> myStatusChanged = new LinkedList();

        public final boolean isEmpty() {
            return this.myDeleted.isEmpty() && this.myNew.isEmpty() && this.myStatusChanged.isEmpty();
        }

        @NotNull
        public List<DockerPhysicalRuntime<?>> getNewRuntimes() {
            List<DockerPhysicalRuntime<?>> list = Collections.unmodifiableList(this.myNew);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.unmodifiableList(myNew)");
            return list;
        }

        @NotNull
        public List<DockerPhysicalRuntime<?>> getDeleted() {
            List<DockerPhysicalRuntime<?>> list = Collections.unmodifiableList(this.myDeleted);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.unmodifiableList(myDeleted)");
            return list;
        }

        @NotNull
        public List<DockerPhysicalRuntime<?>> getStatusChanged() {
            List<DockerPhysicalRuntime<?>> list = Collections.unmodifiableList(this.myStatusChanged);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.unmodifiableList(myStatusChanged)");
            return list;
        }

        public final void markAdded(@NotNull DockerPhysicalRuntime<?> newRuntime) {
            Intrinsics.checkNotNullParameter(newRuntime, (String)"newRuntime");
            this.myNew.add(newRuntime);
        }

        public final void markDeleted(@NotNull DockerPhysicalRuntime<?> deletedRuntime) {
            Intrinsics.checkNotNullParameter(deletedRuntime, (String)"deletedRuntime");
            this.myDeleted.add(deletedRuntime);
        }

        public final void markChanged(@NotNull DockerPhysicalRuntime<?> startedOrStopped) {
            Intrinsics.checkNotNullParameter(startedOrStopped, (String)"startedOrStopped");
            this.myStatusChanged.add(startedOrStopped);
        }

        @NotNull
        public final String toLogString() {
            return "\n        deleted [" + this.myDeleted.size() + "]: " + this.myDeleted + ", \n        added [" + this.myNew.size() + "]: " + this.myNew + ", \n        changed [" + this.myStatusChanged.size() + "]: " + this.myStatusChanged;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/runtimes/DockerRuntimesCache$ReportedContainerErrors;", "", "()V", "myReportedLabels", "", "", "reportContainerLabels", "", "labels", "", "intellij.clouds.docker"})
    private static final class ReportedContainerErrors {
        private final Set<String> myReportedLabels;

        public final void reportContainerLabels(@NotNull Map<String, String> labels) {
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            Map<String, String> $this$filterKeys$iv = labels;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            Map<String, String> map2 = $this$filterKeys$iv;
            boolean bl = false;
            for (Map.Entry<String, String> entry$iv : map2.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it, (String)"com.docker", (boolean)false, (int)2, null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            String data = ((Map)result$iv).toString();
            if (this.myReportedLabels.add(data)) {
                LOG.error("Unexpected set of compose container labels", new String[]{data});
            }
        }

        public ReportedContainerErrors() {
            boolean bl = false;
            this.myReportedLabels = new LinkedHashSet();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/runtimes/DockerRuntimesCache$Companion;", "", "()V", "CONTAINER_GROUP_KEY", "", "IMAGE_GROUP_KEY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NETWORK_GROUP_KEY", "SERVICE_GROUP_KEY", "VOLUME_GROUP_KEY", "syncPublisher", "Lcom/intellij/docker/runtimes/DockerRuntimesManagerService$DockerRuntimesListener;", "intellij.clouds.docker"})
    public static final class Companion {
        private final DockerRuntimesManagerService.DockerRuntimesListener syncPublisher() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            Object object = application.getMessageBus().syncPublisher(DockerRuntimesManagerService.DOCKER_RUNTIMES_MANAGER_TOPIC);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026R_RUNTIMES_MANAGER_TOPIC)");
            return (DockerRuntimesManagerService.DockerRuntimesListener)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

